/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.npw.assetstudio.AdaptiveIconGenerator;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.AssetStudioWizardTracker;
import com.android.tools.idea.npw.assetstudio.AssetStudioWizardTrackerImpl;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.LauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.TvChannelIconGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.npw.assetstudio.ui.ClipartIconButton;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureIconView;
import com.android.tools.idea.npw.assetstudio.ui.ImageAssetBrowser;
import com.android.tools.idea.npw.assetstudio.ui.MultiLineTextAssetEditor;
import com.android.tools.idea.npw.assetstudio.ui.SliderUtils;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentStateUtil;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.expressions.optional.AsOptionalExpression;
import com.android.tools.idea.observable.ui.ColorProperty;
import com.android.tools.idea.observable.ui.EnabledProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.SelectedRadioButtonProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.module.AndroidModuleInfo;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAdaptiveIconPanel
extends JPanel
implements Disposable,
ConfigureIconView,
PersistentStateComponent<PersistentState> {
    private static final boolean HIDE_INAPPLICABLE_CONTROLS = false;
    private static final String DEFAULT_FOREGROUND_IMAGE = "ic_launcher_foreground.xml";
    private static final String DEFAULT_BACKGROUND_IMAGE = "ic_launcher_background.xml";
    private static final ForegroundAssetType DEFAULT_FOREGROUND_ASSET_TYPE = ForegroundAssetType.IMAGE;
    private static final BackgroundAssetType DEFAULT_BACKGROUND_ASSET_TYPE = BackgroundAssetType.IMAGE;
    private static final MonochromeAssetType DEFAULT_MONOCHROME_ASSET_TYPE = MonochromeAssetType.IMAGE;
    private static final Density DEFAULT_PREVIEW_DENSITY = Density.XHIGH;
    private static final IconGenerator.Shape DEFAULT_ICON_SHAPE = IconGenerator.Shape.SQUARE;
    private static final String FOREGROUND_ASSET_TYPE_PROPERTY = "foregroundAssetType";
    private static final String BACKGROUND_ASSET_TYPE_PROPERTY = "backgroundAssetType";
    private static final String MONOCHROME_ASSET_TYPE_PROPERTY = "monochromeAssetType";
    private static final String BACKGROUND_COLOR_PROPERTY = "backgroundColor";
    private static final String GENERATE_LEGACY_ICON_PROPERTY = "generateLegacyIcon";
    private static final String GENERATE_ROUND_ICON_PROPERTY = "generateRoundIcon";
    private static final String GENERATE_PLAY_STORE_ICON_PROPERTY = "generatePlayStoreIcon";
    private static final String GENERATE_WEBP_ICONS_PROPERTY = "generateWebpIcons";
    private static final String LEGACY_ICON_SHAPE_PROPERTY = "legacyIconShape";
    private static final String SHOW_GRID_PROPERTY = "showGrid";
    private static final String SHOW_SAFE_ZONE_PROPERTY = "showSafeZone";
    private static final String PREVIEW_DENSITY_PROPERTY = "previewDensity";
    private static final String OUTPUT_NAME_PROPERTY = "outputName";
    private static final String FOREGROUND_LAYER_NAME_PROPERTY = "foregroundLayerName";
    private static final String BACKGROUND_LAYER_NAME_PROPERTY = "backgroundLayerName";
    private static final String MONOCHROME_LAYER_NAME_PROPERTY = "monochromeLayerName";
    private static final String BACKGROUND_IMAGE_PROPERTY = "backgroundImage";
    private static final String FOREGROUND_CLIPART_ASSET_PROPERTY = "foregroundClipartAsset";
    private static final String FOREGROUND_TEXT_ASSET_PROPERTY = "foregroundTextAsset";
    private static final String MONOCHROME_CLIPART_ASSET_PROPERTY = "monochromeClipartAsset";
    private static final String MONOCHROME_TEXT_ASSET_PROPERTY = "monochromeTextAsset";
    private JPanel myRootPanel;
    private JBLabel myOutputNameLabel;
    private JTextField myOutputNameTextField;
    private JPanel myForegroundAllOptionsPanel;
    private JRadioButton myForegroundClipartRadioButton;
    private JRadioButton myForegroundTextRadioButton;
    private JRadioButton myForegroundImageRadioButton;
    private JRadioButton myForegroundTrimYesRadioButton;
    private JRadioButton myForegroundTrimNoRadioButton;
    private JPanel myForegroundTrimOptionsPanel;
    private JSlider myForegroundResizeSlider;
    private JTextField myForegroundResizeValueTextField;
    private JLabel myForegroundResizeValueLabel;
    private JPanel myForegroundAssetRadioButtonsPanel;
    private JPanel myForegroundResizeSliderPanel;
    private JTextField myForegroundLayerNameTextField;
    private JPanel myForegroundColorRowPanel;
    private ColorPanel myForegroundColorPanel;
    private JPanel mGenerateLegacyIconRadioButtonsPanel;
    private JRadioButton myGenerateLegacyIconYesRadioButton;
    private JBScrollPane myForegroundScrollPane;
    private JPanel myForegroundImageAssetRowPanel;
    private JPanel myForegroundClipartAssetRowPanel;
    private JPanel myForegroundTextAssetRowPanel;
    private ImageAssetBrowser myForegroundImageAssetBrowser;
    private ClipartIconButton myForegroundClipartAssetButton;
    private MultiLineTextAssetEditor myForegroundTextAssetEditor;
    private JBLabel myForegroundLayerNameLabel;
    private JLabel myForegroundAssetTypeLabel;
    private JBLabel myForegroundImagePathLabel;
    private JBLabel myForegroundClipartLabel;
    private JBLabel myForegroundTextLabel;
    private JBLabel myForegroundTrimLabel;
    private JBLabel myForegroundResizeLabel;
    private JBLabel myForegroundColorLabel;
    private JBLabel myGenerateLegacyIconLabel;
    private JPanel myBackgroundAllOptionsPanel;
    private JRadioButton myBackgroundImageRadioButton;
    private JRadioButton myBackgroundColorRadioButton;
    private JRadioButton myBackgroundTrimYesRadioButton;
    private JPanel myBackgroundTrimOptionsPanel;
    private JSlider myBackgroundResizeSlider;
    private JTextField myBackgroundResizeValueTextField;
    private JLabel myBackgroundResizeValueLabel;
    private JPanel myBackgroundAssetRadioButtonsPanel;
    private JPanel myBackgroundResizeSliderPanel;
    private JTextField myBackgroundLayerNameTextField;
    private JPanel myBackgroundTrimRowPanel;
    private JPanel myBackgroundResizeRowPanel;
    private JPanel myBackgroundColorRowPanel;
    private ColorPanel myBackgroundColorPanel;
    private TitledSeparator myGenerateRoundIconTitle;
    private JPanel myGenerateRoundIconRowPanel;
    private JPanel myGenerateRoundIconRadioButtonsPanel;
    private JRadioButton myGenerateRoundIconYesRadioButton;
    private JComboBox<IconGenerator.Shape> myLegacyIconShapeComboBox;
    private JBScrollPane myBackgroundScrollPane;
    private JPanel myBackgroundImageAssetRowPanel;
    private ImageAssetBrowser myBackgroundImageAssetBrowser;
    private JBLabel myBackgroundLayerNameLabel;
    private JLabel myBackgroundAssetTypeLabel;
    private JBLabel myBackgroundImagePathLabel;
    private JBLabel myBackgroundTrimLabel;
    private JBLabel myBackgroundResizeLabel;
    private JBLabel myGenerateRoundIconLabel;
    private JBLabel myBackgroundColorLabel;
    private JBLabel myLegacyIconShapeLabel;
    private JBScrollPane myOtherIconsScrollPane;
    private JPanel myOtherIconsAllOptionsPanel;
    private JPanel myForegroundAssetTypePanel;
    private JPanel myForegroundLayerNamePanel;
    private JPanel myForegroundAssetTypeSourcePanel;
    private JPanel myForegroundImageOptionsPanel;
    private JPanel myBackgroundLayerNamePanel;
    private JPanel myBackgroundAssetTypePanel;
    private JPanel myBackgroundAssetTypeSourcePanel;
    private JPanel myBackgroundImageOptionsPanel;
    private JPanel myLegacyIconShapeRowPanel;
    private JPanel myOutputNamePanelRow;
    private TitledSeparator myForegroundScalingTitleSeparator;
    private TitledSeparator mySourceAssetTitleSeparator;
    private JPanel myForegroundResizePanel;
    private TitledSeparator myBackgroundScalingTitleSeparator;
    private TitledSeparator myBackgroundSourceAssetTitleSeparator;
    private JPanel myGenerateLegacyIconRowPanel;
    private JPanel myForegroundTrimPanel;
    private JPanel myLegacyIconShapePanel;
    private TitledSeparator myGeneratePlayStoreIconTitle;
    private JPanel myGeneratePlayStoreIconRowPanel;
    private JBLabel myGeneratePlayStoreIconLabel;
    private JPanel myGeneratePlayStoreIconRadioButtonsPanel;
    private JRadioButton myGeneratePlayStoreIconYesRadioButton;
    private JRadioButton myBackgroundTrimNoRadioButton;
    private TitledSeparator myIconFormatTitle;
    private JBLabel myIconFormatLabel;
    private JPanel myIconFormatRowPanel;
    private JRadioButton myIconFormatWebpRadioButton;
    private JPanel myIconFormatRadioButtonsPanel;
    private JPanel myMonochromeAllOptionsPanel;
    private JRadioButton myMonochromeClipartRadioButton;
    private JRadioButton myMonochromeTextRadioButton;
    private JRadioButton myMonochromeImageRadioButton;
    private JRadioButton myMonochromeTrimYesRadioButton;
    private JRadioButton myMonochromeTrimNoRadioButton;
    private JPanel myMonochromeTrimOptionsPanel;
    private JSlider myMonochromeResizeSlider;
    private JTextField myMonochromeResizeValueTextField;
    private JPanel myMonochromeAssetRadioButtonsPanel;
    private JPanel myMonochromeResizeSliderPanel;
    private JTextField myMonochromeLayerNameTextField;
    private JPanel myMonochromeColorRowPanel;
    private ColorPanel myMonochromeColorPanel;
    private JPanel myMonochromeImageAssetRowPanel;
    private JPanel myMonochromeClipartAssetRowPanel;
    private JPanel myMonochromeTextAssetRowPanel;
    private ImageAssetBrowser myMonochromeImageAssetBrowser;
    private ClipartIconButton myMonochromeClipartAssetButton;
    private MultiLineTextAssetEditor myMonochromeTextAssetEditor;
    private JBLabel myMonochromeLayerNameLabel;
    private JLabel myMonochromeAssetTypeLabel;
    private JBLabel myMonochromeImagePathLabel;
    private JBLabel myMonochromeClipartLabel;
    private JBLabel myMonochromeTextLabel;
    private JBLabel myMonochromeTrimLabel;
    private JBLabel myMonochromeResizeLabel;
    private JBLabel myMonochromeColorLabel;
    private JPanel myMonochromeImageOptionsPanel;
    private TitledSeparator myMonochromeScalingTitleSeparator;
    private ImmutableMap<MonochromeAssetType, AssetComponent<?>> myMonochromeAssetPanelMap;
    private StringProperty myMonochromeLayerName;
    private OptionalProperty<BaseAsset> myMonochromeActiveAsset;
    private AbstractProperty<MonochromeAssetType> myMonochromeAssetType;
    @NotNull
    private final AndroidIconType myIconType;
    @NotNull
    private final String myDefaultOutputName;
    private static final Map<IconGenerator.Shape, String> myShapeNames = ImmutableMap.of((Object)((Object)IconGenerator.Shape.NONE), (Object)"None", (Object)((Object)IconGenerator.Shape.CIRCLE), (Object)"Circle", (Object)((Object)IconGenerator.Shape.SQUARE), (Object)"Square", (Object)((Object)IconGenerator.Shape.VRECT), (Object)"Vertical", (Object)((Object)IconGenerator.Shape.HRECT), (Object)"Horizontal");
    @NotNull
    private final AndroidVersion myBuildSdkVersion;
    @NotNull
    private final AdaptiveIconGenerator myIconGenerator;
    @NotNull
    private final ValidatorPanel myValidatorPanel;
    @NotNull
    private final BindingsManager myGeneralBindings = new BindingsManager();
    @NotNull
    private final BindingsManager myForegroundActiveAssetBindings = new BindingsManager();
    @NotNull
    private final BindingsManager myMonochromeActiveAssetBindings = new BindingsManager();
    @NotNull
    private final BindingsManager myBackgroundActiveAssetBindings = new BindingsManager();
    @NotNull
    private final ListenerManager myListeners = new ListenerManager();
    @NotNull
    private final List<ActionListener> myAssetListeners = new ArrayList<ActionListener>(1);
    @NotNull
    private final ImmutableMap<ForegroundAssetType, AssetComponent<?>> myForegroundAssetPanelMap;
    @NotNull
    private final StringProperty myOutputName;
    @NotNull
    private final StringProperty myForegroundLayerName;
    @NotNull
    private final StringProperty myBackgroundLayerName;
    @NotNull
    private final ObjectProperty<BaseAsset> myForegroundActiveAsset;
    @NotNull
    private final OptionalProperty<ImageAsset> myBackgroundImageAsset;
    @NotNull
    private final ObjectProperty<Validator.Result> myForegroundAssetValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
    @NotNull
    private final ObjectProperty<Validator.Result> myBackgroundAssetValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
    @NotNull
    private final ObjectProperty<Validator.Result> myMonochromeAssetValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
    @NotNull
    private final AbstractProperty<ForegroundAssetType> myForegroundAssetType;
    @NotNull
    private final AbstractProperty<BackgroundAssetType> myBackgroundAssetType;
    @NotNull
    private final BoolProperty myShowGrid;
    @NotNull
    private final BoolProperty myShowSafeZone;
    @NotNull
    private final AbstractProperty<Density> myPreviewDensity;
    private ColorProperty myForegroundColor;
    private ColorProperty myMonochromeColor;
    private AbstractProperty<Color> myBackgroundColor;
    private BoolProperty myForegroundTrimmed;
    private BoolProperty myMonochromeTrimmed;
    private BoolProperty myBackgroundTrimmed;
    private IntProperty myForegroundResizePercent;
    private IntProperty myMonochromeResizePercent;
    private IntProperty myBackgroundResizePercent;
    private BoolProperty myGenerateLegacyIcon;
    private BoolProperty myGenerateRoundIcon;
    private BoolProperty myGeneratePlayStoreIcon;
    private BoolProperty myGenerateWebpIcons;
    private AbstractProperty<IconGenerator.Shape> myLegacyIconShape;
    @NotNull
    private final IdeResourceNameValidator myNameValidator = IdeResourceNameValidator.forFilename(ResourceFolderType.DRAWABLE);
    @NotNull
    private final boolean myIsMonochromeSupported;

    public ConfigureAdaptiveIconPanel(@NotNull Disposable disposableParent, @NotNull AndroidFacet facet, @NotNull AndroidIconType iconType, @NotNull BoolProperty showGrid, @NotNull BoolProperty showSafeZone, @NotNull AbstractProperty<Density> previewDensity, @NotNull ValidatorPanel validatorPanel2, @Nullable DrawableRenderer renderer2, boolean isMonochromeSupported) {
        super(new BorderLayout());
        this.myIsMonochromeSupported = isMonochromeSupported;
        this.setupUI(isMonochromeSupported, facet);
        this.myIconType = iconType;
        this.myDefaultOutputName = this.myIconType.toOutputName("");
        AndroidModuleInfo androidModuleInfo = StudioAndroidModuleInfo.getInstance(facet);
        AndroidVersion buildSdkVersion = androidModuleInfo.getBuildSdkVersion();
        this.myBuildSdkVersion = buildSdkVersion != null ? buildSdkVersion : new AndroidVersion(26);
        this.myShowGrid = showGrid;
        this.myShowSafeZone = showSafeZone;
        this.myPreviewDensity = previewDensity;
        this.myIconGenerator = this.myIconType == AndroidIconType.LAUNCHER ? new LauncherIconGenerator(facet.getModule().getProject(), androidModuleInfo.getMinSdkVersion().getApiLevel(), renderer2, (AssetStudioWizardTracker)new AssetStudioWizardTrackerImpl(facet.getModule().getProject())) : new TvChannelIconGenerator(facet.getModule().getProject(), androidModuleInfo.getMinSdkVersion().getApiLevel(), renderer2);
        this.myValidatorPanel = validatorPanel2;
        Path defaultForegroundImage = AssetStudioUtils.getBundledImage("asset_studio", DEFAULT_FOREGROUND_IMAGE);
        Path defaultBackgroundImage = AssetStudioUtils.getBundledImage("asset_studio", DEFAULT_BACKGROUND_IMAGE);
        this.myForegroundImageAssetBrowser.getAsset().setDefaultImagePath(defaultForegroundImage);
        this.myForegroundTextAssetEditor.getAsset().setDefaultText("Aa");
        this.myBackgroundImageAssetBrowser.getAsset().setDefaultImagePath(defaultBackgroundImage);
        DefaultComboBoxModel<IconGenerator.Shape> legacyShapesModel = new DefaultComboBoxModel<IconGenerator.Shape>();
        for (IconGenerator.Shape shape : myShapeNames.keySet()) {
            legacyShapesModel.addElement(shape);
        }
        this.myLegacyIconShapeComboBox.setRenderer((ListCellRenderer<IconGenerator.Shape>)SimpleListCellRenderer.create((String)"", myShapeNames::get));
        this.myLegacyIconShapeComboBox.setModel(legacyShapesModel);
        this.myLegacyIconShapeComboBox.setSelectedItem((Object)IconGenerator.Shape.SQUARE);
        this.myForegroundScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myForegroundScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myBackgroundScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myBackgroundScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myOtherIconsScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myOtherIconsScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myOutputName = new TextProperty(this.myOutputNameTextField);
        this.myForegroundLayerName = new TextProperty(this.myForegroundLayerNameTextField);
        this.myBackgroundLayerName = new TextProperty(this.myBackgroundLayerNameTextField);
        this.myListeners.listen(this.myForegroundLayerName, name2 -> {
            if (name2.equals(this.defaultForegroundLayerName())) {
                this.myGeneralBindings.bind(this.myForegroundLayerName, Expression.create(this::defaultForegroundLayerName, this.myOutputName));
            } else {
                this.myGeneralBindings.release(this.myForegroundLayerName);
            }
        });
        this.myListeners.listen(this.myBackgroundLayerName, name2 -> {
            if (name2.equals(this.defaultBackgroundLayerName())) {
                this.myGeneralBindings.bind(this.myBackgroundLayerName, Expression.create(this::defaultBackgroundLayerName, this.myOutputName));
            } else {
                this.myGeneralBindings.release(this.myBackgroundLayerName);
            }
        });
        this.myForegroundAssetPanelMap = ImmutableMap.of((Object)((Object)ForegroundAssetType.IMAGE), (Object)this.myForegroundImageAssetBrowser, (Object)((Object)ForegroundAssetType.CLIP_ART), (Object)this.myForegroundClipartAssetButton, (Object)((Object)ForegroundAssetType.TEXT), (Object)this.myForegroundTextAssetEditor);
        this.myForegroundImageAssetBrowser.getAsset().imagePath().setValue(defaultForegroundImage.toFile());
        this.myBackgroundImageAssetBrowser.getAsset().imagePath().setValue(defaultBackgroundImage.toFile());
        this.myOutputNameLabel.setLabelFor((Component)this.myOutputNameTextField);
        this.myForegroundLayerNameLabel.setLabelFor((Component)this.myForegroundLayerNameTextField);
        this.myForegroundAssetTypeLabel.setLabelFor(this.myForegroundAssetRadioButtonsPanel);
        this.myForegroundImagePathLabel.setLabelFor((Component)((Object)this.myForegroundImageAssetBrowser));
        this.myForegroundClipartLabel.setLabelFor((Component)this.myForegroundClipartAssetButton);
        this.myForegroundTextLabel.setLabelFor((Component)this.myForegroundTextAssetEditor);
        this.myForegroundTrimLabel.setLabelFor((Component)this.myForegroundTrimOptionsPanel);
        this.myForegroundResizeLabel.setLabelFor((Component)this.myForegroundResizeSliderPanel);
        this.myForegroundColorLabel.setLabelFor((Component)this.myForegroundColorPanel);
        this.myBackgroundLayerNameLabel.setLabelFor((Component)this.myBackgroundLayerNameTextField);
        this.myBackgroundAssetTypeLabel.setLabelFor(this.myBackgroundAssetRadioButtonsPanel);
        this.myBackgroundImagePathLabel.setLabelFor((Component)((Object)this.myBackgroundImageAssetBrowser));
        this.myBackgroundTrimLabel.setLabelFor((Component)this.myBackgroundTrimOptionsPanel);
        this.myBackgroundResizeLabel.setLabelFor((Component)this.myBackgroundResizeSliderPanel);
        this.myBackgroundColorLabel.setLabelFor((Component)this.myBackgroundColorPanel);
        this.myGenerateRoundIconLabel.setLabelFor((Component)this.myGenerateRoundIconRadioButtonsPanel);
        this.myLegacyIconShapeLabel.setLabelFor(this.myLegacyIconShapeComboBox);
        this.myGenerateLegacyIconLabel.setLabelFor((Component)this.mGenerateLegacyIconRadioButtonsPanel);
        this.myForegroundAssetType = new SelectedRadioButtonProperty<ForegroundAssetType>(DEFAULT_FOREGROUND_ASSET_TYPE, (T[])ForegroundAssetType.values(), this.myForegroundImageRadioButton, this.myForegroundClipartRadioButton, this.myForegroundTextRadioButton);
        this.myForegroundActiveAsset = new ObjectValueProperty<ImageAsset>(this.myForegroundImageAssetBrowser.getAsset());
        this.myForegroundImageAssetBrowser.getAsset().setRole("foreground image");
        this.myForegroundColorPanel.setSelectedColor(LauncherIconGenerator.DEFAULT_FOREGROUND_COLOR);
        this.myBackgroundAssetType = new SelectedRadioButtonProperty<BackgroundAssetType>(DEFAULT_BACKGROUND_ASSET_TYPE, (T[])BackgroundAssetType.values(), this.myBackgroundImageRadioButton, this.myBackgroundColorRadioButton);
        this.myBackgroundImageAsset = new OptionalValueProperty<ImageAsset>(this.myBackgroundImageAssetBrowser.getAsset());
        this.myBackgroundImageAssetBrowser.getAsset().setRole("background image");
        this.myBackgroundColorPanel.setSelectedColor((Color)this.myIconGenerator.backgroundColor().get());
        if (isMonochromeSupported) {
            this.myMonochromeTextAssetEditor.getAsset().setDefaultText("Aa");
            this.myMonochromeLayerName = new TextProperty(this.myMonochromeLayerNameTextField);
            this.myMonochromeLayerName.set(this.defaultMonochromeLayerName());
            this.myListeners.listen(this.myMonochromeLayerName, name2 -> {
                if (name2.equals(this.defaultMonochromeLayerName())) {
                    this.myGeneralBindings.bind(this.myMonochromeLayerName, Expression.create(this::defaultMonochromeLayerName, this.myOutputName));
                } else {
                    this.myGeneralBindings.release(this.myMonochromeLayerName);
                }
            });
            this.myMonochromeAssetPanelMap = ImmutableMap.of((Object)((Object)MonochromeAssetType.IMAGE), (Object)this.myMonochromeImageAssetBrowser, (Object)((Object)MonochromeAssetType.CLIP_ART), (Object)this.myMonochromeClipartAssetButton, (Object)((Object)MonochromeAssetType.TEXT), (Object)this.myMonochromeTextAssetEditor);
            this.myMonochromeLayerNameLabel.setLabelFor((Component)this.myMonochromeLayerNameTextField);
            this.myMonochromeAssetTypeLabel.setLabelFor(this.myMonochromeAssetRadioButtonsPanel);
            this.myMonochromeImagePathLabel.setLabelFor((Component)((Object)this.myMonochromeImageAssetBrowser));
            this.myMonochromeClipartLabel.setLabelFor((Component)this.myMonochromeClipartAssetButton);
            this.myMonochromeTextLabel.setLabelFor((Component)this.myMonochromeTextAssetEditor);
            this.myMonochromeTrimLabel.setLabelFor((Component)this.myMonochromeTrimOptionsPanel);
            this.myMonochromeResizeLabel.setLabelFor((Component)this.myMonochromeResizeSliderPanel);
            this.myMonochromeColorLabel.setLabelFor((Component)this.myMonochromeColorPanel);
            this.myMonochromeAssetType = new SelectedRadioButtonProperty<MonochromeAssetType>(DEFAULT_MONOCHROME_ASSET_TYPE, (T[])MonochromeAssetType.values(), this.myMonochromeImageRadioButton, this.myMonochromeClipartRadioButton, this.myMonochromeTextRadioButton);
            this.myMonochromeActiveAsset = new OptionalValueProperty<ImageAsset>(this.myMonochromeImageAssetBrowser.getAsset());
            this.myMonochromeImageAssetBrowser.getAsset().setRole("monochrome image");
            this.myMonochromeColorPanel.setSelectedColor(LauncherIconGenerator.DEFAULT_FOREGROUND_COLOR);
            for (AssetComponent assetComponent : this.myMonochromeAssetPanelMap.values()) {
                Disposer.register((Disposable)this, (Disposable)assetComponent);
            }
        }
        this.initializeListenersAndBindings();
        this.initializeValidators();
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        for (AssetComponent assetComponent : this.myForegroundAssetPanelMap.values()) {
            Disposer.register((Disposable)this, (Disposable)assetComponent);
        }
        Disposer.register((Disposable)this, (Disposable)this.myBackgroundImageAssetBrowser);
        Disposer.register((Disposable)this, (Disposable)this.myIconGenerator);
        this.add(this.myRootPanel);
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state2 = new PersistentState();
        state2.set(FOREGROUND_ASSET_TYPE_PROPERTY, (ForegroundAssetType)((Object)this.myForegroundAssetType.get()), DEFAULT_FOREGROUND_ASSET_TYPE);
        state2.set(BACKGROUND_ASSET_TYPE_PROPERTY, (BackgroundAssetType)((Object)this.myBackgroundAssetType.get()), DEFAULT_BACKGROUND_ASSET_TYPE);
        for (Map.Entry entry : this.myForegroundAssetPanelMap.entrySet()) {
            state2.setChild("foreground" + AssetStudioUtils.toUpperCamelCase((Enum)entry.getKey()), ((BaseAsset)((AssetComponent)entry.getValue()).getAsset()).getState());
        }
        state2.setChild(BACKGROUND_IMAGE_PROPERTY, this.myBackgroundImageAssetBrowser.getAsset().getState());
        state2.set(BACKGROUND_COLOR_PROPERTY, (Color)this.myBackgroundColor.get(), AdaptiveIconGenerator.DEFAULT_BACKGROUND_COLOR);
        state2.set(GENERATE_LEGACY_ICON_PROPERTY, (Boolean)this.myGenerateLegacyIcon.get(), true);
        state2.set(GENERATE_ROUND_ICON_PROPERTY, (Boolean)this.myGenerateRoundIcon.get(), true);
        state2.set(GENERATE_PLAY_STORE_ICON_PROPERTY, (Boolean)this.myGeneratePlayStoreIcon.get(), true);
        state2.set(GENERATE_WEBP_ICONS_PROPERTY, (Boolean)this.myGenerateWebpIcons.get(), true);
        state2.set(LEGACY_ICON_SHAPE_PROPERTY, (IconGenerator.Shape)((Object)this.myLegacyIconShape.get()), DEFAULT_ICON_SHAPE);
        state2.set(SHOW_GRID_PROPERTY, (Boolean)this.myShowGrid.get(), false);
        state2.set(SHOW_SAFE_ZONE_PROPERTY, (Boolean)this.myShowSafeZone.get(), true);
        state2.setEncoded(PREVIEW_DENSITY_PROPERTY, this.nullIfDefault((Density)this.myPreviewDensity.get()), Density::getResourceValue);
        state2.set(OUTPUT_NAME_PROPERTY, (String)this.myOutputName.get(), this.myDefaultOutputName);
        state2.set(FOREGROUND_LAYER_NAME_PROPERTY, (String)this.myForegroundLayerName.get(), this.defaultForegroundLayerName());
        state2.set(BACKGROUND_LAYER_NAME_PROPERTY, (String)this.myBackgroundLayerName.get(), this.defaultBackgroundLayerName());
        state2.setChild(FOREGROUND_CLIPART_ASSET_PROPERTY, this.myForegroundClipartAssetButton.getState());
        state2.setChild(FOREGROUND_TEXT_ASSET_PROPERTY, this.myForegroundTextAssetEditor.getAsset().getState());
        if (this.myIsMonochromeSupported) {
            state2.set(MONOCHROME_ASSET_TYPE_PROPERTY, (MonochromeAssetType)((Object)this.myMonochromeAssetType.get()), DEFAULT_MONOCHROME_ASSET_TYPE);
            for (Map.Entry entry : this.myMonochromeAssetPanelMap.entrySet()) {
                state2.setChild("monochrome" + AssetStudioUtils.toUpperCamelCase((Enum)entry.getKey()), ((BaseAsset)((AssetComponent)entry.getValue()).getAsset()).getState());
            }
            state2.set(MONOCHROME_LAYER_NAME_PROPERTY, (String)this.myMonochromeLayerName.get(), this.defaultMonochromeLayerName());
            state2.setChild(MONOCHROME_CLIPART_ASSET_PROPERTY, this.myMonochromeClipartAssetButton.getState());
            state2.setChild(MONOCHROME_TEXT_ASSET_PROPERTY, this.myMonochromeTextAssetEditor.getAsset().getState());
        }
        return state2;
    }

    @Nullable
    private Density nullIfDefault(Density density) {
        return density == null || density.equals((Object)DEFAULT_PREVIEW_DENSITY) ? null : density;
    }

    public void loadState(@NotNull PersistentState state2) {
        this.myForegroundAssetType.set(state2.get(FOREGROUND_ASSET_TYPE_PROPERTY, DEFAULT_FOREGROUND_ASSET_TYPE));
        this.myBackgroundAssetType.set(state2.get(BACKGROUND_ASSET_TYPE_PROPERTY, DEFAULT_BACKGROUND_ASSET_TYPE));
        for (Map.Entry entry : this.myForegroundAssetPanelMap.entrySet()) {
            PersistentStateUtil.load(((AssetComponent)entry.getValue()).getAsset(), state2.getChild("foreground" + AssetStudioUtils.toUpperCamelCase((Enum)entry.getKey())));
        }
        PersistentStateUtil.load(this.myBackgroundImageAssetBrowser.getAsset(), state2.getChild(BACKGROUND_IMAGE_PROPERTY));
        this.myBackgroundColor.set(state2.get(BACKGROUND_COLOR_PROPERTY, AdaptiveIconGenerator.DEFAULT_BACKGROUND_COLOR));
        this.myGenerateLegacyIcon.set(state2.get(GENERATE_LEGACY_ICON_PROPERTY, true));
        this.myGenerateRoundIcon.set(state2.get(GENERATE_ROUND_ICON_PROPERTY, true));
        this.myGeneratePlayStoreIcon.set(state2.get(GENERATE_PLAY_STORE_ICON_PROPERTY, true));
        this.myGenerateWebpIcons.set(state2.get(GENERATE_WEBP_ICONS_PROPERTY, true));
        this.myLegacyIconShape.set(state2.get(LEGACY_ICON_SHAPE_PROPERTY, DEFAULT_ICON_SHAPE));
        this.myShowGrid.set(state2.get(SHOW_GRID_PROPERTY, false));
        this.myShowSafeZone.set(state2.get(SHOW_SAFE_ZONE_PROPERTY, true));
        this.myPreviewDensity.set((Density)LintUtils.coalesce((Object[])new Density[]{(Density)state2.getDecoded(PREVIEW_DENSITY_PROPERTY, Density::create), DEFAULT_PREVIEW_DENSITY}));
        this.myOutputName.set(state2.get(OUTPUT_NAME_PROPERTY, this.myDefaultOutputName));
        this.myForegroundLayerName.set(state2.get(FOREGROUND_LAYER_NAME_PROPERTY, this.defaultForegroundLayerName()));
        this.myBackgroundLayerName.set(state2.get(BACKGROUND_LAYER_NAME_PROPERTY, this.defaultBackgroundLayerName()));
        PersistentStateUtil.load(this.myForegroundClipartAssetButton, state2.getChild(FOREGROUND_CLIPART_ASSET_PROPERTY));
        PersistentStateUtil.load(this.myForegroundTextAssetEditor.getAsset(), state2.getChild(FOREGROUND_TEXT_ASSET_PROPERTY));
        if (this.myIsMonochromeSupported) {
            this.myMonochromeAssetType.set(state2.get(MONOCHROME_ASSET_TYPE_PROPERTY, DEFAULT_MONOCHROME_ASSET_TYPE));
            for (Map.Entry entry : this.myMonochromeAssetPanelMap.entrySet()) {
                PersistentStateUtil.load(((AssetComponent)entry.getValue()).getAsset(), state2.getChild("monochrome" + AssetStudioUtils.toUpperCamelCase((Enum)entry.getKey())));
            }
            this.myMonochromeLayerName.set(state2.get(MONOCHROME_LAYER_NAME_PROPERTY, this.defaultMonochromeLayerName()));
            PersistentStateUtil.load(this.myMonochromeClipartAssetButton, state2.getChild(MONOCHROME_CLIPART_ASSET_PROPERTY));
            PersistentStateUtil.load(this.myMonochromeTextAssetEditor.getAsset(), state2.getChild(MONOCHROME_TEXT_ASSET_PROPERTY));
        }
    }

    private void initializeListenersAndBindings() {
        this.myForegroundTrimmed = new SelectedProperty(this.myForegroundTrimYesRadioButton);
        this.myBackgroundTrimmed = new SelectedProperty(this.myBackgroundTrimYesRadioButton);
        this.myForegroundResizePercent = SliderUtils.bindTwoWay(this.myGeneralBindings, this.myForegroundResizeSlider, this.myForegroundResizeValueTextField);
        this.myBackgroundResizePercent = SliderUtils.bindTwoWay(this.myGeneralBindings, this.myBackgroundResizeSlider, this.myBackgroundResizeValueTextField);
        this.myForegroundColor = new ColorProperty(this.myForegroundColorPanel);
        this.myBackgroundColor = ObjectProperty.wrap(new ColorProperty(this.myBackgroundColorPanel));
        this.myGenerateLegacyIcon = new SelectedProperty(this.myGenerateLegacyIconYesRadioButton);
        this.myGenerateRoundIcon = new SelectedProperty(this.myGenerateRoundIconYesRadioButton);
        this.myGeneratePlayStoreIcon = new SelectedProperty(this.myGeneratePlayStoreIconYesRadioButton);
        this.myGenerateWebpIcons = new SelectedProperty(this.myIconFormatWebpRadioButton);
        this.myLegacyIconShape = ObjectProperty.wrap(new SelectedItemProperty(this.myLegacyIconShapeComboBox));
        this.updateBindingsAndUiForActiveIconType();
        this.myForegroundAssetType.addListener(() -> {
            AssetComponent assetComponent = (AssetComponent)this.myForegroundAssetPanelMap.get(this.myForegroundAssetType.get());
            this.myForegroundActiveAsset.set((BaseAsset)assetComponent.getAsset());
        });
        this.myBackgroundAssetType.addListener(() -> {
            if (this.myBackgroundAssetType.get() == BackgroundAssetType.IMAGE) {
                this.myBackgroundImageAsset.setValue(this.myBackgroundImageAssetBrowser.getAsset());
            } else {
                this.myBackgroundImageAsset.clear();
            }
        });
        ActionListener assetPanelListener = e -> this.fireAssetListeners();
        for (AssetComponent assetComponent : this.myForegroundAssetPanelMap.values()) {
            assetComponent.addAssetListener(assetPanelListener);
        }
        this.myBackgroundImageAssetBrowser.addAssetListener(assetPanelListener);
        Runnable onAssetModified = this::fireAssetListeners;
        BoolValueProperty monochromeIsResizable = new BoolValueProperty();
        if (this.myIsMonochromeSupported) {
            this.myMonochromeTrimmed = new SelectedProperty(this.myMonochromeTrimYesRadioButton);
            this.myMonochromeResizePercent = SliderUtils.bindTwoWay(this.myGeneralBindings, this.myMonochromeResizeSlider, this.myMonochromeResizeValueTextField);
            this.myMonochromeColor = new ColorProperty(this.myMonochromeColorPanel);
            this.myMonochromeAssetType.addListener(() -> {
                AssetComponent assetComponent = (AssetComponent)this.myMonochromeAssetPanelMap.get(this.myMonochromeAssetType.get());
                this.myMonochromeActiveAsset.setNullableValue((BaseAsset)assetComponent.getAsset());
            });
            for (AssetComponent assetComponent : this.myMonochromeAssetPanelMap.values()) {
                assetComponent.addAssetListener(assetPanelListener);
            }
            this.myListeners.listenAll(this.myForegroundTrimmed, this.myForegroundResizePercent, this.myForegroundColor, this.myBackgroundTrimmed, this.myBackgroundResizePercent, this.myBackgroundColor, this.myMonochromeTrimmed, this.myMonochromeResizePercent, this.myMonochromeColor, this.myGenerateLegacyIcon, this.myLegacyIconShape, this.myGenerateRoundIcon, this.myGeneratePlayStoreIcon, this.myGenerateWebpIcons).with(onAssetModified);
            this.myListeners.listenAndFire(this.myMonochromeActiveAsset, () -> {
                this.myMonochromeActiveAssetBindings.releaseAll();
                BaseAsset asset = this.myMonochromeActiveAsset.getValueOrNull();
                if (asset != null) {
                    this.myMonochromeActiveAssetBindings.bindTwoWay(this.myMonochromeTrimmed, asset.trimmed());
                    this.myMonochromeActiveAssetBindings.bindTwoWay(this.myMonochromeResizePercent, asset.scalingPercent());
                    OptionalValueProperty<Color> assetColor = asset.color();
                    if (assetColor.getValueOrNull() == null) {
                        assetColor.setNullableValue((Color)this.myMonochromeColor.getValueOrNull());
                    }
                    this.myMonochromeActiveAssetBindings.bindTwoWay(this.myMonochromeColor, assetColor);
                    this.myMonochromeActiveAssetBindings.bind(monochromeIsResizable, asset.isResizable());
                    if (asset instanceof ImageAsset) {
                        this.myMonochromeActiveAssetBindings.bind(this.myMonochromeAssetValidityState, ((ImageAsset)asset).getValidityState());
                    } else {
                        this.myMonochromeAssetValidityState.set(Validator.Result.OK);
                    }
                }
                this.getIconGenerator().monochromeImageAsset().setNullableValue(asset);
                onAssetModified.run();
            });
        } else {
            this.myListeners.listenAll(this.myForegroundTrimmed, this.myForegroundResizePercent, this.myForegroundColor, this.myBackgroundTrimmed, this.myBackgroundResizePercent, this.myBackgroundColor, this.myGenerateLegacyIcon, this.myLegacyIconShape, this.myGenerateRoundIcon, this.myGeneratePlayStoreIcon, this.myGenerateWebpIcons).with(onAssetModified);
        }
        BoolValueProperty foregroundIsResizable = new BoolValueProperty();
        this.myListeners.listenAndFire(this.myForegroundActiveAsset, () -> {
            this.myForegroundActiveAssetBindings.releaseAll();
            BaseAsset asset = (BaseAsset)this.myForegroundActiveAsset.get();
            this.myForegroundActiveAssetBindings.bindTwoWay(this.myForegroundTrimmed, asset.trimmed());
            this.myForegroundActiveAssetBindings.bindTwoWay(this.myForegroundResizePercent, asset.scalingPercent());
            OptionalValueProperty<Color> assetColor = asset.color();
            if (assetColor.getValueOrNull() == null) {
                assetColor.setNullableValue((Color)this.myForegroundColor.getValueOrNull());
            }
            this.myForegroundActiveAssetBindings.bindTwoWay(this.myForegroundColor, assetColor);
            this.myForegroundActiveAssetBindings.bind(foregroundIsResizable, asset.isResizable());
            if (asset instanceof ImageAsset) {
                this.myForegroundActiveAssetBindings.bind(this.myForegroundAssetValidityState, ((ImageAsset)asset).getValidityState());
            } else {
                this.myForegroundAssetValidityState.set(Validator.Result.OK);
            }
            this.getIconGenerator().sourceAsset().setValue(asset);
            onAssetModified.run();
        });
        BoolValueProperty backgroundIsResizable = new BoolValueProperty();
        Runnable onBackgroundAssetModified = () -> {
            this.myBackgroundActiveAssetBindings.releaseAll();
            ImageAsset asset = this.myBackgroundImageAsset.getValueOrNull();
            if (asset != null) {
                this.myBackgroundActiveAssetBindings.bindTwoWay(this.myBackgroundTrimmed, asset.trimmed());
                this.myBackgroundActiveAssetBindings.bindTwoWay(this.myBackgroundResizePercent, asset.scalingPercent());
                this.myBackgroundActiveAssetBindings.bind(backgroundIsResizable, asset.isResizable());
                this.myBackgroundActiveAssetBindings.bind(this.myBackgroundAssetValidityState, asset.getValidityState());
            } else {
                backgroundIsResizable.set(false);
                this.myBackgroundAssetValidityState.set(Validator.Result.OK);
            }
            this.getIconGenerator().backgroundImageAsset().setNullableValue(asset);
            onAssetModified.run();
        };
        this.myListeners.listenAndFire(this.myBackgroundImageAsset, onBackgroundAssetModified::run);
        ImmutableMap.Builder layoutPropertiesBuilder = ImmutableMap.builder();
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundImageAssetRowPanel), (Object)new SelectedProperty(this.myForegroundImageRadioButton));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundClipartAssetRowPanel), (Object)new SelectedProperty(this.myForegroundClipartRadioButton));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundTextAssetRowPanel), (Object)new SelectedProperty(this.myForegroundTextRadioButton));
        Expression<Boolean> isForegroundIsNotImage = Expression.create(() -> this.myForegroundAssetType.get() != ForegroundAssetType.IMAGE, this.myForegroundAssetType);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundColorRowPanel), isForegroundIsNotImage);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myForegroundTrimYesRadioButton), (Object)foregroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myForegroundTrimNoRadioButton), (Object)foregroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myForegroundResizeSlider), (Object)foregroundIsResizable);
        if (this.myIsMonochromeSupported) {
            layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myMonochromeImageAssetRowPanel), (Object)new SelectedProperty(this.myMonochromeImageRadioButton));
            layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myMonochromeClipartAssetRowPanel), (Object)new SelectedProperty(this.myMonochromeClipartRadioButton));
            layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myMonochromeTextAssetRowPanel), (Object)new SelectedProperty(this.myMonochromeTextRadioButton));
            Expression<Boolean> isMonochromeIsNotImage = Expression.create(() -> this.myMonochromeAssetType.get() != MonochromeAssetType.IMAGE, this.myMonochromeAssetType);
            layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myMonochromeColorRowPanel), isMonochromeIsNotImage);
            layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myMonochromeTrimYesRadioButton), (Object)monochromeIsResizable);
            layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myMonochromeTrimNoRadioButton), (Object)monochromeIsResizable);
            layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myMonochromeResizeSlider), (Object)monochromeIsResizable);
        }
        SelectedProperty backgroundIsImage = new SelectedProperty(this.myBackgroundImageRadioButton);
        SelectedProperty backgroundIsColor = new SelectedProperty(this.myBackgroundColorRadioButton);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myBackgroundImageAssetRowPanel), (Object)backgroundIsImage);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myBackgroundColorRowPanel), (Object)backgroundIsColor);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myBackgroundTrimYesRadioButton), (Object)backgroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myBackgroundTrimNoRadioButton), (Object)backgroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myBackgroundResizeSlider), (Object)backgroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myLegacyIconShapeComboBox), (Object)new SelectedProperty(this.myGenerateLegacyIconYesRadioButton));
        BoolValueProperty isLauncherIcon = new BoolValueProperty(this.myIconType == AndroidIconType.LAUNCHER);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myLegacyIconShapeRowPanel), (Object)isLauncherIcon);
        layoutPropertiesBuilder.put((Object)new VisibleProperty((JComponent)this.myGenerateRoundIconTitle), (Object)isLauncherIcon);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myGenerateRoundIconRowPanel), (Object)isLauncherIcon);
        layoutPropertiesBuilder.put((Object)new VisibleProperty((JComponent)this.myGeneratePlayStoreIconTitle), (Object)isLauncherIcon);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myGeneratePlayStoreIconRowPanel), (Object)isLauncherIcon);
        ImmutableMap layoutProperties = layoutPropertiesBuilder.build();
        for (Map.Entry entry : layoutProperties.entrySet()) {
            ((BoolProperty)entry.getKey()).set(false);
            this.myGeneralBindings.bind((SettableValue)entry.getKey(), (ObservableValue)entry.getValue());
        }
        this.myListeners.listenAll((Collection<? extends ObservableValue<?>>)layoutProperties.keySet()).with(() -> {
            SwingUtilities.updateComponentTreeUI(this.myForegroundAllOptionsPanel);
            if (this.myIsMonochromeSupported) {
                SwingUtilities.updateComponentTreeUI(this.myMonochromeAllOptionsPanel);
            }
            SwingUtilities.updateComponentTreeUI(this.myBackgroundAllOptionsPanel);
            SwingUtilities.updateComponentTreeUI(this.myOtherIconsAllOptionsPanel);
        });
    }

    private void initializeValidators() {
        VisibleProperty isActive = new VisibleProperty(this);
        this.myValidatorPanel.registerTest(Expression.create(() -> isActive.get() == false || this.myBuildSdkVersion.getFeatureLevel() >= 26, isActive), "Project must be built with SDK 26 or later to use adaptive icons");
        this.myValidatorPanel.registerTest(ConfigureAdaptiveIconPanel.nameIsNotEmptyExpression(isActive, this.myForegroundLayerName), "Foreground layer name must be set");
        this.myValidatorPanel.registerValidator((ObservableValue)this.myForegroundLayerName, name2 -> Validator.Result.fromNullableMessage((String)this.myNameValidator.getErrorText(name2.trim())), new ObservableValue[0]);
        this.myValidatorPanel.registerTest(ConfigureAdaptiveIconPanel.nameIsNotEmptyExpression(isActive, this.myBackgroundLayerName), "Background layer name must be set");
        this.myValidatorPanel.registerValidator((ObservableValue)this.myBackgroundLayerName, name2 -> Validator.Result.fromNullableMessage((String)this.myNameValidator.getErrorText(name2.trim())), new ObservableValue[0]);
        this.myValidatorPanel.registerTest(ConfigureAdaptiveIconPanel.namesAreDistinctExpression(isActive, this.myOutputName, this.myForegroundLayerName), "Foreground layer must have a name distinct from the icon name");
        this.myValidatorPanel.registerTest(ConfigureAdaptiveIconPanel.namesAreDistinctExpression(isActive, this.myOutputName, this.myBackgroundLayerName), "Background layer must have a name distinct from the icon name");
        this.myValidatorPanel.registerTest(ConfigureAdaptiveIconPanel.namesAreDistinctExpression(isActive, this.myForegroundLayerName, this.myBackgroundLayerName), "Background and foreground layers must have distinct names");
        if (this.myIsMonochromeSupported) {
            this.myValidatorPanel.registerTest(ConfigureAdaptiveIconPanel.nameIsNotEmptyExpression(isActive, this.myMonochromeLayerName), "Monochrome layer name must be set");
            this.myValidatorPanel.registerTest(ConfigureAdaptiveIconPanel.namesAreDistinctExpression(isActive, this.myOutputName, this.myMonochromeLayerName), "Monochrome layer must have a name distinct from the icon name");
            this.myValidatorPanel.registerTest(ConfigureAdaptiveIconPanel.namesAreDistinctExpression(isActive, this.myMonochromeLayerName, this.myBackgroundLayerName), "Monochrome and foreground layers must have distinct names");
            this.myValidatorPanel.registerTest(ConfigureAdaptiveIconPanel.namesAreDistinctExpression(isActive, this.myMonochromeLayerName, this.myForegroundLayerName), "Monochrome and background layers must have distinct names");
            this.myValidatorPanel.registerValidator(this.myMonochromeAssetValidityState, validity -> validity, new ObservableValue[0]);
            this.myValidatorPanel.registerValidator((ObservableValue)new TextProperty(this.myMonochromeResizeValueTextField), SliderUtils.inRange(this.myMonochromeResizeSlider, "Monochrome scale"), new ObservableValue[0]);
        }
        this.myValidatorPanel.registerValidator(this.myForegroundAssetValidityState, validity -> validity, new ObservableValue[0]);
        this.myValidatorPanel.registerValidator(this.myBackgroundAssetValidityState, validity -> validity, new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)new TextProperty(this.myForegroundResizeValueTextField), SliderUtils.inRange(this.myForegroundResizeSlider, "Foreground scale"), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)new TextProperty(this.myBackgroundResizeValueTextField), SliderUtils.inRange(this.myBackgroundResizeSlider, "Background scale"), new ObservableValue[0]);
    }

    private void setupUI(boolean isMonochromeSupported, AndroidFacet androidFacet) {
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myOutputNamePanelRow = new JPanel();
        this.myOutputNamePanelRow.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myRootPanel.add((Component)this.myOutputNamePanelRow, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null, 0, false));
        this.myOutputNamePanelRow.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), null, 0, 0, null, null));
        this.myOutputNameLabel = new JBLabel();
        this.myOutputNameLabel.setText("Name:");
        this.myOutputNamePanelRow.add((Component)this.myOutputNameLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(80, -1), null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 1, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myOutputNamePanelRow.add((Component)panel1, new GridConstraints(0, 1, 1, 1, 0, 3, 5, 3, null, null, null, 0, false));
        this.myOutputNameTextField = new JTextField();
        this.myOutputNameTextField.setText("(name)");
        this.myOutputNameTextField.setToolTipText("The filename which will be used for these icons.");
        panel1.add((Component)this.myOutputNameTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JBTabbedPane imagePanelToolbar = new JBTabbedPane();
        imagePanelToolbar.setTabPlacement(1);
        this.myRootPanel.add((Component)imagePanelToolbar, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null, 0, false));
        imagePanelToolbar.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0), null, 0, 0, null, null));
        this.addForegroundLayerTab(imagePanelToolbar, androidFacet);
        this.addBackgroundLayerTab(imagePanelToolbar);
        if (isMonochromeSupported) {
            this.addMonochromeLayerTab(imagePanelToolbar, androidFacet);
        }
        this.addOtherImageOptionLayerTab(imagePanelToolbar);
    }

    private void addOtherImageOptionLayerTab(JBTabbedPane jBTabbedPane1) {
        JPanel panel6 = new JPanel();
        panel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, (Insets)JBUI.emptyInsets(), -1, -1));
        jBTabbedPane1.addTab("Options", (Component)panel6);
        this.myOtherIconsScrollPane = new JBScrollPane();
        this.myOtherIconsScrollPane.setHorizontalScrollBarPolicy(31);
        panel6.add((Component)this.myOtherIconsScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
        this.myOtherIconsAllOptionsPanel = new JPanel();
        this.myOtherIconsAllOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(10, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myOtherIconsScrollPane.setViewportView((Component)this.myOtherIconsAllOptionsPanel);
        this.myOtherIconsAllOptionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), null, 0, 0, null, null));
        TitledSeparator titledSeparator1 = new TitledSeparator();
        titledSeparator1.setText("Legacy Icon (API \u2264 25)");
        this.myOtherIconsAllOptionsPanel.add((Component)titledSeparator1, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 0, null, null, null, 0, false));
        this.myGenerateLegacyIconRowPanel = new JPanel();
        this.myGenerateLegacyIconRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myGenerateLegacyIconRowPanel.setVisible(true);
        this.myOtherIconsAllOptionsPanel.add((Component)this.myGenerateLegacyIconRowPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myGenerateLegacyIconLabel = new JBLabel();
        this.myGenerateLegacyIconLabel.setText("Generate:");
        this.myGenerateLegacyIconRowPanel.add((Component)this.myGenerateLegacyIconLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.mGenerateLegacyIconRadioButtonsPanel = new JPanel();
        this.mGenerateLegacyIconRadioButtonsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myGenerateLegacyIconRowPanel.add((Component)this.mGenerateLegacyIconRadioButtonsPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myGenerateLegacyIconYesRadioButton = new JRadioButton();
        this.myGenerateLegacyIconYesRadioButton.setSelected(true);
        this.myGenerateLegacyIconYesRadioButton.setText("Yes");
        this.myGenerateLegacyIconYesRadioButton.setToolTipText("Generate legacy icon (API \u2264 25)");
        this.mGenerateLegacyIconRadioButtonsPanel.add((Component)this.myGenerateLegacyIconYesRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JRadioButton radioButton1 = new JRadioButton();
        radioButton1.setSelected(false);
        radioButton1.setText("No");
        radioButton1.setToolTipText("");
        this.mGenerateLegacyIconRadioButtonsPanel.add((Component)radioButton1, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer5 = new Spacer();
        this.mGenerateLegacyIconRadioButtonsPanel.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myLegacyIconShapeRowPanel = new JPanel();
        this.myLegacyIconShapeRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myOtherIconsAllOptionsPanel.add((Component)this.myLegacyIconShapeRowPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 5, 3, null, null, null, 0, true));
        this.myLegacyIconShapeLabel = new JBLabel();
        this.myLegacyIconShapeLabel.setText("Shape:");
        this.myLegacyIconShapeRowPanel.add((Component)this.myLegacyIconShapeLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myLegacyIconShapePanel = new JPanel();
        this.myLegacyIconShapePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myLegacyIconShapeRowPanel.add((Component)this.myLegacyIconShapePanel, new GridConstraints(0, 1, 1, 1, 0, 3, 5, 3, null, null, null, 0, false));
        this.myLegacyIconShapeComboBox = new JComboBox();
        this.myLegacyIconShapeComboBox.setToolTipText("The shape of the launcher icon's backdrop.");
        this.myLegacyIconShapePanel.add(this.myLegacyIconShapeComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        Spacer spacer6 = new Spacer();
        this.myLegacyIconShapePanel.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myGenerateRoundIconTitle = new TitledSeparator();
        this.myGenerateRoundIconTitle.setText("Round Icon (API = 25)");
        this.myOtherIconsAllOptionsPanel.add((Component)this.myGenerateRoundIconTitle, new GridConstraints(3, 0, 1, 2, 0, 1, 0, 0, null, null, null, 0, false));
        this.myGenerateRoundIconRowPanel = new JPanel();
        this.myGenerateRoundIconRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myGenerateRoundIconRowPanel.setVisible(true);
        this.myOtherIconsAllOptionsPanel.add((Component)this.myGenerateRoundIconRowPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myGenerateRoundIconLabel = new JBLabel();
        this.myGenerateRoundIconLabel.setText("Generate:");
        this.myGenerateRoundIconRowPanel.add((Component)this.myGenerateRoundIconLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myGenerateRoundIconRadioButtonsPanel = new JPanel();
        this.myGenerateRoundIconRadioButtonsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myGenerateRoundIconRowPanel.add((Component)this.myGenerateRoundIconRadioButtonsPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myGenerateRoundIconYesRadioButton = new JRadioButton();
        this.myGenerateRoundIconYesRadioButton.setSelected(true);
        this.myGenerateRoundIconYesRadioButton.setText("Yes");
        this.myGenerateRoundIconYesRadioButton.setToolTipText("Generate round icon (API 25)");
        this.myGenerateRoundIconRadioButtonsPanel.add((Component)this.myGenerateRoundIconYesRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JRadioButton radioButton2 = new JRadioButton();
        radioButton2.setSelected(false);
        radioButton2.setText("No");
        radioButton2.setToolTipText("");
        this.myGenerateRoundIconRadioButtonsPanel.add((Component)radioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer7 = new Spacer();
        this.myGenerateRoundIconRadioButtonsPanel.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myGeneratePlayStoreIconTitle = new TitledSeparator();
        this.myGeneratePlayStoreIconTitle.setText("Google Play Store Icon");
        this.myOtherIconsAllOptionsPanel.add((Component)this.myGeneratePlayStoreIconTitle, new GridConstraints(5, 0, 1, 2, 0, 1, 0, 0, null, null, null, 0, false));
        this.myGeneratePlayStoreIconRowPanel = new JPanel();
        this.myGeneratePlayStoreIconRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myGeneratePlayStoreIconRowPanel.setVisible(true);
        this.myOtherIconsAllOptionsPanel.add((Component)this.myGeneratePlayStoreIconRowPanel, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myGeneratePlayStoreIconLabel = new JBLabel();
        this.myGeneratePlayStoreIconLabel.setText("Generate:");
        this.myGeneratePlayStoreIconRowPanel.add((Component)this.myGeneratePlayStoreIconLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myGeneratePlayStoreIconRadioButtonsPanel = new JPanel();
        this.myGeneratePlayStoreIconRadioButtonsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myGeneratePlayStoreIconRowPanel.add((Component)this.myGeneratePlayStoreIconRadioButtonsPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myGeneratePlayStoreIconYesRadioButton = new JRadioButton();
        this.myGeneratePlayStoreIconYesRadioButton.setSelected(true);
        this.myGeneratePlayStoreIconYesRadioButton.setText("Yes");
        this.myGeneratePlayStoreIconYesRadioButton.setToolTipText("Generate icon for Google Play Store (512x512)");
        this.myGeneratePlayStoreIconRadioButtonsPanel.add((Component)this.myGeneratePlayStoreIconYesRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JRadioButton radioButton3 = new JRadioButton();
        radioButton3.setSelected(false);
        radioButton3.setText("No");
        radioButton3.setToolTipText("");
        this.myGeneratePlayStoreIconRadioButtonsPanel.add((Component)radioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer8 = new Spacer();
        this.myGeneratePlayStoreIconRadioButtonsPanel.add((Component)spacer8, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        Spacer spacer9 = new Spacer();
        this.myOtherIconsAllOptionsPanel.add((Component)spacer9, new GridConstraints(9, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        this.myIconFormatTitle = new TitledSeparator();
        this.myIconFormatTitle.setText("Icon Format");
        this.myOtherIconsAllOptionsPanel.add((Component)this.myIconFormatTitle, new GridConstraints(7, 0, 1, 2, 0, 1, 0, 0, null, null, null, 0, false));
        this.myIconFormatRowPanel = new JPanel();
        this.myIconFormatRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myOtherIconsAllOptionsPanel.add((Component)this.myIconFormatRowPanel, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myIconFormatLabel = new JBLabel();
        this.myIconFormatLabel.setText("Format:");
        this.myIconFormatRowPanel.add((Component)this.myIconFormatLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myIconFormatRadioButtonsPanel = new JPanel();
        this.myIconFormatRadioButtonsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myIconFormatRowPanel.add((Component)this.myIconFormatRadioButtonsPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myIconFormatWebpRadioButton = new JRadioButton();
        this.myIconFormatWebpRadioButton.setActionCommand("WebP");
        this.myIconFormatWebpRadioButton.setText("WebP");
        this.myIconFormatWebpRadioButton.setSelected(true);
        this.myIconFormatWebpRadioButton.setText("WebP");
        this.myIconFormatWebpRadioButton.setToolTipText("Generate WebP icons");
        this.myIconFormatRadioButtonsPanel.add((Component)this.myIconFormatWebpRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JRadioButton radioButton4 = new JRadioButton();
        radioButton4.setActionCommand("PNG");
        radioButton4.setText("PNG");
        radioButton4.setText("PNG");
        radioButton4.setToolTipText("Generate PNG icons");
        this.myIconFormatRadioButtonsPanel.add((Component)radioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer10 = new Spacer();
        this.myIconFormatRadioButtonsPanel.add((Component)spacer10, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myForegroundImageRadioButton);
        buttonGroup.add(this.myForegroundClipartRadioButton);
        buttonGroup.add(this.myForegroundTextRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myForegroundTrimNoRadioButton);
        buttonGroup.add(this.myForegroundTrimYesRadioButton);
        if (this.myIsMonochromeSupported) {
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.myMonochromeImageRadioButton);
            buttonGroup.add(this.myMonochromeClipartRadioButton);
            buttonGroup.add(this.myMonochromeTextRadioButton);
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.myMonochromeTrimNoRadioButton);
            buttonGroup.add(this.myMonochromeTrimYesRadioButton);
        }
        buttonGroup = new ButtonGroup();
        buttonGroup.add(radioButton1);
        buttonGroup.add(this.myGenerateLegacyIconYesRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myBackgroundImageRadioButton);
        buttonGroup.add(this.myBackgroundColorRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myBackgroundTrimNoRadioButton);
        buttonGroup.add(this.myBackgroundTrimYesRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(radioButton2);
        buttonGroup.add(this.myGenerateRoundIconYesRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myGeneratePlayStoreIconYesRadioButton);
        buttonGroup.add(radioButton3);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myIconFormatWebpRadioButton);
        buttonGroup.add(radioButton4);
    }

    private void addBackgroundLayerTab(JBTabbedPane jBTabbedPane1) {
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        jBTabbedPane1.addTab("Background Layer", (Component)panel4);
        this.myBackgroundScrollPane = new JBScrollPane();
        this.myBackgroundScrollPane.setHorizontalScrollBarPolicy(31);
        panel4.add((Component)this.myBackgroundScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
        this.myBackgroundAllOptionsPanel = new JPanel();
        this.myBackgroundAllOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myBackgroundScrollPane.setViewportView((Component)this.myBackgroundAllOptionsPanel);
        this.myBackgroundLayerNamePanel = new JPanel();
        this.myBackgroundLayerNamePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myBackgroundLayerNamePanel.setVisible(true);
        this.myBackgroundAllOptionsPanel.add((Component)this.myBackgroundLayerNamePanel, new GridConstraints(0, 0, 1, 2, 0, 3, 5, 3, null, null, null, 0, true));
        this.myBackgroundLayerNameLabel = new JBLabel();
        this.myBackgroundLayerNameLabel.setText("Layer name:");
        this.myBackgroundLayerNamePanel.add((Component)this.myBackgroundLayerNameLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 0, false));
        JPanel panel5 = new JPanel();
        panel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myBackgroundLayerNamePanel.add((Component)panel5, new GridConstraints(0, 1, 1, 1, 0, 3, 5, 3, null, null, null, 0, false));
        this.myBackgroundLayerNameTextField = new JTextField();
        this.myBackgroundLayerNameTextField.setText("(name)");
        this.myBackgroundLayerNameTextField.setToolTipText("The filename which will be used for these icons.");
        panel5.add((Component)this.myBackgroundLayerNameTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myBackgroundSourceAssetTitleSeparator = new TitledSeparator();
        this.myBackgroundSourceAssetTitleSeparator.setText("Source Asset");
        this.myBackgroundAllOptionsPanel.add((Component)this.myBackgroundSourceAssetTitleSeparator, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 0, null, null, null, 0, false));
        this.myBackgroundAssetTypePanel = new JPanel();
        this.myBackgroundAssetTypePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myBackgroundAllOptionsPanel.add((Component)this.myBackgroundAssetTypePanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundAssetTypeLabel = new JLabel();
        this.myBackgroundAssetTypeLabel.setText("Asset type:");
        this.myBackgroundAssetTypePanel.add((Component)this.myBackgroundAssetTypeLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myBackgroundAssetRadioButtonsPanel = new JPanel();
        this.myBackgroundAssetRadioButtonsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myBackgroundAssetTypePanel.add((Component)this.myBackgroundAssetRadioButtonsPanel, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null, 0, false));
        this.myBackgroundImageRadioButton = new JRadioButton();
        this.myBackgroundImageRadioButton.setText("Image");
        this.myBackgroundImageRadioButton.setToolTipText("Select an image, e.g. PNG, SVG, PSD, or a drawable from disk to generate Android icons for your app.");
        this.myBackgroundAssetRadioButtonsPanel.add((Component)this.myBackgroundImageRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myBackgroundColorRadioButton = new JRadioButton();
        this.myBackgroundColorRadioButton.setText("Color");
        this.myBackgroundColorRadioButton.setToolTipText("Select from a background color for the Android icons for your app.");
        this.myBackgroundAssetRadioButtonsPanel.add((Component)this.myBackgroundColorRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myBackgroundAssetTypeSourcePanel = new JPanel();
        this.myBackgroundAssetTypeSourcePanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myBackgroundAllOptionsPanel.add((Component)this.myBackgroundAssetTypeSourcePanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundImageAssetRowPanel = new JPanel();
        this.myBackgroundImageAssetRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myBackgroundAssetTypeSourcePanel.add((Component)this.myBackgroundImageAssetRowPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, new Dimension(30, 30), null, null, 0, true));
        this.myBackgroundImagePathLabel = new JBLabel();
        this.myBackgroundImagePathLabel.setText("Path:");
        this.myBackgroundImageAssetRowPanel.add((Component)this.myBackgroundImagePathLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myBackgroundImageAssetBrowser = new ImageAssetBrowser();
        this.myBackgroundImageAssetRowPanel.add((Component)((Object)this.myBackgroundImageAssetBrowser), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myBackgroundColorRowPanel = new JPanel();
        this.myBackgroundColorRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myBackgroundAssetTypeSourcePanel.add((Component)this.myBackgroundColorRowPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, new Dimension(30, 30), null, null, 0, true));
        this.myBackgroundColorLabel = new JBLabel();
        this.myBackgroundColorLabel.setText("Color:");
        this.myBackgroundColorRowPanel.add((Component)this.myBackgroundColorLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myBackgroundColorPanel = new ColorPanel();
        this.myBackgroundColorPanel.setSelectedColor(new Color(-16777216));
        this.myBackgroundColorRowPanel.add((Component)this.myBackgroundColorPanel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, new Dimension(78, -1), null, null, 0, false));
        this.myBackgroundScalingTitleSeparator = new TitledSeparator();
        this.myBackgroundScalingTitleSeparator.setText("Scaling");
        this.myBackgroundAssetTypeSourcePanel.add((Component)this.myBackgroundScalingTitleSeparator, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 0, null, null, null, 0, false));
        this.myBackgroundImageOptionsPanel = new JPanel();
        this.myBackgroundImageOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myBackgroundAllOptionsPanel.add((Component)this.myBackgroundImageOptionsPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundTrimRowPanel = new JPanel();
        this.myBackgroundTrimRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myBackgroundTrimRowPanel.setVisible(true);
        this.myBackgroundImageOptionsPanel.add((Component)this.myBackgroundTrimRowPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myBackgroundTrimLabel = new JBLabel();
        this.myBackgroundTrimLabel.setText("Trim:");
        this.myBackgroundTrimRowPanel.add((Component)this.myBackgroundTrimLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myBackgroundTrimOptionsPanel = new JPanel();
        this.myBackgroundTrimOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myBackgroundTrimRowPanel.add((Component)this.myBackgroundTrimOptionsPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        this.myBackgroundTrimOptionsPanel.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myBackgroundTrimYesRadioButton = new JRadioButton();
        this.myBackgroundTrimYesRadioButton.setText("Yes");
        this.myBackgroundTrimYesRadioButton.setToolTipText("Remove any transparent space from around your source asset before rendering to icon.");
        this.myBackgroundTrimOptionsPanel.add((Component)this.myBackgroundTrimYesRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myBackgroundTrimNoRadioButton = new JRadioButton();
        this.myBackgroundTrimNoRadioButton.setSelected(true);
        this.myBackgroundTrimNoRadioButton.setText("No");
        this.myBackgroundTrimNoRadioButton.setToolTipText("Leave the original asset unmodified.");
        this.myBackgroundTrimOptionsPanel.add((Component)this.myBackgroundTrimNoRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myBackgroundResizeRowPanel = new JPanel();
        this.myBackgroundResizeRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myBackgroundResizeRowPanel.setVisible(true);
        this.myBackgroundImageOptionsPanel.add((Component)this.myBackgroundResizeRowPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myBackgroundResizeLabel = new JBLabel();
        this.myBackgroundResizeLabel.setText("Resize:");
        this.myBackgroundResizeRowPanel.add((Component)this.myBackgroundResizeLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myBackgroundResizeSliderPanel = new JPanel();
        this.myBackgroundResizeSliderPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myBackgroundResizeRowPanel.add((Component)this.myBackgroundResizeSliderPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myBackgroundResizeSlider = new JSlider();
        this.myBackgroundResizeSlider.setMaximum(400);
        this.myBackgroundResizeSlider.setMinimum(0);
        this.myBackgroundResizeSlider.setMinorTickSpacing(20);
        this.myBackgroundResizeSlider.setPaintLabels(false);
        this.myBackgroundResizeSlider.setPaintTicks(true);
        this.myBackgroundResizeSlider.setSnapToTicks(false);
        this.myBackgroundResizeSlider.setToolTipText("Resize the original asset using the specified scaling factor (in percent). This happens after any trimming.");
        this.myBackgroundResizeSlider.setValue(100);
        this.myBackgroundResizeSliderPanel.add((Component)this.myBackgroundResizeSlider, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myBackgroundResizeValueTextField = new JTextField();
        this.myBackgroundResizeValueTextField.setHorizontalAlignment(4);
        this.myBackgroundResizeValueTextField.setText("100");
        this.myBackgroundResizeSliderPanel.add((Component)this.myBackgroundResizeValueTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(30, -1), null, 0, false));
        this.myBackgroundResizeValueLabel = new JLabel();
        this.myBackgroundResizeValueLabel.setHorizontalAlignment(4);
        this.myBackgroundResizeValueLabel.setText("%");
        this.myBackgroundResizeSliderPanel.add((Component)this.myBackgroundResizeValueLabel, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, new Dimension(-1, -1), null, 0, false));
        Spacer spacer4 = new Spacer();
        this.myBackgroundAllOptionsPanel.add((Component)spacer4, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
    }

    private void addForegroundLayerTab(JBTabbedPane jBTabbedPane1, AndroidFacet androidFacet) {
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, (Insets)JBUI.emptyInsets(), -1, -1));
        jBTabbedPane1.addTab("Foreground Layer", (Component)panel2);
        this.myForegroundScrollPane = new JBScrollPane();
        this.myForegroundScrollPane.setHorizontalScrollBarPolicy(31);
        panel2.add((Component)this.myForegroundScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
        this.myForegroundAllOptionsPanel = new JPanel();
        this.myForegroundAllOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myForegroundScrollPane.setViewportView((Component)this.myForegroundAllOptionsPanel);
        this.myForegroundLayerNamePanel = new JPanel();
        this.myForegroundLayerNamePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myForegroundLayerNamePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myForegroundLayerNamePanel.setVisible(true);
        this.myForegroundAllOptionsPanel.add((Component)this.myForegroundLayerNamePanel, new GridConstraints(0, 0, 1, 2, 0, 3, 5, 0, null, null, null, 0, true));
        this.myForegroundLayerNameLabel = new JBLabel();
        this.myForegroundLayerNameLabel.setText("Layer name:");
        this.myForegroundLayerNamePanel.add((Component)this.myForegroundLayerNameLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myForegroundLayerNamePanel.add((Component)panel3, new GridConstraints(0, 1, 1, 1, 0, 3, 5, 3, null, null, null, 0, false));
        this.myForegroundLayerNameTextField = new JTextField();
        this.myForegroundLayerNameTextField.setText("(name)");
        this.myForegroundLayerNameTextField.setToolTipText("The filename which will be used for these icons.");
        panel3.add((Component)this.myForegroundLayerNameTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.mySourceAssetTitleSeparator = new TitledSeparator();
        this.mySourceAssetTitleSeparator.setText("Source Asset");
        this.myForegroundAllOptionsPanel.add((Component)this.mySourceAssetTitleSeparator, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 0, null, null, null, 0, false));
        this.myForegroundAssetTypePanel = new JPanel();
        this.myForegroundAssetTypePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myForegroundAllOptionsPanel.add((Component)this.myForegroundAssetTypePanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundAssetTypeLabel = new JLabel();
        this.myForegroundAssetTypeLabel.setText("Asset type:");
        this.myForegroundAssetTypePanel.add((Component)this.myForegroundAssetTypeLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myForegroundAssetRadioButtonsPanel = new JPanel();
        this.myForegroundAssetRadioButtonsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myForegroundAssetTypePanel.add((Component)this.myForegroundAssetRadioButtonsPanel, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 0, null, null, null, 0, false));
        this.myForegroundClipartRadioButton = new JRadioButton();
        this.myForegroundClipartRadioButton.setText("Clip art");
        this.myForegroundClipartRadioButton.setToolTipText("Select from a list of clipart choices to generate Android icons for your app.");
        this.myForegroundAssetRadioButtonsPanel.add((Component)this.myForegroundClipartRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myForegroundTextRadioButton = new JRadioButton();
        this.myForegroundTextRadioButton.setText("Text");
        this.myForegroundTextRadioButton.setToolTipText("Enter text which will be rendered into Android icons for your app.");
        this.myForegroundAssetRadioButtonsPanel.add((Component)this.myForegroundTextRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myForegroundImageRadioButton = new JRadioButton();
        this.myForegroundImageRadioButton.setText("Image");
        this.myForegroundImageRadioButton.setToolTipText("Select an image, e.g. PNG, SVG, PSD, or a drawable from disk to generate Android icons for your app.");
        this.myForegroundAssetRadioButtonsPanel.add((Component)this.myForegroundImageRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myForegroundAssetTypeSourcePanel = new JPanel();
        this.myForegroundAssetTypeSourcePanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myForegroundAllOptionsPanel.add((Component)this.myForegroundAssetTypeSourcePanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundImageAssetRowPanel = new JPanel();
        this.myForegroundImageAssetRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myForegroundAssetTypeSourcePanel.add((Component)this.myForegroundImageAssetRowPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundImagePathLabel = new JBLabel();
        this.myForegroundImagePathLabel.setText("Path:");
        this.myForegroundImageAssetRowPanel.add((Component)this.myForegroundImagePathLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myForegroundImageAssetBrowser = new ImageAssetBrowser();
        this.myForegroundImageAssetRowPanel.add((Component)((Object)this.myForegroundImageAssetBrowser), new GridConstraints(0, 1, 1, 1, 0, 1, 5, 0, null, null, null, 0, false));
        this.myForegroundClipartAssetRowPanel = new JPanel();
        this.myForegroundClipartAssetRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myForegroundAssetTypeSourcePanel.add((Component)this.myForegroundClipartAssetRowPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundClipartLabel = new JBLabel();
        this.myForegroundClipartLabel.setText("Clip art:");
        this.myForegroundClipartAssetRowPanel.add((Component)this.myForegroundClipartLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myForegroundClipartAssetButton = new ClipartIconButton(androidFacet);
        this.myForegroundClipartAssetRowPanel.add((Component)this.myForegroundClipartAssetButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 2, null, null, null, 0, false));
        this.myForegroundTextAssetRowPanel = new JPanel();
        this.myForegroundTextAssetRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myForegroundAssetTypeSourcePanel.add((Component)this.myForegroundTextAssetRowPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundTextLabel = new JBLabel();
        this.myForegroundTextLabel.setText("Text:");
        this.myForegroundTextAssetRowPanel.add((Component)this.myForegroundTextLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myForegroundTextAssetEditor = new MultiLineTextAssetEditor();
        this.myForegroundTextAssetRowPanel.add((Component)this.myForegroundTextAssetEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myForegroundColorRowPanel = new JPanel();
        this.myForegroundColorRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myForegroundAssetTypeSourcePanel.add((Component)this.myForegroundColorRowPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundColorLabel = new JBLabel();
        this.myForegroundColorLabel.setText("Color:");
        this.myForegroundColorRowPanel.add((Component)this.myForegroundColorLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myForegroundColorPanel = new ColorPanel();
        this.myForegroundColorPanel.setSelectedColor(new Color(-16777216));
        this.myForegroundColorRowPanel.add((Component)this.myForegroundColorPanel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(78, -1), null, null, 0, false));
        this.myForegroundImageOptionsPanel = new JPanel();
        this.myForegroundImageOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myForegroundAllOptionsPanel.add((Component)this.myForegroundImageOptionsPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundScalingTitleSeparator = new TitledSeparator();
        this.myForegroundScalingTitleSeparator.setText("Scaling");
        this.myForegroundImageOptionsPanel.add((Component)this.myForegroundScalingTitleSeparator, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 0, null, null, null, 0, false));
        this.myForegroundTrimPanel = new JPanel();
        this.myForegroundTrimPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myForegroundTrimPanel.setVisible(true);
        this.myForegroundImageOptionsPanel.add((Component)this.myForegroundTrimPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundTrimLabel = new JBLabel();
        this.myForegroundTrimLabel.setText("Trim:");
        this.myForegroundTrimPanel.add((Component)this.myForegroundTrimLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myForegroundTrimOptionsPanel = new JPanel();
        this.myForegroundTrimOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myForegroundTrimPanel.add((Component)this.myForegroundTrimOptionsPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myForegroundTrimOptionsPanel.add((Component)spacer1, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myForegroundTrimYesRadioButton = new JRadioButton();
        this.myForegroundTrimYesRadioButton.setText("Yes");
        this.myForegroundTrimYesRadioButton.setToolTipText("Remove any transparent space from around your source asset before rendering to icon.");
        this.myForegroundTrimOptionsPanel.add((Component)this.myForegroundTrimYesRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myForegroundTrimNoRadioButton = new JRadioButton();
        this.myForegroundTrimNoRadioButton.setSelected(true);
        this.myForegroundTrimNoRadioButton.setText("No");
        this.myForegroundTrimNoRadioButton.setToolTipText("Leave the original asset unmodified.");
        this.myForegroundTrimOptionsPanel.add((Component)this.myForegroundTrimNoRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myForegroundResizePanel = new JPanel();
        this.myForegroundResizePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myForegroundResizePanel.setVisible(true);
        this.myForegroundImageOptionsPanel.add((Component)this.myForegroundResizePanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundResizeLabel = new JBLabel();
        this.myForegroundResizeLabel.setText("Resize:");
        this.myForegroundResizePanel.add((Component)this.myForegroundResizeLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myForegroundResizeSliderPanel = new JPanel();
        this.myForegroundResizeSliderPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myForegroundResizePanel.add((Component)this.myForegroundResizeSliderPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myForegroundResizeSlider = new JSlider();
        this.myForegroundResizeSlider.setMaximum(400);
        this.myForegroundResizeSlider.setMinimum(0);
        this.myForegroundResizeSlider.setMinorTickSpacing(20);
        this.myForegroundResizeSlider.setPaintLabels(false);
        this.myForegroundResizeSlider.setPaintTicks(true);
        this.myForegroundResizeSlider.setSnapToTicks(false);
        this.myForegroundResizeSlider.setToolTipText("Resize the original asset using the specified scaling factor (in percent). This happens after any trimming.");
        this.myForegroundResizeSlider.setValue(100);
        this.myForegroundResizeSlider.setValueIsAdjusting(false);
        this.myForegroundResizeSliderPanel.add((Component)this.myForegroundResizeSlider, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myForegroundResizeValueTextField = new JTextField();
        this.myForegroundResizeValueTextField.setHorizontalAlignment(4);
        this.myForegroundResizeValueTextField.setText("100");
        this.myForegroundResizeSliderPanel.add((Component)this.myForegroundResizeValueTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(30, -1), null, 0, false));
        this.myForegroundResizeValueLabel = new JLabel();
        this.myForegroundResizeValueLabel.setHorizontalAlignment(4);
        this.myForegroundResizeValueLabel.setText("%");
        this.myForegroundResizeSliderPanel.add((Component)this.myForegroundResizeValueLabel, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, new Dimension(-1, -1), null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myForegroundAllOptionsPanel.add((Component)spacer2, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
    }

    private void addMonochromeLayerTab(JBTabbedPane jBTabbedPane1, AndroidFacet androidFacet) {
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.emptyInsets(), -1, -1));
        jBTabbedPane1.addTab("Monochrome", (Component)panel2);
        JBScrollPane monochromeScrollPane = new JBScrollPane();
        monochromeScrollPane.setHorizontalScrollBarPolicy(31);
        panel2.add((Component)monochromeScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
        this.myMonochromeAllOptionsPanel = new JPanel();
        this.myMonochromeAllOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        monochromeScrollPane.setViewportView((Component)this.myMonochromeAllOptionsPanel);
        JPanel monochromeLayerNamePanel = new JPanel();
        monochromeLayerNamePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        monochromeLayerNamePanel.setVisible(true);
        this.myMonochromeAllOptionsPanel.add((Component)monochromeLayerNamePanel, new GridConstraints(0, 0, 1, 2, 0, 3, 5, 0, null, null, null, 0, true));
        this.myMonochromeLayerNameLabel = new JBLabel();
        this.myMonochromeLayerNameLabel.setText("Layer name:");
        monochromeLayerNamePanel.add((Component)this.myMonochromeLayerNameLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, (Insets)JBUI.emptyInsets(), -1, -1));
        monochromeLayerNamePanel.add((Component)panel3, new GridConstraints(0, 1, 1, 1, 0, 3, 5, 3, null, null, null, 0, false));
        this.myMonochromeLayerNameTextField = new JTextField();
        this.myMonochromeLayerNameTextField.setText("(name)");
        this.myMonochromeLayerNameTextField.setToolTipText("The filename which will be used for these icons.");
        panel3.add((Component)this.myMonochromeLayerNameTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.mySourceAssetTitleSeparator = new TitledSeparator();
        this.mySourceAssetTitleSeparator.setText("Source Asset");
        this.myMonochromeAllOptionsPanel.add((Component)this.mySourceAssetTitleSeparator, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 0, null, null, null, 0, false));
        JPanel monochromeAssetTypePanel = new JPanel();
        monochromeAssetTypePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myMonochromeAllOptionsPanel.add((Component)monochromeAssetTypePanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myMonochromeAssetTypeLabel = new JLabel();
        this.myMonochromeAssetTypeLabel.setText("Asset type:");
        monochromeAssetTypePanel.add((Component)this.myMonochromeAssetTypeLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myMonochromeAssetRadioButtonsPanel = new JPanel();
        this.myMonochromeAssetRadioButtonsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.emptyInsets(), -1, -1));
        monochromeAssetTypePanel.add((Component)this.myMonochromeAssetRadioButtonsPanel, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 0, null, null, null, 0, false));
        this.myMonochromeClipartRadioButton = new JRadioButton();
        this.myMonochromeClipartRadioButton.setText("Clip art");
        this.myMonochromeClipartRadioButton.setToolTipText("Select from a list of clipart choices to generate Android icons for your app.");
        this.myMonochromeAssetRadioButtonsPanel.add((Component)this.myMonochromeClipartRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myMonochromeTextRadioButton = new JRadioButton();
        this.myMonochromeTextRadioButton.setText("Text");
        this.myMonochromeTextRadioButton.setToolTipText("Enter text which will be rendered into Android icons for your app.");
        this.myMonochromeAssetRadioButtonsPanel.add((Component)this.myMonochromeTextRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myMonochromeImageRadioButton = new JRadioButton();
        this.myMonochromeImageRadioButton.setText("Image");
        this.myMonochromeImageRadioButton.setToolTipText("Select an image, e.g. PNG, SVG, PSD, or a drawable from disk to generate Android icons for your app.");
        this.myMonochromeAssetRadioButtonsPanel.add((Component)this.myMonochromeImageRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel monochromeAssetTypeSourcePanel = new JPanel();
        monochromeAssetTypeSourcePanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myMonochromeAllOptionsPanel.add((Component)monochromeAssetTypeSourcePanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myMonochromeImageAssetRowPanel = new JPanel();
        this.myMonochromeImageAssetRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        monochromeAssetTypeSourcePanel.add((Component)this.myMonochromeImageAssetRowPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myMonochromeImagePathLabel = new JBLabel();
        this.myMonochromeImagePathLabel.setText("Path:");
        this.myMonochromeImageAssetRowPanel.add((Component)this.myMonochromeImagePathLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myMonochromeImageAssetBrowser = new ImageAssetBrowser();
        this.myMonochromeImageAssetRowPanel.add((Component)((Object)this.myMonochromeImageAssetBrowser), new GridConstraints(0, 1, 1, 1, 0, 1, 5, 0, null, null, null, 0, false));
        this.myMonochromeClipartAssetRowPanel = new JPanel();
        this.myMonochromeClipartAssetRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        monochromeAssetTypeSourcePanel.add((Component)this.myMonochromeClipartAssetRowPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myMonochromeClipartLabel = new JBLabel();
        this.myMonochromeClipartLabel.setText("Clip art:");
        this.myMonochromeClipartAssetRowPanel.add((Component)this.myMonochromeClipartLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myMonochromeClipartAssetButton = new ClipartIconButton(androidFacet);
        this.myMonochromeClipartAssetRowPanel.add((Component)this.myMonochromeClipartAssetButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 2, null, null, null, 0, false));
        this.myMonochromeTextAssetRowPanel = new JPanel();
        this.myMonochromeTextAssetRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        monochromeAssetTypeSourcePanel.add((Component)this.myMonochromeTextAssetRowPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myMonochromeTextLabel = new JBLabel();
        this.myMonochromeTextLabel.setText("Text:");
        this.myMonochromeTextAssetRowPanel.add((Component)this.myMonochromeTextLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myMonochromeTextAssetEditor = new MultiLineTextAssetEditor();
        this.myMonochromeTextAssetRowPanel.add((Component)this.myMonochromeTextAssetEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myMonochromeColorRowPanel = new JPanel();
        this.myMonochromeColorRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        monochromeAssetTypeSourcePanel.add((Component)this.myMonochromeColorRowPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myMonochromeColorLabel = new JBLabel();
        this.myMonochromeColorLabel.setText("Color:");
        this.myMonochromeColorRowPanel.add((Component)this.myMonochromeColorLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myMonochromeColorPanel = new ColorPanel();
        this.myMonochromeColorPanel.setSelectedColor(new Color(-16777216));
        this.myMonochromeColorRowPanel.add((Component)this.myMonochromeColorPanel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(78, -1), null, null, 0, false));
        this.myMonochromeImageOptionsPanel = new JPanel();
        this.myMonochromeImageOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myMonochromeAllOptionsPanel.add((Component)this.myMonochromeImageOptionsPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myMonochromeScalingTitleSeparator = new TitledSeparator();
        this.myMonochromeScalingTitleSeparator.setText("Scaling");
        this.myMonochromeImageOptionsPanel.add((Component)this.myMonochromeScalingTitleSeparator, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 0, null, null, null, 0, false));
        JPanel myMonochromeTrimPanel = new JPanel();
        myMonochromeTrimPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        myMonochromeTrimPanel.setVisible(true);
        this.myMonochromeImageOptionsPanel.add((Component)myMonochromeTrimPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myMonochromeTrimLabel = new JBLabel();
        this.myMonochromeTrimLabel.setText("Trim:");
        myMonochromeTrimPanel.add((Component)this.myMonochromeTrimLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myMonochromeTrimOptionsPanel = new JPanel();
        this.myMonochromeTrimOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.emptyInsets(), -1, -1));
        myMonochromeTrimPanel.add((Component)this.myMonochromeTrimOptionsPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myMonochromeTrimOptionsPanel.add((Component)spacer1, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myMonochromeTrimYesRadioButton = new JRadioButton();
        this.myMonochromeTrimYesRadioButton.setText("Yes");
        this.myMonochromeTrimYesRadioButton.setToolTipText("Remove any transparent space from around your source asset before rendering to icon.");
        this.myMonochromeTrimOptionsPanel.add((Component)this.myMonochromeTrimYesRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myMonochromeTrimNoRadioButton = new JRadioButton();
        this.myMonochromeTrimNoRadioButton.setSelected(true);
        this.myMonochromeTrimNoRadioButton.setText("No");
        this.myMonochromeTrimNoRadioButton.setToolTipText("Leave the original asset unmodified.");
        this.myMonochromeTrimOptionsPanel.add((Component)this.myMonochromeTrimNoRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JPanel monochromeResizePanel = new JPanel();
        monochromeResizePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.emptyInsets(), -1, -1));
        monochromeResizePanel.setVisible(true);
        this.myMonochromeImageOptionsPanel.add((Component)monochromeResizePanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myMonochromeResizeLabel = new JBLabel();
        this.myMonochromeResizeLabel.setText("Resize:");
        monochromeResizePanel.add((Component)this.myMonochromeResizeLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myMonochromeResizeSliderPanel = new JPanel();
        this.myMonochromeResizeSliderPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, (Insets)JBUI.emptyInsets(), -1, -1));
        monochromeResizePanel.add((Component)this.myMonochromeResizeSliderPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myMonochromeResizeSlider = new JSlider();
        this.myMonochromeResizeSlider.setMaximum(400);
        this.myMonochromeResizeSlider.setMinimum(0);
        this.myMonochromeResizeSlider.setMinorTickSpacing(20);
        this.myMonochromeResizeSlider.setPaintLabels(false);
        this.myMonochromeResizeSlider.setPaintTicks(true);
        this.myMonochromeResizeSlider.setSnapToTicks(false);
        this.myMonochromeResizeSlider.setToolTipText("Resize the original asset using the specified scaling factor (in percent). This happens after any trimming.");
        this.myMonochromeResizeSlider.setValue(100);
        this.myMonochromeResizeSlider.setValueIsAdjusting(false);
        this.myMonochromeResizeSliderPanel.add((Component)this.myMonochromeResizeSlider, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myMonochromeResizeValueTextField = new JTextField();
        this.myMonochromeResizeValueTextField.setHorizontalAlignment(4);
        this.myMonochromeResizeValueTextField.setText("100");
        this.myMonochromeResizeSliderPanel.add((Component)this.myMonochromeResizeValueTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(30, -1), null, 0, false));
        JLabel monochromeResizeValueLabel = new JLabel();
        monochromeResizeValueLabel.setHorizontalAlignment(4);
        monochromeResizeValueLabel.setText("%");
        this.myMonochromeResizeSliderPanel.add((Component)monochromeResizeValueLabel, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, new Dimension(-1, -1), null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myMonochromeAllOptionsPanel.add((Component)spacer2, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
    }

    @NotNull
    private static Expression<Boolean> nameIsNotEmptyExpression(@NotNull VisibleProperty isActive, @NotNull StringProperty name2) {
        return Expression.create(() -> isActive.get() == false || !StringUtil.isEmptyOrSpaces((String)((String)name2.get())), isActive, name2);
    }

    @NotNull
    private static Expression<Boolean> namesAreDistinctExpression(@NotNull VisibleProperty isActive, @NotNull StringProperty name1, @NotNull StringProperty name2) {
        return Expression.create(() -> isActive.get() == false || !StringUtil.equalsTrimWhitespaces((CharSequence)((CharSequence)name1.get()), (CharSequence)((CharSequence)name2.get())), isActive, name1, name2);
    }

    @Override
    @NotNull
    public AdaptiveIconGenerator getIconGenerator() {
        return this.myIconGenerator;
    }

    @Override
    @NotNull
    public JComponent getRootComponent() {
        return this;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener listener2) {
        this.myAssetListeners.add(listener2);
    }

    @Override
    @NotNull
    public StringProperty outputName() {
        return this.myOutputName;
    }

    private void fireAssetListeners() {
        ActionEvent e = new ActionEvent(this, 1001, null);
        for (ActionListener assetListener : this.myAssetListeners) {
            assetListener.actionPerformed(e);
        }
    }

    private void updateBindingsAndUiForActiveIconType() {
        this.myOutputName.set(this.myDefaultOutputName);
        this.myForegroundLayerName.set(this.defaultForegroundLayerName());
        this.myBackgroundLayerName.set(this.defaultBackgroundLayerName());
        this.myGeneralBindings.bind(this.myIconGenerator.sourceAsset(), new AsOptionalExpression<BaseAsset>((ObservableValue<BaseAsset>)this.myForegroundActiveAsset));
        this.myGeneralBindings.bind(this.myIconGenerator.outputName(), this.myOutputName);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.backgroundImageAsset(), this.myBackgroundImageAsset);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.backgroundColor(), this.myBackgroundColor);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.showSafeZone(), this.myShowSafeZone);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.generateLegacyIcon(), this.myGenerateLegacyIcon);
        AdaptiveIconGenerator adaptiveIconGenerator = this.myIconGenerator;
        if (adaptiveIconGenerator instanceof LauncherIconGenerator) {
            LauncherIconGenerator iconGenerator = (LauncherIconGenerator)adaptiveIconGenerator;
            this.myGeneralBindings.bindTwoWay(iconGenerator.generateRoundIcon(), this.myGenerateRoundIcon);
            this.myGeneralBindings.bindTwoWay(iconGenerator.generatePlayStoreIcon(), this.myGeneratePlayStoreIcon);
            this.myGeneralBindings.bindTwoWay(iconGenerator.generateWebpIcons(), this.myGenerateWebpIcons);
            this.myGeneralBindings.bindTwoWay(iconGenerator.legacyIconShape(), this.myLegacyIconShape);
            this.myGeneralBindings.bindTwoWay(iconGenerator.showGrid(), this.myShowGrid);
            this.myGeneralBindings.bindTwoWay(iconGenerator.previewDensity(), this.myPreviewDensity);
        }
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.foregroundLayerName(), this.myForegroundLayerName);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.backgroundLayerName(), this.myBackgroundLayerName);
        if (this.myIsMonochromeSupported) {
            this.myGeneralBindings.bindTwoWay(this.myIconGenerator.monochromeLayerName(), this.myMonochromeLayerName);
        }
    }

    public void dispose() {
        this.myGeneralBindings.releaseAll();
        this.myForegroundActiveAssetBindings.releaseAll();
        this.myBackgroundActiveAssetBindings.releaseAll();
        if (this.myIsMonochromeSupported) {
            this.myMonochromeActiveAssetBindings.releaseAll();
        }
        this.myListeners.releaseAll();
        this.myAssetListeners.clear();
    }

    @NotNull
    private String defaultForegroundLayerName() {
        return (String)this.myOutputName.get() + "_foreground";
    }

    @NotNull
    private String defaultBackgroundLayerName() {
        return (String)this.myOutputName.get() + "_background";
    }

    @NotNull
    private String defaultMonochromeLayerName() {
        return (String)this.myOutputName.get() + "_monochrome";
    }

    private static enum ForegroundAssetType {
        IMAGE,
        CLIP_ART,
        TEXT;

    }

    private static enum BackgroundAssetType {
        IMAGE,
        COLOR;

    }

    private static enum MonochromeAssetType {
        IMAGE,
        CLIP_ART,
        TEXT;

    }
}

