/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.ndk;

import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SourceCodeFilter
implements PsiFileSystemItemFilter {
    @NotNull
    private final List<String> mySourceFolderPaths;

    SourceCodeFilter(@NotNull List<String> sourceFolderPaths) {
        this.mySourceFolderPaths = sourceFolderPaths;
    }

    public boolean shouldShow(@NotNull PsiFileSystemItem item) {
        if (item instanceof PsiDirectory) {
            PsiDirectory psiFolder = (PsiDirectory)item;
            VirtualFile folder = psiFolder.getVirtualFile();
            String folderPath = VfsUtilCore.virtualToIoFile((VirtualFile)folder).toString();
            return this.isValidPath(folderPath);
        }
        return true;
    }

    private boolean isValidPath(@NotNull String path) {
        for (String existing : this.mySourceFolderPaths) {
            if (!existing.contains(path) && !path.contains(existing)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SourceCodeFilter)) {
            return false;
        }
        SourceCodeFilter filter2 = (SourceCodeFilter)o;
        return Objects.equals(this.mySourceFolderPaths, filter2.mySourceFolderPaths);
    }

    public int hashCode() {
        return Objects.hash(this.mySourceFolderPaths);
    }
}

