/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.navigator.AndroidViewNodes;
import com.android.tools.idea.navigator.nodes.AndroidViewTypeSortWeight;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.GroupNodes;
import com.android.tools.idea.navigator.nodes.android.AndroidPsiDirectoryNode;
import com.android.tools.idea.navigator.nodes.android.AndroidPsiFileNode;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.SourceProvidersKt;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0016\u0018\u0000 72\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003:\u00017B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0012\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013H\u0016J$\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00132\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013H\u0002J \u0010\u0017\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00182\u0006\u0010\u001a\u001a\u00020\rH\u0004J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0014\u0010#\u001a\u0004\u0018\u00010\u00192\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0011\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\rH\u0096\u0002J\u0010\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0016J\u000e\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010-H\u0016J\u000e\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010-H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020'H\u0016J\u0013\u00102\u001a\u00020'2\b\u00103\u001a\u0004\u0018\u00010+H\u0096\u0002J\b\u00104\u001a\u000200H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u001e\u00a8\u00068"}, d2={"Lcom/android/tools/idea/navigator/nodes/android/AndroidSourceTypeNode;", "Lcom/intellij/ide/projectView/ProjectViewNode;", "Lorg/jetbrains/android/facet/AndroidFacet;", "Lcom/android/tools/idea/navigator/nodes/FolderGroupNode;", "project", "Lcom/intellij/openapi/project/Project;", "androidFacet", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "sourceType", "Lorg/jetbrains/android/facet/AndroidSourceType;", "sourceRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/android/facet/AndroidFacet;Lcom/intellij/ide/projectView/ViewSettings;Lorg/jetbrains/android/facet/AndroidSourceType;Ljava/util/Set;)V", "sortedSourceRoots", "", "getChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "annotateWithSourceProvider", "folderChildren", "findSourceProvider", "Lkotlin/Pair;", "", "virtualFile", "sourceFolders", "Lcom/intellij/psi/PsiDirectory;", "getSourceFolders", "()Ljava/util/List;", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "toTestString", "printInfo", "Lcom/intellij/openapi/ui/Queryable$PrintInfo;", "contains", "", "file", "canRepresent", "element", "", "getSortKey", "", "getTypeSortKey", "getTypeSortWeight", "", "sortByType", "equals", "other", "hashCode", "folders", "getFolders", "Companion", "intellij.android.navigator"})
@SourceDebugExtension(value={"SMAP\nAndroidSourceTypeNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidSourceTypeNode.kt\ncom/android/tools/idea/navigator/nodes/android/AndroidSourceTypeNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1056#2:160\n1374#2:161\n1460#2,5:162\n1563#2:167\n1634#2,3:168\n1761#2,3:171\n*S KotlinDebug\n*F\n+ 1 AndroidSourceTypeNode.kt\ncom/android/tools/idea/navigator/nodes/android/AndroidSourceTypeNode\n*L\n52#1:160\n59#1:161\n59#1:162,5\n65#1:167\n65#1:168,3\n120#1:171,3\n*E\n"})
public class AndroidSourceTypeNode
extends ProjectViewNode<AndroidFacet>
implements FolderGroupNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidSourceType sourceType;
    @NotNull
    private final List<VirtualFile> sortedSourceRoots;
    @NotNull
    private static final String GENERATED_SUFFIX = " (generated)";

    public AndroidSourceTypeNode(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull ViewSettings settings, @NotNull AndroidSourceType sourceType, @NotNull Set<? extends VirtualFile> sourceRoots) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)androidFacet, (String)"androidFacet");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
        Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
        super(project, (Object)androidFacet, settings);
        this.sourceType = sourceType;
        Iterable $this$sortedBy$iv = sourceRoots;
        boolean $i$f$sortedBy = false;
        this.sortedSourceRoots = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(this){
            final /* synthetic */ AndroidSourceTypeNode this$0;
            {
                this.this$0 = androidSourceTypeNode;
            }

            public final int compare(T a, T b) {
                VirtualFile it = (VirtualFile)a;
                boolean bl = false;
                String name2 = (String)this.this$0.findSourceProvider(it).component1();
                it = (VirtualFile)b;
                Comparable comparable = (Comparable)((Object)AndroidPsiDirectoryNode.getSourceProviderSortKeyPart(name2));
                bl = false;
                name2 = (String)this.this$0.findSourceProvider(it).component1();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)AndroidPsiDirectoryNode.getSourceProviderSortKeyPart(name2))));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        void $this$flatMapTo$iv$iv;
        ProjectViewDirectoryHelper projectViewDirectoryHelper = ProjectViewDirectoryHelper.getInstance((Project)this.myProject);
        Iterable $this$flatMap$iv = this.getSourceFolders();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiDirectory directory = (PsiDirectory)element$iv$iv;
            boolean bl = false;
            Collection collection2 = projectViewDirectoryHelper.getDirectoryChildren(directory, this.getSettings(), true);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getDirectoryChildren(...)");
            Iterable list$iv$iv = this.annotateWithSourceProvider(collection2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<AbstractTreeNode<?>> annotateWithSourceProvider(Collection<? extends AbstractTreeNode<?>> folderChildren) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = folderChildren;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            AbstractTreeNode abstractTreeNode;
            void child;
            AbstractTreeNode abstractTreeNode2 = (AbstractTreeNode)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void var11_11 = child;
            if (var11_11 instanceof PsiDirectoryNode) {
                Object object = ((PsiDirectoryNode)child).getValue();
                Intrinsics.checkNotNull((Object)object);
                PsiDirectory folder = (PsiDirectory)object;
                VirtualFile virtualFile = folder.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                Pair<String, VirtualFile> pair = this.findSourceProvider(virtualFile);
                String first = (String)pair.component1();
                VirtualFile file = (VirtualFile)pair.component2();
                PsiDirectory psiDir = file == null ? null : PsiManager.getInstance((Project)this.myProject).findDirectory(file);
                abstractTreeNode = (AbstractTreeNode)new AndroidPsiDirectoryNode(this.myProject, folder, this.getSettings(), first, psiDir);
            } else if (var11_11 instanceof PsiFileNode) {
                Object object = ((PsiFileNode)child).getValue();
                Intrinsics.checkNotNull((Object)object);
                PsiFile file = (PsiFile)object;
                VirtualFile virtualFile = file.getVirtualFile();
                Intrinsics.checkNotNull((Object)virtualFile);
                String first = (String)this.findSourceProvider(virtualFile).component1();
                abstractTreeNode = (AbstractTreeNode)new AndroidPsiFileNode(this.myProject, file, this.getSettings(), first);
            } else {
                abstractTreeNode = child;
            }
            collection2.add(abstractTreeNode);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final Pair<String, VirtualFile> findSourceProvider(@NotNull VirtualFile virtualFile) {
        Pair pair;
        Pair pair2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Object object = this.getValue();
            Intrinsics.checkNotNull((Object)object);
            AndroidFacet androidFacet = (AndroidFacet)object;
            Iterable<NamedIdeaSourceProvider> iterable = AndroidViewNodes.getSourceProviders(androidFacet);
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"getSourceProviders(...)");
            for (NamedIdeaSourceProvider provider : iterable) {
                VirtualFile root;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)provider);
                Pair pair3 = SourceProvidersKt.findSourceRoot(provider, virtualFile) == null ? null : TuplesKt.to((Object)provider.getName(), (Object)root);
                if (pair3 == null) continue;
                pair2 = pair3;
                break block2;
            }
            pair2 = pair = null;
        }
        if (pair2 == null) {
            pair = TuplesKt.to(null, null);
        }
        return pair;
    }

    @NotNull
    protected final List<PsiDirectory> getSourceFolders() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.sortedSourceRoots), AndroidSourceTypeNode::_get_sourceFolders_$lambda$0), arg_0 -> AndroidSourceTypeNode._get_sourceFolders_$lambda$1(psiManager2, arg_0)));
    }

    protected void update(@NotNull PresentationData presentation) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.addText(this.sourceType.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.sourceType.isGenerated()) {
            presentation.addText(GENERATED_SUFFIX, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if ((icon = this.sourceType.getIcon()) != null) {
            presentation.setIcon(icon);
        }
        presentation.setPresentableText(this.toTestString(null));
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.sourceType.isGenerated() ? this.sourceType.getName() + GENERATED_SUFFIX : this.sourceType.getName();
    }

    public boolean contains(@NotNull VirtualFile file) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$any$iv = this.sortedSourceRoots;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile root = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean canRepresent(@NotNull Object element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return GroupNodes.canRepresent(this, element);
    }

    @Nullable
    public Comparable<?> getSortKey() {
        return this.sourceType;
    }

    @Nullable
    public Comparable<?> getTypeSortKey() {
        return this.sourceType;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return AndroidViewTypeSortWeight.PACKAGE.getWeight();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        AndroidSourceTypeNode that = (AndroidSourceTypeNode)other;
        return this.sourceType == that.sourceType && Intrinsics.areEqual(this.sortedSourceRoots, that.sortedSourceRoots);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.sourceType, this.sortedSourceRoots};
        return Objects.hash(objectArray);
    }

    @Override
    @NotNull
    public List<PsiDirectory> getFolders() {
        return this.getSourceFolders();
    }

    private static final boolean _get_sourceFolders_$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isValid();
    }

    private static final PsiDirectory _get_sourceFolders_$lambda$1(PsiManager $psiManager, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $psiManager.findDirectory(it);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/navigator/nodes/android/AndroidSourceTypeNode$Companion;", "", "<init>", "()V", "GENERATED_SUFFIX", "", "intellij.android.navigator"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

