/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.navigator.nodes.AndroidViewTypeSortWeight;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidBuildScriptNode
extends PsiFileNode {
    @Nullable
    private final String myQualifier;
    private final int myOrder;

    public AndroidBuildScriptNode(@NotNull Project project, @NotNull PsiFile value2, @NotNull ViewSettings settings, @Nullable String qualifier, int order) {
        super(project, value2, settings);
        this.myQualifier = qualifier;
        this.myOrder = order;
    }

    public void update(@NotNull PresentationData data2) {
        super.update(data2);
        PsiFile psiFile = (PsiFile)this.getValue();
        if (psiFile != null && psiFile.isValid()) {
            String fileName = psiFile.getName();
            data2.addText(fileName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            data2.setPresentableText(fileName);
            if (this.myQualifier != null) {
                data2.addText(" (" + this.myQualifier + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }
    }

    @Nullable
    public Comparable getSortKey() {
        return Integer.valueOf(this.myOrder);
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    public int getTypeSortWeight(boolean sortByType) {
        return AndroidViewTypeSortWeight.FILE.getWeight();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiFile value2 = (PsiFile)this.getValue();
        String fileName = value2 != null ? value2.getName() : "";
        return fileName + (String)(this.myQualifier == null ? "" : " (" + this.myQualifier + ")");
    }
}

