/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.nav.safeargs.module;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.nav.safeargs.SafeArgsFeature;
import com.android.tools.idea.nav.safeargs.SafeArgsMode;
import com.android.tools.idea.nav.safeargs.SafeArgsModeKt;
import com.android.tools.idea.nav.safeargs.index.NavXmlData;
import com.android.tools.idea.nav.safeargs.index.NavXmlIndex;
import com.android.tools.idea.nav.safeargs.module.NavEntry;
import com.android.tools.idea.nav.safeargs.module.NavInfo;
import com.android.tools.idea.nav.safeargs.module.NavInfoChangeReason;
import com.android.tools.idea.nav.safeargs.module.NavInfoFetcherBase;
import com.android.tools.idea.nav.safeargs.module.SafeArgsModeModuleService;
import com.android.tools.idea.nav.safeargs.project.NavigationResourcesModificationListenerKt;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.res.LocalResourceRepository;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0019\u001a\u00020\fH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u00148FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0018\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/nav/safeargs/module/NavInfoFetcher;", "Lcom/android/tools/idea/nav/safeargs/module/NavInfoFetcherBase;", "Lcom/intellij/openapi/util/ModificationTracker;", "parent", "Lcom/intellij/openapi/Disposable;", "module", "Lcom/intellij/openapi/module/Module;", "mode", "Lcom/android/tools/idea/nav/safeargs/SafeArgsMode;", "onChange", "Lkotlin/Function1;", "Lcom/android/tools/idea/nav/safeargs/module/NavInfoChangeReason;", "", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/module/Module;Lcom/android/tools/idea/nav/safeargs/SafeArgsMode;Lkotlin/jvm/functions/Function1;)V", "modificationTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "_listenersRegistered", "Ljava/util/concurrent/atomic/AtomicBoolean;", "listenersRegistered", "", "getListenersRegistered$annotations", "()V", "getListenersRegistered", "()Z", "ensureListenersRegistered", "androidFacetIfEnabled", "Lorg/jetbrains/android/facet/AndroidFacet;", "getAndroidFacetIfEnabled", "()Lorg/jetbrains/android/facet/AndroidFacet;", "isEnabled", "getModificationCount", "", "invalidate", "reason", "getCurrentNavInfo", "Lcom/android/tools/idea/nav/safeargs/module/NavInfo;", "Companion", "intellij.android.nav.safeargs.common"})
@SourceDebugExtension(value={"SMAP\nNavInfoFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavInfoFetcher.kt\ncom/android/tools/idea/nav/safeargs/module/NavInfoFetcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,315:1\n1617#2,9:316\n1869#2:325\n1870#2:327\n1626#2:328\n1#3:326\n*S KotlinDebug\n*F\n+ 1 NavInfoFetcher.kt\ncom/android/tools/idea/nav/safeargs/module/NavInfoFetcher\n*L\n216#1:316,9\n216#1:325\n216#1:327\n216#1:328\n216#1:326\n*E\n"})
public final class NavInfoFetcher
implements NavInfoFetcherBase,
ModificationTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Disposable parent;
    @NotNull
    private final Module module;
    @NotNull
    private final SafeArgsMode mode;
    @NotNull
    private final Function1<NavInfoChangeReason, Unit> onChange;
    @NotNull
    private final SimpleModificationTracker modificationTracker;
    @NotNull
    private final AtomicBoolean _listenersRegistered;

    public NavInfoFetcher(@NotNull Disposable parent, @NotNull Module module, @NotNull SafeArgsMode mode, @NotNull Function1<? super NavInfoChangeReason, Unit> onChange2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter(onChange2, (String)"onChange");
        this.parent = parent;
        this.module = module;
        this.mode = mode;
        this.onChange = onChange2;
        this.modificationTracker = new SimpleModificationTracker();
        this._listenersRegistered = new AtomicBoolean(false);
    }

    public /* synthetic */ NavInfoFetcher(Disposable disposable, Module module, SafeArgsMode safeArgsMode, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = NavInfoFetcher::_init_$lambda$0;
        }
        this(disposable, module, safeArgsMode, (Function1<? super NavInfoChangeReason, Unit>)function1);
    }

    public final boolean getListenersRegistered() {
        return this._listenersRegistered.get();
    }

    @VisibleForTesting
    public static /* synthetic */ void getListenersRegistered$annotations() {
    }

    private final void ensureListenersRegistered() {
        MessageBusConnection messageBusConnection;
        if (this._listenersRegistered.getAndSet(true)) {
            return;
        }
        MessageBusConnection $this$ensureListenersRegistered_u24lambda_u240 = messageBusConnection = this.module.getProject().getMessageBus().connect(this.parent);
        boolean bl = false;
        $this$ensureListenersRegistered_u24lambda_u240.subscribe(NavigationResourcesModificationListenerKt.getNAVIGATION_RESOURCES_CHANGED(), arg_0 -> NavInfoFetcher.ensureListenersRegistered$lambda$0$0(this, arg_0));
        $this$ensureListenersRegistered_u24lambda_u240.subscribe(SafeArgsModeModuleService.Companion.getMODE_CHANGED(), (arg_0, arg_1) -> NavInfoFetcher.ensureListenersRegistered$lambda$0$1(this, arg_0, arg_1));
        $this$ensureListenersRegistered_u24lambda_u240.subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, arg_0 -> NavInfoFetcher.ensureListenersRegistered$lambda$0$2(this, arg_0));
        $this$ensureListenersRegistered_u24lambda_u240.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(this){
            final /* synthetic */ NavInfoFetcher this$0;
            {
                this.this$0 = $receiver;
            }

            public void enteredDumbMode() {
                NavInfoFetcher.access$invalidate(this.this$0, NavInfoChangeReason.DUMB_MODE_CHANGED);
            }

            public void exitDumbMode() {
                NavInfoFetcher.access$invalidate(this.this$0, NavInfoChangeReason.DUMB_MODE_CHANGED);
            }
        });
        SafeArgsModeModuleService.Companion.getInstance(this.module);
    }

    private final AndroidFacet getAndroidFacetIfEnabled() {
        return NavInfoFetcher.Companion.getAndroidFacetIfSafeArgsEnabled(this.module, this.mode);
    }

    @Override
    public boolean isEnabled() {
        this.ensureListenersRegistered();
        return this.getAndroidFacetIfEnabled() != null;
    }

    public long getModificationCount() {
        this.ensureListenersRegistered();
        return this.modificationTracker.getModificationCount();
    }

    private final void invalidate(NavInfoChangeReason reason) {
        this.modificationTracker.incModificationCount();
        this.onChange.invoke((Object)reason);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public NavInfo getCurrentNavInfo() {
        void $this$mapNotNullTo$iv$iv;
        this.ensureListenersRegistered();
        AndroidFacet androidFacet = this.getAndroidFacetIfEnabled();
        if (androidFacet == null) {
            return null;
        }
        AndroidFacet facet = androidFacet;
        String string = ProjectSystemUtil.getModuleSystem(facet).getPackageName();
        if (string == null) {
            return null;
        }
        String modulePackage = string;
        Set<SafeArgsFeature> safeArgsFeatures = SafeArgsModeKt.getSafeArgsFeatures(facet);
        long modificationCount = this.getModificationCount();
        LocalResourceRepository<VirtualFile> localResourceRepository = StudioResourceRepositoryManager.getModuleResources(facet);
        Intrinsics.checkNotNullExpressionValue(localResourceRepository, (String)"getModuleResources(...)");
        LocalResourceRepository<VirtualFile> moduleResources2 = localResourceRepository;
        ListMultimap<String, ResourceItem> listMultimap = moduleResources2.getResources(ResourceNamespace.RES_AUTO, ResourceType.NAVIGATION);
        Intrinsics.checkNotNullExpressionValue(listMultimap, (String)"getResources(...)");
        ListMultimap<String, ResourceItem> navResources = listMultimap;
        Collection collection2 = navResources.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"values(...)");
        Iterable $this$mapNotNull$iv = collection2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            NavEntry navEntry;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ResourceItem resource = (ResourceItem)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)resource);
            if (IdeResourcesUtil.getSourceAsVirtualFile(resource) == null) {
                navEntry = null;
            } else {
                NavXmlData data2;
                VirtualFile file;
                Project project = this.module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                navEntry = NavXmlIndex.Companion.getDataForFile(project, file) == null ? null : new NavEntry(facet, resource, file, data2);
            }
            if (navEntry == null) continue;
            NavEntry it$iv$iv = navEntry;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List entries2 = (List)destination$iv$iv;
        return new NavInfo(facet, modulePackage, entries2, safeArgsFeatures, modificationCount);
    }

    private static final Unit _init_$lambda$0(NavInfoChangeReason it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return Unit.INSTANCE;
    }

    private static final void ensureListenersRegistered$lambda$0$0(NavInfoFetcher this$0, Module changedModule) {
        if (changedModule == null || Intrinsics.areEqual((Object)changedModule, (Object)this$0.module)) {
            this$0.invalidate(NavInfoChangeReason.NAVIGATION_RESOURCE_CHANGED);
        }
    }

    private static final void ensureListenersRegistered$lambda$0$1(NavInfoFetcher this$0, Module changedModule, SafeArgsMode safeArgsMode) {
        Intrinsics.checkNotNullParameter((Object)changedModule, (String)"changedModule");
        Intrinsics.checkNotNullParameter((Object)((Object)safeArgsMode), (String)"<unused var>");
        if (Intrinsics.areEqual((Object)changedModule, (Object)this$0.module)) {
            this$0.invalidate(NavInfoChangeReason.SAFE_ARGS_MODE_CHANGED);
        }
    }

    private static final void ensureListenersRegistered$lambda$0$2(NavInfoFetcher this$0, ProjectSystemSyncManager.SyncResult it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        this$0.invalidate(NavInfoChangeReason.GRADLE_SYNC);
    }

    public static final /* synthetic */ void access$invalidate(NavInfoFetcher $this, NavInfoChangeReason reason) {
        $this.invalidate(reason);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/nav/safeargs/module/NavInfoFetcher$Companion;", "", "<init>", "()V", "getAndroidFacetIfSafeArgsEnabled", "Lorg/jetbrains/android/facet/AndroidFacet;", "Lorg/jetbrains/annotations/Nullable;", "module", "Lcom/intellij/openapi/module/Module;", "requiredMode", "Lcom/android/tools/idea/nav/safeargs/SafeArgsMode;", "isSafeArgsModule", "", "intellij.android.nav.safeargs.common"})
    public static final class Companion {
        private Companion() {
        }

        private final AndroidFacet getAndroidFacetIfSafeArgsEnabled(Module module, SafeArgsMode requiredMode) {
            Object object;
            AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
            if (androidFacet != null) {
                AndroidFacet androidFacet2;
                AndroidFacet it = androidFacet2 = androidFacet;
                boolean bl = false;
                object = SafeArgsModeKt.isSafeArgsEnabled(it) && SafeArgsModeKt.getSafeArgsMode(it) == requiredMode ? androidFacet2 : null;
            } else {
                object = null;
            }
            return object;
        }

        public final boolean isSafeArgsModule(@NotNull Module module, @NotNull SafeArgsMode requiredMode) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)requiredMode), (String)"requiredMode");
            return this.getAndroidFacetIfSafeArgsEnabled(module, requiredMode) != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

