/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.annotations.concurrency.Slow;
import com.android.manifmerger.Actions;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.tools.idea.model.MergedManifestException;
import com.android.tools.idea.model.MergedManifestInfoToken;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ManifestOverrides;
import com.android.tools.idea.projectsystem.MergedManifestContributors;
import com.android.tools.idea.projectsystem.ModuleSystemUtil;
import com.android.tools.idea.projectsystem.ProjectSyncModificationTracker;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProviders;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXParseException;

final class MergedManifestInfo {
    private static final Logger LOG = Logger.getInstance(MergedManifestInfo.class);
    @NotNull
    private final AndroidFacet myFacet;
    @Nullable
    private final org.w3c.dom.Document myDomDocument;
    @NotNull
    private final ModificationStamps myModificationStamps;
    private final long mySyncModificationCount;
    @Nullable
    private final ImmutableList<MergingReport.Record> myLoggingRecords;
    @Nullable
    private final Actions myActions;

    private MergedManifestInfo(@NotNull AndroidFacet facet, @Nullable org.w3c.dom.Document domDocument, @NotNull ModificationStamps modificationStamps, long syncModificationCount, @Nullable ImmutableList<MergingReport.Record> loggingRecords, @Nullable Actions actions2) {
        this.myFacet = facet;
        this.myDomDocument = domDocument;
        this.myModificationStamps = modificationStamps;
        this.mySyncModificationCount = syncModificationCount;
        this.myLoggingRecords = loggingRecords;
        this.myActions = actions2;
    }

    @Slow
    @NotNull
    public static MergedManifestInfo create(@NotNull AndroidFacet facet) {
        Project project = facet.getModule().getProject();
        MergedManifestContributors contributors = ProjectSystemUtil.getModuleSystem(facet).getMergedManifestContributors();
        ModificationStamps modificationStamps = ModificationStamps.forFiles(project, contributors.allFiles);
        long syncModificationCount = ProjectSyncModificationTracker.getInstance(project).getModificationCount();
        org.w3c.dom.Document document = null;
        ImmutableList<MergingReport.Record> loggingRecords = null;
        Actions actions2 = null;
        ParsedMergeResult result2 = MergedManifestInfo.mergeManifests(facet, contributors);
        if (result2 != null) {
            document = result2.document;
            loggingRecords = result2.loggingRecords;
            actions2 = result2.actions;
        }
        return new MergedManifestInfo(facet, document, modificationStamps, syncModificationCount, loggingRecords, actions2);
    }

    @NotNull
    public static MergedManifestInfo createEmpty(@NotNull AndroidFacet facet) {
        Project project = facet.getModule().getProject();
        MergedManifestContributors contributors = ProjectSystemUtil.getModuleSystem(facet).getMergedManifestContributors();
        ModificationStamps modificationStamps = ModificationStamps.forFiles(project, contributors.allFiles);
        long syncModificationCount = ProjectSyncModificationTracker.getInstance(project).getModificationCount();
        return new MergedManifestInfo(facet, null, modificationStamps, syncModificationCount, null, null);
    }

    @Slow
    @Nullable
    private static ParsedMergeResult mergeManifests(@NotNull AndroidFacet facet, @NotNull MergedManifestContributors manifests) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (manifests.primaryManifest == null) {
            return null;
        }
        try {
            MergingReport mergingReport = MergedManifestInfo.getMergedManifest(facet, manifests.primaryManifest, manifests.flavorAndBuildTypeManifests, manifests.libraryManifests, manifests.navigationFiles);
            XmlDocument doc = mergingReport.getMergedXmlDocument(MergingReport.MergedManifestKind.MERGED);
            if (doc != null) {
                return new ParsedMergeResult(doc.getXml(), (ImmutableList<MergingReport.Record>)mergingReport.getLoggingRecords(), mergingReport.getActions());
            }
            LOG.warn("getMergedManifestSupplier failed " + mergingReport.getReportString());
            return new ParsedMergeResult(null, (ImmutableList<MergingReport.Record>)mergingReport.getLoggingRecords(), mergingReport.getActions());
        }
        catch (ManifestMerger2.MergeFailureException e) {
            if (e.getCause() instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e.getCause();
            }
            if (e.getCause() instanceof SAXParseException) {
                throw new MergedManifestException.ParsingError(e.getCause());
            }
            throw new MergedManifestException.MergingError(facet.getModule(), (Throwable)e);
        }
    }

    public boolean isUpToDate() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myFacet.isDisposed()) {
            return true;
        }
        MergedManifestContributors manifests = ProjectSystemUtil.getModuleSystem(this.myFacet).getMergedManifestContributors();
        if (manifests.primaryManifest == null) {
            return true;
        }
        long modificationCount = ProjectSyncModificationTracker.getInstance(this.myFacet.getModule().getProject()).getModificationCount();
        if (this.myDomDocument == null || modificationCount != this.mySyncModificationCount) {
            return false;
        }
        return this.myModificationStamps.isCurrent(this.myFacet.getModule().getProject(), manifests.allFiles);
    }

    @Nullable
    public org.w3c.dom.Document getXmlDocument() {
        return this.myDomDocument;
    }

    @NotNull
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @NotNull
    public ImmutableList<VirtualFile> getFiles() {
        return this.myModificationStamps.getFiles();
    }

    @NotNull
    public ImmutableList<MergingReport.Record> getLoggingRecords() {
        return this.myLoggingRecords == null ? ImmutableList.of() : this.myLoggingRecords;
    }

    @Nullable
    public Actions getActions() {
        return this.myActions;
    }

    @Slow
    @NotNull
    static MergingReport getMergedManifest(final @NotNull AndroidFacet facet, final @NotNull VirtualFile primaryManifestFile, @NotNull List<VirtualFile> flavorAndBuildTypeManifests, final @NotNull List<VirtualFile> libManifests, @NotNull List<VirtualFile> navigationFiles) throws ManifestMerger2.MergeFailureException {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final File mainManifestFile = VfsUtilCore.virtualToIoFile((VirtualFile)primaryManifestFile);
        ILogger logger = NullLogger.getLogger();
        ManifestMerger2.MergeType mergeType = ((AndroidFacetConfiguration)facet.getConfiguration()).isAppOrFeature() ? ManifestMerger2.MergeType.APPLICATION : ManifestMerger2.MergeType.LIBRARY;
        ManifestMerger2.Invoker manifestMergerInvoker = ManifestMerger2.newMerger((File)mainManifestFile, (ILogger)logger, (ManifestMerger2.MergeType)mergeType);
        manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.SKIP_BLAME, ManifestMerger2.Invoker.Feature.SKIP_XML_STRING, ManifestMerger2.Invoker.Feature.KEEP_GOING_AFTER_ERRORS, ManifestMerger2.Invoker.Feature.USES_SDK_IN_MANIFEST_LENIENT_HANDLING});
        manifestMergerInvoker.addFlavorAndBuildTypeManifests(VfsUtilCore.virtualToIoFiles(flavorAndBuildTypeManifests).toArray(new File[0]));
        manifestMergerInvoker.addNavigationFiles((Iterable)VfsUtilCore.virtualToIoFiles(navigationFiles));
        manifestMergerInvoker.withProcessCancellationChecker(ProgressManager::checkCanceled);
        for (VirtualFile file : libManifests) {
            manifestMergerInvoker.addLibraryManifest(file.getName(), VfsUtilCore.virtualToIoFile((VirtualFile)file));
        }
        AndroidModuleSystem androidModuleSystem = ProjectSystemUtil.getModuleSystem(facet.getModule());
        String packageName = androidModuleSystem.getPackageName();
        if (packageName != null) {
            manifestMergerInvoker.setNamespace(packageName);
        }
        ManifestOverrides overrides2 = androidModuleSystem.getManifestOverrides();
        overrides2.getPlaceholders().forEach((arg_0, arg_1) -> ((ManifestMerger2.Invoker)manifestMergerInvoker).setPlaceHolderValue(arg_0, arg_1));
        overrides2.getDirectOverrides().forEach((arg_0, arg_1) -> ((ManifestMerger2.Invoker)manifestMergerInvoker).setOverride(arg_0, arg_1));
        if (mergeType == ManifestMerger2.MergeType.APPLICATION) {
            manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS});
        }
        final FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        manifestMergerInvoker.withManifestDocumentProvider(new ManifestMerger2.ManifestDocumentProvider(){

            public Optional<org.w3c.dom.Document> getManifestDocument(@NotNull File file) {
                Module moduleContainingManifest;
                ProgressManager.checkCanceled();
                VirtualFile vFile = MergedManifestInfo.getVirtualFile(file, mainManifestFile, primaryManifestFile);
                if (vFile != null && !libManifests.isEmpty() && (moduleContainingManifest = MergedManifestInfo.getAndroidModuleForFileIfManifest(facet.getModule().getProject(), vFile)) != null && !facet.getModule().equals((Object)moduleContainingManifest)) {
                    MergedManifestSnapshot manifest = MergedManifestManager.getFreshSnapshotInCallingThread(moduleContainingManifest);
                    return Optional.ofNullable(manifest.getDocument());
                }
                return Optional.empty();
            }
        });
        manifestMergerInvoker.withFileStreamProvider(new ManifestMerger2.FileStreamProvider(){

            protected InputStream getInputStream(@NotNull File file) throws IOException {
                ProgressManager.checkCanceled();
                VirtualFile vFile = MergedManifestInfo.getVirtualFile(file, mainManifestFile, primaryManifestFile);
                if (vFile == null) {
                    return new ByteArrayInputStream("<manifest/>".getBytes(StandardCharsets.UTF_8));
                }
                Document document = fileDocumentManager.getCachedDocument(vFile);
                if (document != null) {
                    return new CharSequenceInputStream(document.getCharsSequence(), StandardCharsets.UTF_8);
                }
                return vFile.getInputStream();
            }
        });
        Project project = facet.getModule().getProject();
        AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem(project);
        Optional<MergedManifestInfoToken> maybeToken = MergedManifestInfoToken.EP_NAME.getExtensionList().stream().filter(t -> t.isApplicable(projectSystem)).findFirst();
        maybeToken.ifPresent(token -> token.withProjectSystemFeatures(projectSystem, manifestMergerInvoker, facet));
        return manifestMergerInvoker.merge();
    }

    private static VirtualFile getVirtualFile(@NotNull File file, @NotNull File mainManifestFile, @NotNull VirtualFile primaryManifestFile) {
        VirtualFile vFile = file == mainManifestFile ? primaryManifestFile : VfsUtil.findFileByIoFile((File)file, (boolean)false);
        return vFile;
    }

    @Nullable
    private static Module getAndroidModuleForFileIfManifest(@NotNull Project project, @NotNull VirtualFile vFile) {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)project);
        if (module == null) {
            return null;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet == null) {
            return null;
        }
        SourceProviders sourceProviders = SourceProviders.getInstance(androidFacet);
        if (Iterables.tryFind(sourceProviders.getSources().getManifestFiles(), it -> Objects.equals(it, vFile)).isPresent()) {
            return ModuleSystemUtil.getProductionAndroidModule(androidFacet);
        }
        return null;
    }

    private static class ModificationStamps {
        @NotNull
        private final ImmutableList<VirtualFile> files;
        @NotNull
        private final Object2LongMap<Object> modificationStamps;

        private ModificationStamps(@NotNull ImmutableList<VirtualFile> files2, @NotNull Object2LongMap<Object> modificationStamps) {
            this.files = files2;
            this.modificationStamps = modificationStamps;
        }

        @NotNull
        public static ModificationStamps forFiles(@NotNull Project project, @NotNull List<VirtualFile> files2) {
            ImmutableList.Builder fileListBuilder = ImmutableList.builder();
            Object2LongOpenHashMap modificationStamps = new Object2LongOpenHashMap();
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            for (VirtualFile file : files2) {
                fileListBuilder.add((Object)file);
                PsiFile psiFile = psiManager.findFile(file);
                if (psiFile == null) {
                    modificationStamps.put((Object)file, file.getModificationStamp());
                    continue;
                }
                modificationStamps.put((Object)psiFile, psiFile.getModificationStamp());
            }
            return new ModificationStamps((ImmutableList<VirtualFile>)fileListBuilder.build(), (Object2LongMap<Object>)modificationStamps);
        }

        public boolean isCurrent(@NotNull Project project, @NotNull List<VirtualFile> files2) {
            if (!files2.equals(this.files)) {
                return false;
            }
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            for (VirtualFile file : files2) {
                PsiFile psiFile = psiManager.findFile(file);
                if (!(psiFile == null ? file.getModificationStamp() != this.modificationStamps.getLong((Object)file) : psiFile.getModificationStamp() != this.modificationStamps.getLong((Object)psiFile))) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public ImmutableList<VirtualFile> getFiles() {
            return this.files;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ModificationStamps)) {
                return false;
            }
            return this.modificationStamps.equals(((ModificationStamps)other).modificationStamps);
        }

        public int hashCode() {
            return this.modificationStamps.hashCode();
        }
    }

    private static class ParsedMergeResult {
        @Nullable
        final org.w3c.dom.Document document;
        @NotNull
        final ImmutableList<MergingReport.Record> loggingRecords;
        @NotNull
        final Actions actions;

        ParsedMergeResult(@Nullable org.w3c.dom.Document document, @NotNull ImmutableList<MergingReport.Record> loggingRecords, @NotNull Actions actions2) {
            this.document = document;
            this.loggingRecords = loggingRecords;
            this.actions = actions2;
        }
    }
}

