/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.notifications;

import com.android.tools.idea.mlkit.LoggingUtils;
import com.android.tools.idea.mlkit.MlUtils;
import com.android.tools.idea.mlkit.viewer.TfliteModelFileEditor;
import com.android.tools.idea.npw.template.components.ModuleTemplateComboProvider;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.wireless.android.sdk.stats.MlModelBindingEvent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InNonMlFolderNotificationProvider
implements EditorNotificationProvider {
    private static final Key<String> HIDDEN_KEY = Key.create((String)"ml.incorrect.folder.notification.panel.hidden");

    @Nullable
    public Function<FileEditor, EditorNotificationPanel> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (!"tflite".equals(file.getExtension())) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null || MlUtils.isModelFileInMlModelsFolder(module, file)) {
            return null;
        }
        List moduleTemplateList = ContainerUtil.filter(ProjectSystemUtil.getModuleSystem(module).getModuleTemplates(file), template -> !template.getPaths().getMlModelsDirectories().isEmpty());
        if (moduleTemplateList.isEmpty()) {
            return null;
        }
        return fileEditor -> {
            if (fileEditor.getUserData(HIDDEN_KEY) != null || !(fileEditor instanceof TfliteModelFileEditor)) {
                return null;
            }
            EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
            panel2.setText("This TensorFlow Lite model is not in a configured ml-model directory, so ML Model Binding is disabled. To use ML Model Binding consider moving the file.");
            panel2.createActionLabel("Move File", () -> {
                MoveModelFileDialog moveModelFileDialog = new MoveModelFileDialog(moduleTemplateList);
                if (moveModelFileDialog.showAndGet()) {
                    WriteAction.run(() -> this.onMoveFile(moveModelFileDialog, project, file));
                }
            });
            panel2.createActionLabel("Hide notification", () -> {
                fileEditor.putUserData(HIDDEN_KEY, (Object)"true");
                EditorNotifications.getInstance((Project)project).updateNotifications(file);
            });
            return panel2;
        };
    }

    private void onMoveFile(MoveModelFileDialog moveModelFileDialog, Project project, VirtualFile file) {
        VirtualFile mlVirtualDir = null;
        try {
            PsiDirectory mlPsiDir;
            mlVirtualDir = VfsUtil.createDirectoryIfMissing((String)moveModelFileDialog.getSelectedMlDirectoryPath());
            if (mlVirtualDir != null && !CopyFilesOrDirectoriesHandler.checkFileExist((PsiDirectory)(mlPsiDir = PsiDirectoryFactory.getInstance((Project)project).createDirectory(mlVirtualDir)), null, (PsiFile)PsiManager.getInstance((Project)project).findFile(file), (String)file.getName(), (String)"Move")) {
                file.move((Object)this, mlVirtualDir);
                EditorNotifications.getInstance((Project)project).updateNotifications(file);
                LoggingUtils.logEvent(MlModelBindingEvent.EventType.MODEL_IMPORT_FROM_MOVE_FILE_BUTTON, file);
            }
        }
        catch (IOException e) {
            Logger.getInstance(InNonMlFolderNotificationProvider.class).error(String.format("Error moving %s to %s.", file, mlVirtualDir), (Throwable)e);
        }
    }

    private static class MoveModelFileDialog
    extends DialogWrapper {
        private final List<NamedModuleTemplate> myNamedModuleTemplateList;
        private ComboBox<NamedModuleTemplate> myComboBox;

        private MoveModelFileDialog(@NotNull List<NamedModuleTemplate> namedModuleTemplateList) {
            super(true);
            this.myNamedModuleTemplateList = namedModuleTemplateList;
            this.init();
            this.setTitle("Move TensorFlow Lite Model File");
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel dialogPanel = new JPanel();
            dialogPanel.setLayout(new BoxLayout(dialogPanel, 0));
            dialogPanel.setAlignmentY(0.5f);
            dialogPanel.setBorder(JBUI.Borders.empty((int)10));
            dialogPanel.add((Component)new JBLabel("Move the model file to the ml directory in "));
            this.myComboBox = new ModuleTemplateComboProvider(this.myNamedModuleTemplateList).createComponent();
            dialogPanel.add((Component)this.myComboBox);
            return dialogPanel;
        }

        @NotNull
        private String getSelectedMlDirectoryPath() {
            return ((NamedModuleTemplate)this.myComboBox.getSelectedItem()).getPaths().getMlModelsDirectories().get(0).getPath();
        }
    }
}

