/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.notifications;

import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.WellKnownMavenArtifactId;
import com.android.tools.idea.mlkit.MlUtils;
import com.android.tools.idea.mlkit.viewer.TfliteModelFileEditor;
import com.android.tools.idea.projectsystem.RegisteredDependencyId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DependenciesTooLowNotificationProvider
implements EditorNotificationProvider {
    private static final Key<String> HIDDEN_KEY = Key.create((String)"ml.deps.too.low.notification.panel.hidden");

    DependenciesTooLowNotificationProvider() {
    }

    @Nullable
    public Function<FileEditor, EditorNotificationPanel> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (!"tflite".equals(file.getExtension())) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null || !MlUtils.isMlModelBindingBuildFeatureEnabled(module) || !MlUtils.isModelFileInMlModelsFolder(module, file)) {
            return null;
        }
        List<Pair<RegisteredDependencyId, Map.Entry<WellKnownMavenArtifactId, Version>>> depPairList = MlUtils.getDependenciesLowerThanRequiredVersion(module);
        if (depPairList.isEmpty()) {
            return null;
        }
        return fileEditor -> {
            if (fileEditor.getUserData(HIDDEN_KEY) != null || !(fileEditor instanceof TfliteModelFileEditor)) {
                return null;
            }
            EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
            panel2.setText("ML Model Binding requires updated dependencies");
            panel2.createActionLabel("View dependencies", () -> {
                String existingDepString = depPairList.stream().map(it -> (RegisteredDependencyId)it.getFirst()).map(it -> String.format(Locale.US, "    %s\n", it)).collect(Collectors.joining(""));
                String requiredDepString = depPairList.stream().map(it -> (Map.Entry)it.getSecond()).map(it -> String.format(Locale.US, "    %s\n", ((WellKnownMavenArtifactId)it.getKey()).getComponent(((Version)it.getValue()).toString()))).collect(Collectors.joining(""));
                Messages.showWarningDialog((String)String.format(Locale.US, "Existing:\n%s\nRequired:\n%s", existingDepString, requiredDepString), (String)"Dependencies Needing Updates");
            });
            panel2.createActionLabel("Hide notification", () -> {
                fileEditor.putUserData(HIDDEN_KEY, (Object)"true");
                EditorNotifications.getInstance((Project)project).updateNotifications(file);
            });
            return panel2;
        };
    }
}

