/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.tools.idea.mlkit.MlProjectService;
import com.android.tools.idea.mlkit.MlUtils;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.AndroidLightPackage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MlClassFinder
extends PsiElementFinder {
    private final Project myProject;

    public MlClassFinder(@NotNull Project project) {
        this.myProject = project;
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass[] lightClasses = this.findClasses(qualifiedName, scope);
        return lightClasses.length > 0 ? lightClasses[0] : null;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (!qualifiedName.contains(".ml")) {
            return PsiClass.EMPTY_ARRAY;
        }
        String className = StringUtil.getShortName((String)qualifiedName);
        return (PsiClass[])MlProjectService.getInstance(this.myProject).getLightClassListByClassName(className).stream().filter(lightClass -> PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)lightClass) && qualifiedName.equals(lightClass.getQualifiedName())).toArray(PsiClass[]::new);
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String packageName) {
        if (!packageName.endsWith(".ml")) {
            return null;
        }
        String modulePackageName = StringUtil.substringBeforeLast((String)packageName, (String)".ml");
        for (AndroidFacet facet : ProjectSystemUtil.getProjectSystem(this.myProject).getAndroidFacetsWithPackageName(modulePackageName)) {
            if (!MlUtils.isMlModelBindingBuildFeatureEnabled(facet.getModule())) continue;
            return AndroidLightPackage.withName(packageName, this.myProject);
        }
        return null;
    }
}

