/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memorysettings;

import com.android.tools.idea.memorysettings.BuildSystemComponent;
import com.android.tools.idea.memorysettings.GradleComponent;
import com.android.tools.idea.memorysettings.MemorySettingsToken;
import com.android.tools.idea.projectsystem.GradleToken;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.Arrays;

public class MemorySettingsGradleToken
implements MemorySettingsToken<GradleProjectSystem>,
GradleToken {
    public static final int LARGE_MODULE_COUNT = 100;
    public static final int XLARGE_MODULE_COUNT = 200;

    @Override
    public BuildSystemComponent createBuildSystemComponent(GradleProjectSystem projectSystem) {
        return new GradleComponent();
    }

    @Override
    public int getRecommendedXmxFor(GradleProjectSystem projectSystem) {
        Project project = projectSystem.getProject();
        long numberOfModules = Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).filter(LinkedAndroidModuleGroupUtilsKt::isHolderModule).count();
        if (numberOfModules >= 200L) {
            return 8192;
        }
        if (numberOfModules >= 100L) {
            return 4096;
        }
        return 2048;
    }
}

