/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.messages;

import com.android.tools.idea.logcat.message.LogcatMessage;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0012J\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u0015R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u001d\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/logcat/messages/TextAccumulator;", "", "<init>", "()V", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "text", "", "getText", "()Ljava/lang/String;", "textAttributesRanges", "", "Lcom/android/tools/idea/logcat/messages/TextAccumulator$Range;", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getTextAttributesRanges", "()Ljava/util/List;", "textAttributesKeyRanges", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getTextAttributesKeyRanges", "messageRanges", "Lcom/android/tools/idea/logcat/message/LogcatMessage;", "getMessageRanges", "accumulate", "textAttributes", "textAttributesKey", "getTextLength", "", "addMessageRange", "", "start", "end", "message", "Range", "intellij.android.logcat"})
public final class TextAccumulator {
    @NotNull
    private final StringBuilder stringBuilder = new StringBuilder();
    @NotNull
    private final List<Range<TextAttributes>> textAttributesRanges = new ArrayList();
    @NotNull
    private final List<Range<TextAttributesKey>> textAttributesKeyRanges = new ArrayList();
    @NotNull
    private final List<Range<LogcatMessage>> messageRanges = new ArrayList();

    @NotNull
    public final String getText() {
        String string = this.stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final List<Range<TextAttributes>> getTextAttributesRanges() {
        return this.textAttributesRanges;
    }

    @NotNull
    public final List<Range<TextAttributesKey>> getTextAttributesKeyRanges() {
        return this.textAttributesKeyRanges;
    }

    @NotNull
    public final List<Range<LogcatMessage>> getMessageRanges() {
        return this.messageRanges;
    }

    @NotNull
    public final TextAccumulator accumulate(@NotNull String text2, @Nullable TextAttributes textAttributes, @Nullable TextAttributesKey textAttributesKey) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        boolean bl2 = bl = textAttributes == null || textAttributesKey == null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-TextAccumulator$accumulate$22 = false;
            String $i$a$-assert-TextAccumulator$accumulate$22 = "Only one of textAttributesKey and textAttributesKeyKey can be set";
            throw new AssertionError((Object)$i$a$-assert-TextAccumulator$accumulate$22);
        }
        int start2 = this.stringBuilder.length();
        int end = start2 + text2.length();
        this.stringBuilder.append(text2);
        if (textAttributes != null) {
            this.textAttributesRanges.add(new Range<TextAttributes>(start2, end, textAttributes));
        } else if (textAttributesKey != null) {
            this.textAttributesKeyRanges.add(new Range<TextAttributesKey>(start2, end, textAttributesKey));
        }
        return this;
    }

    public static /* synthetic */ TextAccumulator accumulate$default(TextAccumulator textAccumulator, String string, TextAttributes textAttributes, TextAttributesKey textAttributesKey, int n, Object object) {
        if ((n & 2) != 0) {
            textAttributes = null;
        }
        if ((n & 4) != 0) {
            textAttributesKey = null;
        }
        return textAccumulator.accumulate(string, textAttributes, textAttributesKey);
    }

    public final int getTextLength() {
        return this.stringBuilder.length();
    }

    public final void addMessageRange(int start2, int end, @NotNull LogcatMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.messageRanges.add(new Range<LogcatMessage>(start2, end, message));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\u000e\u0010\u0011\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ2\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/logcat/messages/TextAccumulator$Range;", "T", "", "start", "", "end", "data", "<init>", "(IILjava/lang/Object;)V", "getStart", "()I", "getEnd", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "component3", "copy", "(IILjava/lang/Object;)Lcom/android/tools/idea/logcat/messages/TextAccumulator$Range;", "equals", "", "other", "hashCode", "toString", "", "intellij.android.logcat"})
    public static final class Range<T> {
        private final int start;
        private final int end;
        private final T data;

        public Range(int start2, int end, T data2) {
            this.start = start2;
            this.end = end;
            this.data = data2;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public final T getData() {
            return this.data;
        }

        public final int component1() {
            return this.start;
        }

        public final int component2() {
            return this.end;
        }

        public final T component3() {
            return this.data;
        }

        @NotNull
        public final Range<T> copy(int start2, int end, T data2) {
            return new Range<T>(start2, end, data2);
        }

        public static /* synthetic */ Range copy$default(Range range, int n, int n2, Object object, int n3, Object object2) {
            if ((n3 & 1) != 0) {
                n = range.start;
            }
            if ((n3 & 2) != 0) {
                n2 = range.end;
            }
            if ((n3 & 4) != 0) {
                object = range.data;
            }
            return range.copy(n, n2, object);
        }

        @NotNull
        public String toString() {
            return "Range(start=" + this.start + ", end=" + this.end + ", data=" + this.data + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.start);
            result2 = result2 * 31 + Integer.hashCode(this.end);
            result2 = result2 * 31 + (this.data == null ? 0 : this.data.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Range)) {
                return false;
            }
            Range range = (Range)other;
            if (this.start != range.start) {
                return false;
            }
            if (this.end != range.end) {
                return false;
            }
            return Intrinsics.areEqual(this.data, range.data);
        }
    }
}

