/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.messages;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.android.tools.idea.logcat.messages.DocumentAppenderKt;
import com.android.tools.idea.logcat.messages.TextAccumulator;
import com.android.tools.idea.logcat.util.LogcatLoggerKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0007J\b\u0010\u0019\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/logcat/messages/DocumentAppender;", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "maxDocumentSize", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/DocumentEx;I)V", "markupModel", "Lcom/intellij/openapi/editor/markup/MarkupModel;", "kotlin.jvm.PlatformType", "ranges", "Lkotlin/collections/ArrayDeque;", "Lcom/intellij/openapi/editor/RangeMarker;", "getRanges$intellij_android_logcat", "()Lkotlin/collections/ArrayDeque;", "reset", "", "appendToDocument", "buffer", "Lcom/android/tools/idea/logcat/messages/TextAccumulator;", "setMaxDocumentSize", "size", "trimToSize", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nDocumentAppender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentAppender.kt\ncom/android/tools/idea/logcat/messages/DocumentAppender\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n61#2,5:139\n61#2,5:144\n1#3:149\n*S KotlinDebug\n*F\n+ 1 DocumentAppender.kt\ncom/android/tools/idea/logcat/messages/DocumentAppender\n*L\n53#1:139,5\n66#1:144,5\n*E\n"})
public final class DocumentAppender {
    @NotNull
    private final DocumentEx document;
    private int maxDocumentSize;
    private final MarkupModel markupModel;
    @VisibleForTesting
    @NotNull
    private final ArrayDeque<RangeMarker> ranges;

    public DocumentAppender(@NotNull Project project, @NotNull DocumentEx document, int maxDocumentSize) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.document = document;
        this.maxDocumentSize = maxDocumentSize;
        this.markupModel = DocumentMarkupModel.forDocument((Document)((Document)this.document), (Project)project, (boolean)true);
        this.ranges = new ArrayDeque();
    }

    @NotNull
    public final ArrayDeque<RangeMarker> getRanges$intellij_android_logcat() {
        return this.ranges;
    }

    public final void reset() {
        this.ranges.clear();
    }

    @UiThread
    public final void appendToDocument(@NotNull TextAccumulator buffer) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Logger $this$debug_u24default$iv = LogcatLoggerKt.getLOGGER();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Appending " + buffer.getText().length() + " bytes to document", e$iv);
        }
        String text2 = buffer.getText();
        if (text2.length() >= this.maxDocumentSize) {
            this.document.setText((CharSequence)"");
            int n = this.document.getTextLength();
            String string = text2.substring(StringsKt.lastIndexOf$default((CharSequence)text2, (char)'\n', (int)(text2.length() - this.maxDocumentSize), (boolean)false, (int)4, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.document.insertString(n, (CharSequence)string);
        } else {
            this.document.insertString(this.document.getTextLength(), (CharSequence)text2);
            this.trimToSize();
        }
        Logger $this$debug_u24default$iv2 = LogcatLoggerKt.getLOGGER();
        Throwable e$iv2 = null;
        boolean bl = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl2 = false;
            logger.debug("Document text.length: " + this.document.getText().length() + " immutableCharSequence.length: " + this.document.getImmutableCharSequence().length(), e$iv2);
        }
        int offset = this.document.getTextLength() - text2.length();
        for (TextAccumulator.Range<TextAttributes> range : buffer.getTextAttributesRanges()) {
            DocumentAppenderKt.access$applyRange(range, offset, (arg_0, arg_1, arg_2) -> DocumentAppender.appendToDocument$lambda$2(this, arg_0, arg_1, arg_2));
        }
        for (TextAccumulator.Range<TextAttributes> range : buffer.getTextAttributesKeyRanges()) {
            DocumentAppenderKt.access$applyRange(range, offset, (arg_0, arg_1, arg_2) -> DocumentAppender.appendToDocument$lambda$3(this, arg_0, arg_1, arg_2));
        }
        for (TextAccumulator.Range<Object> range : buffer.getMessageRanges()) {
            DocumentAppenderKt.access$applyRange(range, offset, (arg_0, arg_1, arg_2) -> DocumentAppender.appendToDocument$lambda$4(this, arg_0, arg_1, arg_2));
        }
        while (!this.ranges.isEmpty() && !DocumentAppenderKt.access$isReallyValid((RangeMarker)this.ranges.first())) {
            this.ranges.removeFirst();
        }
    }

    public final void setMaxDocumentSize(int size) {
        this.maxDocumentSize = size;
        this.trimToSize();
    }

    private final void trimToSize() {
        if (this.document.getTextLength() > this.maxDocumentSize) {
            int offset = this.document.getTextLength() - this.maxDocumentSize;
            CharSequence charSequence = this.document.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
            this.document.deleteString(0, StringsKt.lastIndexOf$default((CharSequence)charSequence, (char)'\n', (int)offset, (boolean)false, (int)4, null) + 1);
        }
    }

    private static final Unit appendToDocument$lambda$2(DocumentAppender this$0, int start2, int end, TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        this$0.markupModel.addRangeHighlighter(start2, end, 1000, textAttributes, HighlighterTargetArea.EXACT_RANGE);
        return Unit.INSTANCE;
    }

    private static final Unit appendToDocument$lambda$3(DocumentAppender this$0, int start2, int end, TextAttributesKey textAttributesKey) {
        Intrinsics.checkNotNullParameter((Object)textAttributesKey, (String)"textAttributesKey");
        this$0.markupModel.addRangeHighlighter(textAttributesKey, start2, end, 1000, HighlighterTargetArea.EXACT_RANGE);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit appendToDocument$lambda$4(DocumentAppender this$0, int start2, int end, LogcatMessage message) {
        void $this$appendToDocument_u24lambda_u244_u240;
        RangeMarker rangeMarker;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        RangeMarker rangeMarker2 = rangeMarker = this$0.document.createRangeMarker(start2, end);
        ArrayDeque<RangeMarker> arrayDeque = this$0.ranges;
        boolean bl = false;
        $this$appendToDocument_u24lambda_u244_u240.putUserData(DocumentAppenderKt.getLOGCAT_MESSAGE_KEY(), (Object)message);
        RangeMarker rangeMarker3 = rangeMarker;
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker3, (String)"apply(...)");
        arrayDeque.add((Object)rangeMarker3);
        return Unit.INSTANCE;
    }
}

