/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.folding;

import com.android.tools.idea.logcat.folding.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0016\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"EXCEPTION_LINE_PATTERN", "Lkotlin/text/Regex;", "ELIDED_LINE_PATTERN", "CAUSED_BY_LINE_PATTERN", "EXPANDED_STACK_TRACE_MARKER", "", "SHOULD_BE_FOLDED", "process", "", "context", "Lcom/android/tools/idea/logcat/folding/Context;", "line", "handleFrameLine", "handleCausedByLine", "handleElidedOrEndOfTrace", "handleElidedLine", "elidedCount", "", "isFrameLine", "", "isCauseLine", "getElidedFrameCount", "(Ljava/lang/String;)Ljava/lang/Integer;", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nStackTraceExpander.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StackTraceExpander.kt\ncom/android/tools/idea/logcat/folding/StackTraceExpanderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public final class StackTraceExpanderKt {
    @NotNull
    private static final Regex EXCEPTION_LINE_PATTERN = new Regex("^\\s*at .+\\(.+\\)$");
    @NotNull
    private static final Regex ELIDED_LINE_PATTERN = new Regex("^\\s*... (\\d+) more$");
    @NotNull
    private static final Regex CAUSED_BY_LINE_PATTERN = new Regex("^\\s*Caused by:.+$");
    @NotNull
    private static final String EXPANDED_STACK_TRACE_MARKER = "\u00a0";
    @NotNull
    private static final Regex SHOULD_BE_FOLDED = new Regex("^\\s+at .+\u00a0$");

    private static final List<String> process(Context context, String line) {
        return StackTraceExpanderKt.isFrameLine(line) ? StackTraceExpanderKt.handleFrameLine(context, line) : (!context.isInTrace() ? CollectionsKt.listOf((Object)line) : (StackTraceExpanderKt.isCauseLine(line) ? StackTraceExpanderKt.handleCausedByLine(context, line) : StackTraceExpanderKt.handleElidedOrEndOfTrace(context, line)));
    }

    private static final List<String> handleFrameLine(Context context, String line) {
        context.setInTrace(true);
        context.getCurrentStack().add(line);
        return CollectionsKt.listOf((Object)line);
    }

    private static final List<String> handleCausedByLine(Context context, String line) {
        boolean bl = context.isInTrace();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Unexpected line while parsing stack trace: %s";
            Object[] objectArray = new Object[]{line};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String string3 = string2;
            throw new AssertionError((Object)string3);
        }
        context.swapStacks();
        return CollectionsKt.listOf((Object)line);
    }

    private static final List<String> handleElidedOrEndOfTrace(Context context, String line) {
        List<String> list2;
        Integer count = StackTraceExpanderKt.getElidedFrameCount(line);
        if (count != null) {
            list2 = StackTraceExpanderKt.handleElidedLine(context, line, count);
        } else {
            context.reset();
            list2 = CollectionsKt.listOf((Object)line);
        }
        return list2;
    }

    private static final List<String> handleElidedLine(Context context, String line, int elidedCount) {
        boolean bl = context.isInTrace();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-StackTraceExpanderKt$handleElidedLine$22 = false;
            String string = "Unexpected line while parsing stack trace: %s";
            Object[] objectArray = new Object[]{line};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String $i$a$-assert-StackTraceExpanderKt$handleElidedLine$22 = string2;
            throw new AssertionError((Object)$i$a$-assert-StackTraceExpanderKt$handleElidedLine$22);
        }
        boolean bl2 = bl = elidedCount > 0;
        if (_Assertions.ENABLED && !bl) {
            String $i$a$-assert-StackTraceExpanderKt$handleElidedLine$22 = "Assertion failed";
            throw new AssertionError((Object)$i$a$-assert-StackTraceExpanderKt$handleElidedLine$22);
        }
        List lines = new ArrayList();
        List<String> previousStack = context.getPreviousStack();
        int startIndex = previousStack.size() - elidedCount;
        if (startIndex >= 0) {
            for (int i = 0; i < elidedCount; ++i) {
                String frame = previousStack.get(startIndex + i);
                lines.add(frame + EXPANDED_STACK_TRACE_MARKER);
                context.getCurrentStack().add(frame);
            }
        } else {
            lines.add(line);
        }
        return lines;
    }

    private static final boolean isFrameLine(String line) {
        CharSequence charSequence = line;
        return EXCEPTION_LINE_PATTERN.matches(charSequence);
    }

    private static final boolean isCauseLine(String line) {
        CharSequence charSequence = line;
        return CAUSED_BY_LINE_PATTERN.matches(charSequence);
    }

    private static final Integer getElidedFrameCount(String line) {
        Object object = ELIDED_LINE_PATTERN.matchEntire((CharSequence)line);
        return object != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null ? StringsKt.toIntOrNull((String)object) : null;
    }

    public static final /* synthetic */ Regex access$getSHOULD_BE_FOLDED$p() {
        return SHOULD_BE_FOLDED;
    }

    public static final /* synthetic */ List access$process(Context context, String line) {
        return StackTraceExpanderKt.process(context, line);
    }
}

