/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.filters;

import com.android.tools.idea.logcat.LogcatBundle;
import com.android.tools.idea.logcat.filters.LogcatFilter;
import com.android.tools.idea.logcat.filters.LogcatMessageWrapper;
import com.android.tools.idea.logcat.message.LogLevel;
import com.android.tools.idea.logcat.message.LogcatHeader;
import com.android.tools.idea.projectsystem.ProjectApplicationIdsProvider;
import com.intellij.openapi.util.TextRange;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0013\u0010\u0018\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/logcat/filters/ProjectAppFilter;", "Lcom/android/tools/idea/logcat/filters/LogcatFilter;", "projectApplicationIdsProvider", "Lcom/android/tools/idea/projectsystem/ProjectApplicationIdsProvider;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/android/tools/idea/projectsystem/ProjectApplicationIdsProvider;Lcom/intellij/openapi/util/TextRange;)V", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "packageNames", "", "", "packageNamesRegex", "Lkotlin/text/Regex;", "displayText", "getDisplayText", "()Ljava/lang/String;", "prepare", "", "matches", "", "message", "Lcom/android/tools/idea/logcat/filters/LogcatMessageWrapper;", "equals", "other", "", "hashCode", "", "intellij.android.logcat"})
public final class ProjectAppFilter
extends LogcatFilter {
    @NotNull
    private final ProjectApplicationIdsProvider projectApplicationIdsProvider;
    @NotNull
    private final TextRange textRange;
    @NotNull
    private Set<String> packageNames;
    @Nullable
    private Regex packageNamesRegex;

    public ProjectAppFilter(@NotNull ProjectApplicationIdsProvider projectApplicationIdsProvider, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)projectApplicationIdsProvider, (String)"projectApplicationIdsProvider");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        super(textRange);
        this.projectApplicationIdsProvider = projectApplicationIdsProvider;
        this.textRange = textRange;
        this.packageNames = SetsKt.emptySet();
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        return this.textRange;
    }

    @Override
    @NotNull
    public String getDisplayText() {
        String string;
        if (this.projectApplicationIdsProvider.getPackageNames().size() == 0) {
            string = LogcatBundle.message("logcat.filter.completion.hint.package.mine.empty", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)this.projectApplicationIdsProvider.getPackageNames(), (CharSequence)"<br/>&nbsp;&nbsp;", null, null, (int)0, null, null, (int)62, null)};
            string = LogcatBundle.message("logcat.filter.completion.hint.package.mine.items", objectArray);
        }
        return string;
    }

    @Override
    public void prepare() {
        this.packageNames = this.projectApplicationIdsProvider.getPackageNames();
        this.packageNamesRegex = !((Collection)this.packageNames).isEmpty() ? new Regex(CollectionsKt.joinToString$default((Iterable)this.packageNames, (CharSequence)"|", null, null, (int)0, null, ProjectAppFilter::prepare$lambda$0, (int)30, null)) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(@NotNull LogcatMessageWrapper message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LogcatHeader header = message.getLogcatMessage().getHeader();
        if (this.packageNames.contains(header.getAppName())) return true;
        if (header.getLogLevel().compareTo((Enum)LogLevel.ERROR) < 0) return false;
        Regex regex = this.packageNamesRegex;
        if (regex == null) return false;
        if (!regex.containsMatchIn((CharSequence)message.getLogcatMessage().getMessage())) return false;
        return true;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ProjectAppFilter && Intrinsics.areEqual((Object)this.projectApplicationIdsProvider, (Object)((ProjectAppFilter)other).projectApplicationIdsProvider);
    }

    public int hashCode() {
        return this.projectApplicationIdsProvider.hashCode();
    }

    private static final CharSequence prepare$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.replace$default((String)it, (String)".", (String)"\\.", (boolean)false, (int)4, null);
    }
}

