/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.filters;

import com.android.tools.idea.logcat.filters.LogcatMessageWrapperKt;
import com.android.tools.idea.logcat.message.LogLevel;
import com.android.tools.idea.logcat.message.LogcatHeader;
import com.android.tools.idea.logcat.message.LogcatMessage;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/logcat/filters/LogcatMessageWrapper;", "", "logcatMessage", "Lcom/android/tools/idea/logcat/message/LogcatMessage;", "zoneId", "Ljava/time/ZoneId;", "<init>", "(Lcom/android/tools/idea/logcat/message/LogcatMessage;Ljava/time/ZoneId;)V", "getLogcatMessage", "()Lcom/android/tools/idea/logcat/message/LogcatMessage;", "logLine", "", "getLogLine", "()Ljava/lang/String;", "logLine$delegate", "Lkotlin/Lazy;", "toLine", "intellij.android.logcat"})
public final class LogcatMessageWrapper {
    @NotNull
    private final LogcatMessage logcatMessage;
    @NotNull
    private final Lazy logLine$delegate;

    public LogcatMessageWrapper(@NotNull LogcatMessage logcatMessage, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)logcatMessage, (String)"logcatMessage");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.logcatMessage = logcatMessage;
        this.logLine$delegate = LazyKt.lazy(() -> LogcatMessageWrapper.logLine_delegate$lambda$0(this, zoneId));
    }

    public /* synthetic */ LogcatMessageWrapper(LogcatMessage logcatMessage, ZoneId zoneId, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"systemDefault(...)");
            zoneId = zoneId2;
        }
        this(logcatMessage, zoneId);
    }

    @NotNull
    public final LogcatMessage getLogcatMessage() {
        return this.logcatMessage;
    }

    @NotNull
    public final String getLogLine() {
        Lazy lazy = this.logLine$delegate;
        return (String)lazy.getValue();
    }

    private final String toLine(ZoneId zoneId) {
        LogcatHeader logcatHeader = this.logcatMessage.getHeader();
        LogLevel logLevel = logcatHeader.component1();
        int pid = logcatHeader.component2();
        int tid = logcatHeader.component3();
        String applicationId2 = logcatHeader.component4();
        String tag = logcatHeader.component6();
        Instant timestamp = logcatHeader.component7();
        String datetime = LogcatMessageWrapperKt.access$getDATE_TIME_FORMATTER$p().format(LocalDateTime.ofInstant(timestamp, zoneId));
        return datetime + pid + "-" + tid + " " + tag + " " + applicationId2 + " " + logLevel.getPriorityLetter() + ": " + this.logcatMessage.getMessage();
    }

    private static final String logLine_delegate$lambda$0(LogcatMessageWrapper this$0, ZoneId $zoneId) {
        return this$0.toLine($zoneId);
    }
}

