/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.filters;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.logcat.ConstantsKt;
import com.android.tools.idea.logcat.LogcatBundle;
import com.android.tools.idea.logcat.LogcatPresenter;
import com.android.tools.idea.logcat.filters.AndroidLogcatFilterHistory;
import com.android.tools.idea.logcat.filters.FilterTextField;
import com.android.tools.idea.logcat.filters.FilterTextFieldKt;
import com.android.tools.idea.logcat.filters.LogcatFilter;
import com.android.tools.idea.logcat.filters.LogcatFilterParser;
import com.android.tools.idea.logcat.filters.parser.LogcatFilterFileType;
import com.android.tools.idea.logcat.util.AndroidProjectDetector;
import com.android.tools.idea.logcat.util.AndroidProjectDetectorImpl;
import com.android.tools.idea.logcat.util.LogcatUsageTracker;
import com.google.wireless.android.sdk.stats.LogcatUsageEvent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.NewUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0012\b\u0000\u0018\u0000 J2\u00020\u0001:\u000f<=>?@ABCDEFGHIJB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\f\u00103\u001a\b\u0012\u0004\u0012\u00020.04J\r\u00105\u001a\u000206H\u0001\u00a2\u0006\u0002\b7J\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u000209H\u0003J\b\u0010;\u001a\u000209H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00060\u0019R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00060\u001bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b&\u0010\"R$\u0010'\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010.008\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102\u00a8\u0006K"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "project", "Lcom/intellij/openapi/project/Project;", "logcatPresenter", "Lcom/android/tools/idea/logcat/LogcatPresenter;", "filterParser", "Lcom/android/tools/idea/logcat/filters/LogcatFilterParser;", "initialText", "", "matchCase", "", "androidProjectDetector", "Lcom/android/tools/idea/logcat/util/AndroidProjectDetector;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/logcat/LogcatPresenter;Lcom/android/tools/idea/logcat/filters/LogcatFilterParser;Ljava/lang/String;Ljava/lang/Boolean;Lcom/android/tools/idea/logcat/util/AndroidProjectDetector;)V", "filterHistory", "Lcom/android/tools/idea/logcat/filters/AndroidLogcatFilterHistory;", "textField", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterEditorTextField;", "historyButton", "Lcom/android/tools/idea/logcat/filters/FilterTextField$InlineButton;", "clearButton", "Lcom/android/tools/idea/logcat/filters/FilterTextField$ClearButton;", "favoriteButton", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FavoriteButton;", "matchCaseButton", "Lcom/android/tools/idea/logcat/filters/FilterTextField$MatchCaseButton;", "separator", "Ljavax/swing/JSeparator;", "value", "getMatchCase", "()Z", "setMatchCase", "(Z)V", "filter", "Lcom/android/tools/idea/logcat/filters/LogcatFilter;", "isFavorite", "setFavorite", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "filterUpdateChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterUpdated;", "filterUpdateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getFilterUpdateFlow$intellij_android_logcat", "()Lkotlinx/coroutines/flow/StateFlow;", "trackFilterUpdates", "Lkotlinx/coroutines/flow/Flow;", "getEditorEx", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getEditorEx$intellij_android_logcat", "updateButtons", "", "showPopup", "addToHistory", "FilterTextFieldBorder", "FilterEditorTextField", "InlineButton", "InlinePanel", "HistoryList", "HistoryListCellRenderer", "FilterHistoryItem", "HoverButton", "ClearButton", "FavoriteButton", "ToggleMatchCase", "MatchCaseButton", "FilterUpdated", "FilterStatusChanged", "Companion", "intellij.android.logcat"})
public final class FilterTextField
extends BorderLayoutPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LogcatPresenter logcatPresenter;
    @NotNull
    private final LogcatFilterParser filterParser;
    @NotNull
    private final AndroidLogcatFilterHistory filterHistory;
    @NotNull
    private final FilterEditorTextField textField;
    @NotNull
    private final InlineButton historyButton;
    @NotNull
    private final ClearButton clearButton;
    @NotNull
    private final FavoriteButton favoriteButton;
    @NotNull
    private final MatchCaseButton matchCaseButton;
    @NotNull
    private final JSeparator separator;
    private boolean matchCase;
    @Nullable
    private LogcatFilter filter;
    private boolean isFavorite;
    @NotNull
    private final Channel<FilterUpdated> filterUpdateChannel;
    @VisibleForTesting
    @NotNull
    private final StateFlow<FilterUpdated> filterUpdateFlow;
    @VisibleForTesting
    @NotNull
    public static final String MATCH_CASE_PROPERTY = "LogcatFilterMatchCase";

    public FilterTextField(@NotNull Project project, @NotNull LogcatPresenter logcatPresenter, @NotNull LogcatFilterParser filterParser, @NotNull String initialText, @Nullable Boolean matchCase, @NotNull AndroidProjectDetector androidProjectDetector) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)logcatPresenter, (String)"logcatPresenter");
        Intrinsics.checkNotNullParameter((Object)filterParser, (String)"filterParser");
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        Intrinsics.checkNotNullParameter((Object)androidProjectDetector, (String)"androidProjectDetector");
        this.logcatPresenter = logcatPresenter;
        this.filterParser = filterParser;
        this.filterHistory = AndroidLogcatFilterHistory.Companion.getInstance();
        this.textField = new FilterEditorTextField(project, this.logcatPresenter, androidProjectDetector);
        Icon icon = StudioIcons.Logcat.Input.FILTER_HISTORY;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FILTER_HISTORY");
        this.historyButton = new InlineButton(icon);
        this.clearButton = new ClearButton();
        this.favoriteButton = new FavoriteButton();
        this.matchCaseButton = new MatchCaseButton();
        this.separator = new JSeparator(1);
        Boolean bl = matchCase;
        this.matchCase = bl != null ? bl.booleanValue() : PropertiesComponent.getInstance().getBoolean(MATCH_CASE_PROPERTY);
        this.filter = this.filterParser.parse(initialText, this.matchCase);
        this.filterUpdateChannel = ChannelKt.Channel$default((int)1, (BufferOverflow)BufferOverflow.DROP_LATEST, null, (int)4, null);
        this.filterUpdateFlow = FlowKt.stateIn((Flow)FlowKt.distinctUntilChanged((Flow)FlowKt.consumeAsFlow((ReceiveChannel)((ReceiveChannel)this.filterUpdateChannel))), (CoroutineScope)CoroutineUtilsKt.createCoroutineScope$default((Disposable)this.logcatPresenter, null, null, (int)3, null), (SharingStarted)SharingStarted.Companion.getEagerly(), null);
        this.setText(initialText);
        this.setFavorite(this.filterHistory.getFavorites().contains(this.getText()));
        this.addToLeft(this.historyButton);
        this.addToCenter((Component)((Object)this.textField));
        Object object = new JComponent[]{this.clearButton, this.matchCaseButton, this.separator, this.favoriteButton};
        InlinePanel buttonPanel = new InlinePanel((JComponent)object);
        this.addToRight(buttonPanel);
        this.updateButtons();
        this.setBorder(BorderFactory.createCompoundBorder((Border)((Object)new FilterTextFieldBorder()), JBUI.Borders.empty((int)1)));
        object = this.historyButton;
        JComponent[] $this$_init__u24lambda_u240 = object;
        boolean bl2 = false;
        $this$_init__u24lambda_u240.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ FilterTextField this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FilterTextField.access$showPopup(this.this$0);
            }
        });
        $this$_init__u24lambda_u240.setBorder((Border)FilterTextFieldKt.access$getHistoryIconBorder$p());
        $this$_init__u24lambda_u240.setToolTipText(LogcatBundle.message("logcat.filter.history.tooltip", new Object[0]));
        Object $this$_init__u24lambda_u241 = object = this.textField;
        boolean bl3 = false;
        $this$_init__u24lambda_u241.addDocumentListener(new DocumentListener(this, (FilterEditorTextField)((Object)$this$_init__u24lambda_u241)){
            final /* synthetic */ FilterTextField this$0;
            final /* synthetic */ FilterEditorTextField $this_apply;
            {
                this.this$0 = $receiver;
                this.$this_apply = $receiver2;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                LogcatFilterParser logcatFilterParser = FilterTextField.access$getFilterParser$p(this.this$0);
                String string = this.$this_apply.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                FilterTextField.access$setFilter$p(this.this$0, logcatFilterParser.parse(string, this.this$0.getMatchCase()));
                FilterTextField.access$setFavorite(this.this$0, FilterTextField.access$getFilterHistory$p(this.this$0).getFavorites().contains(this.$this_apply.getText()));
                AndroidLogcatFilterHistory androidLogcatFilterHistory = FilterTextField.access$getFilterHistory$p(this.this$0);
                String string2 = FilterTextField.access$getTextField$p(this.this$0).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                androidLogcatFilterHistory.setMostRecentlyUsed(string2);
                Channel channel = FilterTextField.access$getFilterUpdateChannel$p(this.this$0);
                String string3 = this.$this_apply.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                channel.trySend-JP2dKIU((Object)new FilterUpdated(string3, this.this$0.getMatchCase()));
                FilterTextField.access$updateButtons(this.this$0);
            }
        });
        $this$_init__u24lambda_u241.addFocusListener((FocusListener)new FocusAdapter(this){
            final /* synthetic */ FilterTextField this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusGained(FocusEvent e) {
                String hintText = FilterTextFieldKt.access$getFilterHintText();
                new GotItTooltip("filter.tip", hintText, (Disposable)FilterTextField.access$getLogcatPresenter$p(this.this$0)).withBrowserLink(LogcatBundle.message("logcat.filter.got.it.link.text", new Object[0]), FilterTextFieldKt.access$getLogcatFilterHelpUrl$p()).show((JComponent)((Object)FilterTextField.access$getTextField$p(this.this$0)), GotItTooltip.BOTTOM_LEFT);
            }

            public void focusLost(FocusEvent e) {
                FilterTextField.access$addToHistory(this.this$0);
            }
        });
        $this$_init__u24lambda_u241.setBorder(JBUI.Borders.customLine((Color)$this$_init__u24lambda_u241.getBackground(), (int)1, (int)0, (int)0, (int)0));
        $this$_init__u24lambda_u241.setShowPlaceholderWhenFocused(true);
        $this$_init__u24lambda_u241.setPlaceholder((CharSequence)FilterTextFieldKt.access$getFilterHintText());
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.logcatPresenter);
        Topic topic = KeymapManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new KeymapManagerListener((FilterEditorTextField)((Object)$this$_init__u24lambda_u241)){
            final /* synthetic */ FilterEditorTextField $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public void activeKeymapChanged(Keymap keymap) {
                this.$this_apply.setPlaceholder(FilterTextFieldKt.access$getFilterHintText());
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.logcatPresenter).subscribe(FilterStatusChanged.Companion.getTOPIC(), (arg_0, arg_1) -> FilterTextField._init_$lambda$2(this, arg_0, arg_1));
    }

    public /* synthetic */ FilterTextField(Project project, LogcatPresenter logcatPresenter, LogcatFilterParser logcatFilterParser, String string, Boolean bl, AndroidProjectDetector androidProjectDetector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            androidProjectDetector = new AndroidProjectDetectorImpl();
        }
        this(project, logcatPresenter, logcatFilterParser, string, bl, androidProjectDetector);
    }

    public final boolean getMatchCase() {
        return this.matchCase;
    }

    public final void setMatchCase(boolean value2) {
        this.matchCase = value2;
        PropertiesComponent.getInstance().setValue(MATCH_CASE_PROPERTY, value2);
        this.filterUpdateChannel.trySend-JP2dKIU((Object)new FilterUpdated(this.getText(), this.matchCase));
    }

    private final void setFavorite(boolean value2) {
        Icon icon;
        this.isFavorite = value2;
        if (this.isFavorite) {
            Icon icon2 = StudioIcons.Logcat.Input.FAVORITE_FILLED;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"FAVORITE_FILLED");
        } else {
            Icon icon3 = StudioIcons.Logcat.Input.FAVORITE_OUTLINE;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"FAVORITE_OUTLINE");
        }
        this.favoriteButton.setIcon(icon);
    }

    @NotNull
    public final String getText() {
        String string = this.textField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public final void setText(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.textField.setText(value2);
    }

    @NotNull
    public final StateFlow<FilterUpdated> getFilterUpdateFlow$intellij_android_logcat() {
        return this.filterUpdateFlow;
    }

    @NotNull
    public final Flow<FilterUpdated> trackFilterUpdates() {
        return FlowKt.filterNotNull((Flow)((Flow)this.filterUpdateFlow));
    }

    @TestOnly
    @NotNull
    public final EditorEx getEditorEx$intellij_android_logcat() {
        Editor editor = this.textField.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        return (EditorEx)editor;
    }

    private final void updateButtons() {
        boolean hasFilter = ((CharSequence)this.getText()).length() > 0;
        this.clearButton.setVisible(hasFilter);
        this.favoriteButton.setVisible(hasFilter);
        this.separator.setVisible(hasFilter);
    }

    @UiThread
    private final void showPopup() {
        Disposable disposable = Disposer.newDisposable((String)"popupDisposable");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable popupDisposable = disposable;
        this.addToHistory();
        JList list2 = (JList)((Object)new HistoryList(this, popupDisposable, null, 2, null));
        Object[] objectArray = new String[]{"foo", "bar"};
        JBPopupFactory.getInstance().createPopupChooserBuilder(CollectionsKt.listOf((Object[])objectArray));
        JBPopup jBPopup = new PopupChooserBuilder(list2).setMovable(false).setRequestFocus(true).setItemChosenCallback(arg_0 -> FilterTextField.showPopup$lambda$0(this, arg_0)).setSelectedValue((Object)new FilterHistoryItem.Item(this.getText(), this.isFavorite, null, this.filterParser), true).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup = jBPopup;
        Disposer.register((Disposable)((Disposable)popup), (Disposable)popupDisposable);
        popup.showUnderneathOf((Component)((Object)this));
    }

    private final void addToHistory() {
        String string = this.textField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text2 = string;
        if (((CharSequence)text2).length() == 0) {
            return;
        }
        this.filterHistory.add(this.filterParser, text2, this.isFavorite);
        LogcatUsageEvent.LogcatFilterEvent.Builder builder = this.filterParser.getUsageTrackingEvent(text2, this.matchCase);
        LogcatUsageEvent.Builder builder2 = LogcatUsageEvent.newBuilder().setType(LogcatUsageEvent.Type.FILTER_ADDED_TO_HISTORY).setLogcatFilter(builder != null ? builder.setIsFavorite(this.isFavorite) : null);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"setLogcatFilter(...)");
        LogcatUsageTracker.INSTANCE.log(builder2);
    }

    private static final void _init_$lambda$2(FilterTextField this$0, String filter2, boolean isFavorite) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        if (Intrinsics.areEqual((Object)this$0.getText(), (Object)filter2)) {
            this$0.setFavorite(isFavorite);
        }
    }

    private static final void showPopup$lambda$0(FilterTextField this$0, FilterHistoryItem it) {
        block0: {
            FilterHistoryItem.Item item = it instanceof FilterHistoryItem.Item ? (FilterHistoryItem.Item)it : null;
            if (item == null) break block0;
            FilterHistoryItem.Item item2 = item;
            boolean bl = false;
            this$0.setText(item2.getFilter());
            this$0.setFavorite(item2.isFavorite());
        }
    }

    public static final /* synthetic */ LogcatFilter access$getFilter$p(FilterTextField $this) {
        return $this.filter;
    }

    public static final /* synthetic */ LogcatPresenter access$getLogcatPresenter$p(FilterTextField $this) {
        return $this.logcatPresenter;
    }

    public static final /* synthetic */ void access$showPopup(FilterTextField $this) {
        $this.showPopup();
    }

    public static final /* synthetic */ void access$setFilter$p(FilterTextField $this, LogcatFilter logcatFilter) {
        $this.filter = logcatFilter;
    }

    public static final /* synthetic */ Channel access$getFilterUpdateChannel$p(FilterTextField $this) {
        return $this.filterUpdateChannel;
    }

    public static final /* synthetic */ void access$updateButtons(FilterTextField $this) {
        $this.updateButtons();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$ClearButton;", "Lcom/android/tools/idea/logcat/filters/FilterTextField$HoverButton;", "<init>", "(Lcom/android/tools/idea/logcat/filters/FilterTextField;)V", "mouseClicked", "", "intellij.android.logcat"})
    private final class ClearButton
    extends HoverButton {
        public ClearButton() {
            Icon icon = AllIcons.Actions.Close;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Close");
            super(icon, LogcatBundle.message("logcat.filter.clear.tooltip", new Object[0]), AllIcons.Actions.CloseHovered);
            this.setName("ClearButton");
        }

        @Override
        protected void mouseClicked() {
            FilterTextField.this.setText("");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$Companion;", "", "<init>", "()V", "MATCH_CASE_PROPERTY", "", "intellij.android.logcat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$FavoriteButton;", "Lcom/android/tools/idea/logcat/filters/FilterTextField$HoverButton;", "<init>", "(Lcom/android/tools/idea/logcat/filters/FilterTextField;)V", "mouseClicked", "", "intellij.android.logcat"})
    private final class FavoriteButton
    extends HoverButton {
        public FavoriteButton() {
            Icon icon = StudioIcons.Logcat.Input.FAVORITE_OUTLINE;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FAVORITE_OUTLINE");
            super(icon, LogcatBundle.message("logcat.filter.tag.favorite.tooltip", new Object[0]), null, 4, null);
            this.setName("FavoriteButton");
        }

        @Override
        protected void mouseClicked() {
            FilterTextField.this.setFavorite(!FilterTextField.this.isFavorite);
            this.setToolTipText(FilterTextField.this.isFavorite ? LogcatBundle.message("logcat.filter.untag.favorite.tooltip", new Object[0]) : LogcatBundle.message("logcat.filter.tag.favorite.tooltip", new Object[0]));
            FilterStatusChanged filterStatusChanged = (FilterStatusChanged)ApplicationManager.getApplication().getMessageBus().syncPublisher(FilterStatusChanged.Companion.getTOPIC());
            String string = FilterTextField.this.textField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            filterStatusChanged.onFilterStatusChanged(string, FilterTextField.this.isFavorite);
            FilterTextField.this.addToHistory();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterEditorTextField;", "Lcom/intellij/ui/EditorTextField;", "project", "Lcom/intellij/openapi/project/Project;", "logcatPresenter", "Lcom/android/tools/idea/logcat/LogcatPresenter;", "androidProjectDetector", "Lcom/android/tools/idea/logcat/util/AndroidProjectDetector;", "<init>", "(Lcom/android/tools/idea/logcat/filters/FilterTextField;Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/logcat/LogcatPresenter;Lcom/android/tools/idea/logcat/util/AndroidProjectDetector;)V", "createEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "updateUI", "", "intellij.android.logcat"})
    private final class FilterEditorTextField
    extends EditorTextField {
        @NotNull
        private final LogcatPresenter logcatPresenter;
        @NotNull
        private final AndroidProjectDetector androidProjectDetector;

        public FilterEditorTextField(@NotNull Project project, @NotNull LogcatPresenter logcatPresenter, AndroidProjectDetector androidProjectDetector) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)logcatPresenter, (String)"logcatPresenter");
            Intrinsics.checkNotNullParameter((Object)androidProjectDetector, (String)"androidProjectDetector");
            super(project, (FileType)LogcatFilterFileType.INSTANCE);
            this.logcatPresenter = logcatPresenter;
            this.androidProjectDetector = androidProjectDetector;
        }

        @NotNull
        protected EditorEx createEditor() {
            EditorEx editorEx = super.createEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
            EditorEx editorEx2 = editorEx;
            FilterTextField filterTextField = FilterTextField.this;
            EditorEx $this$createEditor_u24lambda_u240 = editorEx2;
            boolean bl = false;
            $this$createEditor_u24lambda_u240.putUserData(ConstantsKt.getTAGS_PROVIDER_KEY(), (Object)this.logcatPresenter);
            $this$createEditor_u24lambda_u240.putUserData(ConstantsKt.getPACKAGE_NAMES_PROVIDER_KEY(), (Object)this.logcatPresenter);
            $this$createEditor_u24lambda_u240.putUserData(ConstantsKt.getPROCESS_NAMES_PROVIDER_KEY(), (Object)this.logcatPresenter);
            $this$createEditor_u24lambda_u240.putUserData(AndroidProjectDetector.Companion.getKEY(), (Object)this.androidProjectDetector);
            $this$createEditor_u24lambda_u240.setBorder(FilterTextFieldKt.access$getEditorBorder$p());
            $this$createEditor_u24lambda_u240.getContentComponent().addKeyListener(new KeyAdapter(filterTextField){
                final /* synthetic */ FilterTextField this$0;
                {
                    this.this$0 = $receiver;
                }

                public void keyPressed(KeyEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e.getKeyCode() == 10) {
                        e.consume();
                        FilterTextField.access$addToHistory(this.this$0);
                    }
                }
            });
            $this$createEditor_u24lambda_u240.getContentComponent().addMouseMotionListener(new MouseAdapter($this$createEditor_u24lambda_u240, this, filterTextField){
                final /* synthetic */ EditorEx $this_apply;
                final /* synthetic */ FilterEditorTextField this$0;
                final /* synthetic */ FilterTextField this$1;
                {
                    this.$this_apply = $receiver;
                    this.this$0 = $receiver2;
                    this.this$1 = $receiver3;
                }

                /*
                 * WARNING - void declaration
                 */
                public void mouseMoved(MouseEvent e) {
                    String string;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    JComponent jComponent = this.$this_apply.getContentComponent();
                    Editor editor = this.this$0.getEditor();
                    if (editor != null) {
                        void editor2;
                        Editor editor3 = editor;
                        FilterTextField filterTextField = this.this$1;
                        Editor editor4 = editor3;
                        JComponent jComponent2 = jComponent;
                        boolean bl = false;
                        LogicalPosition logicalPosition = editor2.xyToLogicalPosition(e.getPoint());
                        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
                        LogicalPosition position = logicalPosition;
                        LogcatFilter logcatFilter = FilterTextField.access$getFilter$p(filterTextField);
                        string = logcatFilter != null && (logcatFilter = logcatFilter.findFilterForOffset(position.column)) != null ? logcatFilter.getDisplayText() : null;
                        jComponent = jComponent2;
                    } else {
                        string = null;
                    }
                    jComponent.setToolTipText(string);
                }
            });
            return editorEx2;
        }

        public void updateUI() {
            this.setBorder(JBUI.Borders.customLine((Color)this.getBackground(), (int)1, (int)0, (int)0, (int)0));
            super.updateUI();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b1\u0018\u00002\u00020\u0001:\u0002\n\u000bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\tH&\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem;", "", "<init>", "()V", "getComponent", "Ljavax/swing/JComponent;", "isSelected", "", "list", "Ljavax/swing/JList;", "Item", "Separator", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem$Item;", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem$Separator;", "intellij.android.logcat"})
    @VisibleForTesting
    public static abstract sealed class FilterHistoryItem {
        private FilterHistoryItem() {
        }

        @NotNull
        public abstract JComponent getComponent(boolean var1, @NotNull JList<? extends FilterHistoryItem> var2);

        public /* synthetic */ FilterHistoryItem(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00052\u000e\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010)H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002J\u0013\u0010-\u001a\u00020\u00052\b\u0010.\u001a\u0004\u0018\u00010/H\u0096\u0002J\b\u00100\u001a\u00020\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000e\"\u0004\b\u0015\u0010\u0010R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem$Item;", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem;", "filter", "", "isFavorite", "", "count", "", "filterParser", "Lcom/android/tools/idea/logcat/filters/LogcatFilterParser;", "<init>", "(Ljava/lang/String;ZLjava/lang/Integer;Lcom/android/tools/idea/logcat/filters/LogcatFilterParser;)V", "getFilter", "()Ljava/lang/String;", "()Z", "setFavorite", "(Z)V", "getCount", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "isFavoriteHovered", "setFavoriteHovered", "tooltip", "getTooltip", "getFavoriteIconBounds", "Ljava/awt/Rectangle;", "offset", "Ljava/awt/Point;", "getDeleteIconBounds", "favoriteLabel", "Ljavax/swing/JLabel;", "filterLabel", "Lcom/intellij/ui/SimpleColoredComponent;", "countLabel", "deleteLabel", "component", "Ljavax/swing/JPanel;", "getComponent", "Ljavax/swing/JComponent;", "isSelected", "list", "Ljavax/swing/JList;", "whiteIconForOldUI", "Ljavax/swing/Icon;", "icon", "equals", "other", "", "hashCode", "intellij.android.logcat"})
        @SourceDebugExtension(value={"SMAP\nFilterTextField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterTextField.kt\ncom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem$Item\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,966:1\n1#2:967\n1788#3,4:968\n*S KotlinDebug\n*F\n+ 1 FilterTextField.kt\ncom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem$Item\n*L\n714#1:968,4\n*E\n"})
        public static final class Item
        extends FilterHistoryItem {
            @NotNull
            private final String filter;
            private boolean isFavorite;
            @Nullable
            private final Integer count;
            @NotNull
            private final LogcatFilterParser filterParser;
            private boolean isFavoriteHovered;
            @Nullable
            private final String tooltip;
            @NotNull
            private final JLabel favoriteLabel;
            @NotNull
            private final SimpleColoredComponent filterLabel;
            @NotNull
            private final JLabel countLabel;
            @NotNull
            private final JLabel deleteLabel;
            @NotNull
            private final JPanel component;

            /*
             * WARNING - void declaration
             */
            public Item(@NotNull String filter2, boolean isFavorite, @Nullable Integer count, @NotNull LogcatFilterParser filterParser) {
                String filterName;
                void $this$component_u24lambda_u240_u240;
                void $this$component_u24lambda_u240;
                GroupLayout groupLayout;
                Object $this$countLabel_u24lambda_u240;
                Object $this$filterLabel_u24lambda_u240;
                Object object;
                Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
                Intrinsics.checkNotNullParameter((Object)filterParser, (String)"filterParser");
                super(null);
                this.filter = filter2;
                this.isFavorite = isFavorite;
                this.count = count;
                this.filterParser = filterParser;
                this.favoriteLabel = new JLabel();
                SimpleColoredComponent simpleColoredComponent = object = new SimpleColoredComponent();
                Item item = this;
                boolean bl = false;
                $this$filterLabel_u24lambda_u240.setBorder((Border)FilterTextFieldKt.access$getHistoryItemLabelBorder$p());
                item.filterLabel = object;
                $this$filterLabel_u24lambda_u240 = object = new JLabel();
                item = this;
                boolean bl2 = false;
                $this$countLabel_u24lambda_u240.setFont(new Font("Monospaced", 0, $this$countLabel_u24lambda_u240.getFont().getSize()));
                $this$countLabel_u24lambda_u240.setBorder((Border)FilterTextFieldKt.access$getHistoryItemLabelBorder$p());
                item.countLabel = object;
                this.deleteLabel = new JLabel();
                $this$countLabel_u24lambda_u240 = object = new JPanel(null);
                item = this;
                boolean bl3 = false;
                GroupLayout groupLayout2 = groupLayout = new GroupLayout((Container)$this$component_u24lambda_u240);
                void var10_15 = $this$component_u24lambda_u240;
                boolean bl4 = false;
                $this$component_u24lambda_u240_u240.setHorizontalGroup($this$component_u24lambda_u240_u240.createSequentialGroup().addComponent(this.favoriteLabel).addComponent((Component)this.filterLabel).addComponent(this.countLabel).addComponent(this.deleteLabel));
                $this$component_u24lambda_u240_u240.setVerticalGroup($this$component_u24lambda_u240_u240.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.favoriteLabel).addComponent((Component)this.filterLabel).addComponent(this.countLabel).addComponent(this.deleteLabel));
                $this$component_u24lambda_u240.setBorder((Border)FilterTextFieldKt.access$getFilterHistoryItemBorder$p());
                var10_15.setLayout(groupLayout);
                item.component = object;
                boolean matchCase = true;
                LogcatFilter logcatFilter = this.filterParser.parse(this.filter, matchCase);
                String string = filterName = logcatFilter != null ? logcatFilter.getFilterName() : null;
                if (filterName != null) {
                    String string2;
                    int n;
                    List<String> history = AndroidLogcatFilterHistory.Companion.getInstance().getItems();
                    Iterable $this$count$iv = history;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv) {
                            String it = (String)element$iv;
                            boolean bl5 = false;
                            LogcatFilter logcatFilter2 = this.filterParser.parse(it, matchCase);
                            if (!Intrinsics.areEqual((Object)(logcatFilter2 != null ? logcatFilter2.getFilterName() : null), (Object)filterName) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    int sameName = n;
                    this.filterLabel.append(filterName, FilterTextFieldKt.access$getNamedFilterHistoryItemColor$p());
                    String filterWithoutName = this.filterParser.removeFilterNames(this.filter);
                    if (sameName > 1) {
                        this.filterLabel.append(": " + filterWithoutName);
                        string2 = null;
                    } else {
                        string2 = filterWithoutName;
                    }
                    this.tooltip = string2;
                } else {
                    this.tooltip = null;
                    SimpleColoredComponent simpleColoredComponent2 = this.filterLabel.append(this.filter);
                    Intrinsics.checkNotNull((Object)simpleColoredComponent2);
                }
            }

            @NotNull
            public final String getFilter() {
                return this.filter;
            }

            public final boolean isFavorite() {
                return this.isFavorite;
            }

            public final void setFavorite(boolean bl) {
                this.isFavorite = bl;
            }

            @Nullable
            public final Integer getCount() {
                return this.count;
            }

            public final boolean isFavoriteHovered() {
                return this.isFavoriteHovered;
            }

            public final void setFavoriteHovered(boolean bl) {
                this.isFavoriteHovered = bl;
            }

            @Nullable
            public final String getTooltip() {
                return this.tooltip;
            }

            @NotNull
            public final Rectangle getFavoriteIconBounds(@NotNull Point offset) {
                Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
                Rectangle rectangle = this.favoriteLabel.getBounds();
                Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
                return FilterTextFieldKt.access$plus(rectangle, offset);
            }

            @NotNull
            public final Rectangle getDeleteIconBounds(@NotNull Point offset) {
                Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
                Rectangle rectangle = this.deleteLabel.getBounds();
                Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
                return FilterTextFieldKt.access$plus(rectangle, offset);
            }

            @Override
            @NotNull
            public JComponent getComponent(boolean isSelected, @NotNull JList<? extends FilterHistoryItem> list2) {
                String string;
                Icon icon;
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                if (this.isFavoriteHovered && this.isFavorite) {
                    Icon icon2 = StudioIcons.Logcat.Input.FAVORITE_FILLED;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"FAVORITE_FILLED");
                    icon = this.whiteIconForOldUI(icon2);
                } else if (this.isFavoriteHovered && !this.isFavorite) {
                    Icon icon3 = StudioIcons.Logcat.Input.FAVORITE_OUTLINE;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"FAVORITE_OUTLINE");
                    icon = this.whiteIconForOldUI(icon3);
                } else {
                    icon = !this.isFavoriteHovered && this.isFavorite ? StudioIcons.Logcat.Input.FAVORITE_FILLED : FilterTextFieldKt.access$getBlankIcon$p();
                }
                this.favoriteLabel.setIcon(icon);
                this.deleteLabel.setIcon(isSelected ? AllIcons.General.Delete : FilterTextFieldKt.access$getBlankIcon$p());
                Integer n = this.count;
                if (n == null) {
                    string = StringsKt.repeat((CharSequence)" ", (int)3);
                } else {
                    int n2 = n;
                    boolean bl = 0 <= n2 ? n2 < 100 : false;
                    if (bl) {
                        String string2 = "% 2d ";
                        Object[] objectArray = new Object[]{this.count};
                        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    } else {
                        string = "99+";
                    }
                }
                this.countLabel.setText(string);
                n = isSelected ? new Pair((Object)list2.getSelectionForeground(), (Object)list2.getSelectionBackground()) : new Pair((Object)list2.getForeground(), (Object)list2.getBackground());
                Color foreground = (Color)n.component1();
                Color background = (Color)n.component2();
                this.filterLabel.setForeground(foreground);
                this.deleteLabel.setForeground(foreground);
                this.component.setBackground(background);
                this.countLabel.setForeground(isSelected ? foreground : SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor());
                return this.component;
            }

            private final Icon whiteIconForOldUI(Icon icon) {
                return NewUI.isEnabled() ? icon : ColoredIconGenerator.generateWhiteIcon((Icon)icon);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                Object object = other;
                if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                    return false;
                }
                Object object2 = other;
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.android.tools.idea.logcat.filters.FilterTextField.FilterHistoryItem.Item");
                Item cfr_ignored_0 = (Item)object2;
                return Intrinsics.areEqual((Object)this.filter, (Object)((Item)other).filter);
            }

            public int hashCode() {
                return this.filter.hashCode();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem$Separator;", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem;", "<init>", "()V", "component", "Ljavax/swing/JPanel;", "getComponent", "Ljavax/swing/JComponent;", "isSelected", "", "list", "Ljavax/swing/JList;", "intellij.android.logcat"})
        public static final class Separator
        extends FilterHistoryItem {
            @NotNull
            private final JPanel component;

            /*
             * WARNING - void declaration
             */
            public Separator() {
                super(null);
                void $this$component_u24lambda_u240;
                JPanel jPanel;
                JPanel jPanel2 = jPanel = new JPanel(null);
                Separator separator = this;
                boolean bl = false;
                $this$component_u24lambda_u240.setLayout(new BoxLayout((Container)$this$component_u24lambda_u240, 3));
                $this$component_u24lambda_u240.setBorder(FilterTextFieldKt.access$getHistoryListSeparatorBorder$p());
                $this$component_u24lambda_u240.add(new JSeparator(0));
                separator.component = jPanel;
            }

            @Override
            @NotNull
            public JComponent getComponent(boolean isSelected, @NotNull JList<? extends FilterHistoryItem> list2) {
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                this.component.setBackground(list2.getBackground());
                return this.component;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00e2\u0080\u0001\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\t\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterStatusChanged;", "", "onFilterStatusChanged", "", "filter", "", "isFavorite", "", "Companion", "intellij.android.logcat"})
    private static interface FilterStatusChanged {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public void onFilterStatusChanged(@NotNull String var1, boolean var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterStatusChanged$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterStatusChanged;", "kotlin.jvm.PlatformType", "getTOPIC", "()Lcom/intellij/util/messages/Topic;", "intellij.android.logcat"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Topic<FilterStatusChanged> TOPIC;

            private Companion() {
            }

            @NotNull
            public final Topic<FilterStatusChanged> getTOPIC() {
                return TOPIC;
            }

            static {
                $$INSTANCE = new Companion();
                TOPIC = new Topic(FilterStatusChanged.class);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterTextFieldBorder;", "Lcom/intellij/ide/ui/laf/darcula/ui/DarculaTextBorder;", "<init>", "(Lcom/android/tools/idea/logcat/filters/FilterTextField;)V", "isFocused", "", "c", "Ljava/awt/Component;", "intellij.android.logcat"})
    private final class FilterTextFieldBorder
    extends DarculaTextBorder {
        protected boolean isFocused(@Nullable Component c) {
            Object object = FilterTextField.this.textField.getEditor();
            return object != null && (object = object.getContentComponent()) != null ? ((Component)object).hasFocus() : false;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterUpdated;", "", "filter", "", "matchCase", "", "<init>", "(Ljava/lang/String;Z)V", "getFilter", "()Ljava/lang/String;", "getMatchCase", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "intellij.android.logcat"})
    public static final class FilterUpdated {
        @NotNull
        private final String filter;
        private final boolean matchCase;

        public FilterUpdated(@NotNull String filter2, boolean matchCase) {
            Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
            this.filter = filter2;
            this.matchCase = matchCase;
        }

        @NotNull
        public final String getFilter() {
            return this.filter;
        }

        public final boolean getMatchCase() {
            return this.matchCase;
        }

        @NotNull
        public final String component1() {
            return this.filter;
        }

        public final boolean component2() {
            return this.matchCase;
        }

        @NotNull
        public final FilterUpdated copy(@NotNull String filter2, boolean matchCase) {
            Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
            return new FilterUpdated(filter2, matchCase);
        }

        public static /* synthetic */ FilterUpdated copy$default(FilterUpdated filterUpdated, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = filterUpdated.filter;
            }
            if ((n & 2) != 0) {
                bl = filterUpdated.matchCase;
            }
            return filterUpdated.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "FilterUpdated(filter=" + this.filter + ", matchCase=" + this.matchCase + ")";
        }

        public int hashCode() {
            int result2 = this.filter.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.matchCase);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FilterUpdated)) {
                return false;
            }
            FilterUpdated filterUpdated = (FilterUpdated)other;
            if (!Intrinsics.areEqual((Object)this.filter, (Object)filterUpdated.filter)) {
                return false;
            }
            return this.matchCase == filterUpdated.matchCase;
        }
    }

    @UiThread
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0081\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$HistoryList;", "Lcom/intellij/ui/components/JBList;", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "parentContext", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Lcom/android/tools/idea/logcat/filters/FilterTextField;Lcom/intellij/openapi/Disposable;Lkotlin/coroutines/CoroutineContext;)V", "listModel", "Lcom/intellij/ui/CollectionListModel;", "inactiveColor", "", "getToolTipText", "event", "Ljava/awt/event/MouseEvent;", "getFavoriteTooltip", "item", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem$Item;", "toggleFavoriteItem", "", "index", "", "bounds", "Ljava/awt/Rectangle;", "deleteItem", "MouseListener", "intellij.android.logcat"})
    @VisibleForTesting
    @SourceDebugExtension(value={"SMAP\nFilterTextField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterTextField.kt\ncom/android/tools/idea/logcat/filters/FilterTextField$HistoryList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,966:1\n1563#2:967\n1634#2,3:968\n1563#2:971\n1634#2,3:972\n1563#2:975\n1634#2,3:976\n1563#2:979\n1634#2,3:980\n*S KotlinDebug\n*F\n+ 1 FilterTextField.kt\ncom/android/tools/idea/logcat/filters/FilterTextField$HistoryList\n*L\n443#1:967\n443#1:968,3\n451#1:971\n451#1:972,3\n456#1:975\n456#1:976,3\n462#1:979\n462#1:980,3\n*E\n"})
    public final class HistoryList
    extends JBList<FilterHistoryItem> {
        @NotNull
        private final CollectionListModel<FilterHistoryItem> listModel;
        @NotNull
        private final String inactiveColor;
        final /* synthetic */ FilterTextField this$0;

        /*
         * WARNING - void declaration
         */
        public HistoryList(@NotNull FilterTextField this$0, @NotNull Disposable parentDisposable, CoroutineContext parentContext) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String it;
            Collection collection2;
            Iterable $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            Intrinsics.checkNotNullParameter((Object)parentContext, (String)"parentContext");
            this.this$0 = this$0;
            this.listModel = new CollectionListModel((Object[])new FilterHistoryItem[0]);
            Object object = "%06x";
            Object object2 = new Object[]{NamedColorUtil.getInactiveTextColor().getRGB() & 0xFFFFFF};
            String string = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            this.inactiveColor = string;
            object = new ArrayList();
            object2 = this.this$0;
            Object $this$_init__u24lambda_u240 = object;
            boolean bl = false;
            Iterable iterable = ((FilterTextField)((Object)object2)).filterHistory.getFavorites();
            Object object3 = $this$_init__u24lambda_u240;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                String string2 = (String)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(new FilterHistoryItem.Item(it, true, null, ((FilterTextField)((Object)object2)).filterParser));
            }
            object3.addAll((List)destination$iv$iv);
            if (!((Collection)((FilterTextField)((Object)object2)).filterHistory.getFavorites()).isEmpty() && !((Collection)((FilterTextField)((Object)object2)).filterHistory.getNonFavorites()).isEmpty()) {
                $this$_init__u24lambda_u240.add(new FilterHistoryItem.Separator());
            }
            $this$map$iv2 = ((FilterTextField)((Object)object2)).filterHistory.getNamed();
            object3 = $this$_init__u24lambda_u240;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (String)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(new FilterHistoryItem.Item(it, false, null, ((FilterTextField)((Object)object2)).filterParser));
            }
            object3.addAll((List)destination$iv$iv);
            $this$map$iv2 = ((FilterTextField)((Object)object2)).filterHistory.getNonFavorites();
            object3 = $this$_init__u24lambda_u240;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (String)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl4 = false;
                collection2.add(new FilterHistoryItem.Item(it, false, null, ((FilterTextField)((Object)object2)).filterParser));
            }
            object3.addAll((List)destination$iv$iv);
            Object items = object;
            object2 = (Iterable)items;
            FilterTextField filterTextField = this.this$0;
            boolean $i$f$map2 = false;
            $this$map$iv2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                FilterHistoryItem $i$f$mapTo3 = (FilterHistoryItem)item$iv$iv;
                Collection collection3 = destination$iv$iv2;
                boolean bl5 = false;
                collection3.add(it2 instanceof FilterHistoryItem.Item ? filterTextField.filterParser.parse(((FilterHistoryItem.Item)it2).getFilter(), filterTextField.getMatchCase()) : null);
            }
            List filters = (List)destination$iv$iv2;
            this.setModel((ListModel)this.listModel);
            this.listModel.addAll(0, (List)items);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    FilterHistoryItem.Item item;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Object object = this.getSelectedValue();
                    FilterHistoryItem.Item item2 = item = object instanceof FilterHistoryItem.Item ? (FilterHistoryItem.Item)object : null;
                    if (item != null && ArraysKt.contains((Object[])FilterTextFieldKt.access$getDeleteKeyCodes$p(), (Object)e.getKeyCode())) {
                        this.deleteItem(this.getSelectedIndex());
                    }
                }
            });
            this.setCellRenderer(new HistoryListCellRenderer());
            BuildersKt.launch$default((CoroutineScope)CoroutineUtilsKt.createCoroutineScope$default((Disposable)parentDisposable, null, (CoroutineContext)parentContext, (int)1, null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, parentContext, this.this$0, (List<? extends LogcatFilter>)filters, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ HistoryList this$0;
                final /* synthetic */ CoroutineContext $parentContext;
                final /* synthetic */ FilterTextField this$1;
                final /* synthetic */ List<LogcatFilter> $filters;
                {
                    this.this$0 = $receiver;
                    this.$parentContext = $parentContext;
                    this.this$1 = $receiver2;
                    this.$filters = $filters;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$forEachIndexed$iv;
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            Application application = ApplicationManager.getApplication();
                            List list2 = this.this$0.listModel.getItems();
                            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
                            Iterable iterable = list2;
                            CoroutineContext coroutineContext = this.$parentContext;
                            FilterTextField filterTextField = this.this$1;
                            List<LogcatFilter> list3 = this.$filters;
                            HistoryList historyList = this.this$0;
                            boolean $i$f$forEachIndexed = false;
                            int index$iv = 0;
                            for (Object item$iv : $this$forEachIndexed$iv) {
                                void item;
                                int n;
                                if ((n = index$iv++) < 0) {
                                    CollectionsKt.throwIndexOverflow();
                                }
                                FilterHistoryItem filterHistoryItem = (FilterHistoryItem)item$iv;
                                int index = n;
                                boolean bl = false;
                                if (!(item instanceof FilterHistoryItem.Item)) continue;
                                BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(application, coroutineContext, filterTextField, list3, index, historyList, (FilterHistoryItem)item, null){
                                    int label;
                                    final /* synthetic */ Application $application;
                                    final /* synthetic */ CoroutineContext $parentContext;
                                    final /* synthetic */ FilterTextField this$0;
                                    final /* synthetic */ List<LogcatFilter> $filters;
                                    final /* synthetic */ int $index;
                                    final /* synthetic */ HistoryList this$1;
                                    final /* synthetic */ FilterHistoryItem $item;
                                    {
                                        this.$application = $application;
                                        this.$parentContext = $parentContext;
                                        this.this$0 = $receiver;
                                        this.$filters = $filters;
                                        this.$index = $index;
                                        this.this$1 = $receiver2;
                                        this.$item = $item;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                Integer count = (Integer)this.$application.runReadAction(() -> 1.1.invokeSuspend$lambda$0(this.this$0, this.$filters, this.$index));
                                                this.label = 1;
                                                Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE).plus(this.$parentContext), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, this.$item, count, this.this$0, this.$index, null){
                                                    int label;
                                                    final /* synthetic */ HistoryList this$0;
                                                    final /* synthetic */ FilterHistoryItem $item;
                                                    final /* synthetic */ Integer $count;
                                                    final /* synthetic */ FilterTextField this$1;
                                                    final /* synthetic */ int $index;
                                                    {
                                                        this.this$0 = $receiver;
                                                        this.$item = $item;
                                                        this.$count = $count;
                                                        this.this$1 = $receiver2;
                                                        this.$index = $index;
                                                        super(2, $completion);
                                                    }

                                                    public final Object invokeSuspend(Object object) {
                                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)object);
                                                                int selected = this.this$0.getSelectedIndex();
                                                                HistoryList.access$getListModel$p(this.this$0).setElementAt((Object)new FilterHistoryItem.Item(((FilterHistoryItem.Item)this.$item).getFilter(), ((FilterHistoryItem.Item)this.$item).isFavorite(), this.$count, FilterTextField.access$getFilterParser$p(this.this$1)), this.$index);
                                                                if (selected >= 0) {
                                                                    this.this$0.setSelectedIndex(selected);
                                                                }
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }
                                                }), (Continuation)((Continuation)this));
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }

                                    private static final Integer invokeSuspend$lambda$0(FilterTextField this$0, List $filters, int $index) {
                                        return FilterTextField.access$getLogcatPresenter$p(this$0).countFilterMatches((LogcatFilter)$filters.get($index));
                                    }
                                }), (int)3, null);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            MouseListener listener2 = new MouseListener();
            this.addMouseListener(listener2);
            this.addMouseMotionListener(listener2);
        }

        public /* synthetic */ HistoryList(FilterTextField filterTextField, Disposable disposable, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                coroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
            }
            this(filterTextField, disposable, coroutineContext);
        }

        @Nullable
        public String getToolTipText(@NotNull MouseEvent event) {
            String string;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            int index = this.getSelectedIndex();
            if (index < 0) {
                return null;
            }
            Object e = this.getModel().getElementAt(index);
            FilterHistoryItem.Item item = e instanceof FilterHistoryItem.Item ? (FilterHistoryItem.Item)e : null;
            if (item == null) {
                return null;
            }
            FilterHistoryItem.Item item2 = item;
            Point cellLocation = this.getCellBounds(index, index).getLocation();
            Intrinsics.checkNotNull((Object)cellLocation);
            Rectangle favoriteIconBounds = item2.getFavoriteIconBounds(cellLocation);
            Rectangle deleteIconBounds = item2.getDeleteIconBounds(cellLocation);
            if (favoriteIconBounds.contains(event.getPoint())) {
                string = this.getFavoriteTooltip(item2);
            } else if (deleteIconBounds.contains(event.getPoint())) {
                Object[] objectArray = new Object[]{this.inactiveColor};
                string = LogcatBundle.message("logcat.filter.history.delete.tooltip", objectArray);
            } else {
                string = item2.getTooltip();
            }
            return string;
        }

        private final String getFavoriteTooltip(FilterHistoryItem.Item item) {
            String string;
            boolean bl = item.isFavorite();
            if (bl) {
                string = LogcatBundle.message("logcat.filter.untag.favorite.tooltip", new Object[0]);
            } else if (!bl) {
                string = LogcatBundle.message("logcat.filter.tag.favorite.tooltip", new Object[0]);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        private final void toggleFavoriteItem(int index, Rectangle bounds) {
            Object e = this.getModel().getElementAt(index);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type com.android.tools.idea.logcat.filters.FilterTextField.FilterHistoryItem.Item");
            FilterHistoryItem.Item item = (FilterHistoryItem.Item)e;
            if (item.isFavorite()) {
                item.setFavorite(false);
                this.this$0.filterHistory.getFavorites().remove(item.getFilter());
                v1 = this.this$0.filterHistory.getNonFavorites().add(item.getFilter());
            } else {
                item.setFavorite(true);
                this.this$0.filterHistory.getFavorites().add(item.getFilter());
                v1 = this.this$0.filterHistory.getNonFavorites().remove(item.getFilter());
            }
            if (Intrinsics.areEqual((Object)item.getFilter(), (Object)this.this$0.getText())) {
                this.this$0.setFavorite(item.isFavorite());
            }
            ((FilterStatusChanged)ApplicationManager.getApplication().getMessageBus().syncPublisher(FilterStatusChanged.Companion.getTOPIC())).onFilterStatusChanged(item.getFilter(), item.isFavorite());
            this.paintImmediately(bounds);
        }

        public final void deleteItem(int index) {
            Object object = this.listModel.getElementAt(index);
            FilterHistoryItem.Item item = object instanceof FilterHistoryItem.Item ? (FilterHistoryItem.Item)object : null;
            if (item == null) {
                return;
            }
            FilterHistoryItem.Item item2 = item;
            this.this$0.filterHistory.remove(item2.getFilter());
            if (Intrinsics.areEqual((Object)this.this$0.getText(), (Object)item2.getFilter())) {
                this.this$0.setText("");
            }
            this.listModel.remove(index);
            this.setSelectedIndex(Math.min(index, this.getModel().getSize() - 1));
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\f\u001a\u00020\b*\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0005H\u0002R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$HistoryList$MouseListener;", "Ljava/awt/event/MouseAdapter;", "<init>", "(Lcom/android/tools/idea/logcat/filters/FilterTextField$HistoryList;)V", "hoveredFavoriteIndex", "", "Ljava/lang/Integer;", "mouseReleased", "", "event", "Ljava/awt/event/MouseEvent;", "mouseMoved", "setIsHoveredFavorite", "value", "", "getItemAt", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem$Item;", "Ljavax/swing/ListModel;", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem;", "index", "intellij.android.logcat"})
        @SourceDebugExtension(value={"SMAP\nFilterTextField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterTextField.kt\ncom/android/tools/idea/logcat/filters/FilterTextField$HistoryList$MouseListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,966:1\n1#2:967\n*E\n"})
        public final class MouseListener
        extends MouseAdapter {
            @Nullable
            private Integer hoveredFavoriteIndex;

            @Override
            public void mouseReleased(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getButton() == 1 && event.getModifiersEx() == 0 && HistoryList.this.getSelectedIndex() >= 0) {
                    int index = HistoryList.this.getSelectedIndex();
                    Object e = HistoryList.this.getModel().getElementAt(index);
                    FilterHistoryItem.Item item = e instanceof FilterHistoryItem.Item ? (FilterHistoryItem.Item)e : null;
                    if (item == null) {
                        return;
                    }
                    FilterHistoryItem.Item item2 = item;
                    Point cellLocation = HistoryList.this.getCellBounds(index, index).getLocation();
                    Intrinsics.checkNotNull((Object)cellLocation);
                    Rectangle favoriteIconBounds = item2.getFavoriteIconBounds(cellLocation);
                    Rectangle deleteIconBounds = item2.getDeleteIconBounds(cellLocation);
                    boolean consume2 = true;
                    if (favoriteIconBounds.contains(event.getPoint())) {
                        HistoryList.this.toggleFavoriteItem(index, favoriteIconBounds);
                    } else if (deleteIconBounds.contains(event.getPoint())) {
                        HistoryList.this.deleteItem(index);
                    } else {
                        consume2 = false;
                    }
                    if (consume2) {
                        event.consume();
                    }
                }
            }

            @Override
            public void mouseMoved(@NotNull MouseEvent event) {
                Integer hoveredIndex;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                int index = HistoryList.this.getSelectedIndex();
                ListModel listModel = HistoryList.this.getModel();
                Intrinsics.checkNotNullExpressionValue((Object)listModel, (String)"getModel(...)");
                FilterHistoryItem.Item item = this.getItemAt(listModel, index);
                if (item == null) {
                    Integer n = this.hoveredFavoriteIndex;
                    if (n != null) {
                        this.setIsHoveredFavorite(n, false);
                    }
                    return;
                }
                Point cellLocation = HistoryList.this.getCellBounds(index, index).getLocation();
                Intrinsics.checkNotNull((Object)cellLocation);
                Rectangle favoriteIconBounds = item.getFavoriteIconBounds(cellLocation);
                Integer n = hoveredIndex = favoriteIconBounds.contains(event.getPoint()) ? Integer.valueOf(index) : null;
                if (!Intrinsics.areEqual((Object)hoveredIndex, (Object)this.hoveredFavoriteIndex)) {
                    Integer n2 = this.hoveredFavoriteIndex;
                    if (n2 != null) {
                        this.setIsHoveredFavorite(n2, false);
                    }
                    Integer n3 = hoveredIndex;
                    if (n3 != null) {
                        this.setIsHoveredFavorite(n3, true);
                    }
                    this.hoveredFavoriteIndex = hoveredIndex;
                    HistoryList.this.paintImmediately(favoriteIconBounds);
                }
            }

            private final void setIsHoveredFavorite(int $this$setIsHoveredFavorite, boolean value2) {
                Object e = HistoryList.this.getModel().getElementAt($this$setIsHoveredFavorite);
                FilterHistoryItem.Item item = e instanceof FilterHistoryItem.Item ? (FilterHistoryItem.Item)e : null;
                if (item == null) {
                    return;
                }
                FilterHistoryItem.Item item2 = item;
                item2.setFavoriteHovered(value2);
            }

            private final FilterHistoryItem.Item getItemAt(ListModel<FilterHistoryItem> $this$getItemAt, int index) {
                Object object;
                Object object2 = $this$getItemAt;
                HistoryList historyList = HistoryList.this;
                try {
                    ListModel<FilterHistoryItem> $this$getItemAt_u24lambda_u240 = object2;
                    boolean bl = false;
                    object = Result.constructor-impl((Object)((FilterHistoryItem)historyList.getModel().getElementAt(index)));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                Object object3 = Result.isFailure-impl((Object)object2) ? null : object2;
                return object3 instanceof FilterHistoryItem.Item ? (FilterHistoryItem.Item)object3 : null;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J8\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$HistoryListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem;", "<init>", "()V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "intellij.android.logcat"})
    private static final class HistoryListCellRenderer
    implements ListCellRenderer<FilterHistoryItem> {
        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends FilterHistoryItem> list2, @NotNull FilterHistoryItem value2, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return value2.getComponent(isSelected, list2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\b\u0010\u0012\u001a\u00020\rH$J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$HoverButton;", "Lcom/intellij/ui/components/JBLabel;", "icon", "Ljavax/swing/Icon;", "tooltip", "", "hoverIcon", "<init>", "(Ljavax/swing/Icon;Ljava/lang/String;Ljavax/swing/Icon;)V", "hovered", "", "getIcon", "processMouseEvent", "", "e", "Ljava/awt/event/MouseEvent;", "mouseHover", "hover", "mouseClicked", "paintComponent", "graphics", "Ljava/awt/Graphics;", "intellij.android.logcat"})
    private static abstract class HoverButton
    extends JBLabel {
        @Nullable
        private final Icon hoverIcon;
        private boolean hovered;

        public HoverButton(@NotNull Icon icon, @NotNull String tooltip, @Nullable Icon hoverIcon) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
            super(icon);
            this.hoverIcon = hoverIcon;
            this.setToolTipText(tooltip);
        }

        public /* synthetic */ HoverButton(Icon icon, String string, Icon icon2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                icon2 = null;
            }
            this(icon, string, icon2);
        }

        @NotNull
        public Icon getIcon() {
            Icon icon;
            if (this.hovered) {
                Icon icon2 = this.hoverIcon;
                if (icon2 == null) {
                    icon2 = super.getIcon();
                }
                Icon icon3 = icon2;
                Intrinsics.checkNotNull((Object)icon3);
                icon = icon3;
            } else {
                Icon icon4 = super.getIcon();
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"getIcon(...)");
            }
            return icon;
        }

        protected void processMouseEvent(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.processMouseEvent(e);
            switch (e.getID()) {
                case 504: {
                    this.mouseHover(true);
                    break;
                }
                case 505: {
                    this.mouseHover(false);
                    break;
                }
                case 500: {
                    this.mouseClicked();
                }
            }
        }

        private final void mouseHover(boolean hover) {
            this.hovered = hover;
            this.repaint();
        }

        protected abstract void mouseClicked();

        protected void paintComponent(@NotNull Graphics graphics) {
            Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
            if (this.hovered && this.hoverIcon == null) {
                ActionButtonLook.SYSTEM_LOOK.paintBackground(graphics, (JComponent)((Object)this), 2);
            }
            super.paintComponent(graphics);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$InlineButton;", "Ljavax/swing/JLabel;", "icon", "Ljavax/swing/Icon;", "<init>", "(Lcom/android/tools/idea/logcat/filters/FilterTextField;Ljavax/swing/Icon;)V", "updateUI", "", "intellij.android.logcat"})
    private final class InlineButton
    extends JLabel {
        public InlineButton(Icon icon) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            super(icon);
            this.setOpaque(true);
        }

        @Override
        public void updateUI() {
            this.setBackground(FilterTextField.this.textField.getBackground());
            super.updateUI();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$InlinePanel;", "Ljavax/swing/JPanel;", "children", "", "Ljavax/swing/JComponent;", "<init>", "(Lcom/android/tools/idea/logcat/filters/FilterTextField;[Ljavax/swing/JComponent;)V", "updateUI", "", "intellij.android.logcat"})
    @SourceDebugExtension(value={"SMAP\nFilterTextField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterTextField.kt\ncom/android/tools/idea/logcat/filters/FilterTextField$InlinePanel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,966:1\n13472#2,2:967\n*S KotlinDebug\n*F\n+ 1 FilterTextField.kt\ncom/android/tools/idea/logcat/filters/FilterTextField$InlinePanel\n*L\n410#1:967,2\n*E\n"})
    private final class InlinePanel
    extends JPanel {
        public InlinePanel(JComponent ... children2) {
            Intrinsics.checkNotNullParameter((Object)children2, (String)"children");
            super(null);
            this.setLayout(new BoxLayout(this, 2));
            this.setOpaque(true);
            this.setBorder(FilterTextFieldKt.access$getVerticalSeparatorBorder$p());
            JComponent[] $this$forEach$iv = children2;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                JComponent element$iv;
                JComponent it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
                this.add(it);
            }
        }

        @Override
        public void updateUI() {
            this.setBackground(FilterTextField.this.textField.getBackground());
            super.updateUI();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$MatchCaseButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/android/tools/idea/logcat/filters/FilterTextField;Lcom/intellij/openapi/actionSystem/AnAction;)V", "(Lcom/android/tools/idea/logcat/filters/FilterTextField;)V", "getIcon", "Ljavax/swing/Icon;", "intellij.android.logcat"})
    private final class MatchCaseButton
    extends ActionButton {
        private MatchCaseButton(AnAction action2) {
            super(action2, action2.getTemplatePresentation().clone(), "FilterTextField", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.setFocusable(true);
            this.updateIcon();
            this.setName("MatchCaseButton");
        }

        public MatchCaseButton() {
            this((AnAction)this$0.new ToggleMatchCase());
        }

        @NotNull
        public Icon getIcon() {
            Icon icon;
            boolean bl;
            boolean bl2 = bl = this.isEnabled() && this.isSelected();
            if (bl) {
                Icon icon2 = this.getPresentation().getSelectedIcon();
                if (icon2 == null) {
                    icon2 = super.getIcon();
                }
                Icon icon3 = icon2;
                Intrinsics.checkNotNull((Object)icon3);
                icon = icon3;
            } else if (!bl) {
                Icon icon4 = super.getIcon();
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"getIcon(...)");
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return icon;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$ToggleMatchCase;", "Lcom/intellij/openapi/actionSystem/ex/CheckboxAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "(Lcom/android/tools/idea/logcat/filters/FilterTextField;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.android.logcat"})
    private final class ToggleMatchCase
    extends CheckboxAction
    implements DumbAware {
        public ToggleMatchCase() {
            this.getTemplatePresentation().setText(LogcatBundle.message("logcat.filter.match.case.tooltip", new Object[0]));
            this.getTemplatePresentation().setIcon(AllIcons.Actions.MatchCase);
            this.getTemplatePresentation().setHoveredIcon(AllIcons.Actions.MatchCaseHovered);
            this.getTemplatePresentation().setSelectedIcon(AllIcons.Actions.MatchCaseSelected);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return FilterTextField.this.getMatchCase();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            FilterTextField.this.setMatchCase(state2);
        }
    }
}

