/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.files;

import com.android.tools.idea.logcat.devices.Device;
import com.android.tools.idea.logcat.files.LogcatFileData;
import com.android.tools.idea.logcat.files.LogcatFileParser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a*\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!H\u0002\u001a\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"MONTH", "", "DAY", "HOUR", "MINUTE", "SECOND", "MILLI", "TIMESTAMP", "UID", "PID", "TID", "LEVEL", "TAG_THREADTIME", "TAG_FIREBASE", "MESSAGE", "JSON_REGEX", "Lkotlin/text/Regex;", "THREADTIME_REGEX", "BUGREPORT_REGEX", "FIREBASE_REGEX", "BUGREPORT_FILE_REGEX", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "readJsonFile", "Lcom/android/tools/idea/logcat/files/LogcatFileData;", "path", "Ljava/nio/file/Path;", "parseLogcat", "headerRegex", "zoneId", "Ljava/time/ZoneId;", "isBugreport", "", "parseBugreport", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nLogcatFileIo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogcatFileIo.kt\ncom/android/tools/idea/logcat/files/LogcatFileIoKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class LogcatFileIoKt {
    @NotNull
    private static final String MONTH = "(?<month>\\d\\d)";
    @NotNull
    private static final String DAY = "(?<day>\\d\\d)";
    @NotNull
    private static final String HOUR = "(?<hour>\\d\\d)";
    @NotNull
    private static final String MINUTE = "(?<minute>\\d\\d)";
    @NotNull
    private static final String SECOND = "(?<second>\\d\\d)";
    @NotNull
    private static final String MILLI = "(?<milli>\\d\\d\\d)";
    @NotNull
    private static final String TIMESTAMP = "(?<month>\\d\\d)-(?<day>\\d\\d) (?<hour>\\d\\d):(?<minute>\\d\\d):(?<second>\\d\\d)\\.(?<milli>\\d\\d\\d)";
    @NotNull
    private static final String UID = "\\w+";
    @NotNull
    private static final String PID = "(?<pid>\\d+)";
    @NotNull
    private static final String TID = "(?<tid>\\d+)";
    @NotNull
    private static final String LEVEL = "(?<level>[VDIWEAF])";
    @NotNull
    private static final String TAG_THREADTIME = "(?<tag>.+?(?=: ))";
    @NotNull
    private static final String TAG_FIREBASE = "(?<tag>.+?(?=\\())";
    @NotNull
    private static final String MESSAGE = "(?<message>.*)";
    @NotNull
    private static final Regex JSON_REGEX = new Regex("^\\{");
    @NotNull
    private static final Regex THREADTIME_REGEX = new Regex("^(?<month>\\d\\d)-(?<day>\\d\\d) (?<hour>\\d\\d):(?<minute>\\d\\d):(?<second>\\d\\d)\\.(?<milli>\\d\\d\\d) +(?<pid>\\d+) +(?<tid>\\d+) (?<level>[VDIWEAF]) (?<tag>.+?(?=: )): (?<message>.*)$");
    @NotNull
    private static final Regex BUGREPORT_REGEX = new Regex("^(?<month>\\d\\d)-(?<day>\\d\\d) (?<hour>\\d\\d):(?<minute>\\d\\d):(?<second>\\d\\d)\\.(?<milli>\\d\\d\\d) +\\w+ +(?<pid>\\d+) +(?<tid>\\d+) (?<level>[VDIWEAF]) (?<tag>.+?(?=: )): (?<message>.*)$");
    @NotNull
    private static final Regex FIREBASE_REGEX = new Regex("^(?<month>\\d\\d)-(?<day>\\d\\d) (?<hour>\\d\\d):(?<minute>\\d\\d):(?<second>\\d\\d)\\.(?<milli>\\d\\d\\d): (?<level>[VDIWEAF])/(?<tag>.+?(?=\\())\\((?<pid>\\d+)\\): (?<message>.*)$");
    @NotNull
    private static final Regex BUGREPORT_FILE_REGEX = new Regex("^========================================================$");
    private static final Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Device.class), (Object)new Device.DeviceSerializer()).setPrettyPrinting().create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final LogcatFileData readJsonFile(Path path) {
        Object object = path;
        Object object2 = new OpenOption[]{};
        Object object3 = Charsets.UTF_8;
        object = new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length)), (Charset)object3);
        object3 = null;
        try {
            InputStreamReader it = (InputStreamReader)object;
            boolean bl = false;
            object2 = (LogcatFileData)gson.fromJson((Reader)it, LogcatFileData.class);
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object3);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"use(...)");
        return object2;
    }

    private static final LogcatFileData parseLogcat(Path path, Regex headerRegex, ZoneId zoneId, boolean isBugreport) {
        return new LogcatFileData(null, new LogcatFileParser(headerRegex, zoneId).parseLogcatFile(path, isBugreport));
    }

    static /* synthetic */ LogcatFileData parseLogcat$default(Path path, Regex regex, ZoneId zoneId, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return LogcatFileIoKt.parseLogcat(path, regex, zoneId, bl);
    }

    private static final LogcatFileData parseBugreport(Path path, ZoneId zoneId) {
        return new LogcatFileData(null, new LogcatFileParser(BUGREPORT_REGEX, zoneId).parseBugreportFile(path));
    }

    public static final /* synthetic */ LogcatFileData access$readJsonFile(Path path) {
        return LogcatFileIoKt.readJsonFile(path);
    }

    public static final /* synthetic */ Regex access$getTHREADTIME_REGEX$p() {
        return THREADTIME_REGEX;
    }

    public static final /* synthetic */ LogcatFileData access$parseLogcat(Path path, Regex headerRegex, ZoneId zoneId, boolean isBugreport) {
        return LogcatFileIoKt.parseLogcat(path, headerRegex, zoneId, isBugreport);
    }

    public static final /* synthetic */ Regex access$getBUGREPORT_REGEX$p() {
        return BUGREPORT_REGEX;
    }

    public static final /* synthetic */ LogcatFileData access$parseBugreport(Path path, ZoneId zoneId) {
        return LogcatFileIoKt.parseBugreport(path, zoneId);
    }

    public static final /* synthetic */ Regex access$getFIREBASE_REGEX$p() {
        return FIREBASE_REGEX;
    }

    public static final /* synthetic */ Regex access$getJSON_REGEX$p() {
        return JSON_REGEX;
    }

    public static final /* synthetic */ Regex access$getBUGREPORT_FILE_REGEX$p() {
        return BUGREPORT_FILE_REGEX;
    }

    public static final /* synthetic */ Gson access$getGson$p() {
        return gson;
    }
}

