/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.devices;

import com.android.sdklib.deviceprovisioner.DeviceIcons;
import com.android.tools.idea.logcat.LogcatBundle;
import com.android.tools.idea.logcat.devices.Device;
import com.android.tools.idea.logcat.devices.DeviceComboBox;
import com.android.tools.idea.logcat.devices.DeviceComboBoxDeviceTrackerFactory;
import com.android.tools.idea.logcat.devices.DeviceComboBoxKt;
import com.android.tools.idea.logcat.devices.DeviceEvent;
import com.android.tools.idea.logcat.devices.IDeviceComboBoxDeviceTracker;
import com.android.tools.idea.logcat.util.LogcatLoggerKt;
import com.intellij.codeInsight.codeVision.ui.popup.layouter.RectangleUtilsKt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxUI;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.plaf.ComboBoxUI;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005$%&'(B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018J\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/logcat/devices/DeviceComboBox;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboItem;", "project", "Lcom/intellij/openapi/project/Project;", "initialItem", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboItem;)V", "deviceTracker", "Lcom/android/tools/idea/logcat/devices/IDeviceComboBoxDeviceTracker;", "deviceComboModel", "Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboModel;", "getDeviceComboModel", "()Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboModel;", "updateUI", "", "setSelectedItem", "item", "", "handleItemError", "", "message", "", "trackSelected", "Lkotlinx/coroutines/flow/Flow;", "getSelectedDevice", "Lcom/android/tools/idea/logcat/devices/Device;", "getSelectedFile", "Ljava/nio/file/Path;", "deviceAdded", "device", "selectItem", "Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboItem$DeviceItem;", "deviceStateChanged", "addOrSelectFile", "path", "DeviceComboBoxRenderer", "DeviceComboModel", "DeviceComboItem", "DeviceComboBoxUi", "DeviceComboBoxPopupMouseListener", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nDeviceComboBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceComboBox.kt\ncom/android/tools/idea/logcat/devices/DeviceComboBox\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,475:1\n30#2,2:476\n1#3:478\n*S KotlinDebug\n*F\n+ 1 DeviceComboBox.kt\ncom/android/tools/idea/logcat/devices/DeviceComboBox\n*L\n104#1:476,2\n*E\n"})
public final class DeviceComboBox
extends ComboBox<DeviceComboItem> {
    @NotNull
    private final Project project;
    @Nullable
    private final DeviceComboItem initialItem;
    @NotNull
    private final IDeviceComboBoxDeviceTracker deviceTracker;

    public DeviceComboBox(@NotNull Project project, @Nullable DeviceComboItem initialItem) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.initialItem = initialItem;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DeviceComboBoxDeviceTrackerFactory> serviceClass$iv = DeviceComboBoxDeviceTrackerFactory.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DeviceComboItem deviceComboItem = this.initialItem;
        DeviceComboItem.DeviceItem deviceItem = deviceComboItem instanceof DeviceComboItem.DeviceItem ? (DeviceComboItem.DeviceItem)deviceComboItem : null;
        this.deviceTracker = ((DeviceComboBoxDeviceTrackerFactory)object).createDeviceComboBoxDeviceTracker(deviceItem != null ? deviceItem.getDevice() : null);
        AccessibleContextUtil.setName((Component)((Component)((Object)this)), (String)LogcatBundle.message("logcat.device.combo.accessible.name", new Object[0]));
        this.renderer = (ListCellRenderer)((Object)new DeviceComboBoxRenderer());
        this.setModel((ComboBoxModel)((Object)new DeviceComboModel()));
        if (this.initialItem instanceof DeviceComboItem.FileItem) {
            this.getDeviceComboModel().add(this.initialItem);
            this.getDeviceComboModel().setSelectedItem(this.initialItem);
        }
    }

    private final DeviceComboModel getDeviceComboModel() {
        ComboBoxModel comboBoxModel = this.getModel();
        Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type com.android.tools.idea.logcat.devices.DeviceComboBox.DeviceComboModel");
        return (DeviceComboModel)((Object)comboBoxModel);
    }

    public void updateUI() {
        this.setUI((ComboBoxUI)((Object)new DeviceComboBoxUi()));
    }

    public void setSelectedItem(@Nullable Object item) {
        if (item instanceof DeviceComboItem.FileItem) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(((DeviceComboItem.FileItem)item).getPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Object[] objectArray = new Object[]{((DeviceComboItem.FileItem)item).getPath()};
                boolean itemRemoved = this.handleItemError((DeviceComboItem)item, LogcatBundle.message("logcat.device.combo.error.message", objectArray));
                if (itemRemoved) {
                    return;
                }
            }
        }
        super.setSelectedItem(item);
    }

    public final boolean handleItemError(@NotNull DeviceComboItem item, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object[] objectArray = new Object[]{message};
        boolean answer2 = MessageDialogBuilder.Companion.yesNo(LogcatBundle.message("logcat.device.combo.error.title", new Object[0]), LogcatBundle.message("logcat.device.combo.error.message", objectArray)).ask(this.project);
        if (answer2) {
            Object object;
            this.getDeviceComboModel().remove(item);
            if (!Intrinsics.areEqual((Object)this.getSelectedItem(), (Object)this.selectedItemReminder)) {
                object = this.selectedItemReminder;
            } else {
                List list2 = this.getDeviceComboModel().getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
                if (((Collection)list2).size() == 1) {
                    object = null;
                } else {
                    List list3 = this.getDeviceComboModel().getItems();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getItems(...)");
                    object = CollectionsKt.first((List)list3);
                }
            }
            this.setSelectedItem(object);
        }
        return answer2;
    }

    @NotNull
    public final Flow<DeviceComboItem> trackSelected() {
        return FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super DeviceComboItem>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DeviceComboBox this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                        Object object3 = this.this$0.getSelectedItem();
                        DeviceComboItem deviceComboItem = object3 instanceof DeviceComboItem ? (DeviceComboItem)object3 : null;
                        if (deviceComboItem != null) {
                            DeviceComboItem it = deviceComboItem;
                            boolean bl = false;
                            ChannelResult.box-impl((Object)ChannelsKt.trySendBlocking((SendChannel)((SendChannel)$this$callbackFlow), (Object)it));
                        }
                        ActionListener listener2 = arg_0 -> trackSelected.1.invokeSuspend$lambda$1(this.this$0, $this$callbackFlow, arg_0);
                        this.this$0.addActionListener(listener2);
                        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)$this$callbackFlow), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, (ProducerScope<? super DeviceComboItem>)$this$callbackFlow, null){
                            int label;
                            final /* synthetic */ DeviceComboBox this$0;
                            final /* synthetic */ ProducerScope<DeviceComboItem> $$this$callbackFlow;
                            {
                                this.this$0 = $receiver;
                                this.$$this$callbackFlow = $$this$callbackFlow;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        this.label = 1;
                                        v0 = DeviceComboBox.access$getDeviceTracker$p(this.this$0).trackDevices((Continuation<? super Flow<? extends DeviceEvent>>)((Continuation)this));
                                        if (v0 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        this.label = 2;
                                        v1 = ((Flow)v0).collect(new FlowCollector(this.this$0){
                                            final /* synthetic */ DeviceComboBox this$0;
                                            {
                                                this.this$0 = $receiver;
                                            }

                                            public final Object emit(DeviceEvent it, Continuation<? super Unit> $completion) {
                                                LogcatLoggerKt.getLOGGER().debug("trackDevices: " + it);
                                                DeviceEvent deviceEvent = it;
                                                if (deviceEvent instanceof DeviceEvent.Added) {
                                                    DeviceComboBox.access$deviceAdded(this.this$0, ((DeviceEvent.Added)it).getDevice());
                                                } else if (deviceEvent instanceof DeviceEvent.StateChanged) {
                                                    DeviceComboBox.access$deviceStateChanged(this.this$0, ((DeviceEvent.StateChanged)it).getDevice());
                                                } else {
                                                    throw new NoWhenBranchMatchedException();
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }, (Continuation)this);
                                        if (v1 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl21
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl21:
                                        // 2 sources

                                        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.$$this$callbackFlow), null, (int)1, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        this.label = 1;
                        Object object4 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, () -> trackSelected.1.invokeSuspend$lambda$2(this.this$0, listener2), (Continuation)((Continuation)this));
                        if (object4 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(ProducerScope<? super DeviceComboItem> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$1(DeviceComboBox this$0, ProducerScope $$this$callbackFlow, ActionEvent it) {
                block0: {
                    DeviceComboItem deviceComboItem = (DeviceComboItem)this$0.getItem();
                    if (deviceComboItem == null) break block0;
                    DeviceComboItem it2 = deviceComboItem;
                    boolean bl = false;
                    ChannelsKt.trySendBlocking((SendChannel)((SendChannel)$$this$callbackFlow), (Object)it2);
                }
            }

            private static final Unit invokeSuspend$lambda$2(DeviceComboBox this$0, ActionListener $listener) {
                this$0.removeActionListener($listener);
                return Unit.INSTANCE;
            }
        }));
    }

    @Nullable
    public final Device getSelectedDevice() {
        Object object = this.getItem();
        DeviceComboItem.DeviceItem deviceItem = object instanceof DeviceComboItem.DeviceItem ? (DeviceComboItem.DeviceItem)object : null;
        return deviceItem != null ? deviceItem.getDevice() : null;
    }

    @Nullable
    public final Path getSelectedFile() {
        Object object = this.getItem();
        DeviceComboItem.FileItem fileItem = object instanceof DeviceComboItem.FileItem ? (DeviceComboItem.FileItem)object : null;
        return fileItem != null ? fileItem.getPath() : null;
    }

    private final void deviceAdded(Device device2) {
        if (this.getDeviceComboModel().containsDevice(device2)) {
            this.deviceStateChanged(device2);
        } else {
            DeviceComboItem deviceComboItem;
            Object object;
            DeviceComboItem.DeviceItem item = this.getDeviceComboModel().addDevice(device2);
            if (this.getSelectedItem() != null) {
                return;
            }
            if (this.initialItem == null) {
                this.selectItem(item);
            } else if (Intrinsics.areEqual((Object)device2.getDeviceId(), (object = (deviceComboItem = this.initialItem) instanceof DeviceComboItem.DeviceItem ? (DeviceComboItem.DeviceItem)deviceComboItem : null) != null && (object = ((DeviceComboItem.DeviceItem)object).getDevice()) != null ? ((Device)object).getDeviceId() : null)) {
                this.selectItem(item);
            }
        }
    }

    private final void selectItem(DeviceComboItem.DeviceItem item) {
        this.setSelectedItem(item);
    }

    private final void deviceStateChanged(Device device2) {
        boolean bl = this.getDeviceComboModel().containsDevice(device2);
        if (bl) {
            Object object;
            Object object2;
            this.getDeviceComboModel().replaceDevice(device2, Intrinsics.areEqual((Object)device2.getDeviceId(), (object2 = (object = this.getItem()) instanceof DeviceComboItem.DeviceItem ? (DeviceComboItem.DeviceItem)object : null) != null && (object2 = ((DeviceComboItem.DeviceItem)object2).getDevice()) != null ? ((Device)object2).getDeviceId() : null));
        } else if (!bl) {
            this.deviceAdded(device2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void addOrSelectFile(@NotNull Path path) {
        DeviceComboItem deviceComboItem;
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            List list2 = this.getDeviceComboModel().getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
            Iterable iterable = list2;
            for (Object t : iterable) {
                DeviceComboItem it = (DeviceComboItem)t;
                boolean bl = false;
                if (!(it instanceof DeviceComboItem.FileItem && Intrinsics.areEqual((Object)((Object)((DeviceComboItem.FileItem)it).getPath()).toString(), (Object)((Object)path).toString()))) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        if ((deviceComboItem = (DeviceComboItem)v1) == null) {
            deviceComboItem = this.getDeviceComboModel().addFile(path);
        }
        DeviceComboItem fileItem = deviceComboItem;
        this.setSelectedItem(fileItem);
    }

    public static final /* synthetic */ IDeviceComboBoxDeviceTracker access$getDeviceTracker$p(DeviceComboBox $this) {
        return $this.deviceTracker;
    }

    public static final /* synthetic */ void access$deviceAdded(DeviceComboBox $this, Device device2) {
        $this.deviceAdded(device2);
    }

    public static final /* synthetic */ void access$deviceStateChanged(DeviceComboBox $this, Device device2) {
        $this.deviceStateChanged(device2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B5\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0013H\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\u0019\u0010\u0018\u001a\u00020\u000f2\u000e\u0010\u0019\u001a\n \u001a*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001J\u0019\u0010\u001b\u001a\u00020\u000f2\u000e\u0010\u0019\u001a\n \u001a*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001J\u0019\u0010\u001c\u001a\u00020\u000f2\u000e\u0010\u0019\u001a\n \u001a*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001J\u0019\u0010\u001d\u001a\u00020\u000f2\u000e\u0010\u0019\u001a\n \u001a*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001J\u0019\u0010\u001e\u001a\u00020\u000f2\u000e\u0010\u0019\u001a\n \u001a*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboBoxPopupMouseListener;", "Ljava/awt/event/KeyAdapter;", "Ljava/awt/event/MouseListener;", "Ljava/awt/event/MouseMotionListener;", "comboBox", "Ljavax/swing/JComboBox;", "Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboItem;", "list", "Ljavax/swing/JList;", "", "mouseListener", "mouseMotionListener", "<init>", "(Ljavax/swing/JComboBox;Ljavax/swing/JList;Ljava/awt/event/MouseListener;Ljava/awt/event/MouseMotionListener;)V", "keyReleased", "", "e", "Ljava/awt/event/KeyEvent;", "mouseReleased", "Ljava/awt/event/MouseEvent;", "mouseMoved", "isOverDeleteIcon", "", "deleteSelectedItem", "mouseClicked", "p0", "kotlin.jvm.PlatformType", "mouseDragged", "mouseEntered", "mouseExited", "mousePressed", "intellij.android.logcat"})
    private static final class DeviceComboBoxPopupMouseListener
    extends KeyAdapter
    implements MouseListener,
    MouseMotionListener {
        @NotNull
        private final JComboBox<? super DeviceComboItem> comboBox;
        @NotNull
        private final JList<Object> list;
        @NotNull
        private final MouseListener mouseListener;
        @NotNull
        private final MouseMotionListener mouseMotionListener;

        public DeviceComboBoxPopupMouseListener(@NotNull JComboBox<? super DeviceComboItem> comboBox2, @NotNull JList<Object> list2, @NotNull MouseListener mouseListener2, @NotNull MouseMotionListener mouseMotionListener) {
            Intrinsics.checkNotNullParameter(comboBox2, (String)"comboBox");
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            Intrinsics.checkNotNullParameter((Object)mouseListener2, (String)"mouseListener");
            Intrinsics.checkNotNullParameter((Object)mouseMotionListener, (String)"mouseMotionListener");
            this.comboBox = comboBox2;
            this.list = list2;
            this.mouseListener = mouseListener2;
            this.mouseMotionListener = mouseMotionListener;
        }

        @Override
        public void keyReleased(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!ArraysKt.contains((Object[])DeviceComboBoxKt.access$getDELETE_KEY_CODES$p(), (Object)e.getKeyCode())) {
                return;
            }
            DeviceComboItem deviceComboItem = (DeviceComboItem)this.list.getSelectedValue();
            if (deviceComboItem == null) {
                return;
            }
            DeviceComboItem item = deviceComboItem;
            if (!DeviceComboBoxKt.access$isDeletable(item)) {
                return;
            }
            this.deleteSelectedItem();
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getButton() == 1 && e.getModifiersEx() == 0 && this.isOverDeleteIcon(e)) {
                this.deleteSelectedItem();
                return;
            }
            this.mouseListener.mouseReleased(e);
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            String string;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String string2 = "%06x";
            Object[] objectArray = new Object[]{NamedColorUtil.getInactiveTextColor().getRGB() & 0xFFFFFF};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            String hintColor = string3;
            if (this.isOverDeleteIcon(e)) {
                Object[] objectArray2 = new Object[]{hintColor};
                string = LogcatBundle.message("logcat.device.combo.delete.tooltip", objectArray2);
            } else {
                string = null;
            }
            this.list.setToolTipText(string);
            this.mouseMotionListener.mouseMoved(e);
        }

        private final boolean isOverDeleteIcon(MouseEvent $this$isOverDeleteIcon) {
            DeviceComboItem deviceComboItem = (DeviceComboItem)this.list.getSelectedValue();
            if (deviceComboItem == null) {
                return false;
            }
            DeviceComboItem item = deviceComboItem;
            if (!DeviceComboBoxKt.access$isDeletable(item)) {
                return false;
            }
            int index = this.list.getSelectedIndex();
            Rectangle cellBounds = this.list.getCellBounds(index, index);
            int cellPadding = JBUI.scale((int)DeviceComboBoxKt.access$getCOMBO_ITEM_INSETS$p().right);
            int x = cellBounds.width - 2 * cellPadding - DeviceComboBoxKt.access$getDELETE_ICON$p().getIconWidth();
            Intrinsics.checkNotNull((Object)cellBounds);
            Rectangle iconBounds = new Rectangle(x, RectangleUtilsKt.getTop((Rectangle)cellBounds), cellBounds.width - x, cellBounds.height);
            return iconBounds.contains($this$isOverDeleteIcon.getPoint());
        }

        private final void deleteSelectedItem() {
            Object object;
            int index = this.list.getSelectedIndex();
            if (index < 0) {
                return;
            }
            ComboBoxModel<? super DeviceComboItem> comboBoxModel = this.comboBox.getModel();
            Intrinsics.checkNotNull(comboBoxModel, (String)"null cannot be cast to non-null type com.android.tools.idea.logcat.devices.DeviceComboBox.DeviceComboModel");
            DeviceComboModel deviceComboModel = (DeviceComboModel)((Object)comboBoxModel);
            deviceComboModel.remove(index);
            if (deviceComboModel.getItems().isEmpty()) {
                object = null;
            } else if (index == 0) {
                List list2 = deviceComboModel.getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
                object = CollectionsKt.first((List)list2);
            } else {
                object = deviceComboModel.getItems().get(index - 1);
            }
            deviceComboModel.setSelectedItem(object);
        }

        @Override
        public void mouseClicked(MouseEvent p0) {
            this.mouseListener.mouseClicked(p0);
        }

        @Override
        public void mousePressed(MouseEvent p0) {
            this.mouseListener.mousePressed(p0);
        }

        @Override
        public void mouseEntered(MouseEvent p0) {
            this.mouseListener.mouseEntered(p0);
        }

        @Override
        public void mouseExited(MouseEvent p0) {
            this.mouseListener.mouseExited(p0);
        }

        @Override
        public void mouseDragged(MouseEvent p0) {
            this.mouseMotionListener.mouseDragged(p0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J:\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J:\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboBoxRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboItem;", "<init>", "()V", "component", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "deleteLabel", "Ljavax/swing/JLabel;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "customizeCellRenderer", "", "item", "renderDevice", "device", "Lcom/android/tools/idea/logcat/devices/Device;", "renderFile", "path", "Ljava/nio/file/Path;", "items", "", "intellij.android.logcat"})
    @SourceDebugExtension(value={"SMAP\nDeviceComboBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceComboBox.kt\ncom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboBoxRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,475:1\n808#2,11:476\n1788#2,4:487\n*S KotlinDebug\n*F\n+ 1 DeviceComboBox.kt\ncom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboBoxRenderer\n*L\n300#1:476,11\n300#1:487,4\n*E\n"})
    private static final class DeviceComboBoxRenderer
    extends ColoredListCellRenderer<DeviceComboItem> {
        @NotNull
        private final BorderLayoutPanel component = new BorderLayoutPanel();
        @NotNull
        private final JLabel deleteLabel = new JLabel();

        public DeviceComboBoxRenderer() {
            this.component.addToRight((Component)this.deleteLabel);
            this.component.setOpaque(false);
        }

        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends DeviceComboItem> list2, @Nullable DeviceComboItem value2, int index, boolean selected, boolean hasFocus) {
            Icon icon;
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            Component deviceComponent = super.getListCellRendererComponent(list2, (Object)value2, index, selected, hasFocus);
            this.component.addToLeft(deviceComponent);
            if (selected && value2 != null && DeviceComboBoxKt.access$isDeletable(value2)) {
                Icon icon2 = DeviceComboBoxKt.access$getDELETE_ICON$p();
                Color color = list2.getSelectionForeground();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getSelectionForeground(...)");
                icon = IconUtil.colorize$default((Icon)icon2, (Color)color, (boolean)false, (boolean)false, (int)12, null);
            } else {
                icon = null;
            }
            this.deleteLabel.setIcon(icon);
            return (Component)this.component;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends DeviceComboItem> list2, @Nullable DeviceComboItem item, int index, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            if (item == null) {
                this.append(LogcatBundle.message("logcat.device.combo.no.connected.devices", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
                return;
            }
            DeviceComboItem deviceComboItem = item;
            if (deviceComboItem instanceof DeviceComboItem.DeviceItem) {
                this.renderDevice(((DeviceComboItem.DeviceItem)item).getDevice());
            } else if (deviceComboItem instanceof DeviceComboItem.FileItem) {
                Path path = ((DeviceComboItem.FileItem)item).getPath();
                ListModel<? extends DeviceComboItem> listModel = list2.getModel();
                Intrinsics.checkNotNull(listModel, (String)"null cannot be cast to non-null type com.android.tools.idea.logcat.devices.DeviceComboBox.DeviceComboModel");
                List list3 = ((DeviceComboModel)((Object)listModel)).getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getItems(...)");
                this.renderFile(path, list3);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }

        private final void renderDevice(Device device2) {
            DeviceIcons icons = device2.isEmulator() ? DeviceComboBoxKt.access$getEMULATOR_ICONS$p() : DeviceComboBoxKt.access$getPHYSICAL_ICONS$p();
            this.setIcon(icons.iconForDeviceType(device2.getType()));
            this.append(device2.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (device2.isOnline()) {
                this.append(" (" + device2.getSerialNumber() + ")", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            Object[] objectArray = new Object[]{device2.getRelease(), device2.getApiLevel()};
            this.append(LogcatBundle.message("logcat.device.combo.version", objectArray), SimpleTextAttributes.GRAY_ATTRIBUTES);
            if (!device2.isOnline()) {
                this.append(LogcatBundle.message("logcat.device.combo.offline", new Object[0]), SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void renderFile(Path path, List<? extends DeviceComboItem> items) {
            int n;
            void $this$count$iv;
            void $this$filterIsInstanceTo$iv$iv;
            this.setIcon(AllIcons.FileTypes.Text);
            Iterable $this$filterIsInstance$iv = items;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DeviceComboItem.FileItem)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    DeviceComboItem.FileItem it = (DeviceComboItem.FileItem)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)PathsKt.getName((Path)it.getPath()), (Object)PathsKt.getName((Path)path)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int sameName = n;
            String name2 = sameName > 1 ? ((Object)path).toString() : PathsKt.getName((Path)path);
            this.append(name2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\u0005H\u0014J\b\u0010\t\u001a\u00020\u0005H\u0014J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboBoxUi;", "Lcom/intellij/ide/ui/laf/darcula/ui/DarculaComboBoxUI;", "<init>", "()V", "installDefaults", "", "createPopup", "Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboBoxUi$DeviceComboBoxPopup;", "selectNextPossibleValue", "selectPreviousPossibleValue", "setSelectedIndex", "index", "", "DeviceComboBoxPopup", "intellij.android.logcat"})
    private static final class DeviceComboBoxUi
    extends DarculaComboBoxUI {
        protected void installDefaults() {
            super.installDefaults();
            if (this.padding == null) {
                this.padding = (Insets)JBUI.insets((int)1, (int)6);
            }
        }

        @NotNull
        protected DeviceComboBoxPopup createPopup() {
            JComboBox jComboBox = this.comboBox;
            Intrinsics.checkNotNullExpressionValue((Object)jComboBox, (String)"comboBox");
            return new DeviceComboBoxPopup(jComboBox);
        }

        protected void selectNextPossibleValue() {
            int index = this.listBox.getSelectedIndex();
            if (index < this.comboBox.getModel().getSize() - 1) {
                this.setSelectedIndex(index + 1);
            }
        }

        protected void selectPreviousPossibleValue() {
            int index = this.listBox.getSelectedIndex();
            if (index > 0) {
                this.setSelectedIndex(index - 1);
            }
        }

        private final void setSelectedIndex(int index) {
            this.listBox.setSelectedIndex(index);
            this.listBox.ensureIndexIsVisible(index);
            this.comboBox.repaint();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboBoxUi$DeviceComboBoxPopup;", "Lcom/intellij/ide/ui/laf/darcula/ui/DarculaComboBoxUI$CustomComboPopup;", "comboBox", "Ljavax/swing/JComboBox;", "", "<init>", "(Ljavax/swing/JComboBox;)V", "installListListeners", "", "customizeListRendererComponent", "component", "Ljavax/swing/JComponent;", "intellij.android.logcat"})
        private static final class DeviceComboBoxPopup
        extends DarculaComboBoxUI.CustomComboPopup {
            public DeviceComboBoxPopup(@NotNull JComboBox<Object> comboBox2) {
                Intrinsics.checkNotNullParameter(comboBox2, (String)"comboBox");
                super(comboBox2);
            }

            protected void installListListeners() {
                MouseListener mouseListener2 = this.createListMouseListener();
                MouseMotionListener mouseMotionListener = this.createListMouseMotionListener();
                JComboBox jComboBox = this.comboBox;
                Intrinsics.checkNotNullExpressionValue((Object)jComboBox, (String)"comboBox");
                JList jList = this.list;
                Intrinsics.checkNotNullExpressionValue((Object)jList, (String)"list");
                Intrinsics.checkNotNull((Object)mouseListener2);
                Intrinsics.checkNotNull((Object)mouseMotionListener);
                DeviceComboBoxPopupMouseListener handler2 = new DeviceComboBoxPopupMouseListener(jComboBox, jList, mouseListener2, mouseMotionListener);
                this.comboBox.addKeyListener(handler2);
                this.listMouseListener = handler2;
                this.list.addMouseListener(this.listMouseListener);
                this.listMouseMotionListener = handler2;
                this.list.addMouseMotionListener(this.listMouseMotionListener);
                this.listSelectionListener = this.createListSelectionListener();
                this.list.addListSelectionListener(this.listSelectionListener);
            }

            protected void customizeListRendererComponent(@NotNull JComponent component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                component.setBorder(JBUI.Borders.empty((Insets)DeviceComboBoxKt.access$getCOMBO_ITEM_INSETS$p()));
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboItem;", "", "<init>", "()V", "DeviceItem", "FileItem", "Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboItem$DeviceItem;", "Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboItem$FileItem;", "intellij.android.logcat"})
    public static abstract sealed class DeviceComboItem {
        private DeviceComboItem() {
        }

        public /* synthetic */ DeviceComboItem(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboItem$DeviceItem;", "Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboItem;", "device", "Lcom/android/tools/idea/logcat/devices/Device;", "<init>", "(Lcom/android/tools/idea/logcat/devices/Device;)V", "getDevice", "()Lcom/android/tools/idea/logcat/devices/Device;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.android.logcat"})
        public static final class DeviceItem
        extends DeviceComboItem {
            @NotNull
            private final Device device;

            public DeviceItem(@NotNull Device device2) {
                Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                super(null);
                this.device = device2;
            }

            @NotNull
            public final Device getDevice() {
                return this.device;
            }

            @NotNull
            public final Device component1() {
                return this.device;
            }

            @NotNull
            public final DeviceItem copy(@NotNull Device device2) {
                Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                return new DeviceItem(device2);
            }

            public static /* synthetic */ DeviceItem copy$default(DeviceItem deviceItem, Device device2, int n, Object object) {
                if ((n & 1) != 0) {
                    device2 = deviceItem.device;
                }
                return deviceItem.copy(device2);
            }

            @NotNull
            public String toString() {
                return "DeviceItem(device=" + this.device + ")";
            }

            public int hashCode() {
                return this.device.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DeviceItem)) {
                    return false;
                }
                DeviceItem deviceItem = (DeviceItem)other;
                return Intrinsics.areEqual((Object)this.device, (Object)deviceItem.device);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboItem$FileItem;", "Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboItem;", "path", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getPath", "()Ljava/nio/file/Path;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.android.logcat"})
        public static final class FileItem
        extends DeviceComboItem {
            @NotNull
            private final Path path;

            public FileItem(@NotNull Path path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                super(null);
                this.path = path;
            }

            @NotNull
            public final Path getPath() {
                return this.path;
            }

            @NotNull
            public final Path component1() {
                return this.path;
            }

            @NotNull
            public final FileItem copy(@NotNull Path path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return new FileItem(path);
            }

            public static /* synthetic */ FileItem copy$default(FileItem fileItem, Path path, int n, Object object) {
                if ((n & 1) != 0) {
                    path = fileItem.path;
                }
                return fileItem.copy(path);
            }

            @NotNull
            public String toString() {
                return "FileItem(path=" + this.path + ")";
            }

            public int hashCode() {
                return ((Object)this.path).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FileItem)) {
                    return false;
                }
                FileItem fileItem = (FileItem)other;
                return Intrinsics.areEqual((Object)this.path, (Object)fileItem.path);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboModel;", "Lcom/intellij/ui/CollectionComboBoxModel;", "Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboItem;", "<init>", "()V", "addDevice", "Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboItem$DeviceItem;", "device", "Lcom/android/tools/idea/logcat/devices/Device;", "addFile", "Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboItem$FileItem;", "path", "Ljava/nio/file/Path;", "replaceDevice", "", "setSelected", "", "containsDevice", "intellij.android.logcat"})
    @SourceDebugExtension(value={"SMAP\nDeviceComboBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceComboBox.kt\ncom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,475:1\n1#2:476\n360#3,7:477\n*S KotlinDebug\n*F\n+ 1 DeviceComboBox.kt\ncom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboModel\n*L\n317#1:477,7\n*E\n"})
    private static final class DeviceComboModel
    extends CollectionComboBoxModel<DeviceComboItem> {
        @NotNull
        public final DeviceComboItem.DeviceItem addDevice(@NotNull Device device2) {
            DeviceComboItem.DeviceItem deviceItem;
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            DeviceComboItem.DeviceItem it = deviceItem = new DeviceComboItem.DeviceItem(device2);
            boolean bl = false;
            this.add(it);
            return deviceItem;
        }

        @NotNull
        public final DeviceComboItem.FileItem addFile(@NotNull Path path) {
            DeviceComboItem.FileItem fileItem;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            DeviceComboItem.FileItem it = fileItem = new DeviceComboItem.FileItem(path);
            boolean bl = false;
            this.add(it);
            return fileItem;
        }

        public final void replaceDevice(@NotNull Device device2, boolean setSelected2) {
            int index;
            block4: {
                int n;
                Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                List list2 = this.getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
                List $this$indexOfFirst$iv = list2;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    DeviceComboItem it = (DeviceComboItem)item$iv;
                    boolean bl = false;
                    if (it instanceof DeviceComboItem.DeviceItem && Intrinsics.areEqual((Object)((DeviceComboItem.DeviceItem)it).getDevice().getDeviceId(), (Object)device2.getDeviceId())) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
            if (index < 0) {
                LogcatLoggerKt.getLOGGER().warn("Device " + device2.getDeviceId() + " expected to exist but was not found");
                return;
            }
            DeviceComboItem.DeviceItem item = new DeviceComboItem.DeviceItem(device2);
            this.setElementAt(item, index);
            if (setSelected2) {
                this.setSelectedItem(item);
            }
        }

        public final boolean containsDevice(@NotNull Device device2) {
            Object v1;
            block1: {
                Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                List list2 = this.getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
                Iterable iterable = list2;
                for (Object t : iterable) {
                    DeviceComboItem it = (DeviceComboItem)t;
                    boolean bl = false;
                    if (!(it instanceof DeviceComboItem.DeviceItem && Intrinsics.areEqual((Object)((DeviceComboItem.DeviceItem)it).getDevice().getDeviceId(), (Object)device2.getDeviceId()))) continue;
                    v1 = t;
                    break block1;
                }
                v1 = null;
            }
            return v1 != null;
        }
    }
}

