/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.actions;

import com.android.tools.idea.logcat.LogcatBundle;
import com.android.tools.idea.logcat.actions.LogcatScrollToTheEndToolbarActionKt;
import com.android.tools.idea.logcat.util.EditorUtilsKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAware;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/logcat/actions/LogcatScrollToTheEndToolbarAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.android.logcat"})
public final class LogcatScrollToTheEndToolbarAction
extends ToggleAction
implements DumbAware {
    @NotNull
    private final EditorEx editor;

    public LogcatScrollToTheEndToolbarAction(@NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        String message = LogcatBundle.message("logcat.scroll.to.end.action.text", new Object[0]);
        this.getTemplatePresentation().setDescription(message);
        this.getTemplatePresentation().setText(message);
        this.getTemplatePresentation().setIcon(AllIcons.RunConfigurations.Scroll_down);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        boolean isScrollAtBottom = EditorUtilsKt.isScrollAtBottom(this.editor, false);
        return (document.getLineCount() == 0 || LogcatScrollToTheEndToolbarActionKt.access$isCaretAtBottom(this.editor)) && isScrollAtBottom;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state2) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (state2) {
            EditorUtil.scrollToTheEnd((Editor)((Editor)this.editor));
        } else {
            int lastLine = Math.max(0, this.editor.getDocument().getLineCount() - 1);
            LogicalPosition logicalPosition = this.editor.getCaretModel().getLogicalPosition();
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
            LogicalPosition currentPosition = logicalPosition;
            LogicalPosition position = new LogicalPosition(Math.max(0, Math.min(currentPosition.line, lastLine - 1)), currentPosition.column);
            this.editor.getCaretModel().moveToLogicalPosition(position);
        }
    }
}

