/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.tools.idea.logcat.LogcatOccurrenceNavigator;
import com.android.tools.idea.logcat.LogcatOccurrenceNavigatorKt;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/logcat/LogcatNavigatableAdapter;", "Lcom/intellij/pom/NavigatableAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "occurrenceRange", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "allRanges", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/markup/RangeHighlighter;Ljava/util/List;)V", "getOccurrenceRange", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getAllRanges", "()Ljava/util/List;", "navigate", "", "requestFocus", "", "intellij.android.logcat"})
public final class LogcatNavigatableAdapter
extends NavigatableAdapter {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @VisibleForTesting
    @NotNull
    private final RangeHighlighter occurrenceRange;
    @VisibleForTesting
    @NotNull
    private final List<RangeHighlighter> allRanges;

    public LogcatNavigatableAdapter(@NotNull Project project, @NotNull Editor editor, @NotNull RangeHighlighter occurrenceRange, @NotNull List<? extends RangeHighlighter> allRanges) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)occurrenceRange, (String)"occurrenceRange");
        Intrinsics.checkNotNullParameter(allRanges, (String)"allRanges");
        this.project = project;
        this.editor = editor;
        this.occurrenceRange = occurrenceRange;
        this.allRanges = allRanges;
    }

    @NotNull
    public final RangeHighlighter getOccurrenceRange() {
        return this.occurrenceRange;
    }

    @NotNull
    public final List<RangeHighlighter> getAllRanges() {
        return this.allRanges;
    }

    public void navigate(boolean requestFocus) {
        int offset = this.occurrenceRange.getStartOffset();
        this.editor.getCaretModel().moveToOffset(offset);
        this.editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        HyperlinkInfo hyperlinkInfo = EditorHyperlinkSupport.getHyperlinkInfo((RangeHighlighter)this.occurrenceRange);
        if (hyperlinkInfo instanceof HyperlinkInfoBase) {
            VisualPosition visualPosition = this.editor.offsetToVisualPosition(offset);
            Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"offsetToVisualPosition(...)");
            VisualPosition position = visualPosition;
            Point point = this.editor.visualPositionToXY(new VisualPosition(position.getLine() + 1, position.getColumn()));
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"visualPositionToXY(...)");
            Point point2 = point;
            ((HyperlinkInfoBase)hyperlinkInfo).navigate(this.project, new RelativePoint((Component)this.editor.getContentComponent(), point2));
        } else {
            HyperlinkInfo hyperlinkInfo2 = hyperlinkInfo;
            if (hyperlinkInfo2 != null) {
                hyperlinkInfo2.navigate(this.project);
            }
        }
        MarkupModel markupModel = this.editor.getMarkupModel();
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx markupModel2 = (MarkupModelEx)markupModel;
        for (RangeHighlighter range : this.allRanges) {
            TextAttributes textAttributes = (TextAttributes)range.getUserData(LogcatOccurrenceNavigatorKt.getORIGINAL_HYPERLINK_TEXT_ATTRIBUTES());
            if (textAttributes == null) continue;
            markupModel2.setRangeHighlighterAttributes(range, textAttributes);
            range.putUserData(LogcatOccurrenceNavigatorKt.getORIGINAL_HYPERLINK_TEXT_ATTRIBUTES(), null);
        }
        this.occurrenceRange.putUserData(LogcatOccurrenceNavigatorKt.getORIGINAL_HYPERLINK_TEXT_ATTRIBUTES(), (Object)this.occurrenceRange.getTextAttributes(this.editor.getColorsScheme()));
        markupModel2.setRangeHighlighterAttributes(this.occurrenceRange, LogcatOccurrenceNavigator.Companion.getFOLLOWED_HYPERLINK_ATTRIBUTES$intellij_android_logcat());
    }
}

