/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\tH\u0002J \u0010\u0015\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/lint/quickFixes/RemoveSdkCheckFix;", "Lcom/android/tools/idea/lint/common/DefaultLintQuickFix;", "removeThen", "", "<init>", "(Z)V", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "applyToIfExpression", "ifExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "findSdkConditional", "Lorg/jetbrains/kotlin/psi/KtExpression;", "start", "isVersionCheckConditional", "element", "isApplicable", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "intellij.android.lint"})
public final class RemoveSdkCheckFix
extends DefaultLintQuickFix {
    private boolean removeThen;

    public RemoveSdkCheckFix(boolean removeThen) {
        super("Remove obsolete SDK version check", "Remove obsolete SDK version checks");
        this.removeThen = removeThen;
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KtExpression ktExpression = this.findSdkConditional(startElement);
        if (ktExpression == null) {
            return;
        }
        KtExpression condition = ktExpression;
        if (!IntentionPreviewUtils.prepareElementForWrite((PsiElement)startElement)) {
            return;
        }
        KtIfExpression ifExpression = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)condition), KtIfExpression.class, (boolean)true);
        if (ifExpression != null && Intrinsics.areEqual((Object)ifExpression.getCondition(), (Object)condition) && this.applyToIfExpression(ifExpression)) {
            return;
        }
        Project project = condition.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        PsiElement psiElement = this.removeThen ? condition.replace((PsiElement)psiFactory.createExpression("true")) : condition.replace((PsiElement)psiFactory.createExpression("false"));
    }

    private final boolean applyToIfExpression(KtIfExpression ifExpression) {
        KtExpression keep;
        KtExpression ktExpression = keep = this.removeThen ? ifExpression.getThen() : ifExpression.getElse();
        if (keep != null) {
            PsiElement psiElement = ifExpression.getParent();
            if (psiElement == null) {
                return false;
            }
            PsiElement parent = psiElement;
            if (keep instanceof KtBlockExpression) {
                for (PsiElement child = ((KtBlockExpression)keep).getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child instanceof TreeElement && (Intrinsics.areEqual((Object)((TreeElement)child).getElementType(), (Object)KtTokens.RBRACE) || Intrinsics.areEqual((Object)((TreeElement)child).getElementType(), (Object)KtTokens.LBRACE))) continue;
                    parent.addBefore(child, (PsiElement)ifExpression);
                }
            } else {
                parent.addBefore((PsiElement)keep, (PsiElement)ifExpression);
            }
        }
        ifExpression.delete();
        return true;
    }

    private final KtExpression findSdkConditional(PsiElement start2) {
        PsiElement current = start2;
        while (current != null && (KtBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)current, KtBinaryExpression.class, (boolean)false) != null) {
            KtBinaryExpression next;
            if (this.isVersionCheckConditional((PsiElement)next)) {
                return (KtExpression)next;
            }
            current = next.getParent();
        }
        return null;
    }

    private final boolean isVersionCheckConditional(PsiElement element) {
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"SDK_INT", (boolean)false, (int)2, null);
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)contextType, (String)"contextType");
        return true;
    }
}

