/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.inspections;

import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidLintUpdatableDependencyInspection;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.inspections.AndroidLintAndroidGradlePluginVersionInspectionKt;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.Incident;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/lint/inspections/AndroidLintAndroidGradlePluginVersionInspection;", "Lcom/android/tools/idea/lint/common/AndroidLintUpdatableDependencyInspection;", "<init>", "()V", "getQuickFixes", "", "Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/android/tools/lint/detector/api/Incident;)[Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "InvokeAGPUpgradeAssistantQuickFix", "intellij.android.lint"})
public final class AndroidLintAndroidGradlePluginVersionInspection
extends AndroidLintUpdatableDependencyInspection {
    public AndroidLintAndroidGradlePluginVersionInspection() {
        super(AndroidLintBundle.Companion.message("android.lint.inspections.android.gradle.plugin.version", new Object[0]), GradleDetector.AGP_DEPENDENCY);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull Incident incident) {
        LintIdeQuickFix[] lintIdeQuickFixArray;
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        LintIdeQuickFix[] fixes = super.getQuickFixes(startElement, endElement, incident);
        LintIdeSupport lintIdeSupport = LintIdeSupport.Companion.get();
        Project project = startElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        LintIdeSupport.AgpUpgradeInfo agpUpgradeInfo = lintIdeSupport.computeAgpUpgradeInfo(project);
        String string = incident.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (StringsKt.endsWith$default((String)string, (String)".properties", (boolean)false, (int)2, null)) {
            Intrinsics.checkNotNull((Object)fixes);
            lintIdeQuickFixArray = fixes;
        } else if (agpUpgradeInfo == null) {
            Intrinsics.checkNotNull((Object)fixes);
            lintIdeQuickFixArray = fixes;
        } else {
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)new InvokeAGPUpgradeAssistantQuickFix(agpUpgradeInfo));
            spreadBuilder.addSpread((Object)fixes);
            lintIdeQuickFixArray = (LintIdeQuickFix[])spreadBuilder.toArray((Object[])new LintIdeQuickFix[spreadBuilder.size()]);
        }
        return lintIdeQuickFixArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/lint/inspections/AndroidLintAndroidGradlePluginVersionInspection$InvokeAGPUpgradeAssistantQuickFix;", "Lcom/android/tools/idea/lint/common/DefaultLintQuickFix;", "info", "Lcom/android/tools/idea/lint/common/LintIdeSupport$AgpUpgradeInfo;", "<init>", "(Lcom/android/tools/idea/lint/common/LintIdeSupport$AgpUpgradeInfo;)V", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isApplicable", "", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "intellij.android.lint"})
    public static final class InvokeAGPUpgradeAssistantQuickFix
    extends DefaultLintQuickFix {
        @NotNull
        private final LintIdeSupport.AgpUpgradeInfo info;

        public InvokeAGPUpgradeAssistantQuickFix(@NotNull LintIdeSupport.AgpUpgradeInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            super("Invoke AGP Upgrade Assistant" + (String)(AndroidLintAndroidGradlePluginVersionInspectionKt.getAgpVersion(info) != null ? " for upgrade to " + AndroidLintAndroidGradlePluginVersionInspectionKt.getAgpVersion(info) : ""));
            this.info = info;
        }

        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            LintIdeSupport.Companion.get().upgradeAgp(this.info);
        }

        @Nullable
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return IntentionPreviewInfo.EMPTY;
        }

        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            Intrinsics.checkNotNullParameter((Object)contextType, (String)"contextType");
            return true;
        }
    }
}

