/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.targets.AndroidTargetManager;
import com.android.tools.lint.client.api.PlatformLookup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/lint/SdkManagerPlatformLookup;", "Lcom/android/tools/lint/client/api/PlatformLookup;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "logger", "Lcom/android/repository/api/ProgressIndicatorAdapter;", "<init>", "(Lcom/android/sdklib/repository/AndroidSdkHandler;Lcom/android/repository/api/ProgressIndicatorAdapter;)V", "getLatestSdkTarget", "Lcom/android/sdklib/IAndroidTarget;", "minApi", "", "includePreviews", "", "includeAddOns", "getTarget", "buildTargetHash", "", "targets", "", "getTargets", "intellij.android.lint"})
@SourceDebugExtension(value={"SMAP\nSdkManagerPlatformLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkManagerPlatformLookup.kt\ncom/android/tools/idea/lint/SdkManagerPlatformLookup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n543#2,6:83\n774#2:89\n865#2,2:90\n1#3:92\n*S KotlinDebug\n*F\n+ 1 SdkManagerPlatformLookup.kt\ncom/android/tools/idea/lint/SdkManagerPlatformLookup\n*L\n64#1:83,6\n76#1:89\n76#1:90,2\n*E\n"})
public final class SdkManagerPlatformLookup
implements PlatformLookup {
    @NotNull
    private final AndroidSdkHandler sdkHandler;
    @NotNull
    private final ProgressIndicatorAdapter logger;
    @Nullable
    private List<? extends IAndroidTarget> targets;

    public SdkManagerPlatformLookup(@NotNull AndroidSdkHandler sdkHandler, @NotNull ProgressIndicatorAdapter logger) {
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.sdkHandler = sdkHandler;
        this.logger = logger;
    }

    @Nullable
    public IAndroidTarget getLatestSdkTarget(int minApi, boolean includePreviews, boolean includeAddOns) {
        List<IAndroidTarget> targets = this.getTargets(includeAddOns);
        int n = ((Collection)targets).size() + -1;
        if (0 <= n) {
            do {
                int i = n--;
                IAndroidTarget target2 = targets.get(i);
                if (!includeAddOns && !target2.isPlatform() || target2.getVersion().getFeatureLevel() < minApi || !includePreviews && target2.getVersion().getCodename() != null) continue;
                return target2;
            } while (0 <= n);
        }
        return null;
    }

    @Nullable
    public IAndroidTarget getTarget(@NotNull String buildTargetHash) {
        IAndroidTarget iAndroidTarget;
        block3: {
            Intrinsics.checkNotNullParameter((Object)buildTargetHash, (String)"buildTargetHash");
            if (this.targets == null) {
                AndroidTargetManager manager = this.sdkHandler.getAndroidTargetManager((ProgressIndicator)this.logger);
                IAndroidTarget target2 = manager.getTargetFromHashString(buildTargetHash, (ProgressIndicator)this.logger);
                if (target2 != null) {
                    return target2;
                }
                return null;
            }
            List<? extends IAndroidTarget> list2 = this.targets;
            Intrinsics.checkNotNull(list2);
            List<? extends IAndroidTarget> $this$lastOrNull$iv = list2;
            boolean $i$f$lastOrNull = false;
            ListIterator<? extends IAndroidTarget> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                IAndroidTarget element$iv;
                IAndroidTarget it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.hashString(), (Object)buildTargetHash)) continue;
                iAndroidTarget = element$iv;
                break block3;
            }
            iAndroidTarget = null;
        }
        return iAndroidTarget;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<IAndroidTarget> getTargets(boolean includeAddOns) {
        Iterable<Object> iterable = this.targets;
        if (iterable == null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            SdkManagerPlatformLookup $this$getTargets_u24lambda_u240 = this;
            boolean bl = false;
            Collection collection2 = $this$getTargets_u24lambda_u240.sdkHandler.getAndroidTargetManager((ProgressIndicator)$this$getTargets_u24lambda_u240.logger).getTargets((ProgressIndicator)$this$getTargets_u24lambda_u240.logger);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getTargets(...)");
            Iterable iterable2 = collection2;
            boolean $i$f$filter = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IAndroidTarget it = (IAndroidTarget)element$iv$iv;
                boolean bl2 = false;
                if (!(includeAddOns || it.isPlatform())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable it = iterable2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            boolean bl3 = false;
            $this$getTargets_u24lambda_u240.targets = it;
            iterable = iterable2;
        }
        return iterable;
    }
}

