/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.tools.idea.gradle.model.IdeAndroidProject;
import com.android.tools.idea.gradle.model.IdeAndroidProjectType;
import com.android.tools.idea.gradle.model.IdeLintOptions;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Severity;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LintAction;
import com.google.wireless.android.sdk.stats.LintIssueId;
import com.google.wireless.android.sdk.stats.LintPerformance;
import com.google.wireless.android.sdk.stats.LintSession;
import com.google.wireless.android.sdk.stats.LintTooltipLinkEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJX\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142&\u0010\u0016\u001a\"\u0012\u0004\u0012\u00020\u0018\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0017\u0018\u00010\u0017J\u0016\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\tJ\u0016\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0018J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0002J<\u0010\"\u001a\u00020\u00072\"\u0010#\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020%0$j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020%`&2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)H\u0002J\f\u0010*\u001a\u00020)*\u00020+H\u0002J\f\u0010*\u001a\u00020)*\u00020,H\u0002JV\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020%0\u00172\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142&\u0010\u0016\u001a\"\u0012\u0004\u0012\u00020\u0018\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0017\u0018\u00010\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J:\u0010.\u001a\u00020\u00072\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\"\u0010#\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020%0$j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020%`&H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u00101\u001a\u0004\u0018\u00010\t2\b\u00102\u001a\u0004\u0018\u000103H\u0002J\u0010\u00104\u001a\u00020!2\u0006\u0010\b\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/tools/idea/lint/LintIdeAnalytics;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logFeedback", "", "issue", "", "feedback", "Lcom/google/wireless/android/sdk/stats/LintAction$LintFeedback;", "logSession", "type", "Lcom/google/wireless/android/sdk/stats/LintSession$AnalysisType;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "severityModule", "Lcom/intellij/openapi/module/Module;", "warnings1", "", "Lcom/android/tools/idea/lint/common/LintProblemData;", "warnings2", "", "Lcom/android/tools/lint/detector/api/Issue;", "Ljava/io/File;", "logQuickFixInvocation", "fixDescription", "logTooltipLink", "url", "computePerformance", "Lcom/google/wireless/android/sdk/stats/LintPerformance;", "singleFileAnalysis", "", "recordSeverityOverride", "map", "Ljava/util/HashMap;", "Lcom/google/wireless/android/sdk/stats/LintIssueId$Builder;", "Lkotlin/collections/HashMap;", "id", "lintSeverity", "Lcom/google/wireless/android/sdk/stats/LintIssueId$LintSeverity;", "toAnalyticsSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "", "computeIssueData", "recordIssueData", "warnings", "computeApplicationId", "computeProjectId", "projectPath", "Ljava/nio/file/Path;", "isAospOrGoogleLintIssue", "intellij.android.lint"})
@SourceDebugExtension(value={"SMAP\nLintIdeAnalytics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintIdeAnalytics.kt\ncom/android/tools/idea/lint/LintIdeAnalytics\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n1#2:323\n*E\n"})
public final class LintIdeAnalytics {
    @NotNull
    private final Project project;

    public LintIdeAnalytics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final void logFeedback(@NotNull String issue2, @NotNull LintAction.LintFeedback feedback) {
        LintAction.Builder builder;
        String it;
        AndroidStudioEvent.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)feedback, (String)"feedback");
        AndroidStudioEvent.Builder $this$logFeedback_u24lambda_u240 = builder2 = AndroidStudioEvent.newBuilder();
        boolean bl = false;
        $this$logFeedback_u24lambda_u240.setKind(AndroidStudioEvent.EventKind.LINT_ACTION);
        String string = this.computeProjectId(this.project);
        if (string != null) {
            it = string;
            boolean bl2 = false;
            $this$logFeedback_u24lambda_u240.setProjectId(it);
        }
        String string2 = this.computeApplicationId(this.project);
        if (string2 != null) {
            it = string2;
            boolean bl3 = false;
            $this$logFeedback_u24lambda_u240.setRawProjectId(it);
        }
        LintAction.Builder $this$logFeedback_u24lambda_u240_u242 = builder = LintAction.newBuilder();
        boolean bl4 = false;
        $this$logFeedback_u24lambda_u240_u242.setIssueId(issue2);
        $this$logFeedback_u24lambda_u240_u242.setLintFeedback(feedback);
        LintAction action2 = builder.build();
        $this$logFeedback_u24lambda_u240.setLintAction(action2);
        AndroidStudioEvent.Builder builder3 = builder2;
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"apply(...)");
        AndroidStudioEvent.Builder event = UsageTrackerUtils.withProjectId(builder3, this.project);
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    public final void logSession(@NotNull LintSession.AnalysisType type, @NotNull LintDriver driver, @Nullable Module severityModule, @Nullable List<? extends LintProblemData> warnings1, @Nullable Map<Issue, ? extends Map<File, ? extends List<? extends LintProblemData>>> warnings2) {
        AndroidStudioEvent.Builder builder;
        LintSession.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        if (this.project.isDisposed()) {
            return;
        }
        if (!AnalyticsSettings.getOptedIn()) {
            return;
        }
        LintSession.Builder $this$logSession_u24lambda_u240 = builder2 = LintSession.newBuilder();
        boolean bl = false;
        $this$logSession_u24lambda_u240.setAnalysisType(type);
        $this$logSession_u24lambda_u240.setProjectId(this.computeProjectId(this.project));
        $this$logSession_u24lambda_u240.setLintPerformance(this.computePerformance(driver, type == LintSession.AnalysisType.IDE_FILE));
        $this$logSession_u24lambda_u240.setBaselineEnabled(driver.getBaseline() != null);
        $this$logSession_u24lambda_u240.setIncludingGeneratedSources(driver.getCheckGeneratedSources());
        $this$logSession_u24lambda_u240.setIncludingTestSources(driver.getCheckTestSources());
        $this$logSession_u24lambda_u240.setIncludingDependencies(driver.getCheckDependencies());
        for (LintIssueId.Builder issueBuilder : this.computeIssueData(warnings1, warnings2, severityModule).values()) {
            $this$logSession_u24lambda_u240.addIssueIds(issueBuilder);
        }
        LintSession session2 = builder2.build();
        AndroidStudioEvent.Builder $this$logSession_u24lambda_u241 = builder = AndroidStudioEvent.newBuilder();
        boolean bl2 = false;
        $this$logSession_u24lambda_u241.setKind(AndroidStudioEvent.EventKind.LINT_SESSION);
        $this$logSession_u24lambda_u241.setLintSession(session2);
        $this$logSession_u24lambda_u241.setJavaProcessStats(CommonMetricsData.getJavaProcessStats());
        $this$logSession_u24lambda_u241.setJvmDetails(CommonMetricsData.getJvmDetails());
        AndroidStudioEvent.Builder builder3 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"apply(...)");
        AndroidStudioEvent.Builder event = UsageTrackerUtils.withProjectId(builder3, this.project);
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    public final void logQuickFixInvocation(@NotNull Issue issue2, @NotNull String fixDescription) {
        AndroidStudioEvent.Builder builder;
        LintAction.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)fixDescription, (String)"fixDescription");
        if (this.project.isDisposed()) {
            return;
        }
        if (!AnalyticsSettings.getOptedIn()) {
            return;
        }
        if (!this.isAospOrGoogleLintIssue(issue2)) {
            return;
        }
        LintAction.Builder $this$logQuickFixInvocation_u24lambda_u240 = builder2 = LintAction.newBuilder();
        boolean bl = false;
        $this$logQuickFixInvocation_u24lambda_u240.setIssueId(issue2.getId());
        $this$logQuickFixInvocation_u24lambda_u240.setFixId(fixDescription);
        LintAction action2 = builder2.build();
        AndroidStudioEvent.Builder $this$logQuickFixInvocation_u24lambda_u241 = builder = AndroidStudioEvent.newBuilder();
        boolean bl2 = false;
        $this$logQuickFixInvocation_u24lambda_u241.setKind(AndroidStudioEvent.EventKind.LINT_ACTION);
        $this$logQuickFixInvocation_u24lambda_u241.setLintAction(action2);
        AndroidStudioEvent.Builder builder3 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"apply(...)");
        AndroidStudioEvent.Builder event = UsageTrackerUtils.withProjectId(builder3, this.project);
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    public final void logTooltipLink(@NotNull String url, @NotNull Issue issue2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        if (this.project.isDisposed()) {
            return;
        }
        if (!AnalyticsSettings.getOptedIn()) {
            return;
        }
        if (!this.isAospOrGoogleLintIssue(issue2)) {
            return;
        }
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        AndroidStudioEvent.Builder builder2 = UsageTrackerUtils.withProjectId(builder, this.project).setKind(AndroidStudioEvent.EventKind.LINT_TOOLTIP_LINK_EVENT).setLintTooltipLinkEvent(LintTooltipLinkEvent.newBuilder().setIssueId(issue2.getId()).setUrl(url));
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"setLintTooltipLinkEvent(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder2);
    }

    private final LintPerformance computePerformance(LintDriver driver, boolean singleFileAnalysis) {
        LintPerformance.Builder builder;
        LintPerformance.Builder $this$computePerformance_u24lambda_u240 = builder = LintPerformance.newBuilder();
        boolean bl = false;
        $this$computePerformance_u24lambda_u240.setAnalysisTimeMs(System.currentTimeMillis() - driver.getAnalysisStartTime());
        $this$computePerformance_u24lambda_u240.setFileCount((long)driver.getFileCount());
        if (!singleFileAnalysis) {
            $this$computePerformance_u24lambda_u240.setModuleCount((long)driver.getModuleCount());
            $this$computePerformance_u24lambda_u240.setJavaSourceCount((long)driver.getJavaFileCount());
            $this$computePerformance_u24lambda_u240.setKotlinSourceCount((long)driver.getKotlinFileCount());
            $this$computePerformance_u24lambda_u240.setResourceFileCount((long)driver.getResourceFileCount());
            $this$computePerformance_u24lambda_u240.setTestSourceCount((long)driver.getTestSourceCount());
        }
        LintPerformance lintPerformance = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)lintPerformance, (String)"build(...)");
        return lintPerformance;
    }

    private final void recordSeverityOverride(HashMap<String, LintIssueId.Builder> map2, String id2, LintIssueId.LintSeverity lintSeverity) {
        LintIssueId.Builder builder;
        LintIssueId.Builder builder2 = map2.get(id2);
        if (builder2 != null) {
            return;
        }
        LintIssueId.Builder $this$recordSeverityOverride_u24lambda_u240 = builder = LintIssueId.newBuilder();
        boolean bl = false;
        ((Map)map2).put(id2, $this$recordSeverityOverride_u24lambda_u240);
        $this$recordSeverityOverride_u24lambda_u240.setIssueId(id2);
        $this$recordSeverityOverride_u24lambda_u240.setCount(0L);
        $this$recordSeverityOverride_u24lambda_u240.setSeverity(lintSeverity);
    }

    private final LintIssueId.LintSeverity toAnalyticsSeverity(Severity $this$toAnalyticsSeverity) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toAnalyticsSeverity.ordinal()]) {
            case 1 -> LintIssueId.LintSeverity.FATAL_SEVERITY;
            case 2 -> LintIssueId.LintSeverity.ERROR_SEVERITY;
            case 3 -> LintIssueId.LintSeverity.WARNING_SEVERITY;
            case 4 -> LintIssueId.LintSeverity.INFORMATIONAL_SEVERITY;
            case 5 -> LintIssueId.LintSeverity.IGNORE_SEVERITY;
            default -> LintIssueId.LintSeverity.UNKNOWN_SEVERITY;
        };
    }

    private final LintIssueId.LintSeverity toAnalyticsSeverity(int $this$toAnalyticsSeverity) {
        return switch ($this$toAnalyticsSeverity) {
            case 1 -> LintIssueId.LintSeverity.FATAL_SEVERITY;
            case 2 -> LintIssueId.LintSeverity.ERROR_SEVERITY;
            case 3 -> LintIssueId.LintSeverity.WARNING_SEVERITY;
            case 4 -> LintIssueId.LintSeverity.INFORMATIONAL_SEVERITY;
            case 5 -> LintIssueId.LintSeverity.IGNORE_SEVERITY;
            default -> LintIssueId.LintSeverity.UNKNOWN_SEVERITY;
        };
    }

    private final Map<String, LintIssueId.Builder> computeIssueData(List<? extends LintProblemData> warnings1, Map<Issue, ? extends Map<File, ? extends List<? extends LintProblemData>>> warnings2, Module severityModule) {
        GradleAndroidModel model;
        HashMap<String, LintIssueId.Builder> map2 = new HashMap<String, LintIssueId.Builder>(100);
        if (warnings1 != null) {
            this.recordIssueData(warnings1, map2);
        }
        if (warnings2 != null) {
            for (Map<File, ? extends List<? extends LintProblemData>> map3 : warnings2.values()) {
                for (List<? extends LintProblemData> list2 : map3.values()) {
                    this.recordIssueData(list2, map2);
                }
            }
        }
        if (severityModule != null && (model = GradleAndroidModel.Companion.get(severityModule)) != null) {
            try {
                IdeLintOptions lintOptions;
                IdeAndroidProject throwable = model.getAndroidProject();
                IdeLintOptions ideLintOptions = lintOptions = throwable.getLintOptions();
                Map map4 = ideLintOptions != null ? ideLintOptions.getSeverityOverrides() : null;
                Map map5 = map4;
                if (!(map5 == null || map5.isEmpty())) {
                    for (Map.Entry entry : map4.entrySet()) {
                        String id2 = (String)entry.getKey();
                        int severity = ((Number)entry.getValue()).intValue();
                        this.recordSeverityOverride(map2, id2, this.toAnalyticsSeverity(severity));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return map2;
    }

    private final void recordIssueData(List<? extends LintProblemData> warnings, HashMap<String, LintIssueId.Builder> map2) {
        for (LintProblemData lintProblemData : warnings) {
            Issue issue2;
            Intrinsics.checkNotNullExpressionValue((Object)lintProblemData.getIssue(), (String)"getIssue(...)");
            String id2 = issue2.getId();
            LintIssueId.Builder builder = map2.get(id2);
            if (builder == null) {
                LintIssueId.Builder builder2;
                LintIdeAnalytics $this$recordIssueData_u24lambda_u240 = this;
                boolean bl = false;
                LintIssueId.Builder $this$recordIssueData_u24lambda_u240_u240 = builder2 = LintIssueId.newBuilder();
                boolean bl2 = false;
                ((Map)map2).put(id2, $this$recordIssueData_u24lambda_u240_u240);
                $this$recordIssueData_u24lambda_u240_u240.setIssueId(issue2.getId());
                Severity configuredSeverity = lintProblemData.getConfiguredSeverity();
                $this$recordIssueData_u24lambda_u240_u240.setSeverity(configuredSeverity == null || configuredSeverity == issue2.getDefaultSeverity() ? LintIssueId.LintSeverity.DEFAULT_SEVERITY : $this$recordIssueData_u24lambda_u240.toAnalyticsSeverity(configuredSeverity));
                builder = builder2;
            }
            LintIssueId.Builder issueBuilder = builder;
            issueBuilder.setCount(issueBuilder.getCount() + 1L);
        }
    }

    private final String computeApplicationId(Project project) {
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
        for (Module module : moduleManager.getModules()) {
            GradleAndroidModel androidModel = GradleAndroidModel.Companion.get(module);
            if (androidModel == null || androidModel.getAndroidProject().getProjectType() != IdeAndroidProjectType.PROJECT_TYPE_APP) continue;
            return androidModel.getApplicationId();
        }
        return null;
    }

    private final String computeProjectId(Project project) {
        return this.computeProjectId(Paths.get(project.getBasePath(), new String[0]));
    }

    private final String computeProjectId(Path projectPath) {
        if (projectPath == null) {
            return null;
        }
        String string = Anonymizer.anonymize((String)((Object)projectPath.toAbsolutePath()).toString());
        if (string == null) {
            string = "*ANONYMIZATION_ERROR*";
        }
        return string;
    }

    private final boolean isAospOrGoogleLintIssue(Issue issue2) {
        IssueRegistry issueRegistry;
        Object object = issue2.getVendor();
        if ((object == null || (object = object.getVendorName()) == null) && ((issueRegistry = issue2.getRegistry()) != null && (issueRegistry = issueRegistry.getVendor()) != null ? issueRegistry.getVendorName() : (object = null)) == null) {
            return false;
        }
        Object vendorName = object;
        String string = IssueRegistry.Companion.getAOSP_VENDOR().getVendorName();
        Intrinsics.checkNotNull((Object)string);
        return StringsKt.startsWith$default((String)vendorName, (String)string, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)vendorName, (String)"Google", (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            try {
                nArray[Severity.FATAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.INFORMATIONAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.IGNORE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

