/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.Version;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.manifmerger.Actions;
import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.apk.analyzer.ResourceIdResolver;
import com.android.tools.idea.editors.manifest.ManifestUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.repositories.IdeGoogleMavenRepository;
import com.android.tools.idea.lint.PlayPolicyInsightsDeprecationUtilKt;
import com.android.tools.idea.lint.PlayPolicyInsightsJarCache;
import com.android.tools.idea.lint.SdkManagerPlatformLookup;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintResult;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.tools.idea.projectsystem.gradle.IdeGooglePlaySdkIndexKt;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StudioFrameworkResourceRepositoryManager;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.PlatformLookup;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.res.FileResourceReader;
import com.android.tools.sdk.AndroidSdkData;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.StudioAndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;

public class AndroidLintIdeClient
extends LintIdeClient {
    private final boolean myIsPlayPolicyInsightsObsolete;
    private final boolean myIsPlayPolicyInsightsEnabled;
    @NotNull
    protected com.intellij.openapi.project.Project myProject;
    private PlayPolicyInsightsJarCache myCache;
    private AndroidSdkHandler sdk = null;
    @Nullable
    private PlatformLookup platformLookup = null;
    private static final String MERGED_MANIFEST_INFO = "lint-merged-manifest-info";

    public void report(@NotNull Context context, @NotNull Incident incident, @NotNull TextFormat format) {
        if (PlayPolicyInsightsDeprecationUtilKt.isPlayPolicyIssue(incident.getIssue())) {
            if (!this.myIsPlayPolicyInsightsEnabled) {
                return;
            }
            if (this.myIsPlayPolicyInsightsObsolete) {
                PlayPolicyInsightsDeprecationUtilKt.updateMessageWithDeprecationInfo(incident);
            }
        }
        super.report(context, incident, format);
    }

    public AndroidLintIdeClient(@NotNull com.intellij.openapi.project.Project project, @NotNull LintResult lintResult) {
        super(project, lintResult);
        this.myProject = project;
        this.myIsPlayPolicyInsightsEnabled = (Boolean)StudioFlags.ENABLE_PLAY_POLICY_INSIGHTS.get();
        this.myIsPlayPolicyInsightsObsolete = PlayPolicyInsightsDeprecationUtilKt.isPlayPolicyInsightsUnsupported();
    }

    @NotNull
    public byte[] readBytes(@NotNull PathString resourcePath) throws IOException {
        ProgressManager.checkCanceled();
        return FileResourceReader.readBytes(resourcePath, ResourceIdResolver.NO_RESOLUTION);
    }

    @NotNull
    public @NotNull List<@NotNull File> findGlobalRuleJars(@Nullable LintDriver driver, boolean warnDeprecated) {
        List result2 = super.findGlobalRuleJars(driver, warnDeprecated);
        if (((Boolean)StudioFlags.ENABLE_PLAY_POLICY_INSIGHTS.get()).booleanValue()) {
            PlayPolicyInsightsJarCache cache = this.getPlayPolicyInsightsJarCache();
            ArrayList jars = Lists.newArrayList(cache.getCustomRuleJars());
            jars.addAll(result2);
            return jars;
        }
        return result2;
    }

    private PlayPolicyInsightsJarCache getPlayPolicyInsightsJarCache() {
        if (this.myCache == null) {
            this.myCache = new PlayPolicyInsightsJarCache(this);
        }
        return this.myCache;
    }

    @Nullable
    public File getSdkHome() {
        File home;
        String path;
        Sdk moduleSdk;
        Module module = this.getModule();
        if (module != null && (moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk()) != null && moduleSdk.getSdkType() instanceof AndroidSdkType && (path = moduleSdk.getHomePath()) != null && (home = new File(path)).exists()) {
            return home;
        }
        File sdkHome = super.getSdkHome();
        if (sdkHome != null) {
            return sdkHome;
        }
        for (Module m : ModuleManager.getInstance((com.intellij.openapi.project.Project)this.myProject).getModules()) {
            File home2;
            String path2;
            Sdk moduleSdk2 = ModuleRootManager.getInstance((Module)m).getSdk();
            if (moduleSdk2 == null || !(moduleSdk2.getSdkType() instanceof AndroidSdkType) || (path2 = moduleSdk2.getHomePath()) == null || !(home2 = new File(path2)).exists()) continue;
            return home2;
        }
        return IdeSdks.getInstance().getAndroidSdkPath();
    }

    @Nullable
    public PlatformLookup getPlatformLookup() {
        if (this.platformLookup == null) {
            AndroidSdkHandler handler2 = this.getSdk();
            if (handler2 != null) {
                StudioLoggerProgressIndicator logger = new StudioLoggerProgressIndicator(AndroidLintIdeClient.class);
                this.platformLookup = new SdkManagerPlatformLookup(handler2, (ProgressIndicatorAdapter)logger);
            } else {
                this.platformLookup = super.getPlatformLookup();
            }
        }
        return this.platformLookup;
    }

    @Nullable
    public Object getClientProperty(@NotNull String key) {
        if (key.equals("ideAgpVersion")) {
            return Version.ANDROID_GRADLE_PLUGIN_VERSION;
        }
        return super.getClientProperty(key);
    }

    @Nullable
    protected AndroidSdkHandler getSdk() {
        if (this.sdk == null) {
            Module module = this.getModule();
            AndroidSdkHandler localSdk = AndroidLintIdeClient.getLocalSdk(module);
            if (localSdk != null) {
                this.sdk = localSdk;
            } else {
                File sdkHome;
                for (Module m : ModuleManager.getInstance((com.intellij.openapi.project.Project)this.myProject).getModules()) {
                    localSdk = AndroidLintIdeClient.getLocalSdk(m);
                    if (localSdk == null) continue;
                    this.sdk = localSdk;
                    break;
                }
                if (localSdk == null && (sdkHome = this.getSdkHome()) != null) {
                    this.sdk = AndroidSdkHandler.getInstance((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE, (Path)sdkHome.toPath());
                }
            }
        }
        return this.sdk;
    }

    @Nullable
    private static AndroidSdkHandler getLocalSdk(@Nullable Module module) {
        AndroidSdkData sdkData;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance((Module)module)) != null && (sdkData = StudioAndroidSdkData.getSdkData(facet)) != null) {
            return sdkData.getSdkHandler();
        }
        return null;
    }

    public boolean isGradleProject(@NotNull Project project) {
        Module module = this.getModule(project);
        if (module != null) {
            AndroidFacet facet = AndroidFacet.getInstance((Module)module);
            return facet != null && AndroidModel.isRequired(facet);
        }
        return ProjectSystemUtil.requiresAndroidModel(this.myProject);
    }

    @Nullable
    public File getCacheDir(@Nullable String name2, boolean create2) {
        if ("maven.google".equals(name2)) {
            Path cacheDir = IdeGoogleMavenRepository.INSTANCE.getCacheDir();
            return cacheDir == null ? null : cacheDir.toFile();
        }
        if ("sdk_index".equals(name2)) {
            Path cacheDir = IdeGooglePlaySdkIndexKt.getCacheDir();
            return cacheDir == null ? null : cacheDir.toFile();
        }
        return super.getCacheDir(name2, create2);
    }

    @Nullable
    public File getRootDir() {
        File root;
        String pathname = ExternalSystemApiUtil.getExternalRootProjectPath((Module)this.getModule());
        if (pathname != null && (root = new File(pathname)).exists()) {
            return root;
        }
        return super.getRootDir();
    }

    @Nullable
    public Document getMergedManifest(@NotNull Project project) {
        MergedManifestSnapshot mergedManifest;
        Document document;
        Module module = this.findModuleForLintProject(this.myProject, project);
        if (module != null && (document = (mergedManifest = MergedManifestManager.getFreshSnapshot(module)).getDocument()) != null) {
            Element root = document.getDocumentElement();
            if (root != null && !this.isMergeManifestNode(root)) {
                this.resolveMergeManifestSources(document, project.getDir());
                document.setUserData(MERGED_MANIFEST_INFO, mergedManifest, null);
            }
            return document;
        }
        return null;
    }

    @Nullable
    public Pair<File, ? extends Node> findManifestSourceNode(@NotNull Node mergedNode) {
        Map sourceNodeCache = this.getSourceNodeCache();
        Pair source2 = (Pair)sourceNodeCache.get(mergedNode);
        if (source2 != null) {
            if (source2 == NOT_FOUND) {
                return null;
            }
            return source2;
        }
        Document doc = mergedNode.getOwnerDocument();
        if (doc == null) {
            return null;
        }
        MergedManifestSnapshot mergedManifest = (MergedManifestSnapshot)doc.getUserData(MERGED_MANIFEST_INFO);
        if (mergedManifest == null) {
            return null;
        }
        source2 = NOT_FOUND;
        List<? extends Actions.Record> records = ManifestUtils.getRecords(mergedManifest, mergedNode);
        for (Actions.Record record : records) {
            Node sourceNode;
            if (record.getActionType() != Actions.ActionType.ADDED && record.getActionType() != Actions.ActionType.MERGED || (sourceNode = ManifestUtils.getSourceNode(mergedManifest.getModule(), record)) == null) continue;
            File file = record.getActionLocation().getFile().getSourceFile();
            source2 = Pair.of((Object)file, (Object)sourceNode);
            break;
        }
        if (source2 == NOT_FOUND && mergedNode.getNodeType() == 1) {
            for (Actions.Record record : records) {
                File file = record.getActionLocation().getFile().getSourceFile();
                if (file == null) continue;
                try {
                    Element sourceNode;
                    Document document = this.getXmlParser().parseXml(file);
                    if (document == null || (sourceNode = Lint.matchXmlElement((Element)((Element)mergedNode), (Document)document)) == null) continue;
                    source2 = Pair.of((Object)file, (Object)sourceNode);
                    break;
                }
                catch (Throwable e) {
                    this.log(e, "Can't parse %1$s", new Object[]{file});
                }
            }
        }
        sourceNodeCache.put(mergedNode, source2);
        return source2 != NOT_FOUND ? source2 : null;
    }

    @NotNull
    public Set<Desugaring> getDesugaring(@NotNull Project project) {
        Module module = this.getModule(project);
        if (module == null) {
            return Desugaring.DEFAULT;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null) {
            return Desugaring.DEFAULT;
        }
        AndroidModel model = AndroidModel.get(module);
        if (model == null) {
            return Desugaring.DEFAULT;
        }
        return model.getDesugaring();
    }

    @NotNull
    public Iterable<File> findRuleJars(@NotNull Project project) {
        Iterable<File> lintRuleJars;
        AndroidModel model;
        Module module = this.getModule(project);
        if (module != null && (model = AndroidModel.get(module)) != null && (lintRuleJars = model.getLintRuleJarsOverride()) != null) {
            return lintRuleJars;
        }
        return super.findRuleJars(project);
    }

    @NotNull
    public List<File> getResourceFolders(@NotNull Project project) {
        Module module = this.getModule(project);
        if (module == null) {
            return super.getResourceFolders(project);
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet != null) {
            return AndroidLintIdeClient.getResourceFolders(facet);
        }
        return super.getResourceFolders(project);
    }

    @NotNull
    public static List<File> getResourceFolders(@NotNull AndroidFacet facet) {
        ArrayList<File> resDirectories = new ArrayList<File>();
        IdeaSourceProvider sourceProvider = SourceProviderManager.getInstance(facet).getSources();
        for (VirtualFile resDirectory : sourceProvider.getResDirectories()) {
            resDirectories.add(VfsUtilCore.virtualToIoFile((VirtualFile)resDirectory));
        }
        return resDirectories;
    }

    @NotNull
    public ResourceRepository getResources(@NotNull Project project, @NotNull ResourceRepositoryScope scope) {
        AndroidFacet facet;
        Module module = this.findModuleForLintProject(this.myProject, project);
        if (module != null && (facet = AndroidFacet.getInstance((Module)module)) != null) {
            if (scope == ResourceRepositoryScope.ANDROID) {
                IAndroidTarget target2 = project.getBuildTarget();
                if (target2 != null) {
                    return StudioFrameworkResourceRepositoryManager.getInstance().getFrameworkResources(target2.getPath(11), false, Collections.emptySet(), Collections.emptyList());
                }
                return super.getResources(project, scope);
            }
            if (scope.includesLibraries()) {
                return StudioResourceRepositoryManager.getAppResources(facet);
            }
            if (scope.includesDependencies()) {
                return StudioResourceRepositoryManager.getProjectResources(facet);
            }
            return StudioResourceRepositoryManager.getModuleResources(facet);
        }
        return super.getResources(project, scope);
    }

    @NotNull
    public Location.ResourceItemHandle createResourceItemHandle(@NotNull ResourceItem item, boolean nameOnly, boolean valueOnly) {
        Supplier<Location> defaultHandleProvider = () -> AndroidLintIdeClient.super.createResourceItemHandle(item, nameOnly, valueOnly).resolve();
        return new LocationHandle(item, nameOnly, valueOnly, defaultHandleProvider);
    }

    @Nullable
    public XmlPullParser createXmlPullParser(@NotNull PathString resourcePath) throws IOException {
        ProgressManager.checkCanceled();
        return FileResourceReader.createXmlPullParser(resourcePath, ResourceIdResolver.NO_RESOLUTION);
    }

    private class LocationHandle
    extends Location.ResourceItemHandle
    implements Location.Handle,
    Computable<Location> {
        private final Supplier<Location> myDefaultLocationProvider;
        private Object myClientData;

        LocationHandle(ResourceItem item, boolean nameOnly, boolean valueOnly, Supplier<Location> defaultLocationProvider) {
            super((LintClient)AndroidLintIdeClient.this, item, nameOnly, valueOnly);
            this.myDefaultLocationProvider = defaultLocationProvider;
        }

        @NotNull
        public Location resolve() {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (Location)ApplicationManager.getApplication().runReadAction((Computable)this);
            }
            ResourceItem item = this.getItem();
            XmlTag node = IdeResourcesUtil.getItemTag(AndroidLintIdeClient.this.myProject, item);
            if (node == null) {
                return this.myDefaultLocationProvider.get();
            }
            PathString source2 = item.getSource();
            assert (source2 != null) : item;
            File file = source2.toFile();
            assert (file != null) : item;
            TextRange textRange = node.getTextRange();
            if (node instanceof XmlTag) {
                XmlTag element = node;
                if (this.getNameOnly()) {
                    XmlAttribute attribute2 = element.getAttribute("name");
                    if (attribute2 != null) {
                        textRange = attribute2.getValueTextRange();
                    }
                } else if (this.getValueOnly()) {
                    XmlTagValue value2 = element.getValue();
                    textRange = value2.getTextRange();
                } else {
                    String tag = element.getName();
                    int index = node.getText().indexOf(tag);
                    if (index != -1) {
                        int start2 = textRange.getStartOffset() + index;
                        textRange = new TextRange(start2, start2 + tag.length());
                    }
                }
            }
            DefaultPosition start3 = new DefaultPosition(-1, -1, textRange.getStartOffset());
            DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
            return Location.create((File)file, (Position)start3, (Position)end);
        }

        public Location compute() {
            return this.resolve();
        }

        public void setClientData(@Nullable Object clientData) {
            this.myClientData = clientData;
        }

        @Nullable
        public Object getClientData() {
            return this.myClientData;
        }
    }
}

