/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui.toolbar.actions;

import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.LayoutInspectorBundle;
import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.NotificationModel;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.ui.LayoutInspectorRootPanel;
import com.android.tools.idea.layoutinspector.ui.RenderModel;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.actionSystem.ex.TooltipLinkProvider;
import com.intellij.ui.EditorNotificationPanel;
import icons.StudioIcons;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\bR$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\b\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/toolbar/actions/Toggle3dAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/ex/TooltipLinkProvider;", "Lcom/intellij/openapi/actionSystem/ex/TooltipDescriptionProvider;", "renderModelProvider", "Lkotlin/Function0;", "Lcom/android/tools/idea/layoutinspector/ui/RenderModel;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "executorFactory", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "getExecutorFactory", "()Lkotlin/jvm/functions/Function0;", "setExecutorFactory", "getCurrentTimeMillis", "", "getGetCurrentTimeMillis", "setGetCurrentTimeMillis", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "getTooltipLink", "Lcom/intellij/openapi/actionSystem/ex/TooltipLinkProvider$TooltipLink;", "owner", "Ljavax/swing/JComponent;", "intellij.android.layout-inspector"})
public final class Toggle3dAction
extends AnAction
implements TooltipLinkProvider,
TooltipDescriptionProvider {
    @NotNull
    private final Function0<RenderModel> renderModelProvider;
    @VisibleForTesting
    @NotNull
    private Function0<? extends ScheduledExecutorService> executorFactory;
    @VisibleForTesting
    @NotNull
    private Function0<Long> getCurrentTimeMillis;

    public Toggle3dAction(@NotNull Function0<RenderModel> renderModelProvider) {
        Intrinsics.checkNotNullParameter(renderModelProvider, (String)"renderModelProvider");
        super(StudioIcons.LayoutInspector.Toolbar.MODE_3D);
        this.renderModelProvider = renderModelProvider;
        this.executorFactory = Toggle3dAction::executorFactory$lambda$0;
        this.getCurrentTimeMillis = Toggle3dAction::getCurrentTimeMillis$lambda$0;
    }

    @NotNull
    public final Function0<ScheduledExecutorService> getExecutorFactory() {
        return this.executorFactory;
    }

    public final void setExecutorFactory(@NotNull Function0<? extends ScheduledExecutorService> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.executorFactory = function0;
    }

    @NotNull
    public final Function0<Long> getGetCurrentTimeMillis() {
        return this.getCurrentTimeMillis;
    }

    public final void setGetCurrentTimeMillis(@NotNull Function0<Long> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.getCurrentTimeMillis = function0;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        InspectorClient client;
        LayoutInspector inspector;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RenderModel renderModel = (RenderModel)this.renderModelProvider.invoke();
        LayoutInspector layoutInspector = inspector = LayoutInspectorRootPanel.Companion.get(event);
        InspectorClient inspectorClient = client = layoutInspector != null ? layoutInspector.getCurrentClient() : null;
        if (renderModel.isRotated()) {
            Object object = inspector;
            if (object != null && (object = ((LayoutInspector)object).getNotificationModel()) != null) {
                ((NotificationModel)object).removeNotification("3d.mode.deprecation.warning");
            }
            renderModel.resetRotation();
        } else {
            NotificationModel notificationModel;
            if (inspector != null && (notificationModel = inspector.getNotificationModel()) != null) {
                NotificationModel.addNotification$default(notificationModel, "3d.mode.deprecation.warning", LayoutInspectorBundle.INSTANCE.message("3d.mode.deprecation.warning", new String[0]), EditorNotificationPanel.Status.Warning, null, false, 24, null);
            }
            InspectorClient inspectorClient2 = client;
            if (inspectorClient2 != null) {
                inspectorClient2.updateScreenshotType(AndroidWindow.ImageType.SKP, -1.0f);
            }
            long timerStart = ((Number)this.getCurrentTimeMillis.invoke()).longValue();
            ScheduledExecutorService executor = (ScheduledExecutorService)this.executorFactory.invoke();
            Ref.IntRef iteration = new Ref.IntRef();
            executor.scheduleAtFixedRate(() -> Toggle3dAction.actionPerformed$lambda$0(this, timerStart, executor, inspector, iteration, renderModel), 0L, 15L, TimeUnit.MILLISECONDS);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void update(@NotNull AnActionEvent event) {
        InspectorClient client;
        RenderModel model;
        block4: {
            block5: {
                LayoutInspector inspector;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                super.update(event);
                model = (RenderModel)this.renderModelProvider.invoke();
                LayoutInspector layoutInspector = inspector = LayoutInspectorRootPanel.Companion.get(event);
                client = layoutInspector != null ? layoutInspector.getCurrentClient() : null;
                LayoutInspector layoutInspector2 = inspector;
                InspectorModel inspectorModel = layoutInspector2 != null ? layoutInspector2.getInspectorModel() : null;
                event.getPresentation().setIcon(model.isRotated() ? StudioIcons.LayoutInspector.Toolbar.RESET_VIEW : StudioIcons.LayoutInspector.Toolbar.MODE_3D);
                if (model.getOverlayImage() != null) break block4;
                Object object = client;
                boolean bl = object != null && (object = object.getCapabilities()) != null ? object.contains((Object)InspectorClient.Capability.SUPPORTS_SKP) : false;
                if (!bl) break block4;
                if (client.getInLiveMode()) break block5;
                InspectorModel inspectorModel2 = inspectorModel;
                if ((inspectorModel2 != null ? inspectorModel2.getPictureType() : null) != AndroidWindow.ImageType.SKP) break block4;
            }
            event.getPresentation().setEnabled(true);
            if (model.isRotated()) {
                event.getPresentation().setText("2D Mode");
                event.getPresentation().setDescription("Inspect the layout in 2D mode. Enabling this mode has less impact on your device's runtime performance.");
                return;
            }
            event.getPresentation().setText("3D Mode");
            event.getPresentation().setDescription("Visually inspect the hierarchy by clicking and dragging to rotate the layout. Enabling this mode consumes more device resources and might impact runtime performance.");
            return;
        }
        event.getPresentation().setEnabled(false);
        boolean isLowerThenApi29 = client != null && client.isConnected() && client.getProcess().getDevice().getApiLevel().getMajorVersion() < 29;
        event.getPresentation().setText(model.getOverlayImage() != null ? "Rotation not available when overlay is active" : (isLowerThenApi29 ? "Rotation not available for devices below API 29" : "Error while rendering device image, rotation not available"));
    }

    @NotNull
    public TooltipLinkProvider.TooltipLink getTooltipLink(@Nullable JComponent owner) {
        return new TooltipLinkProvider.TooltipLink("Learn More", Toggle3dAction::getTooltipLink$lambda$0);
    }

    private static final ScheduledExecutorService executorFactory$lambda$0() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    private static final long getCurrentTimeMillis$lambda$0() {
        return System.currentTimeMillis();
    }

    private static final void actionPerformed$lambda$0(Toggle3dAction this$0, long $timerStart, ScheduledExecutorService $executor, LayoutInspector $inspector, Ref.IntRef $iteration, RenderModel $renderModel) {
        InspectorModel inspectorModel;
        long currentTime = ((Number)this$0.getCurrentTimeMillis.invoke()).longValue();
        if (currentTime - $timerStart > 10000L) {
            $executor.shutdown();
            return;
        }
        LayoutInspector layoutInspector = $inspector;
        InspectorModel inspectorModel2 = inspectorModel = layoutInspector != null ? layoutInspector.getInspectorModel() : null;
        if ((inspectorModel2 != null ? inspectorModel2.getPictureType() : null) != AndroidWindow.ImageType.SKP) {
            return;
        }
        int n = $iteration.element;
        $iteration.element = n + 1;
        if ((long)$iteration.element > 20L) {
            $executor.shutdown();
            return;
        }
        $renderModel.setXOff((double)$iteration.element * 0.45 / (double)20L);
        $renderModel.setYOff((double)$iteration.element * 0.06 / (double)20L);
        $renderModel.refresh();
    }

    private static final void getTooltipLink$lambda$0() {
        BrowserUtil.browse((String)"https://d.android.com/r/studio-ui/layout-inspector-2D-3D-mode");
    }
}

