/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.adtui.Zoomable;
import com.android.tools.adtui.ZoomableKt;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.layoutinspector.ui.CenteredViewportLayout;
import com.android.tools.idea.layoutinspector.ui.toolbar.NewFloatingToolbarProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001*B9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001fH\u0016J\b\u0010#\u001a\u00020\u001fH\u0016J\b\u0010$\u001a\u00020\u001fH\u0016J\b\u0010%\u001a\u00020\u001fH\u0016J\b\u0010&\u001a\u00020\nH\u0002J\u0010\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020)H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/ZoomableContainer;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/android/tools/adtui/Zoomable;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "disposable", "Lcom/intellij/openapi/Disposable;", "contentPanel", "Ljavax/swing/JPanel;", "getZoomPercent", "Lkotlin/Function0;", "", "setZoomPercent", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/openapi/Disposable;Ljavax/swing/JPanel;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "scale", "", "getScale", "()D", "screenScalingFactor", "getScreenScalingFactor", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "layeredPane", "Ljavax/swing/JLayeredPane;", "floatingToolbarProvider", "Lcom/android/tools/idea/layoutinspector/ui/toolbar/NewFloatingToolbarProvider;", "viewportLayoutManager", "Lcom/android/tools/idea/layoutinspector/ui/CenteredViewportLayout;", "zoom", "", "type", "Lcom/android/tools/adtui/actions/ZoomType;", "canZoomIn", "canZoomOut", "canZoomToFit", "canZoomToActual", "getZoomToFit", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "LayeredPaneLayout", "intellij.android.layout-inspector"})
public final class ZoomableContainer
extends BorderLayoutPanel
implements Zoomable,
UiDataProvider {
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final JPanel contentPanel;
    @NotNull
    private final Function0<Integer> getZoomPercent;
    @NotNull
    private final Function1<Integer, Unit> setZoomPercent;
    private final double screenScalingFactor;
    @NotNull
    private final JBScrollPane scrollPane;
    @NotNull
    private final JLayeredPane layeredPane;
    @NotNull
    private final NewFloatingToolbarProvider floatingToolbarProvider;
    @NotNull
    private final CenteredViewportLayout viewportLayoutManager;

    public ZoomableContainer(@NotNull Disposable disposable, @NotNull JPanel contentPanel, @NotNull Function0<Integer> getZoomPercent, @NotNull Function1<? super Integer, Unit> setZoomPercent) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)contentPanel, (String)"contentPanel");
        Intrinsics.checkNotNullParameter(getZoomPercent, (String)"getZoomPercent");
        Intrinsics.checkNotNullParameter(setZoomPercent, (String)"setZoomPercent");
        this.disposable = disposable;
        this.contentPanel = contentPanel;
        this.getZoomPercent = getZoomPercent;
        this.setZoomPercent = setZoomPercent;
        this.screenScalingFactor = 1.0;
        this.scrollPane = new JBScrollPane((Component)this.contentPanel);
        this.layeredPane = new JLayeredPane();
        Disposable disposable2 = this.disposable;
        this.floatingToolbarProvider = new NewFloatingToolbarProvider((JComponent)((Object)this), disposable2);
        JViewport jViewport = this.scrollPane.getViewport();
        Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"getViewport(...)");
        this.viewportLayoutManager = new CenteredViewportLayout(jViewport);
        this.scrollPane.setBorder((Border)JBUI.Borders.empty());
        this.scrollPane.getViewport().setLayout(this.viewportLayoutManager);
        this.contentPanel.setBorder(JBUI.Borders.empty((int)50));
        Component component = (Component)this.scrollPane;
        Integer n = JLayeredPane.DEFAULT_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"DEFAULT_LAYER");
        this.layeredPane.setLayer(component, ((Number)n).intValue());
        Component component2 = this.floatingToolbarProvider.getFloatingToolbar();
        Integer n2 = JLayeredPane.PALETTE_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"PALETTE_LAYER");
        this.layeredPane.setLayer(component2, ((Number)n2).intValue());
        this.layeredPane.setLayout(new LayeredPaneLayout());
        this.layeredPane.add(this.floatingToolbarProvider.getFloatingToolbar());
        this.layeredPane.add((Component)this.scrollPane, "Center");
        this.addToCenter(this.layeredPane);
    }

    public double getScale() {
        return ((Number)this.getZoomPercent.invoke()).doubleValue() / 100.0;
    }

    public double getScreenScalingFactor() {
        return this.screenScalingFactor;
    }

    public boolean zoom(@NotNull ZoomType type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        int oldZoom = ((Number)this.getZoomPercent.invoke()).intValue();
        int newZoomRaw = switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> {
                this.viewportLayoutManager.setForceCenterOnNextLayout(true);
                yield this.getZoomToFit();
            }
            case 2 -> 100;
            case 3 -> oldZoom + 10;
            case 4 -> oldZoom - 10;
            default -> throw new NoWhenBranchMatchedException();
        };
        int newZoom = RangesKt.coerceIn((int)newZoomRaw, (int)10, (int)100);
        if (newZoom != oldZoom) {
            this.floatingToolbarProvider.zoomChanged();
            this.setZoomPercent.invoke((Object)newZoom);
            this.contentPanel.revalidate();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean canZoomIn() {
        return ((Number)this.getZoomPercent.invoke()).intValue() < 100;
    }

    public boolean canZoomOut() {
        return ((Number)this.getZoomPercent.invoke()).intValue() > 10;
    }

    public boolean canZoomToFit() {
        return ((Number)this.getZoomPercent.invoke()).intValue() != this.getZoomToFit();
    }

    public boolean canZoomToActual() {
        return ((Number)this.getZoomPercent.invoke()).intValue() != 100;
    }

    private final int getZoomToFit() {
        JViewport viewport = this.scrollPane.getViewport();
        int horizontalMargin = JBUI.scale((int)50) * 2;
        int verticalMargin = JBUI.scale((int)50) * 2;
        int availableWidth = viewport.getWidth() - horizontalMargin;
        int availableHeight = viewport.getHeight() - verticalMargin;
        if (availableWidth <= 0 || availableHeight <= 0) {
            return 100;
        }
        Dimension currentPreferredSize = this.contentPanel.getPreferredSize();
        int currentScaledWidth = currentPreferredSize.width - horizontalMargin;
        int currentScaledHeight = currentPreferredSize.height - verticalMargin;
        if (currentScaledWidth <= 0 || currentScaledHeight <= 0) {
            return 100;
        }
        double unscaledWidth = (double)currentScaledWidth / this.getScale();
        double unscaledHeight = (double)currentScaledHeight / this.getScale();
        double scaleX = (double)availableWidth / unscaledWidth;
        double scaleY = (double)availableHeight / unscaledHeight;
        double fitScale = Math.min(scaleX, scaleY);
        int rawZoom = (int)(fitScale * (double)100);
        return (rawZoom + 5) / 10 * 10;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(ZoomableKt.ZOOMABLE_KEY, (Object)this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0002\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/ZoomableContainer$LayeredPaneLayout;", "Ljava/awt/BorderLayout;", "<init>", "(Lcom/android/tools/idea/layoutinspector/ui/ZoomableContainer;)V", "layoutContainer", "", "target", "Ljava/awt/Container;", "positionToolbar", "intellij.android.layout-inspector"})
    private final class LayeredPaneLayout
    extends BorderLayout {
        @Override
        public void layoutContainer(@Nullable Container target2) {
            super.layoutContainer(target2);
            ZoomableContainer.this.scrollPane.setSize(ZoomableContainer.this.layeredPane.getSize());
            this.positionToolbar();
        }

        private final void positionToolbar() {
            JComponent floatingToolbar = ZoomableContainer.this.floatingToolbarProvider.getFloatingToolbar();
            floatingToolbar.setSize(floatingToolbar.getPreferredSize());
            int x = ZoomableContainer.this.layeredPane.getWidth() - floatingToolbar.getWidth() - JBUI.scale((int)14);
            int y = ZoomableContainer.this.layeredPane.getHeight() - floatingToolbar.getHeight() - JBUI.scale((int)14);
            floatingToolbar.setLocation(new Point(x, y));
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ZoomType.values().length];
            try {
                nArray[ZoomType.FIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomType.ACTUAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomType.IN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomType.OUT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

