/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.adtui.stdui.KeyBindingKt;
import com.android.tools.adtui.stdui.KeyStrokes;
import com.android.tools.idea.layoutinspector.model.ResolutionStackModel;
import com.android.tools.idea.layoutinspector.properties.InspectorGroupPropertyItem;
import com.android.tools.idea.layoutinspector.properties.InspectorPropertyItem;
import com.android.tools.idea.layoutinspector.properties.ResolutionStackItem;
import com.android.tools.idea.layoutinspector.resource.SourceLocation;
import com.android.tools.idea.layoutinspector.ui.ResolutionElementEditor;
import com.android.tools.property.panel.api.PropertyEditorModel;
import com.android.tools.property.panel.api.PropertyItem;
import com.android.tools.property.panel.api.TableSupport;
import com.android.tools.property.ptable.PTableGroupItem;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0003\u000f\u0010\u0011B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/ResolutionElementEditor;", "Ljavax/swing/JPanel;", "model", "Lcom/android/tools/idea/layoutinspector/model/ResolutionStackModel;", "editorModel", "Lcom/android/tools/property/panel/api/PropertyEditorModel;", "editor", "Ljavax/swing/JComponent;", "<init>", "(Lcom/android/tools/idea/layoutinspector/model/ResolutionStackModel;Lcom/android/tools/property/panel/api/PropertyEditorModel;Ljavax/swing/JComponent;)V", "getEditorModel", "()Lcom/android/tools/property/panel/api/PropertyEditorModel;", "linkPanel", "updateFromModel", "", "ExpansionPanel", "Companion", "SourceLocationLink", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nResolutionElementEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionElementEditor.kt\ncom/android/tools/idea/layoutinspector/ui/ResolutionElementEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,275:1\n1#2:276\n*E\n"})
public final class ResolutionElementEditor
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResolutionStackModel model;
    @NotNull
    private final PropertyEditorModel editorModel;
    @NotNull
    private final JPanel linkPanel;

    public ResolutionElementEditor(@NotNull ResolutionStackModel model, @NotNull PropertyEditorModel editorModel, @NotNull JComponent editor) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(new BorderLayout());
        this.model = model;
        this.editorModel = editorModel;
        this.linkPanel = new JPanel();
        this.setOpaque(false);
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.add((Component)editor, "Center");
        this.add((Component)this.linkPanel, "South");
        this.linkPanel.setLayout(new BoxLayout(this.linkPanel, 1));
        this.linkPanel.setVisible(false);
        this.linkPanel.setOpaque(false);
        this.linkPanel.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.editorModel.addListener(() -> ResolutionElementEditor._init_$lambda$0(this));
        editor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!event.isConsumed() && event.getClickCount() > 1) {
                    TableSupport tableSupport = this.getEditorModel().getTableSupport();
                    if (tableSupport != null) {
                        tableSupport.toggleGroup();
                    }
                    event.consume();
                }
            }
        });
        this.updateFromModel();
    }

    @VisibleForTesting
    @NotNull
    public final PropertyEditorModel getEditorModel() {
        return this.editorModel;
    }

    private final void updateFromModel() {
        PropertyItem propertyItem = this.editorModel.getProperty();
        Intrinsics.checkNotNull((Object)propertyItem, (String)"null cannot be cast to non-null type com.android.tools.idea.layoutinspector.properties.InspectorPropertyItem");
        InspectorPropertyItem property2 = (InspectorPropertyItem)propertyItem;
        List<SourceLocation> locations = property2.getSourceLocations();
        InspectorGroupPropertyItem inspectorGroupPropertyItem = property2 instanceof InspectorGroupPropertyItem ? (InspectorGroupPropertyItem)property2 : null;
        SourceLocation classLocation = inspectorGroupPropertyItem != null ? inspectorGroupPropertyItem.getClassLocation() : null;
        boolean hideLinkPanel = locations.isEmpty() && classLocation == null || property2 instanceof PTableGroupItem && !this.editorModel.isExpandedTableItem();
        boolean isSelected = this.editorModel.isUsedInRendererWithSelection();
        this.linkPanel.setVisible(!hideLinkPanel);
        this.editorModel.setCustomHeight(!hideLinkPanel);
        this.setOpaque(isSelected);
        this.setBackground(isSelected ? UIUtil.getTableBackground((boolean)true, (boolean)true) : UIUtil.TRANSPARENT_COLOR);
        if (!hideLinkPanel) {
            this.linkPanel.removeAll();
            boolean isOverridden = property2 instanceof ResolutionStackItem;
            SourceLocation sourceLocation = classLocation;
            if (sourceLocation != null) {
                SourceLocation it = sourceLocation;
                boolean bl = false;
                this.linkPanel.add((Component)((Object)new SourceLocationLink(it, isSelected, false)));
            }
            switch (locations.size()) {
                case 0: {
                    Object object = Unit.INSTANCE;
                    break;
                }
                case 1: {
                    Object object = this.linkPanel.add((Component)((Object)new SourceLocationLink((SourceLocation)CollectionsKt.first(locations), isSelected, isOverridden)));
                    break;
                }
                default: {
                    Object object = this.linkPanel.add(new ExpansionPanel(this.model, this.editorModel, property2, locations, isSelected, isOverridden));
                }
            }
        }
    }

    private static final void _init_$lambda$0(ResolutionElementEditor this$0) {
        this$0.updateFromModel();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/ResolutionElementEditor$Companion;", "", "<init>", "()V", "hasLinkPanel", "", "property", "Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;", "intellij.android.layout-inspector"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean hasLinkPanel(@NotNull InspectorPropertyItem property2) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            if (property2 instanceof PTableGroupItem) {
                return true;
            }
            return !((Collection)property2.getSourceLocations()).isEmpty();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000=\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003*\u0001\u0012\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/ResolutionElementEditor$ExpansionPanel;", "Ljavax/swing/JPanel;", "model", "Lcom/android/tools/idea/layoutinspector/model/ResolutionStackModel;", "editorModel", "Lcom/android/tools/property/panel/api/PropertyEditorModel;", "property", "Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;", "locations", "", "Lcom/android/tools/idea/layoutinspector/resource/SourceLocation;", "isSelected", "", "isOverridden", "<init>", "(Lcom/android/tools/idea/layoutinspector/model/ResolutionStackModel;Lcom/android/tools/property/panel/api/PropertyEditorModel;Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;Ljava/util/List;ZZ)V", "extraPanel", "expandLabel", "com/android/tools/idea/layoutinspector/ui/ResolutionElementEditor$ExpansionPanel$expandLabel$1", "Lcom/android/tools/idea/layoutinspector/ui/ResolutionElementEditor$ExpansionPanel$expandLabel$1;", "toggle", "", "open", "close", "intellij.android.layout-inspector"})
    private static final class ExpansionPanel
    extends JPanel {
        @NotNull
        private final ResolutionStackModel model;
        @NotNull
        private final PropertyEditorModel editorModel;
        @NotNull
        private final InspectorPropertyItem property;
        private final boolean isSelected;
        @NotNull
        private final JPanel extraPanel;
        @NotNull
        private final expandLabel.1 expandLabel;

        public ExpansionPanel(@NotNull ResolutionStackModel model, @NotNull PropertyEditorModel editorModel, @NotNull InspectorPropertyItem property2, @NotNull List<SourceLocation> locations, boolean isSelected, boolean isOverridden) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            Intrinsics.checkNotNullParameter(locations, (String)"locations");
            super(new BorderLayout());
            this.model = model;
            this.editorModel = editorModel;
            this.property = property2;
            this.isSelected = isSelected;
            this.extraPanel = new JPanel();
            this.expandLabel = new JBLabel(){

                protected void paintComponent(Graphics g) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    super.paintComponent(g);
                    if (this.hasFocus() && g instanceof Graphics2D) {
                        DarculaUIUtil.paintFocusBorder((Graphics2D)((Graphics2D)g), (int)this.getWidth(), (int)this.getHeight(), (float)0.0f, (boolean)true);
                    }
                }
            };
            JPanel mainPanel2 = new JPanel();
            mainPanel2.setLayout(new BoxLayout(mainPanel2, 0));
            mainPanel2.setOpaque(false);
            mainPanel2.setBackground(UIUtil.TRANSPARENT_COLOR);
            mainPanel2.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
            boolean isExtraPanelVisible = this.model.isExpanded(this.property);
            this.extraPanel.setLayout(new BoxLayout(this.extraPanel, 1));
            this.extraPanel.setOpaque(false);
            this.extraPanel.setBackground(UIUtil.TRANSPARENT_COLOR);
            this.extraPanel.setVisible(isExtraPanelVisible);
            this.extraPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)24));
            this.expandLabel.setIcon(UIUtil.getTreeNodeIcon((boolean)isExtraPanelVisible, (boolean)this.isSelected, (boolean)this.isSelected));
            KeyBindingKt.registerActionKey$default((JComponent)((JComponent)((Object)this.expandLabel)), () -> ExpansionPanel._init_$lambda$0(this), (KeyStroke)KeyStrokes.INSTANCE.getSPACE(), (String)"space", null, (int)0, (int)24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((JComponent)((Object)this.expandLabel)), () -> ExpansionPanel._init_$lambda$1(this), (KeyStroke)KeyStrokes.INSTANCE.getENTER(), (String)"enter", null, (int)0, (int)24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((JComponent)((Object)this.expandLabel)), () -> ExpansionPanel._init_$lambda$2(this), (KeyStroke)KeyStrokes.INSTANCE.getRIGHT(), (String)"open", null, (int)0, (int)24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((JComponent)((Object)this.expandLabel)), () -> ExpansionPanel._init_$lambda$3(this), (KeyStroke)KeyStrokes.INSTANCE.getNUM_RIGHT(), (String)"open", null, (int)0, (int)24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((JComponent)((Object)this.expandLabel)), () -> ExpansionPanel._init_$lambda$4(this), (KeyStroke)KeyStrokes.INSTANCE.getLEFT(), (String)"close", null, (int)0, (int)24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((JComponent)((Object)this.expandLabel)), () -> ExpansionPanel._init_$lambda$5(this), (KeyStroke)KeyStrokes.INSTANCE.getNUM_LEFT(), (String)"close", null, (int)0, (int)24, null);
            this.expandLabel.setBorder(JBUI.Borders.empty((int)2));
            this.expandLabel.setFocusable(true);
            this.expandLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.toggle();
                }
            });
            SourceLocation mainLocation = (SourceLocation)CollectionsKt.first(locations);
            mainPanel2.add((Component)((Object)this.expandLabel));
            mainPanel2.add((Component)((Object)new SourceLocationLink(mainLocation, this.isSelected, isOverridden)));
            int n = locations.size();
            for (int index = 1; index < n; ++index) {
                this.extraPanel.add((Component)((Object)new SourceLocationLink(locations.get(index), this.isSelected, isOverridden)));
            }
            this.add((Component)mainPanel2, "Center");
            this.add((Component)this.extraPanel, "South");
            this.setOpaque(false);
            this.setBackground(UIUtil.TRANSPARENT_COLOR);
            this.setAlignmentX(0.0f);
        }

        private final void toggle() {
            block0: {
                this.model.toggle(this.property);
                boolean isExpanded = this.model.isExpanded(this.property);
                this.expandLabel.setIcon(UIUtil.getTreeNodeIcon((boolean)isExpanded, (boolean)this.isSelected, (boolean)this.isSelected));
                this.extraPanel.setVisible(isExpanded);
                TableSupport tableSupport = this.editorModel.getTableSupport();
                if (tableSupport == null) break block0;
                tableSupport.updateRowHeight(true);
            }
        }

        private final void open() {
            if (!this.model.isExpanded(this.property)) {
                this.toggle();
            }
        }

        private final void close() {
            if (this.model.isExpanded(this.property)) {
                this.toggle();
            }
        }

        private static final Unit _init_$lambda$0(ExpansionPanel this$0) {
            this$0.toggle();
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$1(ExpansionPanel this$0) {
            this$0.toggle();
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$2(ExpansionPanel this$0) {
            this$0.open();
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$3(ExpansionPanel this$0) {
            this$0.open();
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$4(ExpansionPanel this$0) {
            this$0.close();
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$5(ExpansionPanel this$0) {
            this$0.close();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/ResolutionElementEditor$SourceLocationLink;", "Lcom/intellij/ui/components/JBLabel;", "location", "Lcom/android/tools/idea/layoutinspector/resource/SourceLocation;", "isSelected", "", "isOverridden", "<init>", "(Lcom/android/tools/idea/layoutinspector/resource/SourceLocation;ZZ)V", "activateLink", "", "paintComponent", "g", "Ljava/awt/Graphics;", "getSmallFont", "Ljava/awt/Font;", "showAsLink", "strikeout", "intellij.android.layout-inspector"})
    private static final class SourceLocationLink
    extends JBLabel {
        @NotNull
        private final SourceLocation location;

        public SourceLocationLink(@NotNull SourceLocation location, boolean isSelected, boolean isOverridden) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            this.location = location;
            boolean showAsLink = this.location.getNavigatable() != null;
            Color color = isSelected ? UIUtil.getTableForeground((boolean)true, (boolean)true) : (showAsLink ? JBUI.CurrentTheme.Link.Foreground.ENABLED : UIUtil.getTableForeground((boolean)false, (boolean)false));
            Intrinsics.checkNotNull((Object)color);
            Color normalForegroundColor = color;
            this.setText(this.location.getSource());
            this.setFont(this.getSmallFont(showAsLink, isOverridden));
            this.setForeground(normalForegroundColor);
            this.setFocusable(true);
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)2, (int)2, (int)2));
            this.setAlignmentX(0.0f);
            this.setCursor(Cursor.getPredefinedCursor(12));
            KeyBindingKt.registerActionKey$default((JComponent)((JComponent)((Object)this)), () -> SourceLocationLink._init_$lambda$0(this), (KeyStroke)KeyStrokes.INSTANCE.getSPACE(), (String)"space", null, (int)0, (int)24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((JComponent)((Object)this)), () -> SourceLocationLink._init_$lambda$1(this), (KeyStroke)KeyStrokes.INSTANCE.getENTER(), (String)"enter", null, (int)0, (int)24, null);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.activateLink();
                }
            });
        }

        private final void activateLink() {
            block0: {
                Navigatable navigatable2 = this.location.getNavigatable();
                if (navigatable2 == null) break block0;
                navigatable2.navigate(true);
            }
        }

        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paintComponent(g);
            if (this.hasFocus() && g instanceof Graphics2D) {
                DarculaUIUtil.paintFocusBorder((Graphics2D)((Graphics2D)g), (int)this.getWidth(), (int)this.getHeight(), (float)0.0f, (boolean)true);
            }
        }

        private final Font getSmallFont(boolean showAsLink, boolean strikeout) {
            Font font = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getLabelFont(...)");
            Font font2 = font;
            Map<TextAttribute, ?> map2 = font2.getAttributes();
            Intrinsics.checkNotNull(map2, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<java.awt.font.TextAttribute, kotlin.Any?>");
            Map attributes = TypeIntrinsics.asMutableMap(map2);
            if (showAsLink) {
                attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (strikeout) {
                attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            Font font3 = font2.deriveFont(attributes);
            Intrinsics.checkNotNullExpressionValue((Object)font3, (String)"deriveFont(...)");
            return font3;
        }

        private static final Unit _init_$lambda$0(SourceLocationLink this$0) {
            this$0.activateLink();
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$1(SourceLocationLink this$0) {
            this$0.activateLink();
            return Unit.INSTANCE;
        }
    }
}

