/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.idea.appinspection.api.process.ProcessesModel;
import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/LayoutInspectorLoadingObserver;", "Lcom/intellij/openapi/Disposable;", "parentDisposable", "layoutInspector", "Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/layoutinspector/LayoutInspector;)V", "listeners", "Lcom/android/tools/idea/util/ListenerCollection;", "Lcom/android/tools/idea/layoutinspector/ui/LayoutInspectorLoadingObserver$Listener;", "getListeners", "()Lcom/android/tools/idea/util/ListenerCollection;", "setListeners", "(Lcom/android/tools/idea/util/ListenerCollection;)V", "isLoading", "", "()Z", "_isLoading", "Ljava/util/concurrent/atomic/AtomicBoolean;", "stopInspectorListener", "Lkotlin/Function0;", "", "selectedProcessListener", "inspectorModelModificationListener", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel$ModificationListener;", "dispose", "setIsLoading", "Listener", "intellij.android.layout-inspector"})
public final class LayoutInspectorLoadingObserver
implements Disposable {
    @NotNull
    private final LayoutInspector layoutInspector;
    @NotNull
    private ListenerCollection<Listener> listeners;
    @NotNull
    private final AtomicBoolean _isLoading;
    @NotNull
    private final Function0<Unit> stopInspectorListener;
    @NotNull
    private final Function0<Unit> selectedProcessListener;
    @NotNull
    private final InspectorModel.ModificationListener inspectorModelModificationListener;

    public LayoutInspectorLoadingObserver(@NotNull Disposable parentDisposable, @NotNull LayoutInspector layoutInspector) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)layoutInspector, (String)"layoutInspector");
        this.layoutInspector = layoutInspector;
        this.listeners = ListenerCollection.Companion.createWithDirectExecutor();
        this._isLoading = new AtomicBoolean(false);
        this.stopInspectorListener = () -> LayoutInspectorLoadingObserver.stopInspectorListener$lambda$0(this);
        this.selectedProcessListener = () -> LayoutInspectorLoadingObserver.selectedProcessListener$lambda$0(this);
        this.inspectorModelModificationListener = (arg_0, arg_1, arg_2) -> LayoutInspectorLoadingObserver.inspectorModelModificationListener$lambda$0(this, arg_0, arg_1, arg_2);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.layoutInspector.getStopInspectorListeners().add(this.stopInspectorListener);
        ProcessesModel processesModel = this.layoutInspector.getProcessModel();
        if (processesModel != null) {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
            processesModel.addSelectedProcessListeners(executorService, this.selectedProcessListener);
        }
        this.layoutInspector.getInspectorModel().addModificationListener(this.inspectorModelModificationListener);
    }

    @NotNull
    public final ListenerCollection<Listener> getListeners() {
        return this.listeners;
    }

    public final void setListeners(@NotNull ListenerCollection<Listener> listenerCollection) {
        Intrinsics.checkNotNullParameter(listenerCollection, (String)"<set-?>");
        this.listeners = listenerCollection;
    }

    public final boolean isLoading() {
        return this._isLoading.get();
    }

    public void dispose() {
        this.listeners.clear();
        this.layoutInspector.getStopInspectorListeners().remove(this.stopInspectorListener);
        ProcessesModel processesModel = this.layoutInspector.getProcessModel();
        if (processesModel != null) {
            processesModel.removeSelectedProcessListener(this.selectedProcessListener);
        }
        this.layoutInspector.getInspectorModel().removeModificationListener(this.inspectorModelModificationListener);
    }

    private final void setIsLoading(boolean isLoading) {
        this._isLoading.set(isLoading);
        ListenableFuture listenableFuture = isLoading ? this.listeners.forEach(LayoutInspectorLoadingObserver::setIsLoading$lambda$0) : this.listeners.forEach(LayoutInspectorLoadingObserver::setIsLoading$lambda$1);
    }

    private static final Unit stopInspectorListener$lambda$0(LayoutInspectorLoadingObserver this$0) {
        this$0.setIsLoading(false);
        return Unit.INSTANCE;
    }

    private static final Unit selectedProcessListener$lambda$0(LayoutInspectorLoadingObserver this$0) {
        Object object = this$0.layoutInspector.getProcessModel();
        boolean bl = object != null && (object = ((ProcessesModel)object).getSelectedProcess()) != null ? object.isRunning() : false;
        if (bl) {
            this$0.setIsLoading(true);
        }
        ProcessesModel processesModel = this$0.layoutInspector.getProcessModel();
        if ((processesModel != null ? processesModel.getSelectedProcess() : null) == null) {
            this$0.setIsLoading(false);
        }
        return Unit.INSTANCE;
    }

    private static final void inspectorModelModificationListener$lambda$0(LayoutInspectorLoadingObserver this$0, AndroidWindow androidWindow, AndroidWindow androidWindow2, boolean bl) {
        this$0.setIsLoading(false);
    }

    private static final void setIsLoading$lambda$0(Listener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.onStartLoading();
    }

    private static final void setIsLoading$lambda$1(Listener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.onStopLoading();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/LayoutInspectorLoadingObserver$Listener;", "", "onStartLoading", "", "onStopLoading", "intellij.android.layout-inspector"})
    public static interface Listener {
        public void onStartLoading();

        public void onStopLoading();
    }
}

