/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.idea.layoutinspector.model.NotificationListener;
import com.android.tools.idea.layoutinspector.model.NotificationModel;
import com.android.tools.idea.layoutinspector.model.StatusNotification;
import com.android.tools.idea.layoutinspector.model.StatusNotificationAction;
import com.android.tools.idea.layoutinspector.ui.InspectorBanner;
import com.google.common.html.HtmlEscapers;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\t\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/InspectorBanner;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "parentDisposable", "notificationModel", "Lcom/android/tools/idea/layoutinspector/model/NotificationModel;", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/layoutinspector/model/NotificationModel;)V", "notificationListener", "com/android/tools/idea/layoutinspector/ui/InspectorBanner$notificationListener$1", "Lcom/android/tools/idea/layoutinspector/ui/InspectorBanner$notificationListener$1;", "dispose", "", "updateNotifications", "notifications", "", "Lcom/android/tools/idea/layoutinspector/model/StatusNotification;", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nInspectorBanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectorBanner.kt\ncom/android/tools/idea/layoutinspector/ui/InspectorBanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1869#2:75\n1869#2,2:76\n1870#2:78\n*S KotlinDebug\n*F\n+ 1 InspectorBanner.kt\ncom/android/tools/idea/layoutinspector/ui/InspectorBanner\n*L\n61#1:75\n64#1:76,2\n61#1:78\n*E\n"})
public final class InspectorBanner
extends JPanel
implements Disposable {
    @NotNull
    private final NotificationModel notificationModel;
    @NotNull
    private final notificationListener.1 notificationListener;

    public InspectorBanner(@NotNull Disposable parentDisposable, @NotNull NotificationModel notificationModel) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)notificationModel, (String)"notificationModel");
        this.notificationModel = notificationModel;
        this.notificationListener = new NotificationListener(this){
            final /* synthetic */ InspectorBanner this$0;
            {
                this.this$0 = $receiver;
            }

            public void notificationsChanged(List<StatusNotification> notifications) {
                Intrinsics.checkNotNullParameter(notifications, (String)"notifications");
                InspectorBanner.access$updateNotifications(this.this$0, notifications);
            }
        };
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.setVisible(false);
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.notificationModel.addNotificationListener(this.notificationListener);
    }

    public void dispose() {
        this.notificationModel.removeNotificationListener(this.notificationListener);
    }

    private final void updateNotifications(List<StatusNotification> notifications) {
        ApplicationManager.getApplication().invokeLater(() -> InspectorBanner.updateNotifications$lambda$0(this, notifications));
    }

    private static final void updateNotifications$lambda$0(InspectorBanner this$0, List $notifications) {
        this$0.removeAll();
        this$0.setVisible(!((Collection)$notifications).isEmpty());
        Iterable $this$forEach$iv = $notifications;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StatusNotification notification = (StatusNotification)element$iv;
            boolean bl = false;
            EditorNotificationPanel panel2 = new EditorNotificationPanel(notification.getStatus());
            panel2.setText("<html>" + HtmlEscapers.htmlEscaper().escape(notification.getMessage()) + "</html>");
            Iterable $this$forEach$iv2 = notification.getActions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                StatusNotificationAction action2 = (StatusNotificationAction)element$iv2;
                boolean bl2 = false;
                panel2.createActionLabel(action2.getName(), () -> InspectorBanner.updateNotifications$lambda$0$0$0$0(action2, notification));
            }
            this$0.add((Component)panel2);
        }
        this$0.revalidate();
    }

    private static final void updateNotifications$lambda$0$0$0$0(StatusNotificationAction $action, StatusNotification $notification) {
        $action.getInvoke().invoke((Object)$notification);
    }

    public static final /* synthetic */ void access$updateNotifications(InspectorBanner $this, List notifications) {
        $this.updateNotifications(notifications);
    }
}

