/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.skia;

import com.android.annotations.concurrency.Slow;
import com.android.io.CancellableFileIo;
import com.android.repository.Revision;
import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.UpdatablePackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.layoutinspector.skia.SkiaParserServerConnection;
import com.android.tools.idea.layoutinspector.skia.SkiaParserServerConnectionFactory;
import com.android.tools.idea.layoutinspector.skia.SkiaParserServerConnectionFactoryKt;
import com.android.tools.idea.layoutinspector.skia.UnsupportedPictureVersionException;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.util.StudioPathManager;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.layoutinspector.LayoutInspectorUtils;
import com.android.tools.layoutinspector.ServerVersionSpec;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\bH\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\bH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0003J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/layoutinspector/skia/SkiaParserServerConnectionFactoryImpl;", "Lcom/android/tools/idea/layoutinspector/skia/SkiaParserServerConnectionFactory;", "<init>", "()V", "devbuildServerInfo", "Lcom/android/tools/idea/layoutinspector/skia/SkiaParserServerConnectionFactoryImpl$ServerInfo;", "supportedVersionMap", "", "", "latestPackagePath", "", "mapLock", "", "VERSION_MAP_FILE_NAME", "progressIndicator", "Lcom/android/tools/idea/progress/StudioLoggerProgressIndicator;", "createConnection", "Lcom/android/tools/idea/layoutinspector/skia/SkiaParserServerConnection;", "data", "", "findServerInfoForSkpVersion", "skpVersion", "findVersionInMap", "downloadLatestVersion", "", "readVersionMapping", "", "getLatestParserPackage", "Lcom/android/repository/api/LocalPackage;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "ServerInfo", "intellij.android.layout-inspector"})
public final class SkiaParserServerConnectionFactoryImpl
implements SkiaParserServerConnectionFactory {
    @NotNull
    public static final SkiaParserServerConnectionFactoryImpl INSTANCE = new SkiaParserServerConnectionFactoryImpl();
    @NotNull
    private static final ServerInfo devbuildServerInfo = new ServerInfo(null, -1, -1);
    @Nullable
    private static Map<Integer, ServerInfo> supportedVersionMap;
    @Nullable
    private static String latestPackagePath;
    @NotNull
    private static final Object mapLock;
    @NotNull
    private static final String VERSION_MAP_FILE_NAME = "version-map.xml";
    @NotNull
    private static final StudioLoggerProgressIndicator progressIndicator;

    private SkiaParserServerConnectionFactoryImpl() {
    }

    @Override
    @NotNull
    public SkiaParserServerConnection createConnection(@NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        int skpVersion = LayoutInspectorUtils.INSTANCE.getSkpVersion(data2);
        ServerInfo serverInfo = this.findServerInfoForSkpVersion(skpVersion);
        if (serverInfo == null) {
            throw new UnsupportedPictureVersionException(skpVersion);
        }
        ServerInfo serverInfo2 = serverInfo;
        return serverInfo2.createServer();
    }

    @VisibleForTesting
    @Nullable
    public final ServerInfo findServerInfoForSkpVersion(int skpVersion) {
        ServerInfo serverInfo;
        if (((Boolean)StudioFlags.DYNAMIC_LAYOUT_INSPECTOR_USE_DEVBUILD_SKIA_SERVER.get()).booleanValue()) {
            return devbuildServerInfo;
        }
        if (supportedVersionMap == null) {
            this.readVersionMapping();
        }
        if ((serverInfo = this.findVersionInMap(skpVersion)) == null) {
            AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
            Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"tryToChooseSdkHandler(...)");
            LocalPackage latest = this.getLatestParserPackage(androidSdkHandler);
            Object object = latest;
            if (!(object != null && (object = object.getPath()) != null ? ((String)object).equals(latestPackagePath) : false)) {
                this.readVersionMapping();
                serverInfo = this.findVersionInMap(skpVersion);
            }
            if (serverInfo == null && this.downloadLatestVersion()) {
                serverInfo = this.findVersionInMap(skpVersion);
            }
        }
        return serverInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ServerInfo findVersionInMap(int skpVersion) {
        ServerInfo serverInfo;
        Object object = mapLock;
        synchronized (object) {
            ServerInfo serverInfo2;
            boolean bl = false;
            Map<Integer, ServerInfo> map2 = supportedVersionMap;
            if (map2 != null && (map2 = map2.values()) != null) {
                Object v1;
                block6: {
                    Iterable iterable = (Iterable)((Object)map2);
                    for (Object t : iterable) {
                        ServerInfo serverInfo3 = (ServerInfo)t;
                        boolean bl2 = false;
                        if (!serverInfo3.getSkpVersionRange().contains(skpVersion)) continue;
                        v1 = t;
                        break block6;
                    }
                    v1 = null;
                }
                serverInfo2 = v1;
            } else {
                serverInfo2 = null;
            }
            serverInfo = serverInfo2;
        }
        return serverInfo;
    }

    @Slow
    private final boolean downloadLatestVersion() {
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"tryToChooseSdkHandler(...)");
        AndroidSdkHandler sdkHandler = androidSdkHandler;
        RepoManager sdkManager = sdkHandler.getRepoManager((ProgressIndicator)progressIndicator);
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (ProgressIndicator)progressIndicator, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance());
        RemotePackage remotePackage = sdkHandler.getLatestRemotePackageForPrefix("skiaparser", null, true, (ProgressIndicator)progressIndicator);
        if (remotePackage == null) {
            return false;
        }
        RemotePackage latestRemote = remotePackage;
        String maybeNewPackage = latestRemote.getPath();
        UpdatablePackage updatablePackage = (UpdatablePackage)sdkManager.getPackages().getConsolidatedPkgs().get(maybeNewPackage);
        if (updatablePackage == null) {
            return false;
        }
        UpdatablePackage updatablePackage2 = updatablePackage;
        if (updatablePackage2.hasLocal() && !updatablePackage2.isUpdate()) {
            return false;
        }
        CompletableFuture installResult = new CompletableFuture();
        ApplicationManager.getApplication().invokeAndWait(() -> SkiaParserServerConnectionFactoryImpl.downloadLatestVersion$lambda$0(updatablePackage2, sdkManager, maybeNewPackage, installResult));
        return (Boolean)installResult.get() != false && supportedVersionMap != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readVersionMapping() {
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"tryToChooseSdkHandler(...)");
        AndroidSdkHandler sdkHandler = androidSdkHandler;
        LocalPackage latestPackage = this.getLatestParserPackage(sdkHandler);
        if (latestPackage != null) {
            Path mappingFile = latestPackage.getLocation().resolve(VERSION_MAP_FILE_NAME);
            try {
                Object object = mapLock;
                synchronized (object) {
                    boolean bl = false;
                    Map newMap = new LinkedHashMap();
                    Intrinsics.checkNotNull((Object)mappingFile);
                    for (ServerVersionSpec spec : LayoutInspectorUtils.INSTANCE.loadSkiaParserVersionMap(mappingFile).getServers()) {
                        Map<Integer, ServerInfo> map2 = supportedVersionMap;
                        ServerInfo existing = map2 != null ? map2.get(spec.getVersion()) : null;
                        ServerInfo serverInfo = existing;
                        boolean bl2 = serverInfo != null && (serverInfo = serverInfo.getSkpVersionRange()) != null ? serverInfo.getStart().intValue() == spec.getSkpStart() : false;
                        if (bl2) {
                            Integer n = spec.getSkpEnd();
                            if (n != null && existing.getSkpVersionRange().getLast() == n.intValue()) {
                                newMap.put(spec.getVersion(), existing);
                                continue;
                            }
                        }
                        newMap.put(spec.getVersion(), new ServerInfo(spec.getVersion(), spec.getSkpStart(), spec.getSkpEnd()));
                    }
                    supportedVersionMap = newMap;
                    latestPackagePath = latestPackage.getPath();
                    Unit unit = Unit.INSTANCE;
                }
            }
            catch (Exception e) {
                Logger.getInstance(SkiaParserServerConnectionFactory.class).warn("Failed to parse mapping file", (Throwable)e);
            }
        }
    }

    private final LocalPackage getLatestParserPackage(AndroidSdkHandler sdkHandler) {
        return sdkHandler.getLatestLocalPackageForPrefix("skiaparser", SkiaParserServerConnectionFactoryImpl::getLatestParserPackage$lambda$0, true, (ProgressIndicator)progressIndicator);
    }

    private static final void downloadLatestVersion$lambda$0(UpdatablePackage $updatablePackage, RepoManager $sdkManager, String $maybeNewPackage, CompletableFuture $installResult) {
        UpdatablePackage newPackage;
        ModelWizardDialog modelWizardDialog = SdkQuickfixUtils.createDialogForPackages(null, CollectionsKt.listOf((Object)$updatablePackage), CollectionsKt.emptyList(), false);
        if (modelWizardDialog != null) {
            modelWizardDialog.show();
        }
        if ((newPackage = (UpdatablePackage)$sdkManager.getPackages().getConsolidatedPkgs().get($maybeNewPackage)) == null || !newPackage.hasLocal() || newPackage.isUpdate()) {
            $installResult.complete(false);
        }
        INSTANCE.readVersionMapping();
        $installResult.complete(true);
    }

    private static final boolean getLatestParserPackage$lambda$0(Revision it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    static {
        mapLock = new Object();
        progressIndicator = new StudioLoggerProgressIndicator(SkiaParserServerConnection.class);
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0003R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/layoutinspector/skia/SkiaParserServerConnectionFactoryImpl$ServerInfo;", "", "serverVersion", "", "skpStart", "skpEnd", "<init>", "(Ljava/lang/Integer;ILjava/lang/Integer;)V", "getServerVersion", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "serverName", "", "skpVersionRange", "Lkotlin/ranges/IntRange;", "getSkpVersionRange", "()Lkotlin/ranges/IntRange;", "progressIndicator", "Lcom/android/tools/idea/progress/StudioLoggerProgressIndicator;", "packagePath", "findPath", "Ljava/nio/file/Path;", "createServer", "Lcom/android/tools/idea/layoutinspector/skia/SkiaParserServerConnection;", "tryDownload", "", "intellij.android.layout-inspector"})
    @SourceDebugExtension(value={"SMAP\nSkiaParserServerConnectionFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkiaParserServerConnectionFactory.kt\ncom/android/tools/idea/layoutinspector/skia/SkiaParserServerConnectionFactoryImpl$ServerInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,301:1\n1#2:302\n*E\n"})
    public static final class ServerInfo {
        @Nullable
        private final Integer serverVersion;
        @NotNull
        private final String serverName;
        @NotNull
        private final IntRange skpVersionRange;
        @NotNull
        private final StudioLoggerProgressIndicator progressIndicator;
        @NotNull
        private final String packagePath;

        public ServerInfo(@Nullable Integer serverVersion, int skpStart, @Nullable Integer skpEnd) {
            this.serverVersion = serverVersion;
            this.serverName = "skia-grpc-server" + (SystemInfo.isWindows ? ".exe" : "");
            Integer n = skpEnd;
            this.skpVersionRange = new IntRange(skpStart, n != null ? n : Integer.MAX_VALUE);
            this.progressIndicator = new StudioLoggerProgressIndicator(ServerInfo.class);
            this.packagePath = "skiaparser;" + this.serverVersion;
        }

        @Nullable
        public final Integer getServerVersion() {
            return this.serverVersion;
        }

        @NotNull
        public final IntRange getSkpVersionRange() {
            return this.skpVersionRange;
        }

        private final Path findPath() {
            Path path;
            if (this.serverVersion == null) {
                path = StudioPathManager.isRunningFromSources() ? Paths.get(StudioPathManager.getBinariesRoot(), new String[0]).resolve("tools/vendor/google/skia/" + this.serverName) : null;
            } else {
                AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
                Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"tryToChooseSdkHandler(...)");
                AndroidSdkHandler sdkHandler = androidSdkHandler;
                LocalPackage localPackage = sdkHandler.getLocalPackage(this.packagePath, (ProgressIndicator)this.progressIndicator);
                if (localPackage == null) {
                    return null;
                }
                LocalPackage serverPackage = localPackage;
                Map map2 = SkiaParserServerConnectionFactoryKt.access$getMinimumRevisions$p();
                String string = serverPackage.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (map2.getOrDefault(string, new Revision(0)).compareTo(serverPackage.getVersion()) > 0) {
                    ModelWizardDialog modelWizardDialog;
                    UpdatablePackage updatablePackage = (UpdatablePackage)sdkHandler.getRepoManagerAndLoadSynchronously((ProgressIndicator)this.progressIndicator).getPackages().getConsolidatedPkgs().get(this.packagePath);
                    if (updatablePackage == null) {
                        return null;
                    }
                    UpdatablePackage updatablePackage2 = updatablePackage;
                    if (updatablePackage2.isUpdate() && (modelWizardDialog = SdkQuickfixUtils.createDialogForPackages(null, CollectionsKt.listOf((Object)updatablePackage2), CollectionsKt.emptyList(), false)) != null) {
                        modelWizardDialog.show();
                    }
                    LocalPackage localPackage2 = sdkHandler.getLocalPackage(this.packagePath, (ProgressIndicator)this.progressIndicator);
                    if (localPackage2 == null) {
                        return null;
                    }
                    serverPackage = localPackage2;
                    Map map3 = SkiaParserServerConnectionFactoryKt.access$getMinimumRevisions$p();
                    String string2 = serverPackage.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    if (map3.getOrDefault(string2, new Revision(0)).compareTo(serverPackage.getVersion()) > 0) {
                        return null;
                    }
                }
                path = serverPackage.getLocation().resolve(this.serverName);
            }
            return path;
        }

        @Slow
        @NotNull
        public final SkiaParserServerConnection createServer() {
            SkiaParserServerConnection skiaParserServerConnection;
            Path path;
            boolean bl;
            Path path2;
            Path path3 = path2 = this.findPath();
            if (path3 != null) {
                Path it = path3;
                boolean bl2 = false;
                bl = CancellableFileIo.exists((Path)it, (LinkOption[])new LinkOption[0]);
            } else {
                bl = false;
            }
            if (!bl) {
                this.tryDownload();
                path = this.findPath();
                if (path == null) {
                    throw new Exception("Unable to find server version " + this.serverVersion);
                }
            } else {
                path = path2;
            }
            Path realPath = path;
            SkiaParserServerConnection $this$createServer_u24lambda_u241 = skiaParserServerConnection = new SkiaParserServerConnection(realPath);
            boolean bl3 = false;
            $this$createServer_u24lambda_u241.runServer();
            return skiaParserServerConnection;
        }

        @Slow
        private final boolean tryDownload() {
            if (this.serverVersion == null) {
                return false;
            }
            AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
            Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"tryToChooseSdkHandler(...)");
            AndroidSdkHandler sdkHandler = androidSdkHandler;
            RepoManager sdkManager = sdkHandler.getRepoManager((ProgressIndicator)this.progressIndicator);
            sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (ProgressIndicator)this.progressIndicator, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance());
            UpdatablePackage updatablePackage = (UpdatablePackage)sdkManager.getPackages().getConsolidatedPkgs().get(this.packagePath);
            if (updatablePackage == null) {
                return false;
            }
            UpdatablePackage updatablePackage2 = updatablePackage;
            if (updatablePackage2.hasLocal() && !updatablePackage2.isUpdate()) {
                return false;
            }
            Ref.BooleanRef result2 = new Ref.BooleanRef();
            ActionsKt.invokeAndWaitIfNeeded$default(null, () -> ServerInfo.tryDownload$lambda$0(updatablePackage2, sdkManager, this, result2), (int)1, null);
            return result2.element;
        }

        private static final Unit tryDownload$lambda$0(UpdatablePackage $updatablePackage, RepoManager $sdkManager, ServerInfo this$0, Ref.BooleanRef $result) {
            ModelWizardDialog modelWizardDialog = SdkQuickfixUtils.createDialogForPackages(null, CollectionsKt.listOf((Object)$updatablePackage), CollectionsKt.emptyList(), false);
            if (modelWizardDialog == null) {
                return Unit.INSTANCE;
            }
            modelWizardDialog.show();
            $sdkManager.reloadLocalIfNeeded((ProgressIndicator)this$0.progressIndicator);
            UpdatablePackage updatablePackage = (UpdatablePackage)$sdkManager.getPackages().getConsolidatedPkgs().get(this$0.packagePath);
            if (updatablePackage == null) {
                return Unit.INSTANCE;
            }
            UpdatablePackage newPackage = updatablePackage;
            $result.element = newPackage.hasLocal() && !newPackage.isUpdate();
            return Unit.INSTANCE;
        }
    }
}

