/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.properties;

import com.android.tools.idea.layoutinspector.model.ResolutionStackModel;
import com.android.tools.idea.layoutinspector.properties.BaseTypeProvider;
import com.android.tools.idea.layoutinspector.properties.InspectorPropertiesModel;
import com.android.tools.idea.layoutinspector.properties.InspectorPropertyItem;
import com.android.tools.idea.layoutinspector.properties.PropertyType;
import com.android.tools.idea.layoutinspector.ui.ResolutionElementEditor;
import com.android.tools.property.panel.api.ControlTypeProvider;
import com.android.tools.property.panel.api.EditorContext;
import com.android.tools.property.panel.api.EditorProvider;
import com.android.tools.property.panel.api.EnumSupportProvider;
import com.android.tools.property.panel.api.PropertyEditorModel;
import com.android.tools.property.panel.api.PropertyItem;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ$\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/layoutinspector/properties/ResolutionStackEditorProvider;", "Lcom/android/tools/property/panel/api/EditorProvider;", "Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;", "model", "Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertiesModel;", "enumSupportProvider", "Lcom/android/tools/property/panel/api/EnumSupportProvider;", "controlTypeProvider", "Lcom/android/tools/property/panel/api/ControlTypeProvider;", "<init>", "(Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertiesModel;Lcom/android/tools/property/panel/api/EnumSupportProvider;Lcom/android/tools/property/panel/api/ControlTypeProvider;)V", "baseTypeProvider", "Lcom/android/tools/idea/layoutinspector/properties/BaseTypeProvider;", "editorProvider", "resolutionStackModel", "Lcom/android/tools/idea/layoutinspector/model/ResolutionStackModel;", "linkEditorTypes", "", "Lcom/android/tools/idea/layoutinspector/properties/PropertyType;", "createEditor", "Lkotlin/Pair;", "Lcom/android/tools/property/panel/api/PropertyEditorModel;", "Ljavax/swing/JComponent;", "property", "context", "Lcom/android/tools/property/panel/api/EditorContext;", "isValueClickable", "", "intellij.android.layout-inspector"})
public final class ResolutionStackEditorProvider
implements EditorProvider<InspectorPropertyItem> {
    @NotNull
    private final BaseTypeProvider baseTypeProvider;
    @NotNull
    private final EditorProvider<InspectorPropertyItem> editorProvider;
    @NotNull
    private final ResolutionStackModel resolutionStackModel;
    @NotNull
    private final List<PropertyType> linkEditorTypes;

    public ResolutionStackEditorProvider(@NotNull InspectorPropertiesModel model, @NotNull EnumSupportProvider<? super InspectorPropertyItem> enumSupportProvider2, @NotNull ControlTypeProvider<? super InspectorPropertyItem> controlTypeProvider2) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(enumSupportProvider2, (String)"enumSupportProvider");
        Intrinsics.checkNotNullParameter(controlTypeProvider2, (String)"controlTypeProvider");
        this.baseTypeProvider = new BaseTypeProvider(controlTypeProvider2);
        this.editorProvider = EditorProvider.Companion.create(enumSupportProvider2, this.baseTypeProvider);
        this.resolutionStackModel = new ResolutionStackModel(model);
        PropertyType[] propertyTypeArray = new PropertyType[]{PropertyType.LAMBDA, PropertyType.FUNCTION_REFERENCE, PropertyType.SHOW_MORE_LINK};
        this.linkEditorTypes = CollectionsKt.listOf((Object[])propertyTypeArray);
    }

    @Override
    @NotNull
    public Pair<PropertyEditorModel, JComponent> createEditor(@NotNull InspectorPropertyItem property2, @NotNull EditorContext context) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Pair<PropertyEditorModel, JComponent> pair = this.editorProvider.createEditor((InspectorPropertyItem)((PropertyItem)property2), EditorContext.TABLE_RENDERER);
        PropertyEditorModel model = (PropertyEditorModel)pair.component1();
        JComponent editor = (JComponent)pair.component2();
        model.setReadOnly(true);
        if (!property2.getNeedsResolutionEditor()) {
            return new Pair((Object)model, (Object)editor);
        }
        model.setCustomHeight(true);
        return new Pair((Object)model, (Object)new ResolutionElementEditor(this.resolutionStackModel, model, editor));
    }

    public final boolean isValueClickable(@NotNull InspectorPropertyItem property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        return ResolutionElementEditor.Companion.hasLinkPanel(property2) || this.linkEditorTypes.contains((Object)property2.getType());
    }
}

