/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline.legacy;

import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.DrawViewChild;
import com.android.tools.idea.layoutinspector.model.DrawViewImage;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyClient;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorEvent;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.Collection;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyAndroidWindow;", "Lcom/android/tools/idea/layoutinspector/model/AndroidWindow;", "client", "Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyClient;", "root", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "windowName", "", "<init>", "(Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyClient;Lcom/android/tools/idea/layoutinspector/model/ViewNode;Ljava/lang/String;)V", "refreshImages", "", "scale", "", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nLegacyAndroidWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyAndroidWindow.kt\ncom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyAndroidWindow\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1321#2,2:75\n1321#2:77\n1322#2:81\n1634#3,3:78\n*S KotlinDebug\n*F\n+ 1 LegacyAndroidWindow.kt\ncom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyAndroidWindow\n*L\n54#1:75,2\n58#1:77\n58#1:81\n59#1:78,3\n*E\n"})
public final class LegacyAndroidWindow
extends AndroidWindow {
    @NotNull
    private final LegacyClient client;
    @NotNull
    private final String windowName;

    public LegacyAndroidWindow(@NotNull LegacyClient client, @NotNull ViewNode root, @NotNull String windowName) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)windowName, (String)"windowName");
        super(root, null, windowName, AndroidWindow.ImageType.BITMAP_AS_REQUESTED);
        this.client = client;
        this.windowName = windowName;
    }

    @Override
    public void refreshImages(double scale) {
        Image image;
        byte[] byArray = this.client.getLatestScreenshots().get(this.windowName);
        if (byArray != null) {
            byte[] pngBytes = byArray;
            boolean bl = false;
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(pngBytes));
            if (bufferedImage != null) {
                BufferedImage it = bufferedImage;
                boolean bl2 = false;
                int scaledWidth = (int)((double)it.getWidth() * scale);
                int scaledHeight = (int)((double)it.getHeight() * scale);
                image = scaledWidth > 0 && scaledHeight > 0 ? it.getScaledInstance(scaledWidth, scaledHeight, 1) : null;
            } else {
                image = null;
            }
        } else {
            image = null;
        }
        Image image2 = image;
        ViewNode.Companion.writeAccess(arg_0 -> LegacyAndroidWindow.refreshImages$lambda$1(this, image2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit refreshImages$lambda$1(LegacyAndroidWindow this$0, Image $image, ViewNode.WriteAccess $this$writeAccess) {
        ViewNode it;
        Intrinsics.checkNotNullParameter((Object)$this$writeAccess, (String)"$this$writeAccess");
        Sequence<ViewNode> $this$forEach$iv = $this$writeAccess.flatten(this$0.getRoot());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ViewNode)element$iv;
            boolean bl = false;
            $this$writeAccess.getDrawChildren(it).clear();
        }
        if ($image != null) {
            $this$writeAccess.getDrawChildren(this$0.getRoot()).add(new DrawViewImage($image, this$0.getRoot(), null, 4, null));
        }
        $this$forEach$iv = $this$writeAccess.flatten(this$0.getRoot());
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv;
            it = (ViewNode)element$iv;
            boolean bl = false;
            Iterable iterable = $this$writeAccess.getChildren(it);
            Collection destination$iv = $this$writeAccess.getDrawChildren(it);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void child;
                ViewNode viewNode = (ViewNode)item$iv;
                Collection collection2 = destination$iv;
                boolean bl2 = false;
                collection2.add(new DrawViewChild((ViewNode)child));
            }
        }
        if ($this$writeAccess.getDrawChildren(this$0.getRoot()).size() != $this$writeAccess.getChildren(this$0.getRoot()).size()) {
            this$0.client.logEvent(DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.COMPATIBILITY_RENDER);
        } else {
            this$0.client.logEvent(DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.COMPATIBILITY_RENDER_NO_PICTURE);
        }
        return Unit.INSTANCE;
    }
}

