/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline.legacy;

import com.android.sdklib.AndroidApiLevel;
import com.android.tools.idea.layoutinspector.LayoutInspectorBundle;
import com.android.tools.idea.layoutinspector.model.NotificationModel;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.xml.GenericAttributeValue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/legacy/ComposeWarning;", "", "project", "Lcom/intellij/openapi/project/Project;", "notificationModel", "Lcom/android/tools/idea/layoutinspector/model/NotificationModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/layoutinspector/model/NotificationModel;)V", "performCheck", "", "client", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;", "isRunningCurrentProject", "", "isUsingCompose", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nComposeWarning.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeWarning.kt\ncom/android/tools/idea/layoutinspector/pipeline/legacy/ComposeWarning\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n12637#2:68\n12638#2:70\n12637#2,2:71\n1#3:69\n*S KotlinDebug\n*F\n+ 1 ComposeWarning.kt\ncom/android/tools/idea/layoutinspector/pipeline/legacy/ComposeWarning\n*L\n58#1:68\n58#1:70\n65#1:71,2\n*E\n"})
public final class ComposeWarning {
    @NotNull
    private final Project project;
    @NotNull
    private final NotificationModel notificationModel;

    public ComposeWarning(@NotNull Project project, @NotNull NotificationModel notificationModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notificationModel, (String)"notificationModel");
        this.project = project;
        this.notificationModel = notificationModel;
    }

    public final void performCheck(@NotNull InspectorClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (this.isRunningCurrentProject(client) && this.isUsingCompose()) {
            AndroidApiLevel apiLevel = client.getProcess().getDevice().getApiLevel();
            String message = apiLevel.getMajorVersion() < 29 ? LayoutInspectorBundle.INSTANCE.message("compose.warning.v29", new String[0]) : LayoutInspectorBundle.INSTANCE.message("compose.warning", new String[0]);
            NotificationModel.addNotification$default(this.notificationModel, "compose.warning", message, EditorNotificationPanel.Status.Warning, CollectionsKt.listOf((Object)this.notificationModel.getDismissAction()), false, 16, null);
        }
    }

    private final boolean isRunningCurrentProject(InspectorClient client) {
        boolean bl;
        block3: {
            Module[] $this$any$iv = ProjectUtil.getModules((Project)this.project);
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                Manifest manifest;
                Module element$iv;
                Module module = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                AndroidFacet facet = AndroidFacet.getInstance((Module)module);
                if (facet != null) {
                    AndroidFacet it;
                    boolean bl3 = false;
                    manifest = Manifest.getMainManifest(it);
                } else {
                    manifest = null;
                }
                Manifest manifest2 = manifest;
                String packageName = (String)ActionsKt.runReadAction(() -> ComposeWarning.isRunningCurrentProject$lambda$0$1(manifest2));
                if (!Intrinsics.areEqual((Object)packageName, (Object)client.getProcess().getName())) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isUsingCompose() {
        boolean bl;
        block1: {
            Module[] $this$any$iv = ProjectUtil.getModules((Project)this.project);
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                Module element$iv;
                Module it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!ProjectSystemUtil.getModuleSystem(it).getUsesCompose()) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final String isRunningCurrentProject$lambda$0$1(Manifest $manifest) {
        GenericAttributeValue<String> genericAttributeValue = $manifest;
        return genericAttributeValue != null && (genericAttributeValue = genericAttributeValue.getPackage()) != null ? genericAttributeValue.getStringValue() : null;
    }
}

