/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline.debugger;

import com.android.ddmlib.Client;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a$\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0002\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\f"}, d2={"isPausedInDebugger", "", "client", "Lcom/android/ddmlib/Client;", "resumeDebugger", "runInAttachedDebugger", "operation", "Lkotlin/Function1;", "Lcom/intellij/xdebugger/XDebugSession;", "isDebuggingClient", "Lcom/intellij/xdebugger/XDebugProcess;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nDebuggerDetection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggerDetection.kt\ncom/android/tools/idea/layoutinspector/pipeline/debugger/DebuggerDetectionKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,79:1\n12637#2:80\n12637#2,2:81\n12638#2:83\n*S KotlinDebug\n*F\n+ 1 DebuggerDetection.kt\ncom/android/tools/idea/layoutinspector/pipeline/debugger/DebuggerDetectionKt\n*L\n48#1:80\n50#1:81,2\n48#1:83\n*E\n"})
public final class DebuggerDetectionKt {
    public static final boolean isPausedInDebugger(@NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return DebuggerDetectionKt.runInAttachedDebugger(client, (Function1<? super XDebugSession, Boolean>)((Function1)DebuggerDetectionKt::isPausedInDebugger$lambda$0));
    }

    public static final boolean resumeDebugger(@NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return DebuggerDetectionKt.runInAttachedDebugger(client, (Function1<? super XDebugSession, Boolean>)((Function1)DebuggerDetectionKt::resumeDebugger$lambda$0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean runInAttachedDebugger(Client client, Function1<? super XDebugSession, Boolean> operation) {
        if (!client.isDebuggerAttached()) return false;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] $this$any$iv = projectArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            Object element$iv = $this$any$iv[n];
            Project anyProject = (Project)element$iv;
            boolean bl = false;
            XDebugSession[] xDebugSessionArray = XDebuggerManager.getInstance((Project)anyProject).getDebugSessions();
            Intrinsics.checkNotNullExpressionValue((Object)xDebugSessionArray, (String)"getDebugSessions(...)");
            Object[] $this$any$iv2 = xDebugSessionArray;
            boolean $i$f$any2 = false;
            for (Object element$iv2 : $this$any$iv2) {
                XDebugSession it = (XDebugSession)element$iv2;
                boolean bl2 = false;
                XDebugProcess xDebugProcess = it.getDebugProcess();
                Intrinsics.checkNotNullExpressionValue((Object)xDebugProcess, (String)"getDebugProcess(...)");
                if (DebuggerDetectionKt.isDebuggingClient(xDebugProcess, client)) {
                    Intrinsics.checkNotNull((Object)it);
                    if (((Boolean)operation.invoke((Object)it)).booleanValue()) {
                        return true;
                    }
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return true;
            }
            boolean bl4 = false;
            if (bl4) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final boolean isDebuggingClient(XDebugProcess $this$isDebuggingClient, Client client) {
        if ($this$isDebuggingClient instanceof JavaDebugProcess) {
            DebugProcessImpl debugProcessImpl = ((JavaDebugProcess)$this$isDebuggingClient).getDebuggerSession().getProcess();
            Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getProcess(...)");
            return DebuggerDetectionKt.isDebuggingClient(debugProcessImpl, client);
        }
        for (Class<?> processClass = $this$isDebuggingClient.getClass(); processClass != null && !Intrinsics.areEqual((Object)processClass.getName(), (Object)Object.class.getName()); processClass = processClass.getSuperclass()) {
            try {
                Method method2 = processClass.getDeclaredMethod("getClient", new Class[0]);
                Object object = method2.invoke((Object)$this$isDebuggingClient, new Object[0]);
                Client attachedClient = object instanceof Client ? (Client)object : null;
                Client client2 = attachedClient;
                return client2 != null && (client2 = client2.getClientData()) != null ? client2.getPid() == client.getClientData().getPid() : false;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return false;
    }

    private static final boolean isDebuggingClient(DebugProcessImpl $this$isDebuggingClient, Client client) {
        String string = $this$isDebuggingClient.getConnection().getDebuggerAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDebuggerAddress(...)");
        return Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)String.valueOf(client.getDebuggerListenPort()));
    }

    private static final boolean isPausedInDebugger$lambda$0(XDebugSession debugSession) {
        Intrinsics.checkNotNullParameter((Object)debugSession, (String)"debugSession");
        return debugSession.isPaused();
    }

    private static final boolean resumeDebugger$lambda$0(XDebugSession debugSession) {
        Intrinsics.checkNotNullParameter((Object)debugSession, (String)"debugSession");
        boolean paused = debugSession.isPaused();
        if (paused) {
            debugSession.resume();
        }
        return false;
    }
}

