/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline.appinspection.view;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.sdklib.AndroidApiLevel;
import com.android.tools.idea.appinspection.inspector.api.process.ProcessDescriptor;
import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.NotificationModel;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.pipeline.appinspection.compose.GetComposablesResult;
import com.android.tools.idea.layoutinspector.pipeline.appinspection.view.FromProtoConversionsKt;
import com.android.tools.idea.layoutinspector.pipeline.appinspection.view.ViewAndroidWindow;
import com.android.tools.idea.layoutinspector.pipeline.appinspection.view.ViewNodeCreator;
import com.android.tools.idea.layoutinspector.resource.ResourceLookup;
import com.android.tools.idea.layoutinspector.resource.data.AppContext;
import com.android.tools.idea.layoutinspector.skia.SkiaParser;
import com.android.tools.idea.layoutinspector.view.inspection.LayoutInspectorViewProtocol;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorEvent;
import com.intellij.openapi.util.LowMemoryWatcher;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\b\u0010$\u001a\u0004\u0018\u00010%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/appinspection/view/ViewInspectorTreeLoader;", "", "notificationModel", "Lcom/android/tools/idea/layoutinspector/model/NotificationModel;", "skiaParser", "Lcom/android/tools/idea/layoutinspector/skia/SkiaParser;", "viewEvent", "Lcom/android/tools/idea/layoutinspector/view/inspection/LayoutInspectorViewProtocol$LayoutEvent;", "resourceLookup", "Lcom/android/tools/idea/layoutinspector/resource/ResourceLookup;", "process", "Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;", "composeResult", "Lcom/android/tools/idea/layoutinspector/pipeline/appinspection/compose/GetComposablesResult;", "logEvent", "Lkotlin/Function1;", "Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorEvent$DynamicLayoutInspectorEventType;", "", "<init>", "(Lcom/android/tools/idea/layoutinspector/model/NotificationModel;Lcom/android/tools/idea/layoutinspector/skia/SkiaParser;Lcom/android/tools/idea/layoutinspector/view/inspection/LayoutInspectorViewProtocol$LayoutEvent;Lcom/android/tools/idea/layoutinspector/resource/ResourceLookup;Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;Lcom/android/tools/idea/layoutinspector/pipeline/appinspection/compose/GetComposablesResult;Lkotlin/jvm/functions/Function1;)V", "folderConfig", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "isInterrupted", "", "viewNodeCreator", "Lcom/android/tools/idea/layoutinspector/pipeline/appinspection/view/ViewNodeCreator;", "dynamicCapabilities", "", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient$Capability;", "getDynamicCapabilities", "()Ljava/util/Set;", "lowMemoryWatcher", "Lcom/intellij/openapi/util/LowMemoryWatcher;", "kotlin.jvm.PlatformType", "getLowMemoryWatcher$annotations", "()V", "loadComponentTree", "Lcom/android/tools/idea/layoutinspector/model/AndroidWindow;", "intellij.android.layout-inspector"})
public final class ViewInspectorTreeLoader {
    @NotNull
    private final NotificationModel notificationModel;
    @NotNull
    private final SkiaParser skiaParser;
    @NotNull
    private final LayoutInspectorViewProtocol.LayoutEvent viewEvent;
    @NotNull
    private final ResourceLookup resourceLookup;
    @NotNull
    private final ProcessDescriptor process;
    @NotNull
    private final Function1<DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType, Unit> logEvent;
    @NotNull
    private FolderConfiguration folderConfig;
    private boolean isInterrupted;
    @NotNull
    private final ViewNodeCreator viewNodeCreator;
    private final LowMemoryWatcher lowMemoryWatcher;

    public ViewInspectorTreeLoader(@NotNull NotificationModel notificationModel, @NotNull SkiaParser skiaParser, @NotNull LayoutInspectorViewProtocol.LayoutEvent viewEvent, @NotNull ResourceLookup resourceLookup, @NotNull ProcessDescriptor process2, @Nullable GetComposablesResult composeResult, @NotNull Function1<? super DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType, Unit> logEvent) {
        Intrinsics.checkNotNullParameter((Object)notificationModel, (String)"notificationModel");
        Intrinsics.checkNotNullParameter((Object)skiaParser, (String)"skiaParser");
        Intrinsics.checkNotNullParameter((Object)viewEvent, (String)"viewEvent");
        Intrinsics.checkNotNullParameter((Object)resourceLookup, (String)"resourceLookup");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter(logEvent, (String)"logEvent");
        this.notificationModel = notificationModel;
        this.skiaParser = skiaParser;
        this.viewEvent = viewEvent;
        this.resourceLookup = resourceLookup;
        this.process = process2;
        this.logEvent = logEvent;
        LayoutInspectorViewProtocol.Configuration configuration2 = LayoutInspectorViewProtocol.Configuration.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"getDefaultInstance(...)");
        this.folderConfig = FromProtoConversionsKt.convert(configuration2, new AndroidApiLevel(1, 0, 2, null));
        this.viewNodeCreator = new ViewNodeCreator(this.viewEvent, composeResult);
        this.lowMemoryWatcher = LowMemoryWatcher.register(() -> ViewInspectorTreeLoader.lowMemoryWatcher$lambda$0(this), (LowMemoryWatcher.LowMemoryWatcherType)LowMemoryWatcher.LowMemoryWatcherType.ONLY_AFTER_GC);
    }

    @NotNull
    public final Set<InspectorClient.Capability> getDynamicCapabilities() {
        return this.viewNodeCreator.getDynamicCapabilities();
    }

    private static /* synthetic */ void getLowMemoryWatcher$annotations() {
    }

    @Nullable
    public final AndroidWindow loadComponentTree() {
        LayoutInspectorViewProtocol.Configuration configuration2 = this.viewEvent.getConfiguration();
        LayoutInspectorViewProtocol.AppContext appContext = this.viewEvent.getAppContext();
        Intrinsics.checkNotNull((Object)configuration2);
        this.folderConfig = FromProtoConversionsKt.convert(configuration2, this.process.getDevice().getApiLevel());
        Intrinsics.checkNotNull((Object)appContext);
        AppContext context = FromProtoConversionsKt.convert(appContext);
        ResourceReference theme = context.getTheme().createReference(this.viewNodeCreator.getStrings());
        this.resourceLookup.updateConfiguration(this.folderConfig, theme, this.process, configuration2.getFontScale(), context.getDisplays());
        ViewNode viewNode = this.viewNodeCreator.createRootViewNode((Function0<Boolean>)((Function0)() -> ViewInspectorTreeLoader.loadComponentTree$lambda$0(this)));
        if (viewNode == null) {
            return null;
        }
        ViewNode rootView = viewNode;
        return new ViewAndroidWindow(this.notificationModel, this.skiaParser, rootView, this.viewEvent, this.folderConfig, (Function0<Boolean>)((Function0)() -> ViewInspectorTreeLoader.loadComponentTree$lambda$1(this)), this.logEvent);
    }

    private static final void lowMemoryWatcher$lambda$0(ViewInspectorTreeLoader this$0) {
        this$0.isInterrupted = true;
    }

    private static final boolean loadComponentTree$lambda$0(ViewInspectorTreeLoader this$0) {
        return this$0.isInterrupted;
    }

    private static final boolean loadComponentTree$lambda$1(ViewInspectorTreeLoader this$0) {
        return this$0.isInterrupted;
    }
}

