/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline.appinspection.view;

import com.android.tools.layoutinspector.BitmapType;
import com.android.tools.layoutinspector.LayoutInspectorUtilsKt;
import com.google.common.annotations.VisibleForTesting;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"INVALID_SKP_KEY", "", "UNSUPPORTED_SKP_VERSION_KEY", "CANNOT_LAUNCH_SKP_RENDERER_KEY", "processBitmap", "Ljava/awt/image/BufferedImage;", "bytes", "", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nViewAndroidWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewAndroidWindow.kt\ncom/android/tools/idea/layoutinspector/pipeline/appinspection/view/ViewAndroidWindowKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n1#2:253\n*E\n"})
public final class ViewAndroidWindowKt {
    @NotNull
    private static final String INVALID_SKP_KEY = "skp.invalid";
    @NotNull
    private static final String UNSUPPORTED_SKP_VERSION_KEY = "skp.unsupported";
    @NotNull
    private static final String CANNOT_LAUNCH_SKP_RENDERER_KEY = "skp.renderer.launch.error";

    @VisibleForTesting
    @NotNull
    public static final BufferedImage processBitmap(@NotNull byte[] bytes2) {
        int count;
        Inflater inflater;
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        Inflater it = inflater = new Inflater();
        boolean bl = false;
        it.setInput(bytes2);
        Inflater inf = inflater;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while (!inf.finished() && (count = inf.inflate(buffer)) > 0) {
            baos.write(buffer, 0, count);
        }
        byte[] inflatedBytes = baos.toByteArray();
        Intrinsics.checkNotNull((Object)inflatedBytes);
        int width = LayoutInspectorUtilsKt.toInt(inflatedBytes);
        int height = LayoutInspectorUtilsKt.toInt(ArraysKt.sliceArray((byte[])inflatedBytes, (IntRange)new IntRange(4, 7)));
        BitmapType bitmapType = BitmapType.Companion.fromByteVal(inflatedBytes[8]);
        ByteBuffer byteBuffer = ByteBuffer.wrap(inflatedBytes, 9, inflatedBytes.length - 9);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        return bitmapType.createImage(byteBuffer, width, height);
    }
}

