/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline.appinspection.view;

import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ScreenHeightQualifier;
import com.android.ide.common.resources.configuration.ScreenRoundQualifier;
import com.android.ide.common.resources.configuration.ScreenWidthQualifier;
import com.android.resources.ScreenRound;
import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.LayoutInspectorBundle;
import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.ComponentImageLoader;
import com.android.tools.idea.layoutinspector.model.DrawViewChild;
import com.android.tools.idea.layoutinspector.model.DrawViewImage;
import com.android.tools.idea.layoutinspector.model.NotificationModel;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.pipeline.appinspection.view.FromProtoConversionsKt;
import com.android.tools.idea.layoutinspector.pipeline.appinspection.view.ViewAndroidWindowKt;
import com.android.tools.idea.layoutinspector.proto.SkiaParser;
import com.android.tools.idea.layoutinspector.skia.ParsingFailedException;
import com.android.tools.idea.layoutinspector.skia.SkiaParser;
import com.android.tools.idea.layoutinspector.skia.UnsupportedPictureVersionException;
import com.android.tools.idea.layoutinspector.view.inspection.LayoutInspectorViewProtocol;
import com.android.tools.layoutinspector.InvalidPictureException;
import com.android.tools.layoutinspector.LayoutInspectorUtils;
import com.android.tools.layoutinspector.SkiaViewNode;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorEvent;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0001H\u0016J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'H\u0002J\u0012\u0010*\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J0\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010)\u001a\u00020\u00162\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00060"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/appinspection/view/ViewAndroidWindow;", "Lcom/android/tools/idea/layoutinspector/model/AndroidWindow;", "notificationModel", "Lcom/android/tools/idea/layoutinspector/model/NotificationModel;", "skiaParser", "Lcom/android/tools/idea/layoutinspector/skia/SkiaParser;", "root", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "event", "Lcom/android/tools/idea/layoutinspector/view/inspection/LayoutInspectorViewProtocol$LayoutEvent;", "folderConfiguration", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "isInterrupted", "Lkotlin/Function0;", "", "logEvent", "Lkotlin/Function1;", "Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorEvent$DynamicLayoutInspectorEventType;", "", "<init>", "(Lcom/android/tools/idea/layoutinspector/model/NotificationModel;Lcom/android/tools/idea/layoutinspector/skia/SkiaParser;Lcom/android/tools/idea/layoutinspector/model/ViewNode;Lcom/android/tools/idea/layoutinspector/view/inspection/LayoutInspectorViewProtocol$LayoutEvent;Lcom/android/ide/common/resources/configuration/FolderConfiguration;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "screenshotBytes", "", "image", "Ljava/awt/image/BufferedImage;", "getImage", "()Ljava/awt/image/BufferedImage;", "setImage", "(Ljava/awt/image/BufferedImage;)V", "isXr", "()Z", "deviceClip", "Ljava/awt/geom/Ellipse2D$Float;", "getDeviceClip", "()Ljava/awt/geom/Ellipse2D$Float;", "copyFrom", "other", "refreshImages", "scale", "", "processSkp", "bytes", "createDrawChildren", "getViewTree", "Lcom/android/tools/layoutinspector/SkiaViewNode;", "requestedNodes", "", "Lcom/android/tools/idea/layoutinspector/proto/SkiaParser$RequestedNodeInfo;", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nViewAndroidWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewAndroidWindow.kt\ncom/android/tools/idea/layoutinspector/pipeline/appinspection/view/ViewAndroidWindow\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n682#2:253\n712#2,4:254\n1869#3,2:258\n1869#3:260\n1634#3,3:261\n1870#3:264\n*S KotlinDebug\n*F\n+ 1 ViewAndroidWindow.kt\ncom/android/tools/idea/layoutinspector/pipeline/appinspection/view/ViewAndroidWindow\n*L\n140#1:253\n140#1:254,4\n179#1:258,2\n183#1:260\n183#1:261,3\n183#1:264\n*E\n"})
public final class ViewAndroidWindow
extends AndroidWindow {
    @NotNull
    private final NotificationModel notificationModel;
    @NotNull
    private final SkiaParser skiaParser;
    @NotNull
    private final LayoutInspectorViewProtocol.LayoutEvent event;
    @NotNull
    private final Function0<Boolean> isInterrupted;
    @NotNull
    private final Function1<DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType, Unit> logEvent;
    @Nullable
    private byte[] screenshotBytes;
    @Nullable
    private BufferedImage image;
    private final boolean isXr;
    @Nullable
    private final Ellipse2D.Float deviceClip;

    public ViewAndroidWindow(@NotNull NotificationModel notificationModel, @NotNull SkiaParser skiaParser, @NotNull ViewNode root, @NotNull LayoutInspectorViewProtocol.LayoutEvent event, @NotNull FolderConfiguration folderConfiguration, @NotNull Function0<Boolean> isInterrupted, @NotNull Function1<? super DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType, Unit> logEvent) {
        Ellipse2D.Float float_;
        Intrinsics.checkNotNullParameter((Object)notificationModel, (String)"notificationModel");
        Intrinsics.checkNotNullParameter((Object)skiaParser, (String)"skiaParser");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)folderConfiguration, (String)"folderConfiguration");
        Intrinsics.checkNotNullParameter(isInterrupted, (String)"isInterrupted");
        Intrinsics.checkNotNullParameter(logEvent, (String)"logEvent");
        Integer n = event.getRootView().hasDisplayId() ? Integer.valueOf(event.getRootView().getDisplayId()) : null;
        Long l = root.getDrawId();
        LayoutInspectorViewProtocol.Screenshot.Type type = event.getScreenshot().getType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
        super(root, n, l, FromProtoConversionsKt.toImageType(type));
        this.notificationModel = notificationModel;
        this.skiaParser = skiaParser;
        this.event = event;
        this.isInterrupted = isInterrupted;
        this.logEvent = logEvent;
        this.screenshotBytes = this.event.hasScreenshot() ? this.event.getScreenshot().getBytes().toByteArray() : null;
        this.isXr = this.event.getIsXr();
        ScreenRoundQualifier screenRoundQualifier = folderConfiguration.getScreenRoundQualifier();
        if ((screenRoundQualifier != null ? screenRoundQualifier.getValue() : null) == ScreenRound.ROUND) {
            Integer dpi;
            ScreenWidthQualifier screenWidthQualifier = folderConfiguration.getScreenWidthQualifier();
            Integer width = screenWidthQualifier != null ? Integer.valueOf(screenWidthQualifier.getValue()) : null;
            ScreenHeightQualifier screenHeightQualifier = folderConfiguration.getScreenHeightQualifier();
            Integer height = screenHeightQualifier != null ? Integer.valueOf(screenHeightQualifier.getValue()) : null;
            DensityQualifier densityQualifier = folderConfiguration.getDensityQualifier();
            Integer n2 = densityQualifier != null && (densityQualifier = densityQualifier.getValue()) != null ? Integer.valueOf(densityQualifier.getDpiValue()) : (dpi = null);
            float_ = width != null && height != null && dpi != null ? new Ellipse2D.Float(0.0f, 0.0f, (float)(width * dpi) / 160.0f, (float)(height * dpi) / 160.0f) : null;
        } else {
            float_ = null;
        }
        this.deviceClip = float_;
    }

    @Override
    @Nullable
    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public void setImage(@Nullable BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public final boolean isXr() {
        return this.isXr;
    }

    @Override
    @Nullable
    public Ellipse2D.Float getDeviceClip() {
        return this.deviceClip;
    }

    @Override
    public void copyFrom(@NotNull AndroidWindow other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        super.copyFrom(other);
        if (other instanceof ViewAndroidWindow) {
            this.screenshotBytes = ((ViewAndroidWindow)other).screenshotBytes;
        }
    }

    @Override
    public void refreshImages(double scale) {
        try {
            byte[] immutableScreenshotBytes = this.screenshotBytes;
            if (immutableScreenshotBytes == null) {
                this.createDrawChildren(null);
                this.setImage(null);
            } else if (!(immutableScreenshotBytes.length == 0)) {
                switch (WhenMappings.$EnumSwitchMapping$0[this.getImageType().ordinal()]) {
                    case 1: {
                        BufferedImage bufferedImage = ViewAndroidWindowKt.processBitmap(immutableScreenshotBytes);
                        this.setImage(bufferedImage);
                        this.createDrawChildren(bufferedImage);
                        this.logEvent.invoke((Object)DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.INITIAL_RENDER_BITMAPS);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.setImage(null);
                        this.processSkp(immutableScreenshotBytes, this.skiaParser, scale);
                        break;
                    }
                    default: {
                        this.setImage(null);
                        this.logEvent.invoke((Object)DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.INITIAL_RENDER_NO_PICTURE);
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            this.setImage(null);
            Logger.getInstance(LayoutInspector.class).warn((Throwable)ex);
        }
    }

    private final void processSkp(byte[] bytes2, SkiaParser skiaParser, double scale) {
        Pair pair = (Pair)ViewNode.Companion.readAccess(arg_0 -> ViewAndroidWindow.processSkp$lambda$0(this, arg_0));
        Map nodeMap = (Map)pair.component1();
        List requestedNodeInfo = (List)pair.component2();
        if (requestedNodeInfo.isEmpty()) {
            return;
        }
        SkiaViewNode rootViewFromSkiaImage = this.getViewTree(bytes2, requestedNodeInfo, skiaParser, scale);
        if (rootViewFromSkiaImage != null && rootViewFromSkiaImage.getId() != 0L) {
            this.logEvent.invoke((Object)DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.INITIAL_RENDER);
            new ComponentImageLoader(nodeMap, rootViewFromSkiaImage).loadImages(this);
        }
    }

    private final void createDrawChildren(BufferedImage image) {
        ViewNode.Companion.writeAccess(arg_0 -> ViewAndroidWindow.createDrawChildren$lambda$0(this, image, arg_0));
    }

    private final SkiaViewNode getViewTree(byte[] bytes2, Iterable<SkiaParser.RequestedNodeInfo> requestedNodes, SkiaParser skiaParser, double scale) {
        SkiaViewNode skiaViewNode;
        try {
            skiaViewNode = skiaParser.getViewTree(bytes2, requestedNodes, scale, this.isInterrupted);
        }
        catch (InvalidPictureException ex) {
            NotificationModel.addNotification$default(this.notificationModel, "skp.invalid", LayoutInspectorBundle.INSTANCE.message("skp.invalid", new String[0]), null, null, false, 28, null);
            skiaViewNode = null;
        }
        catch (ParsingFailedException ex) {
            NotificationModel.addNotification$default(this.notificationModel, "skp.invalid", LayoutInspectorBundle.INSTANCE.message("skp.invalid", new String[0]), null, null, false, 28, null);
            skiaViewNode = null;
        }
        catch (UnsupportedPictureVersionException ex) {
            String[] stringArray = new String[]{String.valueOf(ex.getVersion())};
            NotificationModel.addNotification$default(this.notificationModel, "skp.unsupported", LayoutInspectorBundle.INSTANCE.message("skp.unsupported", stringArray), null, null, false, 28, null);
            skiaViewNode = null;
        }
        catch (Exception ex) {
            NotificationModel.addNotification$default(this.notificationModel, "skp.renderer.launch.error", LayoutInspectorBundle.INSTANCE.message("skp.renderer.launch.error", new String[0]), null, null, false, 28, null);
            Logger.getInstance(ViewAndroidWindow.class).warn((Throwable)ex);
            skiaViewNode = null;
        }
        SkiaViewNode inspectorView = skiaViewNode;
        return inspectorView;
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair processSkp$lambda$0(ViewAndroidWindow this$0, ViewNode.ReadAccess $this$readAccess) {
        void $this$associateByTo$iv$iv;
        Sequence allNodes;
        Intrinsics.checkNotNullParameter((Object)$this$readAccess, (String)"$this$readAccess");
        Sequence $this$associateBy$iv = allNodes = SequencesKt.filter($this$readAccess.flatten(this$0.getRoot()), ViewAndroidWindow::processSkp$lambda$0$0);
        boolean $i$f$associateBy = false;
        Sequence sequence = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ViewNode viewNode = (ViewNode)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getDrawId(), element$iv$iv);
        }
        Map nodeMap = destination$iv$iv;
        int surfaceOriginX = this$0.getRoot().getLayoutBounds().x - this$0.event.getRootView().getOffset().getX();
        int surfaceOriginY = this$0.getRoot().getLayoutBounds().y - this$0.event.getRootView().getOffset().getY();
        List requests2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)allNodes, arg_0 -> ViewAndroidWindow.processSkp$lambda$0$2(surfaceOriginX, surfaceOriginY, arg_0)));
        return new Pair((Object)nodeMap, (Object)requests2);
    }

    private static final boolean processSkp$lambda$0$0(ViewNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDrawId() != 0L;
    }

    private static final SkiaParser.RequestedNodeInfo processSkp$lambda$0$2(int $surfaceOriginX, int $surfaceOriginY, ViewNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Rectangle bounds = it.getRenderBounds().getBounds().intersection(new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
        return bounds.isEmpty() ? null : LayoutInspectorUtils.INSTANCE.makeRequestedNodeInfo(it.getDrawId(), bounds.x - $surfaceOriginX, bounds.y - $surfaceOriginY, bounds.width, bounds.height);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createDrawChildren$lambda$0(ViewAndroidWindow this$0, BufferedImage $image, ViewNode.WriteAccess $this$writeAccess) {
        ViewNode it;
        Intrinsics.checkNotNullParameter((Object)$this$writeAccess, (String)"$this$writeAccess");
        List<ViewNode> views = this$0.getRoot().flattenedList();
        Iterable $this$forEach$iv = views;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ViewNode)element$iv;
            boolean bl = false;
            $this$writeAccess.getDrawChildren(it).clear();
        }
        if ($image != null) {
            $this$writeAccess.getDrawChildren(this$0.getRoot()).add(new DrawViewImage($image, this$0.getRoot(), this$0.getDeviceClip()));
        }
        $this$forEach$iv = views;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv;
            it = (ViewNode)element$iv;
            boolean bl = false;
            Iterable iterable = $this$writeAccess.getChildren(it);
            Collection destination$iv = $this$writeAccess.getDrawChildren(it);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void child;
                ViewNode viewNode = (ViewNode)item$iv;
                Collection collection2 = destination$iv;
                boolean bl2 = false;
                collection2.add(new DrawViewChild((ViewNode)child));
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidWindow.ImageType.values().length];
            try {
                nArray[AndroidWindow.ImageType.BITMAP_AS_REQUESTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidWindow.ImageType.SKP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidWindow.ImageType.SKP_PENDING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

