/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.common;

import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u001a7\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0016\u0010\u0007\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t0\b\"\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\n\u001a0\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0014\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b0\f\u001aA\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00012\u0016\u0010\u0007\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t0\b\"\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"DIAGNOSTICS_PREFIX", "", "logDiagnostics", "", "where", "Ljava/lang/Class;", "message", "arguments", "", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Object;)V", "lazyArguments", "Lkotlin/Function0;", "t", "", "(Ljava/lang/Class;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "intellij.android.layout-inspector"})
public final class DiagnosticsKt {
    @NotNull
    private static final String DIAGNOSTICS_PREFIX = "LI-DIAG: ";

    public static final void logDiagnostics(@NotNull Class<?> where, @NotNull String message, Object ... arguments) {
        Intrinsics.checkNotNullParameter(where, (String)"where");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        DiagnosticsKt.logDiagnostics(where, null, message, Arrays.copyOf(arguments, arguments.length));
    }

    public static final void logDiagnostics(@NotNull Class<?> where, @NotNull String message, @NotNull Function0<Object[]> lazyArguments) {
        Intrinsics.checkNotNullParameter(where, (String)"where");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(lazyArguments, (String)"lazyArguments");
        if (((Boolean)StudioFlags.DYNAMIC_LAYOUT_INSPECTOR_EXTRA_LOGGING.get()).booleanValue()) {
            Object[] objectArray = (Object[])lazyArguments.invoke();
            DiagnosticsKt.logDiagnostics(where, null, message, Arrays.copyOf(objectArray, objectArray.length));
        }
    }

    public static final void logDiagnostics(@NotNull Class<?> where, @Nullable Throwable t, @NotNull String message, Object ... arguments) {
        Intrinsics.checkNotNullParameter(where, (String)"where");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (((Boolean)StudioFlags.DYNAMIC_LAYOUT_INSPECTOR_EXTRA_LOGGING.get()).booleanValue()) {
            Logger logger = Logger.getInstance(where);
            String string = DIAGNOSTICS_PREFIX + message;
            Object[] objectArray = Arrays.copyOf(arguments, arguments.length);
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            logger.warn(string2, t);
        }
    }
}

