/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.androidSql.resolution;

import com.android.tools.idea.lang.androidSql.psi.AndroidSqlResultColumn;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlSelectCore;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlSelectStatement;
import com.android.tools.idea.lang.androidSql.resolution.AllColumnsProcessor;
import com.android.tools.idea.lang.androidSql.resolution.AndroidSqlColumn;
import com.android.tools.idea.lang.androidSql.resolution.AndroidSqlSelectedTablePsiReference;
import com.android.tools.idea.lang.androidSql.resolution.AndroidSqlTable;
import com.android.tools.idea.lang.androidSql.resolution.ResolutionKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/lang/androidSql/resolution/SubqueryTable;", "Lcom/android/tools/idea/lang/androidSql/resolution/AndroidSqlTable;", "selectStmt", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlSelectStatement;", "<init>", "(Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlSelectStatement;)V", "name", "", "getName", "()Ljava/lang/Void;", "definingElement", "getDefiningElement", "()Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlSelectStatement;", "isView", "", "()Z", "processColumns", "processor", "Lcom/intellij/util/Processor;", "Lcom/android/tools/idea/lang/androidSql/resolution/AndroidSqlColumn;", "sqlTablesInProcess", "", "Lcom/intellij/psi/PsiElement;", "intellij.android.lang"})
public final class SubqueryTable
implements AndroidSqlTable {
    @NotNull
    private final AndroidSqlSelectStatement selectStmt;

    public SubqueryTable(@NotNull AndroidSqlSelectStatement selectStmt) {
        Intrinsics.checkNotNullParameter((Object)selectStmt, (String)"selectStmt");
        this.selectStmt = selectStmt;
    }

    @Nullable
    public Void getName() {
        return null;
    }

    @Override
    @NotNull
    public AndroidSqlSelectStatement getDefiningElement() {
        return this.selectStmt;
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public boolean processColumns(@NotNull Processor<AndroidSqlColumn> processor, @NotNull Set<PsiElement> sqlTablesInProcess) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Intrinsics.checkNotNullParameter(sqlTablesInProcess, (String)"sqlTablesInProcess");
        List<AndroidSqlSelectCore> list2 = this.selectStmt.getSelectCoreList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getSelectCoreList(...)");
        AndroidSqlSelectCore selectCore = (AndroidSqlSelectCore)CollectionsKt.firstOrNull(list2);
        ProgressManager.checkCanceled();
        Object object = selectCore;
        if (object == null || (object = object.getSelectCoreSelect()) == null || (object = object.getResultColumns()) == null || (object = object.getResultColumnList()) == null) {
            return true;
        }
        Object resultColumns = object;
        Iterator iterator2 = resultColumns.iterator();
        while (iterator2.hasNext()) {
            AndroidSqlResultColumn resultColumn = (AndroidSqlResultColumn)iterator2.next();
            if (resultColumn.getExpression() != null) {
                Intrinsics.checkNotNull((Object)resultColumn);
                AndroidSqlColumn column2 = ResolutionKt.computeSqlColumn(resultColumn, sqlTablesInProcess);
                if (column2 == null || processor.process((Object)column2)) continue;
                return false;
            }
            if (resultColumn.getSelectedTableName() != null) {
                Object sqlTable;
                Object object2 = resultColumn.getSelectedTableName();
                if (object2 == null || (object2 = object2.getReference()) == null) continue;
                if ((object2 = ((AndroidSqlSelectedTablePsiReference)((Object)object2)).resolveSqlTable()) == null || (sqlTable = object2).processColumns(processor, sqlTablesInProcess)) continue;
                return false;
            }
            Intrinsics.checkNotNull((Object)resultColumn);
            if (ResolutionKt.processSelectedSqlTables(resultColumn, (Processor<AndroidSqlTable>)((Processor)new AllColumnsProcessor(processor, sqlTablesInProcess)))) continue;
            return false;
        }
        return true;
    }
}

