/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.instrumentation.threading;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.instrumentation.threading.ThreadingCheckerHookImpl;
import com.android.tools.idea.util.StudioPathManager;
import com.android.tools.instrumentation.threading.agent.callback.ThreadingCheckerHook;
import com.android.tools.instrumentation.threading.agent.callback.ThreadingCheckerTrampoline;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0002J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/instrumentation/threading/ThreadingChecker;", "Lcom/intellij/ide/ApplicationInitializedListener;", "<init>", "()V", "execute", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "maybeAttachThreadingAgent", "attachThreadingAgent", "getThreadingAgentJarLocation", "Ljava/nio/file/Path;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nThreadingChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadingChecker.kt\ncom/android/tools/idea/instrumentation/threading/ThreadingChecker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,109:1\n24#2:110\n24#2:111\n24#2:112\n24#2:113\n24#2:114\n*S KotlinDebug\n*F\n+ 1 ThreadingChecker.kt\ncom/android/tools/idea/instrumentation/threading/ThreadingChecker\n*L\n47#1:110\n79#1:111\n85#1:112\n90#1:113\n93#1:114\n*E\n"})
public final class ThreadingChecker
implements ApplicationInitializedListener {
    @Nullable
    public Object execute(@NotNull Continuation<? super Unit> $completion) {
        boolean bl;
        try {
            Class.forName("com.android.tools.instrumentation.threading.agent.Agent", false, null);
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        boolean agentLoadedAtStartup = bl;
        if (agentLoadedAtStartup) {
            ThreadingCheckerTrampoline.installHook((ThreadingCheckerHook)new ThreadingCheckerHookImpl(null, 1, null));
            ThreadingChecker $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ThreadingChecker.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("ThreadingChecker listener has been installed.");
        } else {
            this.maybeAttachThreadingAgent();
        }
        return Unit.INSTANCE;
    }

    private final void maybeAttachThreadingAgent() {
        if (!((Boolean)StudioFlags.ENABLE_THREADING_CHECKER_AGENT.get()).booleanValue()) {
            return;
        }
        if (StudioPathManager.isRunningFromSources()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> ThreadingChecker.maybeAttachThreadingAgent$lambda$0(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void attachThreadingAgent() {
        VirtualMachine vm = null;
        try {
            Path threadingAgentJarPath = this.getThreadingAgentJarLocation();
            if (threadingAgentJarPath == null) {
                ThreadingChecker $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ThreadingChecker.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Couldn't locate threading_agent.jar.");
                return;
            }
            try {
                vm = VirtualMachine.attach(OSProcessUtil.getApplicationPid());
            }
            catch (IOException e) {
                ThreadingChecker $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ThreadingChecker.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Couldn't attach to current VM to load Threading Agent. Make sure 'jdk.attach.allowAttachSelf=true'", (Throwable)e);
                return;
            }
            vm.loadAgent(((Object)threadingAgentJarPath).toString());
            ThreadingCheckerTrampoline.installHook((ThreadingCheckerHook)new ThreadingCheckerHookImpl(null, 1, null));
            ThreadingChecker $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ThreadingChecker.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("ThreadingChecker listener has been installed (after threading agent was dynamically loaded).");
        }
        catch (Exception e) {
            ThreadingChecker $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ThreadingChecker.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
        }
        finally {
            VirtualMachine virtualMachine = vm;
            if (virtualMachine != null) {
                virtualMachine.detach();
            }
        }
    }

    private final Path getThreadingAgentJarLocation() {
        Path path = Paths.get(PathManager.getHomePath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path homePath = path;
        Path path2 = homePath.resolve("plugins/android/resources/threading_agent.jar");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path jarFile = path2;
        if (!Files.exists(jarFile, new LinkOption[0])) {
            return null;
        }
        return jarFile;
    }

    private static final void maybeAttachThreadingAgent$lambda$0(ThreadingChecker this$0) {
        this$0.attachThreadingAgent();
    }
}

