/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights.ui;

import com.android.tools.idea.insights.AppInsightsProjectLevelController;
import com.android.tools.idea.insights.AppInsightsState;
import com.android.tools.idea.insights.model.issue.AppInsightsIssue;
import com.android.tools.idea.insights.ui.actions.ToggleIssueAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.table.TableView;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/insights/ui/IssueTableMouseListener;", "Ljava/awt/event/MouseAdapter;", "controller", "Lcom/android/tools/idea/insights/AppInsightsProjectLevelController;", "<init>", "(Lcom/android/tools/idea/insights/AppInsightsProjectLevelController;)V", "appInsightState", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/android/tools/idea/insights/AppInsightsState;", "mouseReleased", "", "e", "Ljava/awt/event/MouseEvent;", "mousePressed", "handleMouseClick", "intellij.android.app-quality-insights.ui"})
public final class IssueTableMouseListener
extends MouseAdapter {
    @NotNull
    private final AppInsightsProjectLevelController controller;
    @NotNull
    private final StateFlow<AppInsightsState> appInsightState;

    public IssueTableMouseListener(@NotNull AppInsightsProjectLevelController controller2) {
        Intrinsics.checkNotNullParameter((Object)controller2, (String)"controller");
        this.controller = controller2;
        this.appInsightState = FlowKt.stateIn(this.controller.getState(), (CoroutineScope)this.controller.getCoroutineScope(), (SharingStarted)SharingStarted.Companion.getEagerly(), null);
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.handleMouseClick(e);
    }

    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.handleMouseClick(e);
    }

    private final void handleMouseClick(MouseEvent e) {
        if (e.isPopupTrigger()) {
            Component component = e.getComponent();
            TableView tableView = component instanceof TableView ? (TableView)component : null;
            if (tableView == null) {
                return;
            }
            TableView table2 = tableView;
            int row = table2.rowAtPoint(e.getPoint());
            if (row < 0) {
                return;
            }
            Object object = table2.getRow(row);
            AppInsightsIssue appInsightsIssue = object instanceof AppInsightsIssue ? (AppInsightsIssue)object : null;
            if (appInsightsIssue == null) {
                return;
            }
            AppInsightsIssue issue2 = appInsightsIssue;
            AppInsightsState appInsightsState = (AppInsightsState)this.appInsightState.getValue();
            if (appInsightsState == null) {
                return;
            }
            AppInsightsState state2 = appInsightsState;
            ToggleIssueAction toggleIssueAction = new ToggleIssueAction(this.controller, state2, issue2);
            AnAction[] anActionArray = new AnAction[]{toggleIssueAction};
            ActionManager.getInstance().createActionPopupMenu("issue table", (ActionGroup)new DefaultActionGroup(anActionArray)).getComponent().show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

