/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights.ui;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.stdui.DefaultCommonComboBoxModel;
import com.android.tools.idea.insights.model.issue.IssueVariant;
import com.android.tools.idea.insights.ui.DetailsPanelHeaderKt;
import com.android.tools.idea.insights.ui.DetailsPanelHeaderModel;
import com.android.tools.idea.insights.ui.UiUtilKt;
import com.android.tools.idea.insights.ui.VariantComboBox;
import com.android.tools.idea.insights.ui.VariantRow;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.Key;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001eH\u0002J(\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0007R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/insights/ui/DetailsPanelHeader;", "Ljavax/swing/JPanel;", "variantComboBox", "Lcom/android/tools/idea/insights/ui/VariantComboBox;", "onVariantSelected", "Lkotlin/Function1;", "Lcom/android/tools/idea/insights/model/issue/IssueVariant;", "", "<init>", "(Lcom/android/tools/idea/insights/ui/VariantComboBox;Lkotlin/jvm/functions/Function1;)V", "titleLabel", "Lcom/intellij/ui/components/JBLabel;", "getTitleLabel", "()Lcom/intellij/ui/components/JBLabel;", "eventsCountLabel", "Ljavax/swing/JLabel;", "getEventsCountLabel", "()Ljavax/swing/JLabel;", "usersCountLabel", "getUsersCountLabel", "countsPanel", "titleVariantSeparatorPanel", "variantPanel", "getVariantPanel", "()Ljavax/swing/JPanel;", "clear", "update", "model", "Lcom/android/tools/idea/insights/ui/DetailsPanelHeaderModel;", "generateTitleLabelText", "", "className", "methodName", "contentWidth", "", "displayFont", "Ljava/awt/Font;", "intellij.android.app-quality-insights.ui"})
@SourceDebugExtension(value={"SMAP\nDetailsPanelHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DetailsPanelHeader.kt\ncom/android/tools/idea/insights/ui/DetailsPanelHeader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 UiUtils.kt\ncom/intellij/openapi/ui/UiUtils\n*L\n1#1,246:1\n1#2:247\n56#3:248\n*S KotlinDebug\n*F\n+ 1 DetailsPanelHeader.kt\ncom/android/tools/idea/insights/ui/DetailsPanelHeader\n*L\n125#1:248\n*E\n"})
public final class DetailsPanelHeader
extends JPanel {
    @Nullable
    private final VariantComboBox variantComboBox;
    @VisibleForTesting
    @NotNull
    private final JBLabel titleLabel;
    @VisibleForTesting
    @NotNull
    private final JLabel eventsCountLabel;
    @VisibleForTesting
    @NotNull
    private final JLabel usersCountLabel;
    @NotNull
    private final JPanel countsPanel;
    @NotNull
    private final JPanel titleVariantSeparatorPanel;
    @VisibleForTesting
    @NotNull
    private final JPanel variantPanel;

    /*
     * WARNING - void declaration
     */
    public DetailsPanelHeader(@Nullable VariantComboBox variantComboBox, @NotNull Function1<? super IssueVariant, Unit> onVariantSelected) {
        void $this$titleVariantSeparatorPanel_u24lambda_u240_u240;
        JComponent $this$titleVariantSeparatorPanel_u24lambda_u240;
        JSeparator jSeparator;
        JComponent $this$countsPanel_u24lambda_u240;
        JComponent $this$usersCountLabel_u24lambda_u240;
        JLabel $this$eventsCountLabel_u24lambda_u240;
        JComponent jComponent;
        Intrinsics.checkNotNullParameter(onVariantSelected, (String)"onVariantSelected");
        super(new GridBagLayout());
        this.variantComboBox = variantComboBox;
        this.titleLabel = new JBLabel();
        JLabel jLabel = jComponent = new JLabel(StudioIcons.AppQualityInsights.ISSUE);
        DetailsPanelHeader detailsPanelHeader = this;
        boolean bl = false;
        $this$eventsCountLabel_u24lambda_u240.setToolTipText("Number of Events");
        detailsPanelHeader.eventsCountLabel = jComponent;
        $this$eventsCountLabel_u24lambda_u240 = jComponent = new JLabel(StudioIcons.LayoutEditor.Palette.QUICK_CONTACT_BADGE);
        detailsPanelHeader = this;
        boolean bl2 = false;
        $this$usersCountLabel_u24lambda_u240.setToolTipText("Number of Users");
        detailsPanelHeader.usersCountLabel = jComponent;
        $this$usersCountLabel_u24lambda_u240 = jComponent = UiUtilKt.transparentPanel();
        detailsPanelHeader = this;
        boolean bl3 = false;
        $this$countsPanel_u24lambda_u240.setLayout(new BoxLayout($this$countsPanel_u24lambda_u240, 0));
        $this$countsPanel_u24lambda_u240.add((Component)this.eventsCountLabel, Float.valueOf(0.5f));
        $this$countsPanel_u24lambda_u240.add(Box.createHorizontalStrut(8));
        $this$countsPanel_u24lambda_u240.add((Component)this.usersCountLabel, Float.valueOf(0.5f));
        $this$countsPanel_u24lambda_u240.setBorder((Border)JBUI.Borders.emptyRight((int)8));
        detailsPanelHeader.countsPanel = jComponent;
        $this$countsPanel_u24lambda_u240 = jComponent = new JPanel(new BorderLayout());
        detailsPanelHeader = this;
        boolean bl4 = false;
        JSeparator jSeparator2 = jSeparator = new JSeparator(1);
        void var8_9 = $this$titleVariantSeparatorPanel_u24lambda_u240;
        boolean bl5 = false;
        $this$titleVariantSeparatorPanel_u24lambda_u240_u240.setForeground(JBUI.CurrentTheme.Toolbar.SEPARATOR_COLOR);
        var8_9.add(jSeparator);
        $this$titleVariantSeparatorPanel_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)5, (int)2));
        detailsPanelHeader.titleVariantSeparatorPanel = jComponent;
        if (this.variantComboBox != null) {
            this.variantComboBox.addItemListener(arg_0 -> DetailsPanelHeader._init_$lambda$1(onVariantSelected, arg_0));
            ((DefaultCommonComboBoxModel)this.variantComboBox.getModel()).addListener(() -> DetailsPanelHeader._init_$lambda$2(this));
            $this$titleVariantSeparatorPanel_u24lambda_u240 = jComponent = UiUtilKt.transparentPanel(new BorderLayout());
            detailsPanelHeader = this;
            boolean bl6 = false;
            $this$_init__u24lambda_u243.setVisible(false);
            $this$_init__u24lambda_u243.add((Component)((Object)this.variantComboBox), "Center");
            detailsPanelHeader.variantPanel = jComponent;
            this.titleVariantSeparatorPanel.setVisible(true);
        } else {
            void $this$_init__u24lambda_u244;
            jComponent = UiUtilKt.transparentPanel();
            $this$_init__u24lambda_u243 = jComponent;
            detailsPanelHeader = this;
            boolean bl7 = false;
            $this$_init__u24lambda_u244.setVisible(false);
            detailsPanelHeader.variantPanel = jComponent;
            this.titleVariantSeparatorPanel.setVisible(false);
        }
        JPanel titlePanel = UiUtilKt.transparentPanel((LayoutManager)new HorizontalLayout(5, 0, 2, null));
        titlePanel.add((Component)this.titleLabel, "LEFT");
        titlePanel.add((Component)this.titleVariantSeparatorPanel, "LEFT");
        titlePanel.add((Component)this.variantPanel, "LEFT");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        this.add((Component)titlePanel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)UiUtilKt.transparentPanel(), gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        this.add((Component)this.countsPanel, gbc);
        this.setBorder(new CompoundBorder((Border)new SideBorder(JBColor.border(), 8), (Border)JBUI.Borders.emptyLeft((int)8)));
        this.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void componentResized(ComponentEvent e) {
                void $this$getUserData$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                JComponent jComponent = (JComponent)this.getTitleLabel();
                Key<Pair<String, String>> key$iv = DetailsPanelHeaderKt.getKEY();
                boolean $i$f$getUserData = false;
                Object object = $this$getUserData$iv.getClientProperty(key$iv);
                if (!(object instanceof Pair)) {
                    object = null;
                }
                Pair pair = (Pair)object;
                if (pair == null) {
                    return;
                }
                Pair pair2 = pair;
                String className = (String)pair2.component1();
                String methodName = (String)pair2.component2();
                this.getTitleLabel().setText(this.generateTitleLabelText(className, methodName));
            }
        });
    }

    public /* synthetic */ DetailsPanelHeader(VariantComboBox variantComboBox, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            variantComboBox = null;
        }
        if ((n & 2) != 0) {
            function1 = DetailsPanelHeader::_init_$lambda$0;
        }
        this(variantComboBox, (Function1<? super IssueVariant, Unit>)function1);
    }

    @NotNull
    public final JBLabel getTitleLabel() {
        return this.titleLabel;
    }

    @NotNull
    public final JLabel getEventsCountLabel() {
        return this.eventsCountLabel;
    }

    @NotNull
    public final JLabel getUsersCountLabel() {
        return this.usersCountLabel;
    }

    @NotNull
    public final JPanel getVariantPanel() {
        return this.variantPanel;
    }

    public final void clear() {
        this.titleLabel.setIcon(null);
        this.titleLabel.setText(null);
        this.titleLabel.setVisible(false);
        this.titleVariantSeparatorPanel.setVisible(false);
        this.countsPanel.setVisible(false);
        this.variantPanel.setVisible(false);
    }

    public final void update(@NotNull DetailsPanelHeaderModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.titleLabel.setIcon(model.getIcon());
        this.countsPanel.setVisible(true);
        this.eventsCountLabel.setText(UiUtilKt.formatNumberToPrettyString(model.getEventCount()));
        this.usersCountLabel.setText(UiUtilKt.formatNumberToPrettyString(model.getUserCount()));
        if (this.variantComboBox != null) {
            this.titleVariantSeparatorPanel.setVisible(true);
            this.variantPanel.setVisible(true);
        }
        UiUtils.putUserData((JComponent)((JComponent)this.titleLabel), DetailsPanelHeaderKt.getKEY(), (Object)new Pair((Object)model.getClassName(), (Object)model.getMethodName()));
        this.titleLabel.setText(this.generateTitleLabelText(model.getClassName(), model.getMethodName()));
        this.titleLabel.setVisible(true);
    }

    private final String generateTitleLabelText(String className, String methodName) {
        int contentWidth = this.getWidth() - this.countsPanel.getWidth();
        int remainingWidth = contentWidth - 5 - UiSizeUtilKt.getPreferredWidth((JComponent)this.variantPanel) - 20;
        Font font = this.titleLabel.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        return this.generateTitleLabelText(className, methodName, remainingWidth, font);
    }

    @VisibleForTesting
    @NotNull
    public final String generateTitleLabelText(@NotNull String className, @NotNull String methodName, int contentWidth, @NotNull Font displayFont) {
        String string;
        String shrunkenMethodText;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)displayFont, (String)"displayFont");
        int remainingWidth = 0;
        remainingWidth = contentWidth;
        if (remainingWidth <= 0) {
            return "<html></html>";
        }
        if (((CharSequence)methodName).length() > 0) {
            String string2;
            FontMetrics methodFontMetrics = this.getFontMetrics(displayFont.deriveFont(1));
            Intrinsics.checkNotNull((Object)methodFontMetrics);
            String it = string2 = AdtUiUtils.shrinkToFit((String)methodName, (FontMetrics)methodFontMetrics, (float)remainingWidth, (AdtUiUtils.ShrinkDirection)AdtUiUtils.ShrinkDirection.TRUNCATE_START);
            boolean bl = false;
            remainingWidth -= methodFontMetrics.stringWidth(it);
            v0 = string2;
        } else {
            v0 = shrunkenMethodText = "";
        }
        if (remainingWidth > 0) {
            String string3;
            FontMetrics classFontMetrics = this.getFontMetrics(displayFont);
            String string4 = className + ".";
            Intrinsics.checkNotNull((Object)classFontMetrics);
            String it = string3 = AdtUiUtils.shrinkToFit((String)string4, (FontMetrics)classFontMetrics, (float)remainingWidth, (AdtUiUtils.ShrinkDirection)AdtUiUtils.ShrinkDirection.TRUNCATE_START);
            boolean bl = false;
            remainingWidth -= classFontMetrics.stringWidth(it);
            string = string3;
        } else {
            string = "";
        }
        String shrunkenClassText = string;
        Object methodString = ((CharSequence)shrunkenMethodText).length() > 0 ? "<B>" + shrunkenMethodText + "</B>" : "";
        return "<html>" + shrunkenClassText + (String)methodString + "</html>";
    }

    private static final Unit _init_$lambda$0(IssueVariant it) {
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function1 $onVariantSelected, ItemEvent itemEvent) {
        block1: {
            if (itemEvent.getStateChange() != 1) break block1;
            Object object = itemEvent.getItem();
            VariantRow variantRow = object instanceof VariantRow ? (VariantRow)object : null;
            if (variantRow != null) {
                VariantRow it = variantRow;
                boolean bl = false;
                $onVariantSelected.invoke((Object)it.getIssueVariant());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void _init_$lambda$2(DetailsPanelHeader this$0) {
        void $this$getUserData$iv;
        JComponent jComponent = (JComponent)this$0.titleLabel;
        Key<Pair<String, String>> key$iv = DetailsPanelHeaderKt.getKEY();
        boolean $i$f$getUserData = false;
        Object object = $this$getUserData$iv.getClientProperty(key$iv);
        if (!(object instanceof Pair)) {
            object = null;
        }
        Pair pair = (Pair)object;
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        String className = (String)pair2.component1();
        String methodName = (String)pair2.component2();
        this$0.titleLabel.setText(this$0.generateTitleLabelText(className, methodName));
    }

    public DetailsPanelHeader() {
        this(null, null, 3, null);
    }
}

