/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights.inspection;

import com.android.tools.idea.insights.AppInsight;
import com.android.tools.idea.insights.model.vcs.AppVcsInfo;
import com.android.tools.idea.insights.model.vcs.RepoInfo;
import com.android.tools.idea.insights.vcs.VcsUtilsKt;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.Range;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a%\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\r\u001a\u001f\u0010\u000e\u001a\u0004\u0018\u00010\t*\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"tryCreateVcsDocumentOrNull", "Lcom/intellij/openapi/editor/Document;", "Lcom/android/tools/idea/insights/AppInsight;", "contextVFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "createVcsDocument", "getUpToDateLineNumber", "", "oldLineNumber", "vcsDocument", "document", "(ILcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/Document;)Ljava/lang/Integer;", "inferLineNumber", "", "Lcom/intellij/diff/util/Range;", "lineNumber", "(Ljava/util/List;I)Ljava/lang/Integer;", "intellij.android.app-quality-insights.ide"})
@SourceDebugExtension(value={"SMAP\nLineNumberMapperUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineNumberMapperUtils.kt\ncom/android/tools/idea/insights/inspection/LineNumberMapperUtilsKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n24#2:89\n295#3,2:90\n2756#3:92\n1#4:93\n*S KotlinDebug\n*F\n+ 1 LineNumberMapperUtils.kt\ncom/android/tools/idea/insights/inspection/LineNumberMapperUtilsKt\n*L\n37#1:89\n47#1:90,2\n78#1:92\n78#1:93\n*E\n"})
public final class LineNumberMapperUtilsKt {
    @Nullable
    public static final Document tryCreateVcsDocumentOrNull(@NotNull AppInsight $this$tryCreateVcsDocumentOrNull, @NotNull VirtualFile contextVFile, @NotNull Project project) {
        Document document;
        Intrinsics.checkNotNullParameter((Object)$this$tryCreateVcsDocumentOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contextVFile, (String)"contextVFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            document = LineNumberMapperUtilsKt.createVcsDocument($this$tryCreateVcsDocumentOrNull, contextVFile, project);
        }
        catch (VcsException exception) {
            AppInsight $this$thisLogger$iv = $this$tryCreateVcsDocumentOrNull;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AppInsight.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error when creating VCS document from " + $this$tryCreateVcsDocumentOrNull + " for " + contextVFile + ": " + exception + ".");
            document = null;
        }
        return document;
    }

    @Nullable
    public static final Document createVcsDocument(@NotNull AppInsight $this$createVcsDocument, @NotNull VirtualFile contextVFile, @NotNull Project project) {
        Object v3;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$createVcsDocument, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)contextVFile, (String)"contextVFile");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            AppVcsInfo appVcsInfo = $this$createVcsDocument.getIssue().getSampleEvent().getAppVcsInfo();
            AppVcsInfo.ValidInfo validInfo = appVcsInfo instanceof AppVcsInfo.ValidInfo ? (AppVcsInfo.ValidInfo)appVcsInfo : null;
            if (validInfo == null) {
                return null;
            }
            AppVcsInfo.ValidInfo appVcsInfo2 = validInfo;
            AbstractVcs abstractVcs = VcsUtilsKt.getVcsManager(contextVFile, project);
            if (abstractVcs == null) {
                return null;
            }
            AbstractVcs associatedVcs = abstractVcs;
            Iterable $this$firstOrNull$iv = appVcsInfo2.getRepoInfo();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RepoInfo it = (RepoInfo)element$iv;
                boolean bl = false;
                Repository repository2 = VcsUtilsKt.locateRepository(it, project);
                if (!Intrinsics.areEqual((Object)(repository2 != null ? repository2.getVcs() : null), (Object)associatedVcs)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        RepoInfo repoInfo = v3;
        if (repoInfo == null) {
            return null;
        }
        RepoInfo matchedRepoInfo = repoInfo;
        return VcsUtilsKt.createVcsDocument(matchedRepoInfo.getVcsKey(), contextVFile, matchedRepoInfo.getRevision(), project);
    }

    @Nullable
    public static final Integer getUpToDateLineNumber(int oldLineNumber, @NotNull Document vcsDocument, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)vcsDocument, (String)"vcsDocument");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        CharSequence charSequence = vcsDocument.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence charSequence2 = document.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getImmutableCharSequence(...)");
        LineOffsets lineOffsets = LineOffsetsUtil.create((Document)vcsDocument);
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets, (String)"create(...)");
        LineOffsets lineOffsets2 = LineOffsetsUtil.create((Document)document);
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets2, (String)"create(...)");
        FairDiffIterable diffIterator = RangesBuilder.compareLines((CharSequence)charSequence, (CharSequence)charSequence2, (LineOffsets)lineOffsets, (LineOffsets)lineOffsets2);
        return LineNumberMapperUtilsKt.inferLineNumber(CollectionsKt.toList((Iterable)diffIterator.iterateChanges()), oldLineNumber);
    }

    @Nullable
    public static final Integer inferLineNumber(@NotNull List<Range> $this$inferLineNumber, int lineNumber) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter($this$inferLineNumber, (String)"<this>");
        int mappedLineNumber = 0;
        mappedLineNumber = lineNumber;
        Iterable $this$onEach$iv = $this$inferLineNumber;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
            Range it = (Range)element$iv;
            boolean bl2 = false;
            if (lineNumber < it.start1) {
                return mappedLineNumber;
            }
            if (lineNumber < it.end1) {
                return null;
            }
            int delta1 = it.end1 - it.start1;
            int delta2 = it.end2 - it.start2;
            mappedLineNumber = mappedLineNumber + delta2 - delta1;
        }
        return mappedLineNumber;
    }
}

