/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights;

import com.android.tools.idea.insights.analysis.Cause;
import com.android.tools.idea.insights.model.issue.AppInsightsIssue;
import com.android.tools.idea.insights.model.stacktrace.Frame;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010\u001b\u001a\u00020\u000eJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00c6\u0003J\t\u0010 \u001a\u00020\u000bH\u00c6\u0003J\u0015\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\rH\u00c2\u0003JQ\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001J\t\u0010'\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/insights/AppInsight;", "", "line", "", "issue", "Lcom/android/tools/idea/insights/model/issue/AppInsightsIssue;", "stackFrame", "Lcom/android/tools/idea/insights/model/stacktrace/Frame;", "cause", "Lcom/android/tools/idea/insights/analysis/Cause;", "providerName", "", "markAsSelectedCallback", "Lkotlin/Function1;", "", "<init>", "(ILcom/android/tools/idea/insights/model/issue/AppInsightsIssue;Lcom/android/tools/idea/insights/model/stacktrace/Frame;Lcom/android/tools/idea/insights/analysis/Cause;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getLine", "()I", "getIssue", "()Lcom/android/tools/idea/insights/model/issue/AppInsightsIssue;", "getStackFrame", "()Lcom/android/tools/idea/insights/model/stacktrace/Frame;", "getCause", "()Lcom/android/tools/idea/insights/analysis/Cause;", "getProviderName", "()Ljava/lang/String;", "markAsSelected", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "intellij.android.app-quality-insights.api"})
public final class AppInsight {
    private final int line;
    @NotNull
    private final AppInsightsIssue issue;
    @NotNull
    private final Frame stackFrame;
    @NotNull
    private final Cause cause;
    @NotNull
    private final String providerName;
    @NotNull
    private final Function1<AppInsightsIssue, Unit> markAsSelectedCallback;

    public AppInsight(int line, @NotNull AppInsightsIssue issue2, @NotNull Frame stackFrame, @NotNull Cause cause, @NotNull String providerName, @NotNull Function1<? super AppInsightsIssue, Unit> markAsSelectedCallback) {
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        Intrinsics.checkNotNullParameter(markAsSelectedCallback, (String)"markAsSelectedCallback");
        this.line = line;
        this.issue = issue2;
        this.stackFrame = stackFrame;
        this.cause = cause;
        this.providerName = providerName;
        this.markAsSelectedCallback = markAsSelectedCallback;
    }

    public final int getLine() {
        return this.line;
    }

    @NotNull
    public final AppInsightsIssue getIssue() {
        return this.issue;
    }

    @NotNull
    public final Frame getStackFrame() {
        return this.stackFrame;
    }

    @NotNull
    public final Cause getCause() {
        return this.cause;
    }

    @NotNull
    public final String getProviderName() {
        return this.providerName;
    }

    public final void markAsSelected() {
        Logger.getInstance(AppInsight.class).info("Mark issue as selected " + this.issue);
        this.markAsSelectedCallback.invoke((Object)this.issue);
    }

    public final int component1() {
        return this.line;
    }

    @NotNull
    public final AppInsightsIssue component2() {
        return this.issue;
    }

    @NotNull
    public final Frame component3() {
        return this.stackFrame;
    }

    @NotNull
    public final Cause component4() {
        return this.cause;
    }

    @NotNull
    public final String component5() {
        return this.providerName;
    }

    private final Function1<AppInsightsIssue, Unit> component6() {
        return this.markAsSelectedCallback;
    }

    @NotNull
    public final AppInsight copy(int line, @NotNull AppInsightsIssue issue2, @NotNull Frame stackFrame, @NotNull Cause cause, @NotNull String providerName, @NotNull Function1<? super AppInsightsIssue, Unit> markAsSelectedCallback) {
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        Intrinsics.checkNotNullParameter(markAsSelectedCallback, (String)"markAsSelectedCallback");
        return new AppInsight(line, issue2, stackFrame, cause, providerName, markAsSelectedCallback);
    }

    public static /* synthetic */ AppInsight copy$default(AppInsight appInsight, int n, AppInsightsIssue appInsightsIssue, Frame frame, Cause cause, String string, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = appInsight.line;
        }
        if ((n2 & 2) != 0) {
            appInsightsIssue = appInsight.issue;
        }
        if ((n2 & 4) != 0) {
            frame = appInsight.stackFrame;
        }
        if ((n2 & 8) != 0) {
            cause = appInsight.cause;
        }
        if ((n2 & 0x10) != 0) {
            string = appInsight.providerName;
        }
        if ((n2 & 0x20) != 0) {
            function1 = appInsight.markAsSelectedCallback;
        }
        return appInsight.copy(n, appInsightsIssue, frame, cause, string, function1);
    }

    @NotNull
    public String toString() {
        return "AppInsight(line=" + this.line + ", issue=" + this.issue + ", stackFrame=" + this.stackFrame + ", cause=" + this.cause + ", providerName=" + this.providerName + ", markAsSelectedCallback=" + this.markAsSelectedCallback + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.line);
        result2 = result2 * 31 + this.issue.hashCode();
        result2 = result2 * 31 + this.stackFrame.hashCode();
        result2 = result2 * 31 + this.cause.hashCode();
        result2 = result2 * 31 + this.providerName.hashCode();
        result2 = result2 * 31 + this.markAsSelectedCallback.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AppInsight)) {
            return false;
        }
        AppInsight appInsight = (AppInsight)other;
        if (this.line != appInsight.line) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.issue, (Object)appInsight.issue)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stackFrame, (Object)appInsight.stackFrame)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cause, (Object)appInsight.cause)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.providerName, (Object)appInsight.providerName)) {
            return false;
        }
        return Intrinsics.areEqual(this.markAsSelectedCallback, appInsight.markAsSelectedCallback);
    }
}

