/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.conflict;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.module.Module;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Conflict {
    @NotNull
    private final Module mySource;
    @NotNull
    private final String mySelectedVariant;
    @NotNull
    private final Multimap<String, AffectedModule> myAffectedModulesByExpectedVariant = ArrayListMultimap.create();
    @NotNull
    private final Map<Module, AffectedModule> myAffectedModules = new HashMap<Module, AffectedModule>();
    private boolean myResolved;

    public Conflict(@NotNull Module source2, @NotNull String selectedVariant) {
        this.mySource = source2;
        this.mySelectedVariant = selectedVariant;
    }

    public void addAffectedModule(@NotNull Module target2, @NotNull String expectedVariant) {
        AffectedModule affected = new AffectedModule(this, target2, expectedVariant);
        this.myAffectedModules.put(target2, affected);
        this.myAffectedModulesByExpectedVariant.put((Object)expectedVariant, (Object)affected);
    }

    public boolean hasAffectedModule(Module module) {
        return this.myAffectedModules.containsKey(module);
    }

    @NotNull
    public Collection<String> getVariants() {
        return this.myAffectedModulesByExpectedVariant.keySet();
    }

    @NotNull
    public Collection<AffectedModule> getModulesExpectingVariant(@NotNull String variant) {
        return this.myAffectedModulesByExpectedVariant.get((Object)variant);
    }

    @NotNull
    public Module getSource() {
        return this.mySource;
    }

    @NotNull
    public String getSelectedVariant() {
        return this.mySelectedVariant;
    }

    @NotNull
    public Collection<AffectedModule> getAffectedModules() {
        return this.myAffectedModules.values();
    }

    public void refreshStatus() {
        int selectedVariantCount = 0;
        block0: for (String variant : this.myAffectedModulesByExpectedVariant.keySet()) {
            for (AffectedModule affected : this.getModulesExpectingVariant(variant)) {
                if (!affected.isSelected()) continue;
                ++selectedVariantCount;
                continue block0;
            }
        }
        this.setResolved(selectedVariantCount <= 1);
    }

    public boolean isResolved() {
        return this.myResolved;
    }

    public void setResolved(boolean resolved) {
        this.myResolved = resolved;
    }

    public static class AffectedModule {
        @NotNull
        private final Conflict myConflict;
        @NotNull
        private final Module myTarget;
        @NotNull
        private final String myExpectedVariant;
        private boolean mySelected = true;

        AffectedModule(@NotNull Conflict conflict, @NotNull Module target2, @NotNull String expectedVariant) {
            this.myConflict = conflict;
            this.myTarget = target2;
            this.myExpectedVariant = expectedVariant;
        }

        @NotNull
        public Conflict getConflict() {
            return this.myConflict;
        }

        @NotNull
        public Module getTarget() {
            return this.myTarget;
        }

        @NotNull
        public String getExpectedVariant() {
            return this.myExpectedVariant;
        }

        public boolean isSelected() {
            return this.mySelected;
        }

        public void setSelected(boolean selected) {
            this.mySelected = selected;
            this.myConflict.refreshStatus();
        }
    }
}

