/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class Header
extends JPanel {
    @NotNull
    private final String myTitle;
    private final JPanel myButtonPanel;
    private BufferedImage myImage;
    private BufferedImage myActiveImage;
    private final EventDispatcher<ActivationListener> myEventDispatcher = EventDispatcher.create(ActivationListener.class);

    public Header(@NotNull String title2) {
        super(new BorderLayout());
        this.myTitle = title2;
        JLabel titleLabel = new JLabel(title2);
        titleLabel.setFont(BaseLabel.getLabelFont());
        titleLabel.setForeground(JBColor.foreground());
        titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.add((Component)titleLabel, "Center");
        MouseAdapter mouseListener2 = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ((ActivationListener)Header.this.myEventDispatcher.getMulticaster()).activated();
            }
        };
        titleLabel.addMouseListener(mouseListener2);
        this.addMouseListener(mouseListener2);
        this.myButtonPanel = new JPanel();
        this.myButtonPanel.setOpaque(false);
        this.myButtonPanel.setLayout(new BoxLayout(this.myButtonPanel, 0));
        this.myButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.add((Component)this.myButtonPanel, "East");
        this.setBorder((Border)JBUI.Borders.empty());
    }

    @NotNull
    public String getTitle() {
        return this.myTitle;
    }

    @Override
    protected void paintComponent(Graphics g) {
        BufferedImage image;
        Rectangle r = this.getBounds();
        Graphics2D g2d = (Graphics2D)g;
        if (this.isActive()) {
            if (this.myActiveImage == null) {
                this.myActiveImage = Header.drawToBuffer(true, r.height);
            }
            image = this.myActiveImage;
        } else {
            if (this.myImage == null) {
                this.myImage = Header.drawToBuffer(false, r.height);
            }
            image = this.myImage;
        }
        Rectangle clipBounds = g2d.getClip().getBounds();
        for (int x = clipBounds.x; x < clipBounds.x + clipBounds.width; x += 150) {
            UIUtil.drawImage((Graphics)g, (Image)image, (int)x, (int)0, null);
        }
    }

    @NotNull
    private static BufferedImage drawToBuffer(boolean active, int height) {
        int width = 150;
        BufferedImage image = ImageUtil.createImage((int)width, (int)height, (int)2);
        Graphics2D g = image.createGraphics();
        UIUtil.drawHeader((Graphics)g, (int)0, (int)width, (int)height, (boolean)active, (boolean)true, (boolean)false, (boolean)true);
        g.dispose();
        return image;
    }

    @Override
    protected void paintChildren(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        UISettings.setupAntialiasing((Graphics)graphics);
        super.paintChildren(graphics);
        Rectangle r = this.getBounds();
        if (!this.isActive() && JBColor.isBright()) {
            graphics.setColor(new Color(255, 255, 255, 30));
            graphics.fill(r);
        }
        graphics.dispose();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(size.width, TabsUtil.getTabsHeight());
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        return new Dimension(size.width, TabsUtil.getTabsHeight());
    }

    public void setAdditionalActions(@NotNull List<AnAction> actions2) {
        this.setAdditionalActions(actions2.toArray(AnAction.EMPTY_ARRAY));
    }

    public void setAdditionalActions(AnAction ... actions2) {
        this.myButtonPanel.removeAll();
        this.myButtonPanel.revalidate();
        this.myButtonPanel.repaint();
        int actionCount = actions2.length;
        for (int i = 0; i < actionCount; ++i) {
            AnAction action2 = actions2[i];
            if (action2 == null) continue;
            this.myButtonPanel.add((Component)((Object)new ActionButton(action2)));
            if (i >= actionCount - 1) continue;
            this.myButtonPanel.add(Box.createHorizontalStrut(9));
        }
    }

    public void addActivationListener(@NotNull ActivationListener listener2, @NotNull Disposable parent) {
        this.myEventDispatcher.addListener((EventListener)listener2, parent);
    }

    public boolean isActive() {
        return true;
    }

    public static interface ActivationListener
    extends EventListener {
        public void activated();
    }

    private static class ActionButton
    extends Wrapper
    implements ActionListener {
        private final InplaceButton myButton;
        private final AnAction myAction;

        ActionButton(@NotNull AnAction action2) {
            Icon icon;
            this.myAction = action2;
            Icon hoveredIcon = null;
            if (action2 instanceof Separator) {
                icon = AllIcons.General.Divider;
            } else {
                icon = action2.getTemplatePresentation().getIcon();
                hoveredIcon = action2.getTemplatePresentation().getHoveredIcon();
            }
            if (hoveredIcon == null) {
                hoveredIcon = icon;
            }
            String toolTip = KeymapUtil.createTooltipText((String)action2.getTemplatePresentation().getText(), (AnAction)action2);
            this.myButton = new InplaceButton(toolTip, icon, (ActionListener)this);
            this.myButton.setIcons(icon, icon, hoveredIcon);
            this.myButton.setHoveringEnabled(!SystemInfo.isMac);
            this.setContent((JComponent)this.myButton);
            this.setOpaque(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
            InputEvent inputEvent = e.getSource() instanceof InputEvent ? (InputEvent)e.getSource() : null;
            AnActionEvent event = AnActionEvent.createEvent((AnAction)this.myAction, (DataContext)dataContext, null, (String)"unknown", (ActionUiKind)ActionUiKind.NONE, (InputEvent)inputEvent);
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)this.myAction, (AnActionEvent)event);
        }
    }
}

