/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertiesFiles {
    private PropertiesFiles() {
    }

    public static Properties getProperties(@Nullable VirtualFile virtualFile) throws IOException {
        return (Properties)ReadAction.compute(() -> {
            if (virtualFile == null) {
                return new Properties();
            }
            if (virtualFile.isDirectory()) {
                throw new IllegalArgumentException(String.format("The path '%1$s' belongs to a directory!", virtualFile.getPath()));
            }
            Properties properties = new Properties();
            try (InputStreamReader reader2 = new InputStreamReader(virtualFile.getInputStream(), StandardCharsets.UTF_8);){
                properties.load(reader2);
            }
            return properties;
        });
    }

    @NotNull
    public static Properties getProperties(@NotNull File filePath) throws IOException {
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread()) {
            ThreadingAssertions.assertNoOwnReadAccess();
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)filePath, (boolean)true);
        return PropertiesFiles.getProperties(virtualFile);
    }

    public static void savePropertiesToFile(@NotNull Properties properties, @NotNull File filePath, @Nullable String comments) throws IOException {
        WriteAction.computeAndWait(() -> {
            VirtualFile directory = VfsUtil.createDirectoryIfMissing((String)filePath.getParent());
            if (directory == null) {
                throw new IllegalStateException("Cannot find or create a VFS file for directory: " + filePath.getParent());
            }
            VirtualFile virtualFile = directory.findOrCreateChildData(PropertiesFiles.class, filePath.getName());
            try (OutputStream out = virtualFile.getOutputStream(PropertiesFiles.class);){
                properties.store(out, comments);
            }
            return null;
        });
    }
}

