/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.util.IdeProxyInfo;
import com.google.common.base.Strings;
import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.ProxyConfiguration;
import com.intellij.util.net.ProxyCredentialProvider;
import com.intellij.util.net.ProxyCredentialStore;
import com.intellij.util.net.ProxyCredentialStoreKt;
import com.intellij.util.net.ProxySettings;
import com.intellij.util.net.ProxyUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeGradleProxySettingsBridge {
    @NonNls
    public static final String HTTP_PROXY_TYPE = "http";
    @NonNls
    public static final String HTTPS_PROXY_TYPE = "https";
    @NonNls
    private static final String PROXY_HOST_PROPERTY_SUFFIX = "proxyHost";
    @NonNls
    private static final String PROXY_PORT_PROPERTY_SUFFIX = "proxyPort";
    @NonNls
    private static final String PROXY_USER_PROPERTY_SUFFIX = "proxyUser";
    @NonNls
    private static final String PROXY_PASSWORD_PROPERTY_SUFFIX = "proxyPassword";
    @NonNls
    private static final String PROXY_EXCEPTIONS_PROPERTY_SUFFIX = "nonProxyHosts";
    @NotNull
    private String myProxyType;
    @Nullable
    private String myHost;
    @Nullable
    private String myExceptions;
    @Nullable
    private String myUser;
    @Nullable
    private String myPassword;
    private int myPort = 80;

    public IdeGradleProxySettingsBridge(@NotNull String proxyType) {
        this.myProxyType = proxyType;
    }

    public IdeGradleProxySettingsBridge(@NotNull Properties properties, @NotNull String proxyType) {
        this.myProxyType = proxyType;
        this.myHost = properties.getProperty(this.getProxyPropertyName(PROXY_HOST_PROPERTY_SUFFIX));
        String portValue = properties.getProperty(this.getProxyPropertyName(PROXY_PORT_PROPERTY_SUFFIX));
        if (StringUtil.isNotEmpty((String)portValue)) {
            try {
                this.myPort = Integer.parseInt(portValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.myExceptions = properties.getProperty(this.getProxyPropertyName(PROXY_EXCEPTIONS_PROPERTY_SUFFIX));
        this.myUser = properties.getProperty(this.getProxyPropertyName(PROXY_USER_PROPERTY_SUFFIX));
        this.myPassword = properties.getProperty(this.getProxyPropertyName(PROXY_PASSWORD_PROPERTY_SUFFIX));
    }

    public IdeGradleProxySettingsBridge(@NotNull IdeProxyInfo info, @NotNull ProxyConfiguration.StaticProxyConfiguration configuration2) {
        this.myProxyType = HTTP_PROXY_TYPE;
        this.myHost = configuration2.getHost();
        this.myPort = configuration2.getPort();
        Credentials credentials = ProxyUtils.getStaticProxyCredentials((ProxySettings)info.getSettings(), (ProxyCredentialProvider)ProxyCredentialStoreKt.asProxyCredentialProvider((ProxyCredentialStore)info.getCredentialStore()));
        if (credentials != null) {
            this.myUser = credentials.getUserName();
            this.myPassword = credentials.getPasswordAsString();
        }
        this.myExceptions = IdeGradleProxySettingsBridge.replaceCommasWithPipesAndClean(configuration2.getExceptions());
    }

    @Nullable
    public static String replaceCommasWithPipesAndClean(@Nullable String exceptions) {
        return IdeGradleProxySettingsBridge.replaceSeparatorAndCleanList(exceptions, ",", "|");
    }

    @Nullable
    public static String replacePipesWithCommasAndClean(@Nullable String exceptions) {
        return IdeGradleProxySettingsBridge.replaceSeparatorAndCleanList(exceptions, "|", ", ");
    }

    @Nullable
    private static String replaceSeparatorAndCleanList(@Nullable String list2, @NotNull String separator, @NotNull String replacement) {
        if (StringUtil.isEmpty((String)list2)) {
            return null;
        }
        return Strings.emptyToNull((String)Arrays.stream(list2.replace(separator, replacement).split(Pattern.quote(replacement.trim()))).map(String::trim).filter(com.intellij.openapi.util.text.Strings::isNotEmpty).collect(Collectors.joining(replacement)));
    }

    public void applyProxySettings(@NotNull Properties properties) {
        properties.setProperty(this.getProxyPropertyName(PROXY_HOST_PROPERTY_SUFFIX), this.myHost);
        properties.setProperty(this.getProxyPropertyName(PROXY_PORT_PROPERTY_SUFFIX), String.valueOf(this.myPort));
        if (StringUtil.isEmpty((String)this.myUser)) {
            properties.remove(this.getProxyPropertyName(PROXY_USER_PROPERTY_SUFFIX));
        } else {
            properties.setProperty(this.getProxyPropertyName(PROXY_USER_PROPERTY_SUFFIX), this.myUser);
            properties.setProperty(this.getProxyPropertyName(PROXY_PASSWORD_PROPERTY_SUFFIX), Strings.nullToEmpty((String)this.myPassword));
        }
        if (StringUtil.isEmpty((String)this.myExceptions)) {
            properties.remove(this.getProxyPropertyName(PROXY_EXCEPTIONS_PROPERTY_SUFFIX));
        } else {
            properties.setProperty(this.getProxyPropertyName(PROXY_EXCEPTIONS_PROPERTY_SUFFIX), this.myExceptions);
        }
    }

    @NotNull
    private String getProxyPropertyName(@NotNull String propertySuffix) {
        return "systemProp." + this.myProxyType + "." + propertySuffix;
    }

    @Nullable
    public String getHost() {
        return this.myHost;
    }

    public void setHost(@Nullable String host) {
        this.myHost = host;
    }

    @Nullable
    public String getExceptions() {
        return this.myExceptions;
    }

    public void setExceptions(@Nullable String exceptions) {
        this.myExceptions = exceptions;
    }

    @Nullable
    public String getUser() {
        return this.myUser;
    }

    public void setUser(@Nullable String user) {
        this.myUser = user;
    }

    @Nullable
    public String getPassword() {
        return this.myPassword;
    }

    public void setPassword(@Nullable String password) {
        this.myPassword = password;
    }

    public int getPort() {
        return this.myPort;
    }

    public void setPort(int port) {
        this.myPort = port;
    }

    public void setProxyType(@NotNull String proxyType) {
        this.myProxyType = proxyType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeGradleProxySettingsBridge)) {
            return false;
        }
        IdeGradleProxySettingsBridge settings = (IdeGradleProxySettingsBridge)o;
        return this.myPort == settings.myPort && Objects.equals(this.myProxyType, settings.myProxyType) && Objects.equals(this.myHost, settings.myHost) && Objects.equals(this.myExceptions, settings.myExceptions) && Objects.equals(this.myUser, settings.myUser) && Objects.equals(this.myPassword, settings.myPassword);
    }

    public int hashCode() {
        return Objects.hash(this.myProxyType, this.myHost, this.myExceptions, this.myUser, this.myPassword, this.myPort);
    }

    public String toString() {
        return "ProxySettings{myProxyType='" + this.myProxyType + "', myHost='" + this.myHost + "', myExceptions='" + this.myExceptions + "', myUser='" + this.myUser + "', myPassword='" + this.myPassword + "', myPort=" + this.myPort + "}";
    }
}

