/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.RichVersion;
import com.android.ide.common.gradle.Version;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import org.gradle.initialization.BuildLayoutParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

@Service
public final class GradleLocalCache {
    @NotNull
    public static GradleLocalCache getInstance() {
        return (GradleLocalCache)ApplicationManager.getApplication().getService(GradleLocalCache.class);
    }

    @Nullable
    public Version findLatestArtifactVersion(@NotNull Dependency dependency, @Nullable Project project) {
        String group2 = dependency.getGroup();
        String name2 = dependency.getName();
        Version latest = null;
        if (StringUtil.isNotEmpty((String)group2) && StringUtil.isNotEmpty((String)name2)) {
            for (File gradleServicePath : GradleLocalCache.getGradleServicePaths(project)) {
                Version version2 = GradleLocalCache.findLatestVersionInGradleCache(gradleServicePath, group2, name2, dependency.getVersion());
                if (version2 == null || latest != null && latest.compareTo(version2) >= 0) continue;
                latest = version2;
                Logger.getInstance(GradleLocalCache.class).info("Possibly found " + String.valueOf(dependency) + " from Gradle service path " + String.valueOf(gradleServicePath));
            }
        }
        return latest;
    }

    @Nullable
    private static Version findLatestVersionInGradleCache(@NotNull File gradleServicePath, @NotNull String group2, @NotNull String name2, @Nullable RichVersion richVersion) {
        File gradleCacheFolder = new File(gradleServicePath, "caches");
        if (!gradleCacheFolder.isDirectory()) {
            return null;
        }
        ArrayList<Version> versions2 = new ArrayList<Version>();
        for (File moduleFolder : FileUtil.notNullize((File[])gradleCacheFolder.listFiles())) {
            if (!GradleLocalCache.isDirectoryWithNamePrefix(moduleFolder, "modules-")) continue;
            for (File metadataFolder : FileUtil.notNullize((File[])moduleFolder.listFiles())) {
                File versionFolder;
                if (!GradleLocalCache.isDirectoryWithNamePrefix(metadataFolder, "metadata-") || !(versionFolder = new File(metadataFolder, FileUtil.join((String[])new String[]{"descriptors", group2, name2}))).isDirectory()) continue;
                for (File versionFile : FileUtil.notNullize((File[])versionFolder.listFiles())) {
                    Version version2 = Version.parse((String)versionFile.getName());
                    if (richVersion != null && !richVersion.accepts(version2)) continue;
                    versions2.add(version2);
                }
            }
        }
        return versions2.stream().max(Comparator.naturalOrder()).orElse(null);
    }

    private static boolean isDirectoryWithNamePrefix(@NotNull File file, @NotNull String prefix) {
        return file.getName().startsWith(prefix) && file.isDirectory();
    }

    public boolean containsGradleWrapperVersion(@NotNull String gradleVersion2, @NotNull Project project) {
        String distFolderName = "gradle-" + gradleVersion2;
        String wrapperDirNamePrefix = distFolderName + "-";
        String[] wrapperFolderNames = new String[]{wrapperDirNamePrefix + "all", wrapperDirNamePrefix + "bin"};
        for (File gradleServicePath : GradleLocalCache.getGradleServicePaths(project)) {
            for (String wrapperFolderName : wrapperFolderNames) {
                File wrapperFolderPath = new File(gradleServicePath, FileUtil.join((String[])new String[]{"wrapper", "dists", wrapperFolderName}));
                if (!wrapperFolderPath.isDirectory()) continue;
                for (File mayBeDistParent : FileUtil.notNullize((File[])wrapperFolderPath.listFiles())) {
                    if (!mayBeDistParent.isDirectory()) continue;
                    for (File mayBeDistFolder : FileUtil.notNullize((File[])mayBeDistParent.listFiles())) {
                        if (!mayBeDistFolder.isDirectory() || !distFolderName.equals(mayBeDistFolder.getName())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @NotNull
    private static Collection<File> getGradleServicePaths(@Nullable Project project) {
        File path;
        File file;
        GradleSettings settings;
        String path2;
        LinkedHashSet<File> paths = new LinkedHashSet<File>();
        if (project != null && StringUtil.isNotEmpty((String)(path2 = (settings = GradleSettings.getInstance((Project)project)).getServiceDirectoryPath())) && (file = new File(path2)).isDirectory()) {
            paths.add(file);
        }
        if ((path = new BuildLayoutParameters().getGradleUserHomeDir()).isDirectory()) {
            paths.add(path);
        }
        return paths;
    }
}

